/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.ArcIterator;
import com.guidebee.drawing.geometry.Dimension;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.Line;
import com.guidebee.drawing.geometry.Point;
import com.guidebee.drawing.geometry.Rectangle;
import com.guidebee.drawing.geometry.RectangularShape;
import com.guidebee.game.engine.math.MathEx;

public class Arc
extends RectangularShape {
    public static final int OPEN = 0;
    public static final int CHORD = 1;
    public static final int PIE = 2;
    public double x;
    public double y;
    public double width;
    public double height;
    public double start;
    public double extent;
    private int type;

    public Arc() {
        this(0);
    }

    public Arc(int type) {
        this.setArcType(type);
    }

    public Arc(Rectangle ellipseBounds, double start, double extent, int type) {
        this(type);
        this.x = ellipseBounds.getX();
        this.y = ellipseBounds.getY();
        this.width = ellipseBounds.getWidth();
        this.height = ellipseBounds.getHeight();
        this.start = start;
        this.extent = extent;
    }

    @Override
    public int getX() {
        return (int)(this.x + 0.5);
    }

    @Override
    public int getY() {
        return (int)(this.y + 0.5);
    }

    @Override
    public int getWidth() {
        return (int)(this.width + 0.5);
    }

    @Override
    public int getHeight() {
        return (int)(this.height + 0.5);
    }

    public double getAngleStart() {
        return this.start;
    }

    public double getAngleExtent() {
        return this.extent;
    }

    @Override
    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public void setArc(double x, double y, double w, double h, double angSt, double angExt, int closure) {
        this.setArcType(closure);
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.start = angSt;
        this.extent = angExt;
    }

    public void setAngleStart(double angSt) {
        this.start = angSt;
    }

    public void setAngleExtent(double angExt) {
        this.extent = angExt;
    }

    protected Rectangle makeBounds(double x, double y, double w, double h) {
        return new Rectangle((int)(x + 0.5), (int)(y + 0.5), (int)(w + 0.5), (int)(h + 0.5));
    }

    public Arc(double x, double y, double w, double h, double start, double extent, int type) {
        this(type);
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.start = start;
        this.extent = extent;
    }

    public int getArcType() {
        return this.type;
    }

    public Point getStartPoint() {
        double angle = MathEx.toRadians(-this.getAngleStart());
        double xp = (double)this.getX() + (MathEx.cos(angle) * 0.5 + 0.5) * (double)this.getWidth();
        double yp = (double)this.getY() + (MathEx.sin(angle) * 0.5 + 0.5) * (double)this.getHeight();
        return new Point((int)(xp + 0.5), (int)(yp + 0.5));
    }

    public Point getEndPoint() {
        double angle = MathEx.toRadians(-this.getAngleStart() - this.getAngleExtent());
        double xp = (double)this.getX() + (MathEx.cos(angle) * 0.5 + 0.5) * (double)this.getWidth();
        double yp = (double)this.getY() + (MathEx.sin(angle) * 0.5 + 0.5) * (double)this.getHeight();
        return new Point((int)(xp + 0.5), (int)(yp + 0.5));
    }

    public void setArc(Point loc, Dimension size, double angSt, double angExt, int closure) {
        this.setArc(loc.getX(), loc.getY(), size.getWidth(), size.getHeight(), angSt, angExt, closure);
    }

    public void setArc(Rectangle rect, double angSt, double angExt, int closure) {
        this.setArc(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), angSt, angExt, closure);
    }

    public void setArc(Arc a) {
        this.setArc(a.getX(), a.getY(), a.getWidth(), a.getHeight(), a.getAngleStart(), a.getAngleExtent(), a.type);
    }

    public void setArcByCenter(double x, double y, double radius, double angSt, double angExt, int closure) {
        this.setArc(x - radius, y - radius, radius * 2.0, radius * 2.0, angSt, angExt, closure);
    }

    public void setArcByTangent(Point p1, Point p2, Point p3, double radius) {
        double ang1 = MathEx.atan2(p1.getY() - p2.getY(), p1.getX() - p2.getX());
        double ang2 = MathEx.atan2(p3.getY() - p2.getY(), p3.getX() - p2.getX());
        double diff = ang2 - ang1;
        if (diff > Math.PI) {
            ang2 -= Math.PI * 2;
        } else if (diff < -Math.PI) {
            ang2 += Math.PI * 2;
        }
        double bisect = (ang1 + ang2) / 2.0;
        double theta = MathEx.abs(ang2 - bisect);
        double dist = radius / MathEx.sin(theta);
        double xp = (double)p2.getX() + dist * MathEx.cos(bisect);
        double yp = (double)p2.getY() + dist * MathEx.sin(bisect);
        if (ang1 < ang2) {
            ang1 -= 1.5707963267948966;
            ang2 += 1.5707963267948966;
        } else {
            ang1 += 1.5707963267948966;
            ang2 -= 1.5707963267948966;
        }
        ang1 = MathEx.toDegrees(-ang1);
        ang2 = MathEx.toDegrees(-ang2);
        diff = ang2 - ang1;
        diff = diff < 0.0 ? (diff += 360.0) : (diff -= 360.0);
        this.setArcByCenter(xp, yp, radius, ang1, diff, this.type);
    }

    public void setAngleStart(Point p) {
        double dx = this.getHeight() * (p.getX() - this.getCenterX());
        double dy = this.getWidth() * (p.getY() - this.getCenterY());
        this.setAngleStart(-MathEx.toDegrees(MathEx.atan2(dy, dx)));
    }

    public void setAngles(double x1, double y1, double x2, double y2) {
        double xp = this.getCenterX();
        double yp = this.getCenterY();
        double w = this.getWidth();
        double h = this.getHeight();
        double ang1 = MathEx.atan2(w * (yp - y1), h * (x1 - xp));
        double ang2 = MathEx.atan2(w * (yp - y2), h * (x2 - xp));
        if ((ang2 -= ang1) <= 0.0) {
            ang2 += Math.PI * 2;
        }
        this.setAngleStart(MathEx.toDegrees(ang1));
        this.setAngleExtent(MathEx.toDegrees(ang2));
    }

    public void setAngles(Point p1, Point p2) {
        this.setAngles(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void setArcType(int type) {
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("invalid type for Arc: " + type);
        }
        this.type = type;
    }

    @Override
    public void setFrame(int x, int y, int w, int h) {
        this.setArc(x, y, w, h, this.getAngleStart(), this.getAngleExtent(), this.type);
    }

    @Override
    public Rectangle getBounds() {
        double x1;
        double y1;
        double x2;
        double y2;
        if (this.isEmpty()) {
            return this.makeBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        if (this.getArcType() == 2) {
            y2 = 0.0;
            x2 = 0.0;
            y1 = 0.0;
            x1 = 0.0;
        } else {
            y1 = 1.0;
            x1 = 1.0;
            y2 = -1.0;
            x2 = -1.0;
        }
        double angle = 0.0;
        for (int i = 0; i < 6; ++i) {
            if (i < 4) {
                if (!this.containsAngle(angle += 90.0)) {
                    continue;
                }
            } else {
                angle = i == 4 ? this.getAngleStart() : (angle += this.getAngleExtent());
            }
            double rads = MathEx.toRadians(-angle);
            double xe = MathEx.cos(rads);
            double ye = MathEx.sin(rads);
            x1 = MathEx.min(x1, xe);
            y1 = MathEx.min(y1, ye);
            x2 = MathEx.max(x2, xe);
            y2 = MathEx.max(y2, ye);
        }
        double w = this.getWidth();
        double h = this.getHeight();
        x2 = (x2 - x1) * 0.5 * w;
        y2 = (y2 - y1) * 0.5 * h;
        x1 = (double)this.getX() + (x1 * 0.5 + 0.5) * w;
        y1 = (double)this.getY() + (y1 * 0.5 + 0.5) * h;
        return this.makeBounds(x1, y1, x2, y2);
    }

    public boolean containsAngle(double angle) {
        boolean backwards;
        double angExt = this.getAngleExtent();
        boolean bl = backwards = angExt < 0.0;
        if (backwards) {
            angExt = -angExt;
        }
        if (angExt >= 360.0) {
            return true;
        }
        angle = Arc.normalizeDegrees(angle) - Arc.normalizeDegrees(this.getAngleStart());
        if (backwards) {
            angle = -angle;
        }
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle >= 0.0 && angle < angExt;
    }

    @Override
    public boolean contains(int x, int y) {
        double y2;
        double x2;
        double y1;
        boolean inside;
        double ellw = this.getWidth();
        if (ellw <= 0.0) {
            return false;
        }
        double normx = (double)(x - this.getX()) / ellw - 0.5;
        double ellh = this.getHeight();
        if (ellh <= 0.0) {
            return false;
        }
        double normy = (double)(y - this.getY()) / ellh - 0.5;
        double distSq = normx * normx + normy * normy;
        if (distSq >= 0.25) {
            return false;
        }
        double angExt = MathEx.abs(this.getAngleExtent());
        if (angExt >= 360.0) {
            return true;
        }
        boolean inarc = this.containsAngle(-MathEx.toDegrees(MathEx.atan2(normy, normx)));
        if (this.type == 2) {
            return inarc;
        }
        if (inarc) {
            if (angExt >= 180.0) {
                return true;
            }
        } else if (angExt <= 180.0) {
            return false;
        }
        double angle = MathEx.toRadians(-this.getAngleStart());
        double x1 = MathEx.cos(angle);
        boolean bl = inside = Line.relativeCCW((int)(x1 + 0.5), (int)((y1 = MathEx.sin(angle)) + 0.5), (int)((x2 = MathEx.cos(angle += MathEx.toRadians(-this.getAngleExtent()))) + 0.5), (int)((y2 = MathEx.sin(angle)) + 0.5), (int)(2.0 * normx + 0.5), (int)(2.0 * normy + 0.5)) * Line.relativeCCW((int)(x1 + 0.5), (int)(y1 + 0.5), (int)(x2 + 0.5), (int)(y2 + 0.5), 0, 0) >= 0;
        return inarc ? !inside : inside;
    }

    @Override
    public boolean intersects(int x, int y, int w, int h) {
        double aw = this.getWidth();
        double ah = this.getHeight();
        if (w <= 0 || h <= 0 || aw <= 0.0 || ah <= 0.0) {
            return false;
        }
        double ext = this.getAngleExtent();
        if (ext == 0.0) {
            return false;
        }
        double ax = this.getX();
        double ay = this.getY();
        double axw = ax + aw;
        double ayh = ay + ah;
        double xw = x + w;
        double yh = y + h;
        if ((double)x >= axw || (double)y >= ayh || xw <= ax || yh <= ay) {
            return false;
        }
        double axc = this.getCenterX();
        double ayc = this.getCenterY();
        Point sp = this.getStartPoint();
        Point ep = this.getEndPoint();
        double sx = sp.getX();
        double sy = sp.getY();
        double ex = ep.getX();
        double ey = ep.getY();
        if (ayc >= (double)y && ayc <= yh && (sx < xw && ex < xw && axc < xw && axw > (double)x && this.containsAngle(0.0) || sx > (double)x && ex > (double)x && axc > (double)x && ax < xw && this.containsAngle(180.0))) {
            return true;
        }
        if (axc >= (double)x && axc <= xw && (sy > (double)y && ey > (double)y && ayc > (double)y && ay < yh && this.containsAngle(90.0) || sy < yh && ey < yh && ayc < yh && ayh > (double)y && this.containsAngle(270.0))) {
            return true;
        }
        Rectangle rect = new Rectangle((int)((double)x + 0.5), (int)((double)y + 0.5), (int)((double)w + 0.5), (int)((double)h + 0.5));
        if (this.type == 2 || MathEx.abs(ext) > 180.0 ? rect.intersectsLine((int)(axc + 0.5), (int)(ayc + 0.5), (int)(sx + 0.5), (int)(sy + 0.5)) || rect.intersectsLine((int)(axc + 0.5), (int)(ayc + 0.5), (int)(ex + 0.5), (int)(ey + 0.5)) : rect.intersectsLine((int)(sx + 0.5), (int)(sy + 0.5), (int)(ex + 0.5), (int)(ey + 0.5))) {
            return true;
        }
        return this.contains(x, y) || this.contains(x + w, y) || this.contains(x, y + h) || this.contains(x + w, y + h);
    }

    @Override
    public boolean contains(int x, int y, int w, int h) {
        return this.contains(x, y, w, h, null);
    }

    @Override
    public boolean contains(Rectangle r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight(), r);
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at) {
        return new ArcIterator(this, at);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getX());
        bits += Double.doubleToLongBits(this.getY()) * 37L;
        bits += Double.doubleToLongBits(this.getWidth()) * 43L;
        bits += Double.doubleToLongBits(this.getHeight()) * 47L;
        bits += Double.doubleToLongBits(this.getAngleStart()) * 53L;
        bits += Double.doubleToLongBits(this.getAngleExtent()) * 59L;
        return (int)(bits += (long)(this.getArcType() * 61)) ^ (int)(bits >> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Arc) {
            Arc a2d = (Arc)obj;
            return this.getX() == a2d.getX() && this.getY() == a2d.getY() && this.getWidth() == a2d.getWidth() && this.getHeight() == a2d.getHeight() && this.getAngleStart() == a2d.getAngleStart() && this.getAngleExtent() == a2d.getAngleExtent() && this.getArcType() == a2d.getArcType();
        }
        return false;
    }

    private boolean contains(int x, int y, int w, int h, Rectangle origrect) {
        double ye;
        double angle;
        double xe;
        double yc;
        if (!(this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h))) {
            return false;
        }
        if (this.type != 2 || MathEx.abs(this.getAngleExtent()) <= 180.0) {
            return true;
        }
        if (origrect == null) {
            origrect = new Rectangle((int)((double)x + 0.5), (int)((double)y + 0.5), (int)((double)w + 0.5), (int)((double)h + 0.5));
        }
        double halfW = (double)this.getWidth() / 2.0;
        double halfH = (double)this.getHeight() / 2.0;
        double xc = (double)this.getX() + halfW;
        if (origrect.intersectsLine((int)(xc + 0.5), (int)((yc = (double)this.getY() + halfH) + 0.5), (int)((xe = xc + halfW * MathEx.cos(angle = MathEx.toRadians(-this.getAngleStart()))) + 0.5), (int)((ye = yc + halfH * MathEx.sin(angle)) + 0.5))) {
            return false;
        }
        xe = xc + halfW * MathEx.cos(angle += MathEx.toRadians(-this.getAngleExtent()));
        return !origrect.intersectsLine((int)(xc + 0.5), (int)(yc + 0.5), (int)(xe + 0.5), (int)((ye = yc + halfH * MathEx.sin(angle)) + 0.5));
    }

    static double normalizeDegrees(double angle) {
        if (angle > 180.0) {
            if (angle <= 540.0) {
                angle -= 360.0;
            } else if ((angle = MathEx.IEEEremainder(angle, 360.0)) == -180.0) {
                angle = 180.0;
            }
        } else if (angle <= -180.0) {
            if (angle > -540.0) {
                angle += 360.0;
            } else if ((angle = MathEx.IEEEremainder(angle, 360.0)) == -180.0) {
                angle = 180.0;
            }
        }
        return angle;
    }
}

