/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing;

import com.guidebee.drawing.Brush;
import com.guidebee.drawing.Color;
import com.guidebee.game.engine.collections.Arrays;
import com.guidebee.game.engine.drawing.core.PenFP;

public class Pen {
    public static final int JOIN_MITER = 1;
    public static final int JOIN_ROUND = 2;
    public static final int JOIN_BEVEL = 3;
    public static final int CAP_BUTT = 1;
    public static final int CAP_ROUND = 2;
    public static final int CAP_SQUARE = 3;
    int width;
    int join;
    int cap;
    int[] dash;
    int dash_phase;
    Color color;
    Brush brush = null;
    PenFP wrappedPenFP = null;

    public Pen(Brush brush, int width, int cap, int join, int[] dash, int dash_phase) {
        this(Color.BLACK, width, cap, join, dash, dash_phase);
        this.brush = brush;
    }

    public Pen(Color color, int width, int cap, int join, int[] dash, int dash_phase) {
        int i;
        if (width < 0) {
            throw new IllegalArgumentException("negative width");
        }
        if (cap != 1 && cap != 2 && cap != 3) {
            throw new IllegalArgumentException("illegal end cap value");
        }
        if (join != 2 && join != 3 && join != 1) {
            throw new IllegalArgumentException("illegal line join value");
        }
        if (dash != null) {
            if (dash_phase < 0) {
                throw new IllegalArgumentException("negative dash phase");
            }
            boolean allzero = true;
            for (i = 0; i < dash.length; ++i) {
                int d = dash[i];
                if (d > 0) {
                    allzero = false;
                    continue;
                }
                if (d >= 0) continue;
                throw new IllegalArgumentException("negative dash length");
            }
            if (allzero) {
                throw new IllegalArgumentException("dash lengths all zero");
            }
        }
        this.width = width;
        this.cap = cap;
        this.join = join;
        this.color = color;
        if (dash != null) {
            this.dash = dash;
        }
        this.dash_phase = dash_phase;
        this.wrappedPenFP = new PenFP(color.value, width << 16, cap, cap, join);
        if (dash != null) {
            int[] newDash = new int[dash.length];
            for (i = 0; i < newDash.length; ++i) {
                newDash[i] = dash[i] << 16;
            }
            this.wrappedPenFP.setDashArray(newDash, dash_phase);
        }
    }

    public Pen(Brush brush, int width, int cap, int join) {
        this(brush, width, cap, join, null, 0);
    }

    public Pen(Color color, int width, int cap, int join) {
        this(color, width, cap, join, null, 0);
    }

    public Pen(Brush brush, int width) {
        this(brush, width, 3, 1, null, 0);
    }

    public Pen(Color color, int width) {
        this(color, width, 3, 1, null, 0);
    }

    public Pen(Brush brush) {
        this(brush, 1, 3, 1, null, 0);
    }

    public Pen(Color color) {
        this(color, 1, 3, 1, null, 0);
    }

    public int getLineWidth() {
        return this.width;
    }

    public Color getPenColor() {
        return this.color;
    }

    public int getEndCap() {
        return this.cap;
    }

    public int getLineJoin() {
        return this.join;
    }

    public int[] getDashArray() {
        if (this.dash == null) {
            return null;
        }
        return this.dash;
    }

    public int getDashPhase() {
        return this.dash_phase;
    }

    public int hashCode() {
        int hash = Float.floatToIntBits(this.width);
        hash = hash * 31 + this.join;
        hash = hash * 31 + this.cap;
        if (this.dash != null) {
            hash = hash * 31 + Float.floatToIntBits(this.dash_phase);
            for (int i = 0; i < this.dash.length; ++i) {
                hash = hash * 31 + Float.floatToIntBits(this.dash[i]);
            }
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Pen)) {
            return false;
        }
        Pen bs = (Pen)obj;
        if (this.width != bs.width) {
            return false;
        }
        if (this.join != bs.join) {
            return false;
        }
        if (this.cap != bs.cap) {
            return false;
        }
        if (this.color != bs.color) {
            return false;
        }
        if (this.dash != null) {
            if (this.dash_phase != bs.dash_phase) {
                return false;
            }
            if (!Arrays.equals(this.dash, bs.dash)) {
                return false;
            }
        } else if (bs.dash != null) {
            return false;
        }
        return true;
    }
}

