/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing;

import com.guidebee.drawing.Brush;
import com.guidebee.drawing.Color;
import com.guidebee.drawing.Utils;
import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.Point;
import com.guidebee.drawing.geometry.Rectangle;
import com.guidebee.game.engine.drawing.core.LinearGradientBrushFP;
import com.guidebee.game.engine.drawing.core.MathFP;
import com.guidebee.game.engine.drawing.core.RectangleFP;
import com.guidebee.game.engine.drawing.core.SingleFP;
import com.guidebee.game.engine.math.MathEx;

public final class LinearGradientBrush
extends Brush {
    private final Point start;
    private final Point end;
    private final AffineTransform gradientTransform;
    private final int[] fractions;
    private final Color[] colors;
    final int transparency;

    public LinearGradientBrush(int startX, int startY, int endX, int endY, int[] fractions, Color[] colors, int fillType) {
        this(new Point(startX, startY), new Point(endX, endY), fractions, colors, fillType);
    }

    public LinearGradientBrush(Point start, Point end, int[] fractions, Color[] colors) {
        this(start, end, fractions, colors, 0);
    }

    public LinearGradientBrush(Point start, Point end, int[] fractions, Color[] colors, int fillType) {
        this(start, end, fractions, colors, new AffineTransform(), fillType);
    }

    public LinearGradientBrush(Rectangle rect, Color color1, Color color2, float angle) {
        this(rect, color1, color2, angle, 0);
    }

    public LinearGradientBrush(Rectangle rect, Color color1, Color color2, float angle, int fillType) {
        this.start = new Point(rect.x, rect.y);
        this.end = new Point(rect.x + rect.width, rect.y + rect.height);
        this.gradientTransform = new AffineTransform();
        this.fractions = new int[]{0, 100};
        this.colors = new Color[]{color1, color2};
        boolean opaque = true;
        for (int i = 0; i < this.colors.length; ++i) {
            opaque = opaque && this.colors[i].getAlpha() == 255;
        }
        this.transparency = opaque ? 1 : 3;
        RectangleFP r = Utils.toRectangleFP(rect);
        this.wrappedBrushFP = new LinearGradientBrushFP(r.getLeft(), r.getTop(), r.getRight(), r.getBottom(), MathFP.toRadians(SingleFP.fromFloat(angle)));
        for (int i = 0; i < this.colors.length; ++i) {
            ((LinearGradientBrushFP)this.wrappedBrushFP).setGradientColor(SingleFP.fromFloat((float)this.fractions[i] / 255.0f), this.colors[i].value);
        }
        ((LinearGradientBrushFP)this.wrappedBrushFP).updateGradientTable();
        this.wrappedBrushFP.setMatrix(Utils.toMatrixFP(this.gradientTransform));
        this.wrappedBrushFP.fillMode = fillType;
    }

    public LinearGradientBrush(Point start, Point end, int[] fractions, Color[] colors, AffineTransform gradientTransform, int fillType) {
        if (fractions == null) {
            throw new NullPointerException("Fractions array cannot be null");
        }
        if (colors == null) {
            throw new NullPointerException("Colors array cannot be null");
        }
        if (gradientTransform == null) {
            throw new NullPointerException("Gradient transform cannot be null");
        }
        if (fractions.length != colors.length) {
            throw new IllegalArgumentException("Colors and fractions must have equal size");
        }
        if (colors.length < 2) {
            throw new IllegalArgumentException("User must specify at least 2 colors");
        }
        int previousFraction = -255;
        for (int i = 0; i < fractions.length; ++i) {
            int currentFraction = fractions[i];
            if (currentFraction < 0 || currentFraction > 255) {
                throw new IllegalArgumentException("Fraction values must be in the range 0 to 255: " + currentFraction);
            }
            if (currentFraction <= previousFraction) {
                throw new IllegalArgumentException("Keyframe fractions must be increasing: " + currentFraction);
            }
            previousFraction = currentFraction;
        }
        boolean fixFirst = false;
        boolean fixLast = false;
        int len = fractions.length;
        int off = 0;
        if (fractions[0] != 0) {
            fixFirst = true;
            ++len;
            ++off;
        }
        if (fractions[fractions.length - 1] != 255) {
            fixLast = true;
            ++len;
        }
        this.fractions = new int[len];
        System.arraycopy(fractions, 0, this.fractions, off, fractions.length);
        this.colors = new Color[len];
        System.arraycopy(colors, 0, this.colors, off, colors.length);
        if (fixFirst) {
            this.fractions[0] = 0;
            this.colors[0] = colors[0];
        }
        if (fixLast) {
            this.fractions[len - 1] = 255;
            this.colors[len - 1] = colors[colors.length - 1];
        }
        this.gradientTransform = new AffineTransform(gradientTransform);
        boolean opaque = true;
        for (int i = 0; i < colors.length; ++i) {
            opaque = opaque && colors[i].getAlpha() == 255;
        }
        int n = this.transparency = opaque ? 1 : 3;
        if (start == null || end == null) {
            throw new NullPointerException("Start and end points must benon-null");
        }
        if (start.equals(end)) {
            throw new IllegalArgumentException("Start point cannot equalendpoint");
        }
        this.start = new Point(start.getX(), start.getY());
        this.end = new Point(end.getX(), end.getY());
        Rectangle rectangle = new Rectangle(start, end);
        float dx = start.x - end.x;
        float dy = start.y - end.y;
        double angle = MathEx.atan2(dy, dx);
        int intAngle = SingleFP.fromDouble(angle);
        RectangleFP r = Utils.toRectangleFP(rectangle);
        this.wrappedBrushFP = new LinearGradientBrushFP(r.getLeft(), r.getTop(), r.getRight(), r.getBottom(), intAngle);
        for (int i = 0; i < colors.length; ++i) {
            ((LinearGradientBrushFP)this.wrappedBrushFP).setGradientColor(SingleFP.fromFloat((float)fractions[i] / 100.0f), colors[i].value);
        }
        ((LinearGradientBrushFP)this.wrappedBrushFP).updateGradientTable();
        this.wrappedBrushFP.setMatrix(Utils.toMatrixFP(gradientTransform));
        this.wrappedBrushFP.fillMode = fillType;
    }

    public Point getStartPoint() {
        return new Point(this.start.getX(), this.start.getY());
    }

    public Point getEndPoint() {
        return new Point(this.end.getX(), this.end.getY());
    }

    public final AffineTransform getTransform() {
        return this.gradientTransform;
    }

    public final int[] getFractions() {
        return this.fractions;
    }

    public final Color[] getColors() {
        return this.colors;
    }

    @Override
    public int getTransparency() {
        return this.transparency;
    }
}

