/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing;

import com.guidebee.drawing.Brush;
import com.guidebee.drawing.Color;
import com.guidebee.drawing.Pen;
import com.guidebee.drawing.SolidBrush;
import com.guidebee.drawing.Utils;
import com.guidebee.drawing.VectorFont;
import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.Area;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.IShape;
import com.guidebee.drawing.geometry.Path;
import com.guidebee.drawing.geometry.Point;
import com.guidebee.drawing.geometry.Polygon;
import com.guidebee.drawing.geometry.Polyline;
import com.guidebee.drawing.geometry.Rectangle;
import com.guidebee.game.engine.drawing.core.GraphicsFP;
import com.guidebee.game.engine.drawing.core.GraphicsPathDasherFP;
import com.guidebee.game.engine.drawing.core.GraphicsPathFP;
import com.guidebee.game.engine.drawing.core.MatrixFP;
import com.guidebee.game.engine.drawing.core.PenFP;
import com.guidebee.game.engine.drawing.core.PointFP;
import com.guidebee.game.engine.drawing.core.SolidBrushFP;

public final class Graphics2D {
    private final int graphicsWidth;
    private final int graphicsHeight;
    private final GraphicsFP graphicsFP;
    private Pen defaultPen = null;
    private Brush defaultBrush = null;

    public Graphics2D(int width, int height) {
        this.graphicsFP = new GraphicsFP(width, height);
        this.defaultPen = new Pen(Color.BLACK);
        this.defaultBrush = new SolidBrush(Color.WHITE);
        this.graphicsWidth = width;
        this.graphicsHeight = height;
    }

    public void Reset() {
        this.graphicsFP.setMatrix(new MatrixFP());
        this.defaultPen = new Pen(Color.BLACK);
        this.defaultBrush = new SolidBrush(Color.WHITE);
        this.graphicsFP.setClip(0, 0, this.graphicsWidth, this.graphicsHeight);
    }

    public int getWidth() {
        return this.graphicsWidth;
    }

    public int getHeight() {
        return this.graphicsHeight;
    }

    public static IShape getOutline(Pen pen, IShape shape) {
        if (pen != null) {
            PenFP penFP = new PenFP(pen.color.getRGB());
            penFP.endCap = pen.cap;
            penFP.startCap = pen.cap;
            penFP.lineJoin = pen.join;
            penFP.width = pen.width << 16;
            penFP.brush = pen.brush != null ? pen.brush.wrappedBrushFP : new SolidBrushFP(pen.color.value);
            if (pen.dash != null) {
                penFP.dashArray = new int[pen.dash.length - pen.dash_phase];
                for (int i = 0; i < pen.dash.length - pen.dash_phase; ++i) {
                    penFP.dashArray[i] = pen.dash[i - pen.dash_phase] << 16;
                }
            } else {
                penFP.dashArray = null;
            }
            IPathIterator pathIterator = shape.getPathIterator(null);
            int[] coords = new int[6];
            GraphicsPathFP graphicsPathFP = new GraphicsPathFP();
            PointFP pointFP1 = new PointFP();
            PointFP pointFPCtl1 = new PointFP();
            PointFP pointFPCtl2 = new PointFP();
            while (!pathIterator.isDone()) {
                int type = pathIterator.currentSegment(coords);
                switch (type) {
                    case 0: {
                        pointFP1.reset(coords[0] << 16, coords[1] << 16);
                        graphicsPathFP.addMoveTo(pointFP1);
                        break;
                    }
                    case 4: {
                        graphicsPathFP.addClose();
                        break;
                    }
                    case 1: {
                        pointFP1.reset(coords[0] << 16, coords[1] << 16);
                        graphicsPathFP.addLineTo(pointFP1);
                        break;
                    }
                    case 2: {
                        pointFPCtl1.reset(coords[0] << 16, coords[1] << 16);
                        pointFP1.reset(coords[2] << 16, coords[3] << 16);
                        graphicsPathFP.addQuadTo(pointFPCtl1, pointFP1);
                        break;
                    }
                    case 3: {
                        pointFPCtl1.reset(coords[0] << 16, coords[1] << 16);
                        pointFPCtl2.reset(coords[2] << 16, coords[3] << 16);
                        pointFP1.reset(coords[4] << 16, coords[5] << 16);
                        graphicsPathFP.addCurveTo(pointFPCtl1, pointFPCtl2, pointFP1);
                    }
                }
                pathIterator.next();
            }
            if (penFP.dashArray != null) {
                GraphicsPathFP newPath;
                PenFP newlineStyle = new PenFP(penFP.brush, penFP.width, 1, 1, 1);
                newlineStyle.dashArray = penFP.dashArray;
                GraphicsPathDasherFP dasher = new GraphicsPathDasherFP(graphicsPathFP, newlineStyle.dashArray, 0);
                graphicsPathFP = newPath = dasher.GetDashedGraphicsPath();
            }
            GraphicsPathFP outline = graphicsPathFP.calcOutline(penFP);
            return Graphics2D.union(outline.toPath());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void draw(Pen pen, IShape shape) {
        this.setGraphicsFPPenAttribute(pen);
        IPathIterator pathIterator = shape.getPathIterator(null);
        int[] coords = new int[6];
        GraphicsPathFP graphicsPathFP = new GraphicsPathFP();
        PointFP pointFP1 = new PointFP();
        PointFP pointFPCtl1 = new PointFP();
        PointFP pointFPCtl2 = new PointFP();
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    pointFP1.reset(coords[0] << 16, coords[1] << 16);
                    graphicsPathFP.addMoveTo(pointFP1);
                    break;
                }
                case 4: {
                    graphicsPathFP.addClose();
                    break;
                }
                case 1: {
                    pointFP1.reset(coords[0] << 16, coords[1] << 16);
                    graphicsPathFP.addLineTo(pointFP1);
                    break;
                }
                case 2: {
                    pointFPCtl1.reset(coords[0] << 16, coords[1] << 16);
                    pointFP1.reset(coords[2] << 16, coords[3] << 16);
                    graphicsPathFP.addQuadTo(pointFPCtl1, pointFP1);
                    break;
                }
                case 3: {
                    pointFPCtl1.reset(coords[0] << 16, coords[1] << 16);
                    pointFPCtl2.reset(coords[2] << 16, coords[3] << 16);
                    pointFP1.reset(coords[4] << 16, coords[5] << 16);
                    graphicsPathFP.addCurveTo(pointFPCtl1, pointFPCtl2, pointFP1);
                }
            }
            pathIterator.next();
        }
        GraphicsFP graphicsFP = this.graphicsFP;
        synchronized (graphicsFP) {
            this.graphicsFP.drawPath(graphicsPathFP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fill(Brush brush, IShape shape) {
        if (brush != null) {
            GraphicsFP graphicsFP = this.graphicsFP;
            synchronized (graphicsFP) {
                this.graphicsFP.setBrush(brush.wrappedBrushFP);
            }
            this.defaultBrush = brush;
        }
        IPathIterator pathIterator = shape.getPathIterator(null);
        int[] coords = new int[6];
        GraphicsPathFP graphicsPathFP = new GraphicsPathFP();
        PointFP pointFP1 = new PointFP();
        PointFP pointFPCtl1 = new PointFP();
        PointFP pointFPCtl2 = new PointFP();
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 0: {
                    pointFP1.reset(coords[0] << 16, coords[1] << 16);
                    graphicsPathFP.addMoveTo(pointFP1);
                    break;
                }
                case 4: {
                    graphicsPathFP.addClose();
                    break;
                }
                case 1: {
                    pointFP1.reset(coords[0] << 16, coords[1] << 16);
                    graphicsPathFP.addLineTo(pointFP1);
                    break;
                }
                case 2: {
                    pointFPCtl1.reset(coords[0] << 16, coords[1] << 16);
                    pointFP1.reset(coords[2] << 16, coords[3] << 16);
                    graphicsPathFP.addQuadTo(pointFPCtl1, pointFP1);
                    break;
                }
                case 3: {
                    pointFPCtl1.reset(coords[0] << 16, coords[1] << 16);
                    pointFPCtl2.reset(coords[2] << 16, coords[3] << 16);
                    pointFP1.reset(coords[4] << 16, coords[5] << 16);
                    graphicsPathFP.addCurveTo(pointFPCtl1, pointFPCtl2, pointFP1);
                }
            }
            pathIterator.next();
        }
        GraphicsFP graphicsFP = this.graphicsFP;
        synchronized (graphicsFP) {
            this.graphicsFP.fillPath(graphicsPathFP);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drawLine(Pen pen, int x1, int y1, int x2, int y2) {
        this.setGraphicsFPPenAttribute(pen);
        GraphicsFP graphicsFP = this.graphicsFP;
        synchronized (graphicsFP) {
            this.graphicsFP.drawLine(x1 << 16, y1 << 16, x2 << 16, y2 << 16);
        }
    }

    public final void drawLine(Pen pen, Point pt1, Point pt2) {
        this.drawLine(pen, pt1.x, pt1.y, pt2.x, pt2.y);
    }

    public void drawChars(VectorFont font, int fontSize, char[] data, int x, int y) {
        this.drawChars(font, fontSize, data, 0, data.length, x, y, 1);
    }

    public void drawChars(VectorFont font, int fontSize, char[] data, int offset, int length, int x, int y) {
        this.drawChars(font, fontSize, data, offset, length, x, y, 1);
    }

    public void drawChars(VectorFont font, int fontSize, char[] data, int offset, int length, int x, int y, int tdir) {
        this.drawChars(font, this.defaultBrush, this.defaultPen, fontSize, data, offset, length, x, y, tdir);
    }

    public void drawChars(VectorFont font, Brush brush, Pen pen, int fontSize, char[] data, int offset, int length, int x, int y, int tdir) {
        AffineTransform transfrom = new AffineTransform();
        transfrom.translate(x, y);
        IShape[] shapes = font.getGlyphArray(fontSize, data, offset, length, tdir, transfrom);
        for (int j = 0; j < shapes.length; ++j) {
            if (shapes[j] == null) continue;
            if (brush != null) {
                this.fill(brush, shapes[j]);
            }
            if (pen == null) continue;
            this.draw(pen, shapes[j]);
        }
    }

    public final void setDefaultPen(Pen pen) {
        this.defaultPen = pen;
        this.setGraphicsFPPenAttribute(pen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setPenAndBrush(Pen pen, Brush brush) {
        this.setDefaultPen(pen);
        if (brush != null) {
            GraphicsFP graphicsFP = this.graphicsFP;
            synchronized (graphicsFP) {
                this.graphicsFP.setBrush(brush.wrappedBrushFP);
            }
            this.defaultBrush = brush;
        }
    }

    public final Pen getDefaultPen() {
        return this.defaultPen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDefaultBrush(Brush brush) {
        if (brush != null) {
            GraphicsFP graphicsFP = this.graphicsFP;
            synchronized (graphicsFP) {
                this.graphicsFP.setBrush(brush.wrappedBrushFP);
            }
            this.defaultBrush = brush;
        }
    }

    public final Brush getDefaultBrush() {
        return this.defaultBrush;
    }

    public final void drawRectangle(Pen pen, Rectangle rectangle) {
        this.draw(pen, rectangle);
    }

    public final void fillRectangle(Brush brush, Rectangle rectangle) {
        this.fill(brush, rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drawOval(Pen pen, int x, int y, int width, int height) {
        this.setGraphicsFPPenAttribute(pen);
        GraphicsFP graphicsFP = this.graphicsFP;
        synchronized (graphicsFP) {
            this.graphicsFP.drawOval(x << 16, y << 16, x + width << 16, y + height << 16);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fillOval(Brush brush, int x, int y, int width, int height) {
        this.setDefaultBrush(brush);
        GraphicsFP graphicsFP = this.graphicsFP;
        synchronized (graphicsFP) {
            this.graphicsFP.fillOval(x << 16, y << 16, x + width << 16, y + height << 16);
        }
    }

    public final void drawPolyline(Pen pen, Polyline polyline) {
        this.draw(pen, polyline);
    }

    public final void drawPolygon(Pen pen, Polygon polygon) {
        this.draw(pen, polygon);
    }

    public final void fillPolygon(Brush brush, Polygon polygon) {
        this.fill(brush, polygon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAffineTransform(AffineTransform matrix) {
        GraphicsFP graphicsFP = this.graphicsFP;
        synchronized (graphicsFP) {
            this.graphicsFP.setMatrix(Utils.toMatrixFP(matrix));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final AffineTransform getAffineTransform() {
        GraphicsFP graphicsFP = this.graphicsFP;
        synchronized (graphicsFP) {
            return Utils.toMatrix(this.graphicsFP.getMatrix());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Rectangle getClip() {
        GraphicsFP graphicsFP = this.graphicsFP;
        synchronized (graphicsFP) {
            return new Rectangle(this.graphicsFP.getClipX(), this.graphicsFP.getClipY(), this.graphicsFP.getClipWidth(), this.graphicsFP.getClipHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClip(int x, int y, int width, int height) {
        GraphicsFP graphicsFP = this.graphicsFP;
        synchronized (graphicsFP) {
            this.graphicsFP.setClip(x, y, width, height);
        }
    }

    public final void drawImage(int[] imageRGB, int width, int height, int dstX, int dstY) {
        Rectangle rect2;
        Rectangle rect1 = this.getClip();
        Rectangle rect = rect1.intersection(rect2 = new Rectangle(dstX, dstY, width + dstX, height + dstY));
        if (!rect.isEmpty()) {
            int[] destBuffer = this.getRGB();
            int desWidth = this.graphicsWidth;
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    if (dstX + i >= this.graphicsWidth || dstY + j >= this.graphicsHeight || dstX + i < 0 || dstY + j < 0) continue;
                    destBuffer[dstX + i + (j + dstY) * desWidth] = Graphics2D.merge(destBuffer[dstX + i + (j + dstY) * desWidth], imageRGB[i + j * width] & 0xFFFFFFFF);
                }
            }
        }
    }

    public final void drawImage(int[] imageRGB, int width, int height, int dstX, int dstY, int srcX, int srcY, int dstWidth, int dstHeight) {
        int[] tempRGB = imageRGB;
        dstWidth = Math.min(dstWidth, width - srcX);
        dstHeight = Math.min(dstHeight, height - srcY);
        if (dstWidth != width || dstHeight != height) {
            tempRGB = new int[dstWidth * dstHeight];
            for (int i = 0; i < dstHeight; ++i) {
                System.arraycopy(imageRGB, (i + srcY) * width + srcX, tempRGB, i * dstWidth, dstWidth);
            }
        }
        this.drawImage(tempRGB, dstWidth, dstHeight, dstX, dstY);
    }

    public final void drawImage(int[] imageRGB, int width, int height, int dstX, int dstY, int transpency) {
        Rectangle rect2;
        Rectangle rect1 = this.getClip();
        Rectangle rect = rect1.intersection(rect2 = new Rectangle(dstX, dstY, width + dstX, height + dstY));
        if (!rect.isEmpty()) {
            int[] destBuffer = this.getRGB();
            int desWidth = this.graphicsWidth;
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    if (dstX + i >= this.graphicsWidth || dstY + j >= this.graphicsHeight || dstX + i < 0 || dstY + j < 0 || (imageRGB[i + j * width] & 0xFFFFFF) == (transpency & 0xFFFFFF)) continue;
                    destBuffer[dstX + i + (j + dstY) * desWidth] = Graphics2D.merge(destBuffer[dstX + i + (j + dstY) * desWidth], imageRGB[i + j * width] & 0xFFFFFFFF);
                }
            }
        }
    }

    public final void drawImage(int[] imageRGB, int width, int height, int dstX, int dstY, int transpency, int alpha) {
        Rectangle rect2;
        Rectangle rect1 = this.getClip();
        Rectangle rect = rect1.intersection(rect2 = new Rectangle(dstX, dstY, width + dstX, height + dstY));
        if (!rect.isEmpty()) {
            int[] destBuffer = this.getRGB();
            int desWidth = this.graphicsWidth;
            for (int i = 0; i < width; ++i) {
                for (int j = 0; j < height; ++j) {
                    if (dstX + i >= this.graphicsWidth || dstY + j >= this.graphicsHeight || dstX + i < 0 || dstY + j < 0 || (imageRGB[i + j * width] & 0xFFFFFF) == (transpency & 0xFFFFFF)) continue;
                    destBuffer[dstX + i + (j + dstY) * desWidth] = Graphics2D.merge(destBuffer[dstX + i + (j + dstY) * desWidth], imageRGB[i + j * width] & ((alpha & 0xFF) << 24 | 0xFFFFFF));
                }
            }
        }
    }

    public void setClip(Rectangle rectangle) {
        this.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public final void clear(Color color) {
        this.clear(color.value);
    }

    public void clear() {
        this.clear(0xFFFFFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(int color) {
        GraphicsFP graphicsFP = this.graphicsFP;
        synchronized (graphicsFP) {
            this.graphicsFP.clear(color);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getRGB() {
        GraphicsFP graphicsFP = this.graphicsFP;
        synchronized (graphicsFP) {
            return this.graphicsFP.getRGB();
        }
    }

    static IShape union(IShape shape) {
        IPathIterator pathIterator = shape.getPathIterator(null);
        Area area = new Area();
        int[] coords = new int[6];
        Path path = new Path();
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 4: {
                    path.closePath();
                    area.add(new Area(path));
                    path = new Path();
                    break;
                }
                case 3: {
                    path.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 1: {
                    path.lineTo(coords[0], coords[1]);
                    break;
                }
                case 0: {
                    path.moveTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    path.quadTo(coords[0], coords[1], coords[2], coords[3]);
                }
            }
            pathIterator.next();
        }
        return area;
    }

    private void setGraphicsFPPenAttribute(Pen pen) {
        if (pen != null) {
            this.defaultPen = pen;
            PenFP penFP = this.graphicsFP.getPen();
            penFP.endCap = pen.cap;
            penFP.startCap = pen.cap;
            penFP.lineJoin = pen.join;
            penFP.width = pen.width << 16;
            penFP.brush = pen.brush != null ? pen.brush.wrappedBrushFP : new SolidBrushFP(pen.color.value);
            if (pen.dash != null) {
                penFP.dashArray = new int[pen.dash.length - pen.dash_phase];
                for (int i = pen.dash_phase; i < pen.dash.length - pen.dash_phase; ++i) {
                    penFP.dashArray[i - pen.dash_phase] = pen.dash[i] << 16;
                }
            } else {
                penFP.dashArray = null;
            }
        }
    }

    private static int merge(int color1, int color2) {
        int a2 = color2 >> 24 & 0xFF;
        if (a2 == 255 || color1 == 0) {
            return color2;
        }
        if (a2 == 0) {
            return color1;
        }
        int a1 = 255 - (color1 >> 24 & 0xFF);
        int a3 = 255 - a2;
        int b1 = color1 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int b2 = color2 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int Ca = 65025 - a1 * a3 >> 8;
        int Cr = r1 * a3 + r2 * a2 >> 8;
        int Cg = g1 * a3 + g2 * a2 >> 8;
        int Cb = b1 * a3 + b2 * a2 >> 8;
        return Ca << 24 | Cr << 16 | Cg << 8 | Cb;
    }
}

