/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.utils;

import com.guidebee.game.files.FileHandle;
import com.guidebee.utils.BaseJsonReader;
import com.guidebee.utils.JsonValue;
import com.guidebee.utils.SerializationException;
import com.guidebee.utils.StreamUtils;
import com.guidebee.utils.StringBuilder;
import com.guidebee.utils.collections.Array;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JsonReader
implements BaseJsonReader {
    private static final byte[] _json_actions = JsonReader.init__json_actions_0();
    private static final short[] _json_key_offsets = JsonReader.init__json_key_offsets_0();
    private static final char[] _json_trans_keys = JsonReader.init__json_trans_keys_0();
    private static final byte[] _json_single_lengths = JsonReader.init__json_single_lengths_0();
    private static final byte[] _json_range_lengths = JsonReader.init__json_range_lengths_0();
    private static final short[] _json_index_offsets = JsonReader.init__json_index_offsets_0();
    private static final byte[] _json_indicies = JsonReader.init__json_indicies_0();
    private static final byte[] _json_trans_targs = JsonReader.init__json_trans_targs_0();
    private static final byte[] _json_trans_actions = JsonReader.init__json_trans_actions_0();
    private static final byte[] _json_eof_actions = JsonReader.init__json_eof_actions_0();
    static final int json_start = 1;
    static final int json_first_final = 32;
    static final int json_error = 0;
    static final int json_en_object = 5;
    static final int json_en_array = 22;
    static final int json_en_main = 1;
    private final Array<JsonValue> elements = new Array(8);
    private final Array<JsonValue> lastChild = new Array(8);
    private JsonValue root;
    private JsonValue current;

    public JsonValue parse(String json) {
        char[] data = json.toCharArray();
        return this.parse(data, 0, data.length);
    }

    public JsonValue parse(Reader reader) {
        try {
            int length;
            char[] data = new char[1024];
            int offset = 0;
            while ((length = reader.read(data, offset, data.length - offset)) != -1) {
                if (length == 0) {
                    char[] newData = new char[data.length * 2];
                    System.arraycopy(data, 0, newData, 0, data.length);
                    data = newData;
                    continue;
                }
                offset += length;
            }
            JsonValue jsonValue = this.parse(data, 0, offset);
            return jsonValue;
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        finally {
            StreamUtils.closeQuietly(reader);
        }
    }

    @Override
    public JsonValue parse(InputStream input) {
        try {
            JsonValue jsonValue = this.parse(new InputStreamReader(input, "UTF-8"));
            return jsonValue;
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        finally {
            StreamUtils.closeQuietly(input);
        }
    }

    @Override
    public JsonValue parse(FileHandle file) {
        try {
            return this.parse(file.reader("UTF-8"));
        }
        catch (Exception ex) {
            throw new SerializationException("Error parsing file: " + file, ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public JsonValue parse(char[] data, int offset, int length) {
        p = offset;
        eof = pe = length;
        top = 0;
        stack = new int[4];
        s = 0;
        names = new Array<String>(8);
        needsUnescape = false;
        stringIsName = false;
        stringIsUnquoted = false;
        parseRuntimeEx = null;
        debug = false;
        if (debug) {
            System.out.println();
        }
        try {
            cs = 1;
            top = 0;
            _trans = 0;
            _goto_targ = 0;
            block40: while (true) {
                switch (_goto_targ) {
                    case 0: {
                        if (p == pe) {
                            _goto_targ = 4;
                            continue block40;
                        }
                        if (cs == 0) {
                            _goto_targ = 5;
                            continue block40;
                        }
                    }
                    case 1: {
                        _keys = JsonReader._json_key_offsets[cs];
                        _trans = JsonReader._json_index_offsets[cs];
                        _klen = JsonReader._json_single_lengths[cs];
                        if (_klen <= 0) ** GOTO lbl47
                        _lower = _keys;
                        _upper = _keys + _klen - 1;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1);
                            if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                _upper = _mid - 1;
                                continue;
                            }
                            if (data[p] > JsonReader._json_trans_keys[_mid]) {
                                _lower = _mid + 1;
                                continue;
                            }
                            _trans += _mid - _keys;
                            ** GOTO lbl61
                        }
                        _keys += _klen;
                        _trans += _klen;
lbl47:
                        // 2 sources

                        if ((_klen = JsonReader._json_range_lengths[cs]) > 0) {
                            _lower = _keys;
                            _upper = _keys + (_klen << 1) - 2;
                            while (_upper >= _lower) {
                                _mid = _lower + (_upper - _lower >> 1 & -2);
                                if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                    _upper = _mid - 2;
                                    continue;
                                }
                                if (data[p] > JsonReader._json_trans_keys[_mid + 1]) {
                                    _lower = _mid + 2;
                                    continue;
                                }
                                _trans += _mid - _keys >> 1;
                                ** GOTO lbl61
                            }
                            _trans += _klen;
                        }
lbl61:
                        // 5 sources

                        _trans = JsonReader._json_indicies[_trans];
                        cs = JsonReader._json_trans_targs[_trans];
                        if (JsonReader._json_trans_actions[_trans] == 0) ** GOTO lbl212
                        _acts = JsonReader._json_trans_actions[_trans];
                        _nacts = JsonReader._json_actions[_acts++];
                        block43: while (_nacts-- > 0) {
                            switch (JsonReader._json_actions[_acts++]) {
                                case 0: {
                                    stringIsName = true;
                                    break;
                                }
                                case 1: {
                                    value = new String(data, s, p - s);
                                    s = p;
                                    if (needsUnescape) {
                                        value = this.unescape(value);
                                    }
                                    if (!stringIsName) ** GOTO lbl82
                                    stringIsName = false;
                                    if (debug) {
                                        System.out.println("name: " + value);
                                    }
                                    names.add(value);
                                    ** GOTO lbl115
lbl82:
                                    // 1 sources

                                    v0 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (!stringIsUnquoted) ** GOTO lbl112
                                    if (!value.equals("true")) ** GOTO lbl89
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=true");
                                    }
                                    this.bool(name, true);
                                    ** GOTO lbl115
lbl89:
                                    // 1 sources

                                    if (!value.equals("false")) ** GOTO lbl94
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=false");
                                    }
                                    this.bool(name, false);
                                    ** GOTO lbl115
lbl94:
                                    // 1 sources

                                    if (!value.equals("null")) ** GOTO lbl97
                                    this.string(name, null);
                                    ** GOTO lbl115
lbl97:
                                    // 1 sources

                                    if (value.indexOf(46) == -1) ** GOTO lbl105
                                    try {
                                        if (debug) {
                                            System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                        }
                                        this.number(name, Double.parseDouble(value));
                                        ** GOTO lbl115
                                    }
                                    catch (NumberFormatException ignored) {
                                        ** GOTO lbl112
                                    }
lbl105:
                                    // 1 sources

                                    try {
                                        if (debug) {
                                            System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                        }
                                        this.number(name, Long.parseLong(value));
                                        ** GOTO lbl115
                                    }
                                    catch (NumberFormatException ignored) {
                                        // empty catch block
                                    }
lbl112:
                                    // 3 sources

                                    if (debug) {
                                        System.out.println("string: " + name + "=" + value);
                                    }
                                    this.string(name, value);
lbl115:
                                    // 7 sources

                                    stringIsUnquoted = false;
                                    break;
                                }
                                case 2: {
                                    v1 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("startObject: " + name);
                                    }
                                    this.startObject(name);
                                    if (top == stack.length) {
                                        newStack = new int[stack.length * 2];
                                        System.arraycopy(stack, 0, newStack, 0, stack.length);
                                        stack = newStack;
                                    }
                                    stack[top++] = cs;
                                    cs = 5;
                                    _goto_targ = 2;
                                    continue block40;
                                }
                                case 3: {
                                    if (debug) {
                                        System.out.println("endObject");
                                    }
                                    this.pop();
                                    cs = stack[--top];
                                    _goto_targ = 2;
                                    continue block40;
                                }
                                case 4: {
                                    v2 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("startArray: " + name);
                                    }
                                    this.startArray(name);
                                    if (top == stack.length) {
                                        newStack = new int[stack.length * 2];
                                        System.arraycopy(stack, 0, newStack, 0, stack.length);
                                        stack = newStack;
                                    }
                                    stack[top++] = cs;
                                    cs = 22;
                                    _goto_targ = 2;
                                    continue block40;
                                }
                                case 5: {
                                    if (debug) {
                                        System.out.println("endArray");
                                    }
                                    this.pop();
                                    cs = stack[--top];
                                    _goto_targ = 2;
                                    continue block40;
                                }
                                case 6: {
                                    if (debug) {
                                        System.out.println("comment /" + data[p]);
                                    }
                                    if (data[p++] == '/') {
                                        while (data[p] != '\n') {
                                            ++p;
                                        }
                                        continue block43;
                                    }
                                    while (data[p] != '*' || data[p + 1] != '/') {
                                        ++p;
                                    }
                                    ++p;
                                    break;
                                }
                                case 7: {
                                    if (debug) {
                                        System.out.println("unquotedChars");
                                    }
                                    s = p;
                                    needsUnescape = false;
                                    stringIsUnquoted = true;
                                    if (stringIsName) {
                                        block46: while (true) {
                                            switch (data[p]) {
                                                case '\t': 
                                                case '\n': 
                                                case '\r': 
                                                case ' ': 
                                                case ':': {
                                                    break block46;
                                                }
                                                default: {
                                                    if (++p != eof) continue block46;
                                                    break block46;
                                                }
                                            }
                                            break;
                                        }
                                    } else {
                                        block47: while (true) {
                                            switch (data[p]) {
                                                case '\t': 
                                                case '\n': 
                                                case '\r': 
                                                case ' ': 
                                                case ',': 
                                                case ']': 
                                                case '}': {
                                                    break block47;
                                                }
                                                default: {
                                                    if (++p != eof) continue block47;
                                                    break block47;
                                                }
                                            }
                                            break;
                                        }
                                    }
                                    --p;
                                    break;
                                }
                                case 8: {
                                    if (debug) {
                                        System.out.println("quotedChars");
                                    }
                                    s = ++p;
                                    needsUnescape = false;
                                    block48: while (true) {
                                        switch (data[p]) {
                                            case '\\': {
                                                needsUnescape = true;
                                                ++p;
                                                ** GOTO lbl207
                                            }
                                            case '\"': {
                                                break block48;
                                            }
lbl207:
                                            // 2 sources

                                            default: {
                                                if (++p != eof) continue block48;
                                                break block48;
                                            }
                                        }
                                        break;
                                    }
                                    --p;
                                }
                            }
                        }
                    }
lbl212:
                    // 3 sources

                    case 2: {
                        if (cs == 0) {
                            _goto_targ = 5;
                            continue block40;
                        }
                        if (++p != pe) {
                            _goto_targ = 1;
                            continue block40;
                        }
                    }
                    case 4: {
                        if (p != eof) break block40;
                        __acts = JsonReader._json_eof_actions[cs];
                        __nacts = JsonReader._json_actions[__acts++];
                        while (__nacts-- > 0) {
                            switch (JsonReader._json_actions[__acts++]) {
                                case 1: {
                                    value = new String(data, s, p - s);
                                    s = p;
                                    if (needsUnescape) {
                                        value = this.unescape(value);
                                    }
                                    if (!stringIsName) ** GOTO lbl236
                                    stringIsName = false;
                                    if (debug) {
                                        System.out.println("name: " + value);
                                    }
                                    names.add(value);
                                    ** GOTO lbl269
lbl236:
                                    // 1 sources

                                    v3 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (!stringIsUnquoted) ** GOTO lbl266
                                    if (!value.equals("true")) ** GOTO lbl243
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=true");
                                    }
                                    this.bool(name, true);
                                    ** GOTO lbl269
lbl243:
                                    // 1 sources

                                    if (!value.equals("false")) ** GOTO lbl248
                                    if (debug) {
                                        System.out.println("boolean: " + name + "=false");
                                    }
                                    this.bool(name, false);
                                    ** GOTO lbl269
lbl248:
                                    // 1 sources

                                    if (!value.equals("null")) ** GOTO lbl251
                                    this.string(name, null);
                                    ** GOTO lbl269
lbl251:
                                    // 1 sources

                                    if (value.indexOf(46) == -1) ** GOTO lbl259
                                    try {
                                        if (debug) {
                                            System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                        }
                                        this.number(name, Double.parseDouble(value));
                                        ** GOTO lbl269
                                    }
                                    catch (NumberFormatException ignored) {
                                        ** GOTO lbl266
                                    }
lbl259:
                                    // 1 sources

                                    try {
                                        if (debug) {
                                            System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                        }
                                        this.number(name, Long.parseLong(value));
                                        ** GOTO lbl269
                                    }
                                    catch (NumberFormatException ignored) {
                                        // empty catch block
                                    }
lbl266:
                                    // 3 sources

                                    if (debug) {
                                        System.out.println("string: " + name + "=" + value);
                                    }
                                    this.string(name, value);
lbl269:
                                    // 7 sources

                                    stringIsUnquoted = false;
                                }
                            }
                        }
                        break block40;
                    }
                }
                break;
            }
        }
        catch (RuntimeException ex) {
            parseRuntimeEx = ex;
        }
        root = this.root;
        this.root = null;
        this.current = null;
        this.lastChild.clear();
        if (p < pe) {
            lineNumber = 1;
            for (i = 0; i < p; ++i) {
                if (data[i] != '\n') continue;
                ++lineNumber;
            }
            throw new SerializationException("Error parsing JSON on line " + lineNumber + " near: " + new String(data, p, pe - p), parseRuntimeEx);
        }
        if (this.elements.size != 0) {
            element = this.elements.peek();
            this.elements.clear();
            if (element != null && element.isObject()) {
                throw new SerializationException("Error parsing JSON, unmatched brace.");
            }
            throw new SerializationException("Error parsing JSON, unmatched bracket.");
        }
        if (parseRuntimeEx != null) {
            throw new SerializationException("Error parsing JSON: " + new String(data), parseRuntimeEx);
        }
        return root;
    }

    private static byte[] init__json_actions_0() {
        return new byte[]{0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 2, 0, 7, 2, 0, 8, 2, 1, 3, 2, 1, 5, 2, 6, 1, 2, 7, 6, 3, 0, 7, 6};
    }

    private static short[] init__json_key_offsets_0() {
        return new short[]{0, 0, 12, 14, 15, 28, 40, 46, 52, 54, 66, 73, 80, 92, 93, 100, 113, 115, 116, 124, 137, 144, 157, 169, 176, 183, 195, 196, 204, 217, 219, 227, 240, 245, 250, 256, 256};
    }

    private static char[] init__json_trans_keys_0() {
        return new char[]{'\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '*', '/', '\"', '\r', ' ', '\"', '*', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\r', ' ', '/', ':', '\t', '\n', '\r', ' ', '/', ':', '\t', '\n', '*', '/', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\r', ' ', ',', '/', '}', '\t', '\n', '\r', ' ', ',', '/', '}', '\t', '\n', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\"', '\r', ' ', '*', '/', ':', '\t', '\n', '\r', ' ', '\"', '*', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '*', '/', '\"', '\r', ' ', '*', ',', '/', '}', '\t', '\n', '\r', ' ', '\"', '*', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\r', ' ', '*', '/', ':', '\t', '\n', '\r', ' ', '\"', '*', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\r', ' ', ',', '/', ']', '\t', '\n', '\r', ' ', ',', '/', ']', '\t', '\n', '\r', ' ', '\"', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\"', '\r', ' ', '*', ',', '/', ']', '\t', '\n', '\r', ' ', '\"', '*', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '*', '/', '\r', ' ', '*', ',', '/', ']', '\t', '\n', '\r', ' ', '\"', '*', ',', '/', ':', '[', ']', '{', '}', '\t', '\n', '\r', ' ', '/', '\t', '\n', '\r', ' ', '/', '\t', '\n', '\r', ' ', '*', '/', '\t', '\n', '\u0000'};
    }

    private static byte[] init__json_single_lengths_0() {
        return new byte[]{0, 10, 2, 1, 11, 10, 4, 4, 2, 10, 5, 5, 10, 1, 5, 11, 2, 1, 6, 11, 5, 11, 10, 5, 5, 10, 1, 6, 11, 2, 6, 11, 3, 3, 4, 0, 0};
    }

    private static byte[] init__json_range_lengths_0() {
        return new byte[]{0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0};
    }

    private static short[] init__json_index_offsets_0() {
        return new short[]{0, 0, 12, 15, 17, 30, 42, 48, 54, 57, 69, 76, 83, 95, 97, 104, 117, 120, 122, 130, 143, 150, 163, 175, 182, 189, 201, 203, 211, 224, 227, 235, 248, 253, 258, 264, 265};
    }

    private static byte[] init__json_indicies_0() {
        return new byte[]{1, 1, 2, 3, 4, 3, 5, 3, 6, 3, 1, 0, 7, 7, 3, 8, 3, 1, 1, 2, 9, 3, 10, 3, 5, 3, 6, 3, 1, 0, 12, 12, 13, 14, 15, 3, 3, 3, 3, 16, 12, 11, 17, 17, 18, 19, 17, 3, 20, 20, 21, 22, 20, 3, 23, 23, 3, 22, 22, 25, 3, 26, 3, 27, 3, 28, 3, 22, 24, 29, 29, 30, 31, 32, 29, 3, 33, 33, 14, 34, 16, 33, 3, 14, 14, 13, 3, 35, 3, 3, 3, 3, 16, 14, 11, 17, 3, 17, 17, 36, 37, 19, 17, 3, 14, 14, 13, 38, 3, 39, 3, 3, 3, 3, 16, 14, 11, 40, 40, 3, 29, 3, 29, 29, 41, 30, 42, 32, 29, 3, 22, 22, 25, 43, 3, 44, 3, 27, 3, 28, 3, 22, 24, 17, 17, 45, 46, 19, 17, 3, 12, 12, 13, 38, 14, 47, 3, 3, 3, 3, 16, 12, 11, 49, 49, 50, 51, 52, 3, 53, 54, 55, 3, 49, 48, 56, 56, 57, 58, 59, 56, 3, 60, 60, 51, 61, 54, 60, 3, 51, 51, 50, 3, 62, 3, 53, 54, 55, 3, 51, 48, 56, 3, 56, 56, 63, 57, 64, 59, 56, 3, 51, 51, 50, 65, 3, 66, 3, 53, 54, 55, 3, 51, 48, 67, 67, 3, 56, 56, 68, 57, 69, 59, 56, 3, 49, 49, 50, 65, 51, 70, 3, 53, 54, 55, 3, 49, 48, 8, 8, 71, 8, 3, 72, 72, 73, 72, 3, 8, 8, 74, 75, 8, 3, 3, 3, 0};
    }

    private static byte[] init__json_trans_targs_0() {
        return new byte[]{32, 1, 3, 0, 34, 33, 33, 33, 33, 32, 34, 6, 5, 13, 12, 20, 35, 7, 8, 9, 7, 8, 9, 7, 10, 17, 18, 11, 11, 11, 12, 16, 35, 11, 16, 14, 12, 15, 6, 14, 11, 9, 19, 10, 18, 5, 21, 20, 23, 22, 26, 25, 30, 24, 36, 24, 24, 25, 29, 36, 24, 29, 27, 25, 28, 23, 27, 24, 22, 31, 30, 2, 33, 2, 1, 4};
    }

    private static byte[] init__json_trans_actions_0() {
        return new byte[]{13, 0, 15, 0, 13, 7, 3, 11, 1, 32, 32, 17, 0, 20, 0, 17, 5, 1, 1, 1, 0, 0, 0, 11, 13, 15, 13, 7, 3, 1, 1, 1, 23, 0, 0, 17, 11, 29, 35, 35, 11, 11, 29, 32, 32, 11, 29, 35, 13, 0, 15, 0, 13, 7, 9, 3, 1, 1, 1, 26, 0, 0, 13, 11, 29, 32, 32, 11, 11, 29, 32, 1, 0, 0, 11, 29};
    }

    private static byte[] init__json_eof_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0};
    }

    private void addChild(String name, JsonValue child) {
        child.setName(name);
        if (this.current == null) {
            this.current = child;
            this.root = child;
        } else if (this.current.isArray() || this.current.isObject()) {
            if (this.current.size == 0) {
                this.current.child = child;
            } else {
                JsonValue last = this.lastChild.pop();
                last.next = child;
                child.prev = last;
            }
            this.lastChild.add(child);
            ++this.current.size;
        } else {
            this.root = this.current;
        }
    }

    protected void startObject(String name) {
        JsonValue value = new JsonValue(JsonValue.ValueType.object);
        if (this.current != null) {
            this.addChild(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void startArray(String name) {
        JsonValue value = new JsonValue(JsonValue.ValueType.array);
        if (this.current != null) {
            this.addChild(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void pop() {
        this.root = this.elements.pop();
        if (this.current.size > 0) {
            this.lastChild.pop();
        }
        this.current = this.elements.size > 0 ? this.elements.peek() : null;
    }

    protected void string(String name, String value) {
        this.addChild(name, new JsonValue(value));
    }

    protected void number(String name, double value) {
        this.addChild(name, new JsonValue(value));
    }

    protected void number(String name, long value) {
        this.addChild(name, new JsonValue(value));
    }

    protected void bool(String name, boolean value) {
        this.addChild(name, new JsonValue(value));
    }

    private String unescape(String value) {
        int length = value.length();
        StringBuilder buffer = new StringBuilder(length + 16);
        int i = 0;
        while (i < length) {
            char c;
            if ((c = value.charAt(i++)) != '\\') {
                buffer.append(c);
                continue;
            }
            if (i == length) break;
            if ((c = value.charAt(i++)) == 'u') {
                buffer.append(Character.toChars(Integer.parseInt(value.substring(i, i + 4), 16)));
                i += 4;
                continue;
            }
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    break;
                }
                case 'b': {
                    c = '\b';
                    break;
                }
                case 'f': {
                    c = '\f';
                    break;
                }
                case 'n': {
                    c = '\n';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                default: {
                    throw new SerializationException("Illegal escaped character: \\" + c);
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

