/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.scene.collision;

import com.guidebee.game.Collidable;
import com.guidebee.game.physics.Body;
import com.guidebee.game.physics.Contact;
import com.guidebee.game.physics.Fixture;

public class Collision {
    private Collidable objectA;
    private Collidable objectB;
    private boolean isTouching;
    private int collisionType;

    public Collision(Collidable obj1, Collidable obj2, int type) {
        this.objectA = obj1;
        this.objectB = obj2;
        this.isTouching = true;
        this.collisionType = type;
    }

    public Collision(Contact contact) {
        Fixture fixture1 = contact.getFixtureA();
        Fixture fixture2 = contact.getFixtureB();
        if (fixture1 != null && fixture2 != null) {
            Body body1 = fixture1.getBody();
            Body body2 = fixture2.getBody();
            if (body1 != null) {
                this.objectA = (Collidable)body1.getUserData();
            }
            if (body2 != null) {
                this.objectB = (Collidable)body2.getUserData();
            }
        }
        this.collisionType = 8;
        this.isTouching = contact.isTouching();
    }

    public Collidable getObjectA() {
        return this.objectA;
    }

    public Collidable getObjectB() {
        return this.objectB;
    }

    public boolean isTouching() {
        return this.isTouching;
    }

    public int getCollisionType() {
        return this.collisionType;
    }
}

