/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.scene;

import com.guidebee.game.Collidable;
import com.guidebee.game.GameEngine;
import com.guidebee.game.engine.maps.tiled.TiledMapRenderer;
import com.guidebee.game.engine.maps.tiled.renderers.IsometricTiledMapRenderer;
import com.guidebee.game.engine.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.guidebee.game.maps.MapLayer;
import com.guidebee.game.maps.MapLayers;
import com.guidebee.game.maps.MapObject;
import com.guidebee.game.maps.tiled.TiledMap;
import com.guidebee.game.maps.tiled.TiledMapTile;
import com.guidebee.game.maps.tiled.TiledMapTileLayer;
import com.guidebee.game.physics.Body;
import com.guidebee.game.physics.BodyDef;
import com.guidebee.game.physics.CircleShape;
import com.guidebee.game.physics.Fixture;
import com.guidebee.game.physics.FixtureDef;
import com.guidebee.game.physics.PolygonShape;
import com.guidebee.game.physics.Shape;
import com.guidebee.game.physics.World;
import com.guidebee.game.scene.Stage;
import com.guidebee.math.geometry.Rectangle;
import com.guidebee.utils.Disposable;
import com.guidebee.utils.collections.Array;

public class Scenery
implements Disposable {
    protected Stage stage;
    protected final TiledMap tiledMap;
    protected TiledMapRenderer tiledMapRenderer;
    protected final MapType mapType;
    protected int[] backGroundLayers;
    protected int[] foreGroundLayers;

    public Scenery(TiledMap map) {
        this(map, MapType.OrthogonalTiled);
    }

    public Scenery(TiledMap map, MapType mapType) {
        this.tiledMap = map;
        this.mapType = mapType;
    }

    @Override
    public void dispose() {
        if (this.tiledMapRenderer != null) {
            if (this.tiledMapRenderer instanceof OrthogonalTiledMapRenderer) {
                ((OrthogonalTiledMapRenderer)this.tiledMapRenderer).dispose();
            } else if (this.tiledMapRenderer instanceof IsometricTiledMapRenderer) {
                ((IsometricTiledMapRenderer)this.tiledMapRenderer).dispose();
            }
        }
        if (this.tiledMap != null) {
            this.tiledMap.dispose();
        }
    }

    public void setForeGroundLayers(int[] foreGroundLayers) {
        this.foreGroundLayers = foreGroundLayers;
    }

    public void setBackGroundLayers(int[] backGroundLayers) {
        this.backGroundLayers = backGroundLayers;
    }

    public void renderBackgroundLayers() {
        if (this.tiledMapRenderer != null) {
            if (this.backGroundLayers != null) {
                this.tiledMapRenderer.render(this.backGroundLayers);
            } else {
                this.tiledMapRenderer.render();
            }
        }
    }

    public void renderForegroundLayers() {
        if (this.tiledMapRenderer != null && this.foreGroundLayers != null) {
            this.tiledMapRenderer.render(this.foreGroundLayers);
        }
    }

    public Array<Collidable> getAllCollidables() {
        Array<Collidable> collidables = new Array<Collidable>(false, 32);
        if (this.tiledMap != null) {
            MapLayers mapLayers = this.tiledMap.getLayers();
            for (MapLayer mapLayer : mapLayers) {
                if (mapLayer instanceof TiledMapTileLayer) {
                    TiledMapTileLayer tiledMapTileLayer = (TiledMapTileLayer)mapLayer;
                    int tilesX = tiledMapTileLayer.getWidth();
                    int tilesY = tiledMapTileLayer.getHeight();
                    for (int i = 0; i < tilesX; ++i) {
                        for (int j = 0; j < tilesY; ++j) {
                            TiledMapTile tiledMapTile;
                            TiledMapTileLayer.Cell cell = tiledMapTileLayer.getCell(i, j);
                            if (cell == null || (tiledMapTile = cell.getTile()) == null || !tiledMapTile.isEnabled()) continue;
                            collidables.add(tiledMapTile);
                        }
                    }
                    continue;
                }
                if (!(mapLayer instanceof MapLayer)) continue;
                for (MapObject mapObject : mapLayer.getObjects()) {
                    if (!mapObject.isEnabled()) continue;
                    collidables.add(mapObject);
                }
            }
        }
        return collidables;
    }

    public void initBody(TiledMapTileLayer mapTileLayer, int x, int y) {
        TiledMapTile tiledMapTile;
        TiledMapTileLayer.Cell cell = mapTileLayer.getCell(x, y);
        if (cell != null && (tiledMapTile = cell.getTile()) != null) {
            Rectangle rectangle = new Rectangle(0.0f, 0.0f, mapTileLayer.getTileWidth(), mapTileLayer.getTileHeight());
            this.initBody(mapTileLayer, x, y, BodyDef.BodyType.DynamicBody, Shape.Type.Polygon, rectangle, 1.0f, 0.0f, 1.0f);
        }
    }

    public void initBody(TiledMapTileLayer mapTileLayer, int x, int y, BodyDef.BodyType bodyType) {
        TiledMapTile tiledMapTile;
        TiledMapTileLayer.Cell cell = mapTileLayer.getCell(x, y);
        if (cell != null && (tiledMapTile = cell.getTile()) != null) {
            Rectangle rectangle = new Rectangle(0.0f, 0.0f, mapTileLayer.getTileWidth(), mapTileLayer.getTileHeight());
            this.initBody(mapTileLayer, x, y, bodyType, Shape.Type.Polygon, rectangle, 1.0f, 0.0f, 1.0f);
        }
    }

    public void initBody(TiledMapTileLayer mapTileLayer, int x, int y, BodyDef.BodyType type, Shape.Type shapeType, Rectangle rect, float density, float restitution, float friction) {
        TiledMapTile tiledMapTile;
        if (this.stage == null) {
            throw new RuntimeException("Please add this scenery to a stage first");
        }
        World world = this.stage.getWorld();
        if (world == null) {
            throw new RuntimeException("Please initialize world in stage first");
        }
        TiledMapTileLayer.Cell cell = mapTileLayer.getCell(x, y);
        if (cell != null && (tiledMapTile = cell.getTile()) != null) {
            Shape shape;
            Object object = tiledMapTile.getUserObject();
            if (object != null && object instanceof Body) {
                Body body = (Body)object;
                this.stage.bodiesTobeDeleted.add(body);
            }
            BodyDef bodyDef = new BodyDef();
            bodyDef.type = type;
            bodyDef.position.set(GameEngine.toBox2D((float)x * mapTileLayer.getTileWidth() + rect.getX() + rect.getWidth() / 2.0f), GameEngine.toBox2D((float)(y * mapTileLayer.getHeight()) + rect.getY() + rect.getHeight() / 2.0f));
            Body body = world.createBody(bodyDef);
            if (shapeType == Shape.Type.Circle) {
                shape = new CircleShape();
                shape.setRadius(GameEngine.toBox2D(Math.min(rect.getWidth() / 2.0f, rect.getHeight()) / 2.0f));
            } else {
                shape = new PolygonShape();
                PolygonShape polygonShape = (PolygonShape)shape;
                polygonShape.setAsBox(GameEngine.toBox2D(rect.getWidth() / 2.0f), GameEngine.toBox2D(rect.getHeight() / 2.0f));
            }
            FixtureDef fixtureDef = new FixtureDef();
            fixtureDef.shape = shape;
            fixtureDef.density = density;
            fixtureDef.restitution = restitution;
            fixtureDef.friction = friction;
            Fixture fixture = body.createFixture(fixtureDef);
            tiledMapTile.setUserObject(body);
            body.setUserData(tiledMapTile);
            shape.dispose();
        }
    }

    public static enum MapType {
        OrthogonalTiled,
        IsometricTiled;

    }
}

