/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.scene;

import com.guidebee.game.Collidable;
import com.guidebee.game.GameEngine;
import com.guidebee.game.engine.graphics.opengles.ShapeRenderer;
import com.guidebee.game.entity.DataTrait;
import com.guidebee.game.entity.Entity;
import com.guidebee.game.entity.EntityEngine;
import com.guidebee.game.entity.utils.ImmutableArray;
import com.guidebee.game.graphics.Batch;
import com.guidebee.game.graphics.Color;
import com.guidebee.game.graphics.Sprite;
import com.guidebee.game.graphics.Texture;
import com.guidebee.game.graphics.TextureRegion;
import com.guidebee.game.physics.Body;
import com.guidebee.game.physics.BodyDef;
import com.guidebee.game.physics.CircleShape;
import com.guidebee.game.physics.EdgeShape;
import com.guidebee.game.physics.Fixture;
import com.guidebee.game.physics.FixtureDef;
import com.guidebee.game.physics.PolygonShape;
import com.guidebee.game.physics.Shape;
import com.guidebee.game.physics.World;
import com.guidebee.game.scene.Group;
import com.guidebee.game.scene.InternalActor;
import com.guidebee.game.scene.Stage;
import com.guidebee.game.scene.actions.Action;
import com.guidebee.game.scene.actions.TweenAction;
import com.guidebee.math.Vector2;
import com.guidebee.math.geometry.Circle;
import com.guidebee.math.geometry.Polygon;
import com.guidebee.math.geometry.Rectangle;
import com.guidebee.utils.collections.Array;

public class Actor
implements Collidable {
    protected InternalActor internalActor;
    public Entity entity;
    protected Sprite sprite;
    protected Body body;
    protected ActorDataTrait dataTrait;
    private Object userObject;
    private boolean selfControl = false;
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private boolean collisionEnabled = true;
    private Circle boundingCircle = new Circle();
    private Polygon boundingPolygon = new Polygon();

    protected void drawDebugBounds(ShapeRenderer shapes) {
    }

    public Actor() {
        this(Actor.class.getName());
    }

    public Actor(String name) {
        this.internalActor = new InternalActor(this, name);
        this.entity = new Entity();
        this.dataTrait = new ActorDataTrait();
        this.dataTrait.boundingRect = new Rectangle();
        this.dataTrait.color = this.internalActor.getColor().cpy();
        this.entity.add(this.dataTrait);
        this.dataTrait.name = name;
        this.internalActor.setUserObject(this);
        this.entity.setUserObject(this);
    }

    public void draw(Batch batch, float parentAlpha) {
        if (this.sprite != null) {
            this.sprite.draw(batch, parentAlpha);
        }
    }

    public void act(float delta) {
        if (this.body != null) {
            if (this.selfControl) {
                this.resetBodyWithSprite();
            } else {
                this.resetSpriteWithBody();
            }
        }
    }

    public void setSelfControl(Boolean control) {
        this.selfControl = control;
    }

    public Actor hit(float x, float y) {
        com.guidebee.game.engine.scene.Actor actor = this.internalActor.hit(x, y, true);
        if (actor != null) {
            return (Actor)actor.getUserObject();
        }
        return null;
    }

    public void initBody(BodyDef.BodyType bodyType, Rectangle rect) {
        this.initBody(bodyType, Shape.Type.Polygon, rect, 1.0f, 0.0f, 1.0f);
    }

    public void initBody(BodyDef.BodyType bodyType) {
        Rectangle rectangle = new Rectangle(0.0f, 0.0f, this.getWidth(), this.getHeight());
        this.initBody(bodyType, Shape.Type.Polygon, rectangle, 1.0f, 0.0f, 1.0f);
    }

    public void initBody(Rectangle rectangle) {
        this.initBody(BodyDef.BodyType.DynamicBody, Shape.Type.Polygon, rectangle, 1.0f, 0.0f, 1.0f);
    }

    public void initBody() {
        Rectangle rectangle = new Rectangle(0.0f, 0.0f, this.getWidth(), this.getHeight());
        this.initBody(BodyDef.BodyType.DynamicBody, Shape.Type.Polygon, rectangle, 1.0f, 0.0f, 1.0f);
    }

    public void initBody(BodyDef.BodyType type, Shape.Type shapeType, Rectangle rect, float density, float restitution, float friction) {
        Shape shape;
        if (GameEngine.world == null) {
            throw new RuntimeException("Please initialize game engine world first");
        }
        if (this.body != null) {
            GameEngine.world.destroyBody(this.body);
        }
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = type;
        bodyDef.position.set(GameEngine.toBox2D(this.getX() + rect.getX() + rect.getWidth() / 2.0f), GameEngine.toBox2D(this.getY() + rect.getY() + rect.getHeight() / 2.0f));
        this.body = GameEngine.world.createBody(bodyDef);
        this.offsetX = (this.getWidth() - rect.getWidth()) / 2.0f - rect.getX();
        this.offsetY = (this.getHeight() - rect.getHeight()) / 2.0f - rect.getY();
        this.setOrigin(this.getOriginX() - this.offsetX, this.getOriginY() - this.offsetY);
        if (shapeType == Shape.Type.Circle) {
            shape = new CircleShape();
            shape.setRadius(GameEngine.toBox2D(Math.min(rect.getWidth() / 2.0f, rect.getHeight() / 2.0f)));
        } else {
            shape = new PolygonShape();
            PolygonShape polygonShape = (PolygonShape)shape;
            polygonShape.setAsBox(GameEngine.toBox2D(rect.getWidth() / 2.0f), GameEngine.toBox2D(rect.getHeight() / 2.0f));
        }
        FixtureDef fixtureDef = new FixtureDef();
        fixtureDef.shape = shape;
        fixtureDef.density = density;
        fixtureDef.restitution = restitution;
        fixtureDef.friction = friction;
        Fixture fixture = this.body.createFixture(fixtureDef);
        this.body.setUserData(this);
        shape.dispose();
    }

    public void initEdgeBody(float x1, float y1, float x2, float y2, float density, float restitution, float friction) {
        if (GameEngine.world == null) {
            throw new RuntimeException("Please initialize game engine world first");
        }
        if (this.body != null) {
            GameEngine.world.destroyBody(this.body);
        }
        BodyDef bodyDef3 = new BodyDef();
        bodyDef3.type = BodyDef.BodyType.StaticBody;
        bodyDef3.position.set(GameEngine.toBox2D(this.getX()), GameEngine.toBox2D(this.getY()));
        FixtureDef fixtureDef3 = new FixtureDef();
        EdgeShape edgeShape = new EdgeShape();
        edgeShape.set(GameEngine.toBox2D(x1), GameEngine.toBox2D(y1), GameEngine.toBox2D(x2), GameEngine.toBox2D(y2));
        fixtureDef3.shape = edgeShape;
        fixtureDef3.restitution = restitution;
        fixtureDef3.friction = friction;
        fixtureDef3.density = density;
        this.body = GameEngine.world.createBody(bodyDef3);
        this.body.createFixture(fixtureDef3);
        this.body.setUserData(this);
        edgeShape.dispose();
    }

    public final boolean collidesWith(Collidable otherCollidable) {
        return this.collidesWith(otherCollidable, 4);
    }

    public final boolean collidesWith(Collidable otherCollidable, int collisionType) {
        return Stage.collisionQuery(this, otherCollidable, collisionType);
    }

    public void setBody(Body body) {
        this.body = body;
        this.body.setUserData(this);
    }

    public Body getBody() {
        return this.body;
    }

    public boolean remove() {
        this.internalActor.setUserObject(null);
        this.entity.setUserObject(null);
        this.clear();
        EntityEngine entityEngine = this.getStage().entityEngine;
        entityEngine.removeEntity(this.entity);
        Stage stage = (Stage)entityEngine.getUserObject();
        World world = stage.getWorld();
        if (world != null && this.body != null) {
            stage.bodiesTobeDeleted.add(this.body);
        }
        return this.internalActor.remove();
    }

    public void addAction(Action action) {
        this.internalActor.addAction(action);
        if (action instanceof TweenAction) {
            if (action.getActor() != this.internalActor) {
                throw new IllegalArgumentException("Tween action target mismatch");
            }
            TweenAction tweenAction = (TweenAction)action;
            tweenAction.start();
        }
    }

    public void removeAction(Action action) {
        this.internalActor.removeAction(action);
    }

    public Array<Action> getActions() {
        return this.internalActor.getActions();
    }

    public void clearActions() {
        this.internalActor.clearActions();
    }

    public void clear() {
        this.internalActor.clear();
    }

    public Stage getStage() {
        com.guidebee.game.engine.scene.Stage stage = this.internalActor.getStage();
        if (stage != null) {
            return (Stage)stage.getUserObject();
        }
        return null;
    }

    protected void setStage(Stage stage) {
        if (stage != null) {
            this.internalActor.setStage(stage.internalStage);
        } else {
            this.internalActor.setStage(null);
        }
    }

    public boolean isDescendantOf(Actor actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        return this.internalActor.isDescendantOf(actor.internalActor);
    }

    public boolean isAscendantOf(Actor actor) {
        if (actor == null) {
            throw new IllegalArgumentException("actor cannot be null.");
        }
        return this.internalActor.isAscendantOf(actor.internalActor);
    }

    public boolean overlaps(Actor other) {
        return this.dataTrait.boundingRect.overlaps(other.dataTrait.boundingRect);
    }

    public boolean hasParent() {
        return this.internalActor.hasParent();
    }

    public Group getParent() {
        com.guidebee.game.engine.scene.Group group = this.internalActor.getParent();
        if (group != null) {
            return (Group)group.getUserObject();
        }
        return null;
    }

    protected void positionChanged() {
    }

    protected void sizeChanged() {
    }

    protected void setParent(Group parent) {
        if (parent != null) {
            this.internalActor.setParent(parent.internalGroup);
        } else {
            this.internalActor.setParent(null);
        }
    }

    public boolean isVisible() {
        return this.internalActor.isVisible();
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void moveBy(float x, float y) {
        this.internalActor.moveBy(x, y);
        this.dataTrait.x = this.internalActor.getX();
        this.dataTrait.y = this.internalActor.getY();
        this.resetSprite();
    }

    public float getX() {
        return this.internalActor.getX();
    }

    public float getY() {
        return this.internalActor.getY();
    }

    public void rotateBy(float amountInDegrees) {
        this.internalActor.rotateBy(amountInDegrees);
        this.dataTrait.rotation = this.internalActor.getRotation();
        this.resetSprite();
    }

    public void scaleBy(float scale) {
        this.internalActor.scaleBy(scale);
        this.dataTrait.scaleX = this.internalActor.getScaleX();
        this.dataTrait.scaleY = this.internalActor.getScaleY();
        this.resetSprite();
    }

    public void scaleBy(float scaleX, float scaleY) {
        this.internalActor.scaleBy(scaleX, scaleY);
        this.dataTrait.scaleX = this.internalActor.getScaleX();
        this.dataTrait.scaleY = this.internalActor.getScaleY();
        this.resetSprite();
    }

    public float getRotation() {
        return this.internalActor.getRotation();
    }

    public void setBounds(float x, float y, float width, float height) {
        this.internalActor.setBounds(x, y, width, height);
        this.dataTrait.x = x;
        this.dataTrait.y = y;
        this.dataTrait.width = width;
        this.dataTrait.height = height;
        this.resetSprite();
    }

    public float getOriginX() {
        return this.internalActor.getOriginX();
    }

    public float getCenterX() {
        return this.internalActor.getCenterX();
    }

    public float getCenterY() {
        return this.internalActor.getCenterY();
    }

    public void setCenterPosition(float x, float y) {
        this.internalActor.setCenterPosition(x, y);
        this.dataTrait.x = this.internalActor.getX();
        this.dataTrait.y = this.internalActor.getY();
        this.dataTrait.boundingRect.x = this.dataTrait.x;
        this.dataTrait.boundingRect.y = this.dataTrait.y;
        this.resetSprite();
    }

    public void setColor(Color color) {
        this.internalActor.setColor(color);
        this.dataTrait.color.set(color);
    }

    public void setColor(float r, float g, float b, float a) {
        this.internalActor.setColor(r, g, b, a);
        this.dataTrait.color.set(r, g, b, a);
    }

    public Color getColor() {
        return this.internalActor.getColor();
    }

    @Override
    public String getName() {
        return this.internalActor.getName();
    }

    public void setName(String name) {
        this.internalActor.setName(name);
        this.dataTrait.name = name;
    }

    public Actor addDataTrait(DataTrait dataTrait) {
        this.entity.add(dataTrait);
        return this;
    }

    public DataTrait removeDataTrait(Class<? extends DataTrait> dataTraitClass) {
        return this.entity.remove(dataTraitClass);
    }

    public void removeAllDataTraits() {
        this.entity.removeAll();
    }

    public ImmutableArray<DataTrait> getDataTraits() {
        return this.entity.getDataTraits();
    }

    public <T extends DataTrait> T getDataTrait(Class<T> dataTraitClass) {
        return this.entity.getDataTrait(dataTraitClass);
    }

    public float getTop() {
        return this.internalActor.getTop();
    }

    public float getRight() {
        return this.internalActor.getRight();
    }

    public void setHeight(float height) {
        this.internalActor.setHeight(height);
        this.dataTrait.height = height;
        this.resetSprite();
    }

    public void setOrigin(float originX, float originY) {
        this.internalActor.setOrigin(originX, originY);
        this.dataTrait.originX = originX;
        this.dataTrait.originY = originY;
        this.resetSprite();
    }

    public float getScaleX() {
        return this.internalActor.getScaleX();
    }

    public void setOriginX(float originX) {
        this.internalActor.setOriginX(originX);
        this.dataTrait.originX = this.internalActor.getOriginX();
    }

    public float getOriginY() {
        return this.internalActor.getOriginY();
    }

    public void setOriginY(float originY) {
        this.internalActor.setOriginY(originY);
        this.dataTrait.originY = this.internalActor.getOriginY();
        this.resetSprite();
    }

    public void setPosition(float x, float y) {
        this.internalActor.setPosition(x, y);
        this.dataTrait.x = x;
        this.dataTrait.y = y;
        this.resetSprite();
    }

    public void setRotation(float degrees) {
        this.internalActor.setRotation(degrees);
        this.dataTrait.rotation = degrees;
        this.resetSprite();
    }

    public void setScale(float scaleX, float scaleY) {
        this.internalActor.setScale(scaleX, scaleY);
        this.dataTrait.scaleX = scaleX;
        this.dataTrait.scaleY = scaleY;
        this.resetSprite();
    }

    public void setScale(float scaleXY) {
        this.internalActor.setScale(scaleXY);
        this.dataTrait.scaleX = scaleXY;
        this.dataTrait.scaleY = scaleXY;
        this.resetSprite();
    }

    public void setScaleX(float scaleX) {
        this.internalActor.setScaleX(scaleX);
        this.dataTrait.scaleX = scaleX;
        this.resetSprite();
    }

    public float getScaleY() {
        return this.internalActor.getScaleY();
    }

    public void setScaleY(float scaleY) {
        this.internalActor.setScaleY(scaleY);
        this.dataTrait.scaleY = scaleY;
        this.resetSprite();
    }

    public void setSize(float width, float height) {
        this.internalActor.setSize(width, height);
        this.dataTrait.width = width;
        this.dataTrait.height = height;
        this.resetSprite();
    }

    public void setVisible(boolean visible) {
        this.internalActor.setVisible(visible);
        this.dataTrait.visible = visible;
    }

    public float getHeight() {
        return this.internalActor.getHeight();
    }

    public void setWidth(float width) {
        this.internalActor.setWidth(width);
        this.dataTrait.width = width;
        this.resetSprite();
    }

    public void setX(float x) {
        this.internalActor.setX(x);
        this.dataTrait.x = x;
        this.resetSprite();
    }

    public void setY(float y) {
        this.internalActor.setY(y);
        this.dataTrait.y = y;
        this.resetSprite();
    }

    public void setZIndex(int index) {
        this.internalActor.setZIndex(index);
        this.dataTrait.zIndex = index;
    }

    public int getZIndex() {
        return this.internalActor.getZIndex();
    }

    public float getWidth() {
        return this.internalActor.getWidth();
    }

    public boolean clipBegin() {
        return this.internalActor.clipBegin();
    }

    public boolean clipBegin(float x, float y, float width, float height) {
        return this.internalActor.clipBegin(x, y, width, height);
    }

    public void clipEnd() {
        this.internalActor.clipEnd();
    }

    public Vector2 screenToLocalCoordinates(Vector2 screenCoords) {
        return this.internalActor.screenToLocalCoordinates(screenCoords);
    }

    public Vector2 stageToLocalCoordinates(Vector2 stageCoords) {
        return this.internalActor.stageToLocalCoordinates(stageCoords);
    }

    public Vector2 localToStageCoordinates(Vector2 localCoords) {
        return this.internalActor.localToStageCoordinates(localCoords);
    }

    public Vector2 localToParentCoordinates(Vector2 localCoords) {
        return this.internalActor.localToParentCoordinates(localCoords);
    }

    public Vector2 localToAscendantCoordinates(Actor ascendant, Vector2 localCoords) {
        return this.internalActor.localToAscendantCoordinates(ascendant.internalActor, localCoords);
    }

    public Vector2 parentToLocalCoordinates(Vector2 parentCoords) {
        return this.internalActor.parentToLocalCoordinates(parentCoords);
    }

    public void drawDebug(ShapeRenderer shapes) {
    }

    public void setDebug(boolean enabled) {
        this.internalActor.setDebug(enabled);
    }

    public boolean getDebug() {
        return this.internalActor.getDebug();
    }

    public Actor debug() {
        com.guidebee.game.engine.scene.Actor actor = this.internalActor.debug();
        if (actor != null) {
            return (Actor)actor.getUserObject();
        }
        return null;
    }

    public String toString() {
        return this.internalActor.toString();
    }

    public void sizeBy(float size) {
        this.internalActor.sizeBy(size);
        this.dataTrait.width = this.internalActor.getWidth();
        this.dataTrait.height = this.internalActor.getHeight();
        this.resetSprite();
    }

    public void sizeBy(float width, float height) {
        this.internalActor.sizeBy(width, height);
        this.dataTrait.width = this.internalActor.getWidth();
        this.dataTrait.height = this.internalActor.getHeight();
        this.resetSprite();
    }

    public void toBack() {
        this.internalActor.toBack();
        this.dataTrait.zIndex = this.internalActor.getZIndex();
    }

    public void toFront() {
        this.internalActor.toFront();
        this.dataTrait.zIndex = this.internalActor.getZIndex();
    }

    public void setSprite(Sprite sprite) {
        if (sprite == null) {
            throw new IllegalArgumentException("Sprite cannot be null");
        }
        this.sprite = sprite;
        this.setActorDataTrait();
    }

    public void setTextureRegion(TextureRegion textureRegion) {
        if (this.sprite != null) {
            this.sprite.setRegion(textureRegion);
        } else {
            this.setSprite(new Sprite(textureRegion));
        }
    }

    public void setTexture(Texture texture) {
        if (this.sprite != null) {
            this.sprite.setRegion(texture);
        } else {
            this.setSprite(new Sprite(texture));
        }
    }

    public void setAlpha(float a) {
        if (this.sprite != null) {
            this.sprite.setAlpha(a);
        }
        this.dataTrait.alpha = a;
    }

    void resetSpriteWithBody() {
        if (this.sprite != null) {
            this.sprite.setPosition(this.body.getPosition().x * GameEngine.pixelToBox2DUnit - this.sprite.getWidth() / 2.0f + this.offsetX, this.body.getPosition().y * GameEngine.pixelToBox2DUnit - this.sprite.getHeight() / 2.0f + this.offsetY);
            this.sprite.setRotation((float)Math.toDegrees(this.body.getAngle()));
            this.setActorDataTrait();
        }
    }

    void resetSprite() {
        if (this.sprite != null) {
            this.sprite.setPosition(this.dataTrait.x, this.dataTrait.y);
            this.sprite.setScale(this.dataTrait.scaleX, this.dataTrait.scaleY);
            this.sprite.setOrigin(this.dataTrait.originX, this.dataTrait.originY);
            this.sprite.setRotation(this.dataTrait.rotation);
        }
        if (this.selfControl) {
            this.resetBodyWithSprite();
        }
    }

    void resetBodyWithSprite() {
        if (this.body != null) {
            this.body.setTransform(GameEngine.toBox2D(this.dataTrait.x + this.dataTrait.width / 2.0f - this.offsetX), GameEngine.toBox2D(this.dataTrait.y + this.dataTrait.height / 2.0f - this.offsetY), (float)Math.toRadians(this.dataTrait.rotation));
        }
    }

    void resetSpriteDataTrait() {
        this.dataTrait.boundingRect.x = this.internalActor.getX();
        this.dataTrait.boundingRect.y = this.internalActor.getY();
        this.dataTrait.boundingRect.width = this.internalActor.getWidth();
        this.dataTrait.boundingRect.height = this.internalActor.getHeight();
        this.dataTrait.centerX = this.internalActor.getX() + this.internalActor.getWidth() / 2.0f;
        this.dataTrait.centerY = this.internalActor.getY() + this.internalActor.getHeight() / 2.0f;
        this.dataTrait.color = this.internalActor.getColor();
        this.dataTrait.height = this.internalActor.getHeight();
        this.dataTrait.originX = this.internalActor.getOriginX();
        this.dataTrait.originY = this.internalActor.getOriginY();
        this.dataTrait.rotation = this.internalActor.getRotation();
        this.dataTrait.scaleX = this.internalActor.getScaleX();
        this.dataTrait.scaleY = this.internalActor.getScaleY();
        this.dataTrait.width = this.internalActor.getWidth();
        this.dataTrait.x = this.internalActor.getX();
        this.dataTrait.y = this.internalActor.getY();
        this.resetSprite();
    }

    protected void setActorDataTrait() {
        this.dataTrait.boundingRect.x = this.sprite.getX();
        this.dataTrait.boundingRect.y = this.sprite.getY();
        this.dataTrait.boundingRect.width = this.sprite.getWidth();
        this.dataTrait.boundingRect.height = this.sprite.getHeight();
        this.dataTrait.centerX = this.sprite.getX() + this.sprite.getWidth() / 2.0f;
        this.dataTrait.centerY = this.sprite.getY() + this.sprite.getHeight() / 2.0f;
        this.dataTrait.color = this.sprite.getColor();
        this.dataTrait.height = this.sprite.getHeight();
        this.dataTrait.originX = this.sprite.getOriginX();
        this.dataTrait.originY = this.sprite.getOriginY();
        this.dataTrait.rotation = this.sprite.getRotation();
        this.dataTrait.scaleX = this.sprite.getScaleX();
        this.dataTrait.scaleY = this.sprite.getScaleY();
        this.dataTrait.actor = this;
        this.dataTrait.width = this.sprite.getWidth();
        this.dataTrait.x = this.sprite.getX();
        this.dataTrait.y = this.sprite.getY();
        this.setX(this.dataTrait.x);
        this.setY(this.dataTrait.y);
        this.setWidth(this.dataTrait.width);
        this.setHeight(this.dataTrait.height);
        this.setScale(this.dataTrait.scaleX, this.dataTrait.scaleY);
        this.setRotation(this.dataTrait.rotation);
        this.setColor(this.dataTrait.color);
        this.setOrigin(this.dataTrait.originX, this.dataTrait.originY);
    }

    public void setCollisionEnabled(Boolean value) {
        this.collisionEnabled = value;
    }

    @Override
    public boolean isEnabled() {
        return this.collisionEnabled;
    }

    @Override
    public Rectangle getBoundingAABB() {
        return this.sprite.getBoundingRectangle();
    }

    @Override
    public Polygon getBoundingPolygon() {
        float[] vertices = new float[]{this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), this.getX(), this.getY() + this.getHeight()};
        this.boundingPolygon.setVertices(vertices);
        this.boundingPolygon.setOrigin(this.getX() + this.getWidth() / 2.0f, this.getY() + this.getHeight() / 2.0f);
        this.boundingPolygon.rotate(this.getRotation());
        return this.boundingPolygon;
    }

    @Override
    public Circle getBoundingCircle() {
        this.boundingCircle.setPosition(this.getCenterX(), this.getCenterY());
        this.boundingCircle.setRadius(Math.min(this.getWidth() / 2.0f, this.getHeight() / 2.0f));
        return this.boundingCircle;
    }

    public static class ActorDataTrait
    extends DataTrait {
        public Color color;
        public float centerX;
        public float centerY;
        public Rectangle boundingRect;
        public float originX;
        public float originY;
        public float x;
        public float y;
        public float width;
        public float height;
        public float scaleX;
        public float scaleY;
        public float rotation;
        public float alpha;
        public Actor actor;
        public int zIndex;
        public boolean visible;
        public String name;
    }
}

