/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.maps.tiled;

import com.guidebee.game.maps.tiled.TiledMapTile;
import com.guidebee.game.maps.tiled.TiledMapTileSet;
import com.guidebee.utils.collections.Array;
import java.util.Iterator;

public class TiledMapTileSets
implements Iterable<TiledMapTileSet> {
    private Array<TiledMapTileSet> tilesets = new Array();

    public TiledMapTileSet getTileSet(int index) {
        return this.tilesets.get(index);
    }

    public TiledMapTileSet getTileSet(String name) {
        for (TiledMapTileSet tileset : this.tilesets) {
            if (!name.equals(tileset.getName())) continue;
            return tileset;
        }
        return null;
    }

    public void addTileSet(TiledMapTileSet tileset) {
        this.tilesets.add(tileset);
    }

    public void removeTileSet(int index) {
        this.tilesets.removeIndex(index);
    }

    public void removeTileSet(TiledMapTileSet tileset) {
        this.tilesets.removeValue(tileset, true);
    }

    public TiledMapTile getTile(int id) {
        for (TiledMapTileSet tileset : this.tilesets) {
            TiledMapTile tile = tileset.getTile(id);
            if (tile == null) continue;
            return tile;
        }
        return null;
    }

    @Override
    public Iterator<TiledMapTileSet> iterator() {
        return this.tilesets.iterator();
    }
}

