/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.maps;

import com.guidebee.game.Collidable;
import com.guidebee.game.graphics.Color;
import com.guidebee.game.maps.MapProperties;
import com.guidebee.math.geometry.Circle;
import com.guidebee.math.geometry.Polygon;
import com.guidebee.math.geometry.Rectangle;

public abstract class MapObject
implements Collidable {
    private String name = "";
    private float opacity = 1.0f;
    private boolean visible = true;
    private MapProperties properties = new MapProperties();
    private Color color = Color.WHITE.cpy();
    private boolean collisionEnabled = false;
    private Rectangle boundingRect;
    private Polygon boundingPolygon = new Polygon();
    private Circle boundingCircle = new Circle();

    public void setEnabled(boolean enabled) {
        this.collisionEnabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.collisionEnabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public MapProperties getProperties() {
        return this.properties;
    }

    public void setBoundingRect(Rectangle rect) {
        this.boundingRect = rect;
    }

    @Override
    public Rectangle getBoundingAABB() {
        return this.boundingRect;
    }

    @Override
    public Polygon getBoundingPolygon() {
        if (this.boundingRect != null) {
            float[] vertices = new float[]{this.boundingRect.x, this.boundingRect.y, this.boundingRect.x + this.boundingRect.width, this.boundingRect.y, this.boundingRect.x + this.boundingRect.width, this.boundingRect.y + this.boundingRect.height, this.boundingRect.y, this.boundingRect.y + this.boundingRect.height};
            this.boundingPolygon.setVertices(vertices);
            return this.boundingPolygon;
        }
        return null;
    }

    @Override
    public Circle getBoundingCircle() {
        if (this.boundingRect != null) {
            this.boundingCircle.setPosition(this.boundingRect.x + this.boundingRect.width / 2.0f, this.boundingRect.y + this.boundingRect.height / 2.0f);
            this.boundingCircle.setRadius(Math.min(this.boundingRect.width / 2.0f, this.boundingRect.height / 2.0f));
            return this.boundingCircle;
        }
        return null;
    }
}

