/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.graphics;

import com.guidebee.game.GameEngineRuntimeException;
import com.guidebee.game.engine.platform.svg.SVG;
import com.guidebee.game.files.FileHandle;
import com.guidebee.game.graphics.Pixmap;

public class SVGImage {
    final SVG svg;

    public SVGImage(FileHandle file) {
        try {
            this.svg = SVG.getFromInputStream(file.read());
        }
        catch (Exception e) {
            throw new GameEngineRuntimeException("Couldn't load file: " + file, e);
        }
    }

    public float getWidth() {
        return this.svg.getDocumentWidth();
    }

    public float getHeight() {
        return this.svg.getDocumentHeight();
    }

    public Pixmap getPixmap(int width, int height) {
        int[] rgbData = this.svg.getRGB(width, height);
        Pixmap pixmap = new Pixmap(width, height, Pixmap.Format.RGBA8888);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int mask = rgbData[y * width + x] & 0xFFFFFFFF;
                int aa = mask >> 24 & 0xFF;
                int rr = mask >> 16 & 0xFF;
                int gg = mask >> 8 & 0xFF;
                int bb = mask & 0xFF;
                int color = (aa & 0xFF) << 24 | (gg & 0xFF) << 16 | (rr & 0xFF) << 8 | (bb & 0xFF) << 0;
                pixmap.drawPixel(x, y, color);
            }
        }
        return pixmap;
    }

    public Pixmap getPixmap(float scale) {
        int width = (int)(this.getWidth() * scale);
        int height = (int)(this.getHeight() * scale);
        return this.getPixmap(width, height);
    }
}

