/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.graphics;

import com.guidebee.game.GameEngineRuntimeException;
import com.guidebee.game.engine.graphics.NativePixmap;
import com.guidebee.game.files.FileHandle;
import com.guidebee.game.graphics.Color;
import com.guidebee.utils.Disposable;
import com.guidebee.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class Pixmap
implements Disposable {
    private static Blending blending = Blending.SourceOver;
    final NativePixmap pixmap;
    int color = 0;
    private boolean disposed;

    public static void setBlending(Blending blending) {
        Pixmap.blending = blending;
        NativePixmap.setBlend(blending == Blending.None ? 0 : 1);
    }

    public static void setFilter(Filter filter) {
        NativePixmap.setScale(filter == Filter.NearestNeighbour ? 0 : 1);
    }

    public Pixmap(int width, int height, Format format) {
        this.pixmap = new NativePixmap(width, height, Format.toNativePixmapFormat(format));
        this.setColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.fill();
    }

    public Pixmap(byte[] encodedData, int offset, int len) {
        try {
            this.pixmap = new NativePixmap(encodedData, offset, len, 0);
        }
        catch (IOException e) {
            throw new GameEngineRuntimeException("Couldn't load pixmap from image data", e);
        }
    }

    public Pixmap(FileHandle file) {
        try {
            byte[] bytes = file.readBytes();
            this.pixmap = new NativePixmap(bytes, 0, bytes.length, 0);
        }
        catch (Exception e) {
            throw new GameEngineRuntimeException("Couldn't load file: " + file, e);
        }
    }

    public Pixmap(NativePixmap pixmap) {
        this.pixmap = pixmap;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setColor(float r, float g, float b, float a) {
        this.color = Color.rgba8888(r, g, b, a);
    }

    public void setColor(Color color) {
        this.color = Color.rgba8888(color.r, color.g, color.b, color.a);
    }

    public void fill() {
        this.pixmap.clear(this.color);
    }

    public void drawLine(int x, int y, int x2, int y2) {
        this.pixmap.drawLine(x, y, x2, y2, this.color);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.pixmap.drawRect(x, y, width, height, this.color);
    }

    public void drawPixmap(Pixmap pixmap, int x, int y) {
        this.drawPixmap(pixmap, x, y, 0, 0, pixmap.getWidth(), pixmap.getHeight());
    }

    public void drawPixmap(Pixmap pixmap, int x, int y, int srcx, int srcy, int srcWidth, int srcHeight) {
        this.pixmap.drawPixmap(pixmap.pixmap, srcx, srcy, x, y, srcWidth, srcHeight);
    }

    public void drawPixmap(Pixmap pixmap, int srcx, int srcy, int srcWidth, int srcHeight, int dstx, int dsty, int dstWidth, int dstHeight) {
        this.pixmap.drawPixmap(pixmap.pixmap, srcx, srcy, srcWidth, srcHeight, dstx, dsty, dstWidth, dstHeight);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.pixmap.fillRect(x, y, width, height, this.color);
    }

    public void drawCircle(int x, int y, int radius) {
        this.pixmap.drawCircle(x, y, radius, this.color);
    }

    public void fillCircle(int x, int y, int radius) {
        this.pixmap.fillCircle(x, y, radius, this.color);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.pixmap.fillTriangle(x1, y1, x2, y2, x3, y3, this.color);
    }

    public int getPixel(int x, int y) {
        return this.pixmap.getPixel(x, y);
    }

    public int getWidth() {
        return this.pixmap.getWidth();
    }

    public int getHeight() {
        return this.pixmap.getHeight();
    }

    public void drawRGB(int[] rgbData, int width, int height) {
        if (this.getFormat() != Format.RGBA8888 || width != this.getWidth() || height != this.getHeight()) {
            throw new IllegalArgumentException("Can only draw on same sized RGBA 8888 pixmap");
        }
        this.pixmap.drawRGB(rgbData);
    }

    public int[] getRGB() {
        int[] rgb = new int[this.pixmap.getWidth() * this.pixmap.getHeight()];
        int dest = 0;
        for (int y = 0; y < this.pixmap.getHeight(); ++y) {
            for (int x = 0; x < this.pixmap.getWidth(); ++x) {
                int pixel = this.pixmap.getPixel(x, y);
                int mask = pixel & 0xFFFFFFFF;
                int rr = mask >> 24 & 0xFF;
                int gg = mask >> 16 & 0xFF;
                int bb = mask >> 8 & 0xFF;
                int aa = mask & 0xFF;
                rgb[dest++] = (aa & 0xFF) << 24 | (rr & 0xFF) << 16 | (gg & 0xFF) << 8 | (bb & 0xFF) << 0;
            }
        }
        return rgb;
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            throw new GameEngineRuntimeException("Pixmap already disposed!");
        }
        this.pixmap.dispose();
        this.disposed = true;
    }

    public void drawPixel(int x, int y) {
        this.pixmap.setPixel(x, y, this.color);
    }

    public void drawPixel(int x, int y, int color) {
        this.pixmap.setPixel(x, y, color);
    }

    public int getGLFormat() {
        return this.pixmap.getGLFormat();
    }

    public int getGLInternalFormat() {
        return this.pixmap.getGLInternalFormat();
    }

    public int getGLType() {
        return this.pixmap.getGLType();
    }

    public ByteBuffer getPixels() {
        if (this.disposed) {
            throw new GameEngineRuntimeException("Pixmap already disposed");
        }
        return this.pixmap.getPixels();
    }

    public Format getFormat() {
        return Format.fromNativePixmapFormat(this.pixmap.getFormat());
    }

    public static Blending getBlending() {
        return blending;
    }

    public static void writeCIM(FileHandle file, Pixmap pixmap) {
        CIM.write(file, pixmap);
    }

    public static Pixmap readCIM(FileHandle file) {
        return CIM.read(file);
    }

    public static void writePNG(FileHandle file, Pixmap pixmap) {
        try {
            file.writeBytes(PNG.write(pixmap), false);
        }
        catch (IOException ex) {
            throw new GameEngineRuntimeException("Error writing PNG: " + file, ex);
        }
    }

    private static class PNG {
        static int[] crcTable;
        static final int ZLIB_BLOCK_SIZE = 32000;

        private PNG() {
        }

        static byte[] write(Pixmap pixmap) throws IOException {
            byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
            byte[] header = PNG.createHeaderChunk(pixmap.getWidth(), pixmap.getHeight());
            byte[] data = PNG.createDataChunk(pixmap);
            byte[] trailer = PNG.createTrailerChunk();
            ByteArrayOutputStream png = new ByteArrayOutputStream(signature.length + header.length + data.length + trailer.length);
            png.write(signature);
            png.write(header);
            png.write(data);
            png.write(trailer);
            return png.toByteArray();
        }

        private static byte[] createHeaderChunk(int width, int height) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(13);
            DataOutputStream chunk = new DataOutputStream(baos);
            chunk.writeInt(width);
            chunk.writeInt(height);
            chunk.writeByte(8);
            chunk.writeByte(6);
            chunk.writeByte(0);
            chunk.writeByte(0);
            chunk.writeByte(0);
            return PNG.toChunk("IHDR", baos.toByteArray());
        }

        private static byte[] createDataChunk(Pixmap pixmap) throws IOException {
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            int dest = 0;
            byte[] raw = new byte[4 * width * height + height];
            for (int y = 0; y < height; ++y) {
                raw[dest++] = 0;
                for (int x = 0; x < width; ++x) {
                    int pixel = pixmap.getPixel(x, y);
                    int mask = pixel & 0xFFFFFFFF;
                    int rr = mask >> 24 & 0xFF;
                    int gg = mask >> 16 & 0xFF;
                    int bb = mask >> 8 & 0xFF;
                    int aa = mask & 0xFF;
                    raw[dest++] = (byte)rr;
                    raw[dest++] = (byte)gg;
                    raw[dest++] = (byte)bb;
                    raw[dest++] = (byte)aa;
                }
            }
            return PNG.toChunk("IDAT", PNG.toZLIB(raw));
        }

        private static byte[] createTrailerChunk() throws IOException {
            return PNG.toChunk("IEND", new byte[0]);
        }

        private static byte[] toChunk(String id, byte[] raw) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 12);
            DataOutputStream chunk = new DataOutputStream(baos);
            chunk.writeInt(raw.length);
            byte[] bid = new byte[4];
            for (int i = 0; i < 4; ++i) {
                bid[i] = (byte)id.charAt(i);
            }
            chunk.write(bid);
            chunk.write(raw);
            int crc = -1;
            crc = PNG.updateCRC(crc, bid);
            crc = PNG.updateCRC(crc, raw);
            chunk.writeInt(~crc);
            return baos.toByteArray();
        }

        private static void createCRCTable() {
            crcTable = new int[256];
            for (int i = 0; i < 256; ++i) {
                int c = i;
                for (int k = 0; k < 8; ++k) {
                    c = (c & 1) > 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
                }
                PNG.crcTable[i] = c;
            }
        }

        private static int updateCRC(int crc, byte[] raw) {
            if (crcTable == null) {
                PNG.createCRCTable();
            }
            for (byte element : raw) {
                crc = crcTable[(crc ^ element) & 0xFF] ^ crc >>> 8;
            }
            return crc;
        }

        private static byte[] toZLIB(byte[] raw) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 6 + raw.length / 32000 * 5);
            DataOutputStream zlib = new DataOutputStream(baos);
            int tmp = 8;
            zlib.writeByte(tmp);
            zlib.writeByte((31 - (tmp << 8) % 31) % 31);
            int pos = 0;
            while (raw.length - pos > 32000) {
                PNG.writeUncompressedDeflateBlock(zlib, false, raw, pos, '\u7d00');
                pos += 32000;
            }
            PNG.writeUncompressedDeflateBlock(zlib, true, raw, pos, (char)(raw.length - pos));
            zlib.writeInt(PNG.calcADLER32(raw));
            return baos.toByteArray();
        }

        private static void writeUncompressedDeflateBlock(DataOutputStream zlib, boolean last, byte[] raw, int off, char len) throws IOException {
            zlib.writeByte((byte)(last ? 1 : 0));
            zlib.writeByte((byte)(len & 0xFF));
            zlib.writeByte((byte)((len & 0xFF00) >> 8));
            zlib.writeByte((byte)(~len & 0xFF));
            zlib.writeByte((byte)((~len & 0xFF00) >> 8));
            zlib.write(raw, off, len);
        }

        private static int calcADLER32(byte[] raw) {
            int s1 = 1;
            int s2 = 0;
            for (int i = 0; i < raw.length; ++i) {
                int abs = raw[i] >= 0 ? raw[i] : raw[i] + 256;
                s1 = (s1 + abs) % 65521;
                s2 = (s2 + s1) % 65521;
            }
            return (s2 << 16) + s1;
        }
    }

    private static class CIM {
        private static final int BUFFER_SIZE = 32000;
        private static final byte[] writeBuffer = new byte[32000];
        private static final byte[] readBuffer = new byte[32000];

        private CIM() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static void write(FileHandle file, Pixmap pixmap) {
            DataOutputStream out = null;
            try {
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(file.write(false));
                out = new DataOutputStream(deflaterOutputStream);
                out.writeInt(pixmap.getWidth());
                out.writeInt(pixmap.getHeight());
                out.writeInt(Format.toNativePixmapFormat(pixmap.getFormat()));
                ByteBuffer pixelBuf = pixmap.getPixels();
                pixelBuf.position(0);
                pixelBuf.limit(pixelBuf.capacity());
                int remainingBytes = pixelBuf.capacity() % 32000;
                int iterations = pixelBuf.capacity() / 32000;
                byte[] byArray = writeBuffer;
                synchronized (writeBuffer) {
                    for (int i = 0; i < iterations; ++i) {
                        pixelBuf.get(writeBuffer);
                        out.write(writeBuffer);
                    }
                    pixelBuf.get(writeBuffer, 0, remainingBytes);
                    out.write(writeBuffer, 0, remainingBytes);
                    // ** MonitorExit[var7_8] (shouldn't be in output)
                    pixelBuf.position(0);
                    pixelBuf.limit(pixelBuf.capacity());
                }
            }
            catch (Exception e) {
                try {
                    throw new GameEngineRuntimeException("Couldn't write Pixmap to file '" + file + "'", e);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            {
                StreamUtils.closeQuietly(out);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static Pixmap read(FileHandle file) {
            Object object;
            DataInputStream in = null;
            try {
                in = new DataInputStream(new InflaterInputStream(new BufferedInputStream(file.read())));
                int width = in.readInt();
                int height = in.readInt();
                Format format = Format.fromNativePixmapFormat(in.readInt());
                Pixmap pixmap = new Pixmap(width, height, format);
                ByteBuffer pixelBuf = pixmap.getPixels();
                pixelBuf.position(0);
                pixelBuf.limit(pixelBuf.capacity());
                object = readBuffer;
                synchronized (readBuffer) {
                    int readBytes = 0;
                    while ((readBytes = in.read(readBuffer)) > 0) {
                        pixelBuf.put(readBuffer, 0, readBytes);
                    }
                    // ** MonitorExit[var7_8 /* !! */ ] (shouldn't be in output)
                    pixelBuf.position(0);
                    pixelBuf.limit(pixelBuf.capacity());
                    object = pixmap;
                }
            }
            catch (Exception e) {
                try {
                    throw new GameEngineRuntimeException("Couldn't read Pixmap from file '" + file + "'", e);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            {
                StreamUtils.closeQuietly(in);
                return object;
            }
        }
    }

    public static enum Filter {
        NearestNeighbour,
        BiLinear;

    }

    public static enum Blending {
        None,
        SourceOver;

    }

    public static enum Format {
        Alpha,
        Intensity,
        LuminanceAlpha,
        RGB565,
        RGBA4444,
        RGB888,
        RGBA8888;


        public static int toNativePixmapFormat(Format format) {
            if (format == Alpha) {
                return 1;
            }
            if (format == Intensity) {
                return 1;
            }
            if (format == LuminanceAlpha) {
                return 2;
            }
            if (format == RGB565) {
                return 5;
            }
            if (format == RGBA4444) {
                return 6;
            }
            if (format == RGB888) {
                return 3;
            }
            if (format == RGBA8888) {
                return 4;
            }
            throw new GameEngineRuntimeException("Unknown Format: " + (Object)((Object)format));
        }

        public static Format fromNativePixmapFormat(int format) {
            if (format == 1) {
                return Alpha;
            }
            if (format == 2) {
                return LuminanceAlpha;
            }
            if (format == 5) {
                return RGB565;
            }
            if (format == 6) {
                return RGBA4444;
            }
            if (format == 3) {
                return RGB888;
            }
            if (format == 4) {
                return RGBA8888;
            }
            throw new GameEngineRuntimeException("Unknown NativePixmap Format: " + format);
        }
    }
}

