/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.graphics;

import com.guidebee.game.Application;
import com.guidebee.game.GameEngine;
import com.guidebee.game.engine.graphics.opengles.IGL20;
import com.guidebee.game.graphics.Pixmap;
import com.guidebee.game.graphics.Texture;
import com.guidebee.utils.Disposable;
import com.guidebee.utils.collections.Array;
import com.guidebee.utils.collections.BufferUtils;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;

public class FrameBuffer
implements Disposable {
    private static final Map<Application, Array<FrameBuffer>> buffers = new HashMap<Application, Array<FrameBuffer>>();
    protected Texture colorTexture;
    private static int defaultFramebufferHandle;
    private static boolean defaultFramebufferHandleInitialized;
    private int framebufferHandle;
    private int depthbufferHandle;
    protected final int width;
    protected final int height;
    protected final boolean hasDepth;
    protected final Pixmap.Format format;

    public FrameBuffer(Pixmap.Format format, int width, int height, boolean hasDepth) {
        this.width = width;
        this.height = height;
        this.format = format;
        this.hasDepth = hasDepth;
        this.build();
        FrameBuffer.addManagedFrameBuffer(GameEngine.app, this);
    }

    protected void setupTexture() {
        this.colorTexture = new Texture(this.width, this.height, this.format);
        this.colorTexture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        this.colorTexture.setWrap(Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
    }

    private void build() {
        IGL20 gl = GameEngine.gl20;
        if (!defaultFramebufferHandleInitialized) {
            defaultFramebufferHandleInitialized = true;
            defaultFramebufferHandle = 0;
        }
        this.setupTexture();
        IntBuffer handle = BufferUtils.newIntBuffer(1);
        gl.glGenFramebuffers(1, handle);
        this.framebufferHandle = handle.get(0);
        if (this.hasDepth) {
            handle.clear();
            gl.glGenRenderbuffers(1, handle);
            this.depthbufferHandle = handle.get(0);
        }
        gl.glBindTexture(3553, this.colorTexture.getTextureObjectHandle());
        if (this.hasDepth) {
            gl.glBindRenderbuffer(36161, this.depthbufferHandle);
            gl.glRenderbufferStorage(36161, 33189, this.colorTexture.getWidth(), this.colorTexture.getHeight());
        }
        gl.glBindFramebuffer(36160, this.framebufferHandle);
        gl.glFramebufferTexture2D(36160, 36064, 3553, this.colorTexture.getTextureObjectHandle(), 0);
        if (this.hasDepth) {
            gl.glFramebufferRenderbuffer(36160, 36096, 36161, this.depthbufferHandle);
        }
        int result = gl.glCheckFramebufferStatus(36160);
        gl.glBindRenderbuffer(36161, 0);
        gl.glBindTexture(3553, 0);
        gl.glBindFramebuffer(36160, defaultFramebufferHandle);
        if (result != 36053) {
            this.colorTexture.dispose();
            if (this.hasDepth) {
                handle.clear();
                handle.put(this.depthbufferHandle);
                handle.flip();
                gl.glDeleteRenderbuffers(1, handle);
            }
            handle.clear();
            handle.put(this.framebufferHandle);
            handle.flip();
            gl.glDeleteFramebuffers(1, handle);
            if (result == 36054) {
                throw new IllegalStateException("frame buffer couldn't be constructed: incomplete attachment");
            }
            if (result == 36057) {
                throw new IllegalStateException("frame buffer couldn't be constructed: incomplete dimensions");
            }
            if (result == 36055) {
                throw new IllegalStateException("frame buffer couldn't be constructed: missing attachment");
            }
            if (result == 36061) {
                throw new IllegalStateException("frame buffer couldn't be constructed: unsupported combination of formats");
            }
            throw new IllegalStateException("frame buffer couldn't be constructed: unknown error " + result);
        }
    }

    @Override
    public void dispose() {
        IGL20 gl = GameEngine.gl20;
        IntBuffer handle = BufferUtils.newIntBuffer(1);
        this.colorTexture.dispose();
        if (this.hasDepth) {
            handle.put(this.depthbufferHandle);
            handle.flip();
            gl.glDeleteRenderbuffers(1, handle);
        }
        handle.clear();
        handle.put(this.framebufferHandle);
        handle.flip();
        gl.glDeleteFramebuffers(1, handle);
        if (buffers.get(GameEngine.app) != null) {
            buffers.get(GameEngine.app).removeValue(this, true);
        }
    }

    public void bind() {
        GameEngine.gl20.glBindFramebuffer(36160, this.framebufferHandle);
    }

    public static void unbind() {
        GameEngine.gl20.glBindFramebuffer(36160, defaultFramebufferHandle);
    }

    public void begin() {
        this.bind();
        this.setFrameBufferViewport();
    }

    protected void setFrameBufferViewport() {
        GameEngine.gl20.glViewport(0, 0, this.colorTexture.getWidth(), this.colorTexture.getHeight());
    }

    public void end() {
        FrameBuffer.unbind();
        this.setDefaultFrameBufferViewport();
    }

    protected void setDefaultFrameBufferViewport() {
        GameEngine.gl20.glViewport(0, 0, GameEngine.graphics.getWidth(), GameEngine.graphics.getHeight());
    }

    public void end(int x, int y, int width, int height) {
        FrameBuffer.unbind();
        GameEngine.gl20.glViewport(x, y, width, height);
    }

    public Texture getColorBufferTexture() {
        return this.colorTexture;
    }

    public int getHeight() {
        return this.colorTexture.getHeight();
    }

    public int getWidth() {
        return this.colorTexture.getWidth();
    }

    private static void addManagedFrameBuffer(Application app, FrameBuffer frameBuffer) {
        Array<FrameBuffer> managedResources = buffers.get(app);
        if (managedResources == null) {
            managedResources = new Array();
        }
        managedResources.add(frameBuffer);
        buffers.put(app, managedResources);
    }

    public static void invalidateAllFrameBuffers(Application app) {
        if (GameEngine.gl20 == null) {
            return;
        }
        Array<FrameBuffer> bufferArray = buffers.get(app);
        if (bufferArray == null) {
            return;
        }
        for (int i = 0; i < bufferArray.size; ++i) {
            bufferArray.get(i).build();
        }
    }

    public static void clearAllFrameBuffers(Application app) {
        buffers.remove(app);
    }

    public static StringBuilder getManagedStatus(StringBuilder builder) {
        builder.append("Managed buffers/app: { ");
        for (Application app : buffers.keySet()) {
            builder.append(FrameBuffer.buffers.get((Object)app).size);
            builder.append(" ");
        }
        builder.append("}");
        return builder;
    }

    public static String getManagedStatus() {
        return FrameBuffer.getManagedStatus(new StringBuilder()).toString();
    }

    static {
        defaultFramebufferHandleInitialized = false;
    }
}

