/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.graphics;

import com.guidebee.game.GameEngineRuntimeException;
import com.guidebee.game.graphics.Batch;
import com.guidebee.game.graphics.BitmapFont;
import com.guidebee.game.graphics.Color;
import com.guidebee.game.graphics.Colors;
import com.guidebee.game.graphics.Font;
import com.guidebee.game.graphics.TextureRegion;
import com.guidebee.utils.NumberUtils;
import com.guidebee.utils.StringBuilder;
import com.guidebee.utils.collections.IntArray;

public class BitmapFontCache {
    private final BitmapFont font;
    private float[][] vertexData;
    private int[] idx;
    private int[] tmpGlyphCount;
    private float x;
    private float y;
    private float color;
    private float previousColor;
    private final Color tempColor;
    private final Color hexColor;
    private final StringBuilder colorBuffer;
    private final Font.TextBounds textBounds;
    private boolean integer;
    private int glyphCount;
    private IntArray[] glyphIndices;

    public BitmapFontCache(BitmapFont font) {
        this(font, font.usesIntegerPositions());
    }

    public BitmapFontCache(BitmapFont font, boolean integer) {
        this.previousColor = this.color = Color.WHITE.toFloatBits();
        this.tempColor = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.hexColor = new Color();
        this.colorBuffer = new StringBuilder();
        this.textBounds = new Font.TextBounds();
        this.integer = true;
        this.glyphCount = 0;
        this.font = font;
        this.integer = integer;
        int regionsLength = font.regions.length;
        if (regionsLength == 0) {
            throw new IllegalArgumentException("The specified font must contain at least 1 texture page");
        }
        this.vertexData = new float[regionsLength][];
        this.idx = new int[regionsLength];
        int vertexDataLength = this.vertexData.length;
        if (vertexDataLength > 1) {
            this.glyphIndices = new IntArray[vertexDataLength];
            int n = this.glyphIndices.length;
            for (int i = 0; i < n; ++i) {
                this.glyphIndices[i] = new IntArray();
            }
            this.tmpGlyphCount = new int[vertexDataLength];
        }
    }

    public void setPosition(float x, float y) {
        this.translate(x - this.x, y - this.y);
    }

    public void translate(float xAmount, float yAmount) {
        if (xAmount == 0.0f && yAmount == 0.0f) {
            return;
        }
        if (this.integer) {
            xAmount = Math.round(xAmount);
            yAmount = Math.round(yAmount);
        }
        this.x += xAmount;
        this.y += yAmount;
        int length = this.vertexData.length;
        for (int j = 0; j < length; ++j) {
            float[] vertices = this.vertexData[j];
            int n = this.idx[j];
            for (int i = 0; i < n; i += 5) {
                int n2 = i;
                vertices[n2] = vertices[n2] + xAmount;
                int n3 = i + 1;
                vertices[n3] = vertices[n3] + yAmount;
            }
        }
    }

    public void setColors(float color) {
        int length = this.vertexData.length;
        for (int j = 0; j < length; ++j) {
            float[] vertices = this.vertexData[j];
            int n = this.idx[j];
            for (int i = 2; i < n; i += 5) {
                vertices[i] = color;
            }
        }
    }

    public void setColors(Color tint) {
        float color = tint.toFloatBits();
        int length = this.vertexData.length;
        for (int j = 0; j < length; ++j) {
            float[] vertices = this.vertexData[j];
            int n = this.idx[j];
            for (int i = 2; i < n; i += 5) {
                vertices[i] = color;
            }
        }
    }

    public void setColors(float r, float g, float b, float a) {
        int intBits = (int)(255.0f * a) << 24 | (int)(255.0f * b) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r);
        float color = NumberUtils.intToFloatColor(intBits);
        int length = this.vertexData.length;
        for (int j = 0; j < length; ++j) {
            float[] vertices = this.vertexData[j];
            int n = this.idx[j];
            for (int i = 2; i < n; i += 5) {
                vertices[i] = color;
            }
        }
    }

    public void setColors(Color tint, int start, int end) {
        float color = tint.toFloatBits();
        if (this.vertexData.length == 1) {
            float[] vertices = this.vertexData[0];
            int n = end * 20;
            for (int i = start * 20 + 2; i < n; i += 5) {
                vertices[i] = color;
            }
        } else {
            for (float[] vertices : this.vertexData) {
                int gInd;
                int i;
                int n = this.glyphIndices[i].size;
                for (int j = 0; j < n && (gInd = this.glyphIndices[i].items[j]) < end; ++j) {
                    if (gInd < start) continue;
                    for (int off = 0; off < 20; off += 5) {
                        vertices[off + (j * 20 + 2)] = color;
                    }
                }
            }
        }
    }

    public void setColor(Color tint) {
        this.color = tint.toFloatBits();
    }

    public void setColor(float r, float g, float b, float a) {
        int intBits = (int)(255.0f * a) << 24 | (int)(255.0f * b) << 16 | (int)(255.0f * g) << 8 | (int)(255.0f * r);
        this.color = NumberUtils.intToFloatColor(intBits);
    }

    public void setColor(float color) {
        this.color = color;
    }

    public Color getColor() {
        int intBits = NumberUtils.floatToIntColor(this.color);
        Color color = this.tempColor;
        color.r = (float)(intBits & 0xFF) / 255.0f;
        color.g = (float)(intBits >>> 8 & 0xFF) / 255.0f;
        color.b = (float)(intBits >>> 16 & 0xFF) / 255.0f;
        color.a = (float)(intBits >>> 24 & 0xFF) / 255.0f;
        return color;
    }

    public void draw(Batch spriteBatch) {
        TextureRegion[] regions = this.font.getRegions();
        int n = this.vertexData.length;
        for (int j = 0; j < n; ++j) {
            if (this.idx[j] <= 0) continue;
            float[] vertices = this.vertexData[j];
            spriteBatch.draw(regions[j].getTexture(), vertices, 0, this.idx[j]);
        }
    }

    public void draw(Batch spriteBatch, int start, int end) {
        if (this.vertexData.length == 1) {
            spriteBatch.draw(this.font.getRegion().getTexture(), this.vertexData[0], start * 20, (end - start) * 20);
        } else {
            TextureRegion[] regions = this.font.getRegions();
            int pageCount = this.vertexData.length;
            for (int i = 0; i < pageCount; ++i) {
                int glyphIndex;
                int offset = -1;
                int count = 0;
                IntArray currentGlyphIndices = this.glyphIndices[i];
                int n = currentGlyphIndices.size;
                for (int j = 0; j < n && (glyphIndex = currentGlyphIndices.items[j]) < end; ++j) {
                    if (offset == -1 && glyphIndex >= start) {
                        offset = j;
                    }
                    if (glyphIndex < start) continue;
                    ++count;
                }
                if (offset == -1 || count == 0) continue;
                spriteBatch.draw(regions[i].getTexture(), this.vertexData[i], offset * 20, count * 20);
            }
        }
    }

    public void draw(Batch spriteBatch, float alphaModulation) {
        if (alphaModulation == 1.0f) {
            this.draw(spriteBatch);
            return;
        }
        Color color = this.getColor();
        float oldAlpha = color.a;
        color.a *= alphaModulation;
        this.setColors(color);
        this.draw(spriteBatch);
        color.a = oldAlpha;
        this.setColors(color);
    }

    public void clear() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.glyphCount = 0;
        int n = this.idx.length;
        for (int i = 0; i < n; ++i) {
            if (this.glyphIndices != null) {
                this.glyphIndices[i].clear();
            }
            this.idx[i] = 0;
        }
    }

    private int countGlyphs(CharSequence seq, int start, int end) {
        int count = end - start;
        while (start < end) {
            char ch;
            if ((ch = seq.charAt(start++)) != '[') continue;
            --count;
            if (start >= end || seq.charAt(start) != '[') {
                while (start < end && seq.charAt(start) != ']') {
                    ++start;
                    --count;
                }
                --count;
            }
            ++start;
        }
        return count;
    }

    private void requireSequence(CharSequence seq, int start, int end) {
        if (this.vertexData.length == 1) {
            int newGlyphCount = this.font.markupEnabled ? this.countGlyphs(seq, start, end) : end - start;
            this.require(0, newGlyphCount);
        } else {
            int i;
            int n = this.tmpGlyphCount.length;
            for (i = 0; i < n; ++i) {
                this.tmpGlyphCount[i] = 0;
            }
            while (start < end) {
                BitmapFont.Glyph g;
                char ch;
                if ((ch = seq.charAt(start++)) == '[' && this.font.markupEnabled) {
                    if (start >= end || seq.charAt(start) != '[') {
                        while (start < end && seq.charAt(start) != ']') {
                            ++start;
                        }
                        ++start;
                        continue;
                    }
                    ++start;
                }
                if ((g = this.font.data.getGlyph(ch)) == null) continue;
                int n2 = g.page;
                this.tmpGlyphCount[n2] = this.tmpGlyphCount[n2] + 1;
            }
            n = this.tmpGlyphCount.length;
            for (i = 0; i < n; ++i) {
                this.require(i, this.tmpGlyphCount[i]);
            }
        }
    }

    private void require(int page, int glyphCount) {
        if (this.glyphIndices != null && glyphCount > this.glyphIndices[page].items.length) {
            this.glyphIndices[page].ensureCapacity(glyphCount - this.glyphIndices[page].items.length);
        }
        int vertexCount = this.idx[page] + glyphCount * 20;
        float[] vertices = this.vertexData[page];
        if (vertices == null) {
            this.vertexData[page] = new float[vertexCount];
        } else if (vertices.length < vertexCount) {
            float[] newVertices = new float[vertexCount];
            System.arraycopy(vertices, 0, newVertices, 0, this.idx[page]);
            this.vertexData[page] = newVertices;
        }
    }

    private int parseAndSetColor(CharSequence str, int start, int end) {
        block15: {
            if (start >= end) break block15;
            if (str.charAt(start) == '#') {
                int colorInt = 0;
                for (int i = start + 1; i < end; ++i) {
                    char ch = str.charAt(i);
                    if (ch == ']') {
                        if (i < start + 2 || i > start + 9) {
                            throw new GameEngineRuntimeException("Hex color cannot have " + (i - start - 1) + " digits");
                        }
                        this.previousColor = this.color;
                        if (i <= start + 7) {
                            Color.rgb888ToColor(this.hexColor, colorInt);
                            this.hexColor.a = 1.0f;
                        } else {
                            Color.rgba8888ToColor(this.hexColor, colorInt);
                        }
                        this.color = this.hexColor.toFloatBits();
                        return i - start;
                    }
                    if (ch >= '0' && ch <= '9') {
                        colorInt = colorInt * 16 + (ch - 48);
                        continue;
                    }
                    if (ch >= 'a' && ch <= 'f') {
                        colorInt = colorInt * 16 + (ch - 87);
                        continue;
                    }
                    if (ch >= 'A' && ch <= 'F') {
                        colorInt = colorInt * 16 + (ch - 55);
                        continue;
                    }
                    throw new GameEngineRuntimeException("Unexpected '" + ch + "' in hex color");
                }
            } else {
                this.colorBuffer.setLength(0);
                for (int i = start; i < end; ++i) {
                    char ch = str.charAt(i);
                    if (ch == ']') {
                        if (this.colorBuffer.length() == 0) {
                            this.color = this.previousColor;
                        } else {
                            String colorString = this.colorBuffer.toString();
                            Color newColor = Colors.get(colorString);
                            if (newColor == null) {
                                throw new GameEngineRuntimeException("Unknown color '" + colorString + "'");
                            }
                            this.previousColor = this.color;
                            this.color = newColor.toFloatBits();
                        }
                        return i - start;
                    }
                    this.colorBuffer.append(ch);
                }
            }
        }
        throw new GameEngineRuntimeException("Unclosed color tag");
    }

    private float addToCache(CharSequence str, float x, float y, int start, int end) {
        float startX = x;
        BitmapFont font = this.font;
        BitmapFont.Glyph lastGlyph = null;
        BitmapFont.BitmapFontData data = font.data;
        if (data.scaleX == 1.0f && data.scaleY == 1.0f) {
            char ch;
            while (start < end) {
                if ((ch = str.charAt(start++)) == '[' && font.markupEnabled) {
                    if (start >= end || str.charAt(start) != '[') {
                        start += this.parseAndSetColor(str, start, end) + 1;
                        continue;
                    }
                    ++start;
                }
                if ((lastGlyph = data.getGlyph(ch)) == null) continue;
                this.addGlyph(lastGlyph, x + (float)lastGlyph.xoffset, y + (float)lastGlyph.yoffset, lastGlyph.width, lastGlyph.height);
                x += (float)lastGlyph.xadvance;
                break;
            }
            while (start < end) {
                BitmapFont.Glyph g;
                if ((ch = str.charAt(start++)) == '[' && font.markupEnabled) {
                    if (start >= end || str.charAt(start) != '[') {
                        start += this.parseAndSetColor(str, start, end) + 1;
                        continue;
                    }
                    ++start;
                }
                if ((g = data.getGlyph(ch)) == null) continue;
                lastGlyph = g;
                this.addGlyph(lastGlyph, (x += (float)lastGlyph.getKerning(ch)) + (float)g.xoffset, y + (float)g.yoffset, g.width, g.height);
                x += (float)g.xadvance;
            }
        } else {
            char ch;
            float scaleX = data.scaleX;
            float scaleY = data.scaleY;
            while (start < end) {
                if ((ch = str.charAt(start++)) == '[' && font.markupEnabled) {
                    if (start >= end || str.charAt(start) != '[') {
                        start += this.parseAndSetColor(str, start, end) + 1;
                        continue;
                    }
                    ++start;
                }
                if ((lastGlyph = data.getGlyph(ch)) == null) continue;
                this.addGlyph(lastGlyph, x + (float)lastGlyph.xoffset * scaleX, y + (float)lastGlyph.yoffset * scaleY, (float)lastGlyph.width * scaleX, (float)lastGlyph.height * scaleY);
                x += (float)lastGlyph.xadvance * scaleX;
                break;
            }
            while (start < end) {
                BitmapFont.Glyph g;
                if ((ch = str.charAt(start++)) == '[' && font.markupEnabled) {
                    if (start >= end || str.charAt(start) != '[') {
                        start += this.parseAndSetColor(str, start, end) + 1;
                        continue;
                    }
                    ++start;
                }
                if ((g = data.getGlyph(ch)) == null) continue;
                lastGlyph = g;
                this.addGlyph(lastGlyph, (x += (float)lastGlyph.getKerning(ch) * scaleX) + (float)g.xoffset * scaleX, y + (float)g.yoffset * scaleY, (float)g.width * scaleX, (float)g.height * scaleY);
                x += (float)g.xadvance * scaleX;
            }
        }
        return x - startX;
    }

    private void addGlyph(BitmapFont.Glyph glyph, float x, float y, float width, float height) {
        float x2 = x + width;
        float y2 = y + height;
        float u = glyph.u;
        float u2 = glyph.u2;
        float v = glyph.v;
        float v2 = glyph.v2;
        int page = glyph.page;
        if (this.glyphIndices != null) {
            this.glyphIndices[page].add(this.glyphCount++);
        }
        float[] vertices = this.vertexData[page];
        if (this.integer) {
            x = Math.round(x);
            y = Math.round(y);
            x2 = Math.round(x2);
            y2 = Math.round(y2);
        }
        int idx = this.idx[page];
        int n = page;
        this.idx[n] = this.idx[n] + 20;
        vertices[idx++] = x;
        vertices[idx++] = y;
        vertices[idx++] = this.color;
        vertices[idx++] = u;
        vertices[idx++] = v;
        vertices[idx++] = x;
        vertices[idx++] = y2;
        vertices[idx++] = this.color;
        vertices[idx++] = u;
        vertices[idx++] = v2;
        vertices[idx++] = x2;
        vertices[idx++] = y2;
        vertices[idx++] = this.color;
        vertices[idx++] = u2;
        vertices[idx++] = v2;
        vertices[idx++] = x2;
        vertices[idx++] = y;
        vertices[idx++] = this.color;
        vertices[idx++] = u2;
        vertices[idx] = v;
    }

    public Font.TextBounds setText(CharSequence str, float x, float y) {
        this.clear();
        return this.addText(str, x, y, 0, str.length());
    }

    public Font.TextBounds setText(CharSequence str, float x, float y, int start, int end) {
        this.clear();
        return this.addText(str, x, y, start, end);
    }

    public Font.TextBounds addText(CharSequence str, float x, float y) {
        return this.addText(str, x, y, 0, str.length());
    }

    public Font.TextBounds addText(CharSequence str, float x, float y, int start, int end) {
        this.requireSequence(str, start, end);
        this.textBounds.width = this.addToCache(str, x, y += this.font.data.ascent, start, end);
        this.textBounds.height = this.font.data.capHeight;
        return this.textBounds;
    }

    public Font.TextBounds setMultiLineText(CharSequence str, float x, float y) {
        this.clear();
        return this.addMultiLineText(str, x, y, 0.0f, Font.HAlignment.LEFT);
    }

    public Font.TextBounds setMultiLineText(CharSequence str, float x, float y, float alignmentWidth, Font.HAlignment alignment) {
        this.clear();
        return this.addMultiLineText(str, x, y, alignmentWidth, alignment);
    }

    public Font.TextBounds addMultiLineText(CharSequence str, float x, float y) {
        return this.addMultiLineText(str, x, y, 0.0f, Font.HAlignment.LEFT);
    }

    public Font.TextBounds addMultiLineText(CharSequence str, float x, float y, float alignmentWidth, Font.HAlignment alignment) {
        BitmapFont font = this.font;
        int length = str.length();
        this.requireSequence(str, 0, length);
        float down = font.data.down;
        float maxWidth = 0.0f;
        float startY = y += font.data.ascent;
        int start = 0;
        int numLines = 0;
        while (start < length) {
            float lineWidth;
            int lineEnd = BitmapFont.indexOf(str, '\n', start);
            float xOffset = 0.0f;
            if (alignment != Font.HAlignment.LEFT) {
                lineWidth = font.getBounds((CharSequence)str, (int)start, (int)lineEnd).width;
                xOffset = alignmentWidth - lineWidth;
                if (alignment == Font.HAlignment.CENTER) {
                    xOffset /= 2.0f;
                }
            }
            lineWidth = this.addToCache(str, x + xOffset, y, start, lineEnd);
            maxWidth = Math.max(maxWidth, lineWidth);
            start = lineEnd + 1;
            y += down;
            ++numLines;
        }
        this.textBounds.width = maxWidth;
        this.textBounds.height = font.data.capHeight + (float)(numLines - 1) * font.data.lineHeight;
        return this.textBounds;
    }

    public Font.TextBounds setWrappedText(CharSequence str, float x, float y, float wrapWidth) {
        this.clear();
        return this.addWrappedText(str, x, y, wrapWidth, Font.HAlignment.LEFT);
    }

    public Font.TextBounds setWrappedText(CharSequence str, float x, float y, float wrapWidth, Font.HAlignment alignment) {
        this.clear();
        return this.addWrappedText(str, x, y, wrapWidth, alignment);
    }

    public Font.TextBounds addWrappedText(CharSequence str, float x, float y, float wrapWidth) {
        return this.addWrappedText(str, x, y, wrapWidth, Font.HAlignment.LEFT);
    }

    public Font.TextBounds addWrappedText(CharSequence str, float x, float y, float wrapWidth, Font.HAlignment alignment) {
        BitmapFont font = this.font;
        int length = str.length();
        this.requireSequence(str, 0, length);
        y += font.data.ascent;
        float down = font.data.down;
        if (wrapWidth <= 0.0f) {
            wrapWidth = 2.1474836E9f;
        }
        float maxWidth = 0.0f;
        int start = 0;
        int numLines = 0;
        while (start < length) {
            int lineEnd;
            int newLine = BitmapFont.indexOf(str, '\n', start);
            while (start < newLine && BitmapFont.isWhitespace(str.charAt(start))) {
                ++start;
            }
            int nextStart = lineEnd + 1;
            if (lineEnd < newLine) {
                for (lineEnd = start + font.computeVisibleGlyphs(str, start, newLine, wrapWidth); lineEnd > start && !BitmapFont.isWhitespace(str.charAt(lineEnd)); --lineEnd) {
                }
                if (lineEnd == start) {
                    if (nextStart > start + 1) {
                        --nextStart;
                    }
                    lineEnd = nextStart;
                } else {
                    nextStart = lineEnd;
                    while (lineEnd > start && BitmapFont.isWhitespace(str.charAt(lineEnd - 1))) {
                        --lineEnd;
                    }
                }
            }
            if (lineEnd > start) {
                float lineWidth;
                float xOffset = 0.0f;
                if (alignment != Font.HAlignment.LEFT) {
                    lineWidth = font.getBounds((CharSequence)str, (int)start, (int)lineEnd).width;
                    xOffset = wrapWidth - lineWidth;
                    if (alignment == Font.HAlignment.CENTER) {
                        xOffset /= 2.0f;
                    }
                }
                lineWidth = this.addToCache(str, x + xOffset, y, start, lineEnd);
                maxWidth = Math.max(maxWidth, lineWidth);
            }
            start = nextStart;
            y += down;
            ++numLines;
        }
        this.textBounds.width = maxWidth;
        this.textBounds.height = font.data.capHeight + (float)(numLines - 1) * font.data.lineHeight;
        return this.textBounds;
    }

    public Font.TextBounds getBounds() {
        return this.textBounds;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public BitmapFont getFont() {
        return this.font;
    }

    public void setUseIntegerPositions(boolean use) {
        this.integer = use;
    }

    public boolean usesIntegerPositions() {
        return this.integer;
    }

    public float[] getVertices() {
        return this.getVertices(0);
    }

    public float[] getVertices(int page) {
        return this.vertexData[page];
    }
}

