/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.entity.directors;

import com.guidebee.game.entity.directors.Director;

public abstract class IntervalDirector
extends Director {
    private float interval;
    private float accumulator;

    public IntervalDirector(float interval) {
        this(interval, 0);
    }

    public IntervalDirector(float interval, int priority) {
        super(priority);
        this.interval = interval;
        this.accumulator = 0.0f;
    }

    @Override
    public void direct(float deltaTime) {
        this.accumulator += deltaTime;
        if (this.accumulator >= this.interval) {
            this.accumulator -= this.interval;
            this.updateInterval();
        }
    }

    protected abstract void updateInterval();
}

