/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.entity;

import com.guidebee.game.entity.DataTrait;
import com.guidebee.game.entity.DataTraitType;
import com.guidebee.game.entity.Entity;
import com.guidebee.utils.collections.Bits;
import com.guidebee.utils.collections.ObjectMap;

public class Role {
    private static ObjectMap<String, Role> families = new ObjectMap();
    private static int familyIndex = 0;
    private final Bits all;
    private final Bits one;
    private final Bits exclude;
    private final int index;

    protected Role(Bits all, Bits any, Bits exclude) {
        this.all = all;
        this.one = any;
        this.exclude = exclude;
        this.index = familyIndex++;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean matches(Entity entity) {
        Bits entityDataTraitBits = entity.getDataTraitBits();
        if (entityDataTraitBits.isEmpty()) {
            return false;
        }
        int i = this.all.nextSetBit(0);
        while (i >= 0) {
            if (!entityDataTraitBits.get(i)) {
                return false;
            }
            i = this.all.nextSetBit(i + 1);
        }
        if (!this.one.isEmpty() && !this.one.intersects(entityDataTraitBits)) {
            return false;
        }
        return this.exclude.isEmpty() || !this.exclude.intersects(entityDataTraitBits);
    }

    @SafeVarargs
    public static Role getFor(Class<? extends DataTrait> ... dataTraitTypes) {
        return Role.getFor(DataTraitType.getBitsFor(dataTraitTypes), new Bits(), new Bits());
    }

    public static Role getFor(Bits all, Bits one, Bits exclude) {
        String hash = Role.getFamilyHash(all, one, exclude);
        Role role = families.get(hash, null);
        if (role == null) {
            role = new Role(all, one, exclude);
            families.put(hash, role);
        }
        return role;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.all == null ? 0 : this.all.hashCode());
        result = 31 * result + (this.one == null ? 0 : this.one.hashCode());
        result = 31 * result + (this.exclude == null ? 0 : this.exclude.hashCode());
        result = 31 * result + this.index;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Role)) {
            return false;
        }
        Role other = (Role)obj;
        if (this.all == null ? other.all != null : !this.all.equals(other.all)) {
            return false;
        }
        if (this.one == null ? other.one != null : !this.one.equals(other.one)) {
            return false;
        }
        if (this.exclude == null ? other.exclude != null : !this.exclude.equals(other.exclude)) {
            return false;
        }
        return this.index == other.index;
    }

    private static String getFamilyHash(Bits all, Bits one, Bits exclude) {
        StringBuilder builder = new StringBuilder();
        builder.append("all:");
        builder.append(Role.getBitsString(all));
        builder.append(",one:");
        builder.append(Role.getBitsString(one));
        builder.append(",exclude:");
        builder.append(Role.getBitsString(exclude));
        return builder.toString();
    }

    private static String getBitsString(Bits bits) {
        StringBuilder builder = new StringBuilder();
        int numBits = bits.length();
        for (int i = 0; i < numBits; ++i) {
            builder.append(bits.get(i) ? "1" : "0");
        }
        return builder.toString();
    }
}

