/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.entity;

import com.guidebee.game.entity.DataTrait;
import com.guidebee.game.entity.DataTraitType;
import com.guidebee.game.entity.EntityEngine;
import com.guidebee.game.entity.signals.Signal;
import com.guidebee.game.entity.utils.Bag;
import com.guidebee.game.entity.utils.ImmutableArray;
import com.guidebee.utils.collections.Array;
import com.guidebee.utils.collections.Bits;

public class Entity {
    private static int nextIndex;
    public int flags = 0;
    public final Signal<Entity> dataTraitAdded;
    public final Signal<Entity> dataTraitRemoved;
    private int index;
    private Bag<DataTrait> dataTraits = new Bag();
    private Array<DataTrait> dataTraitsArray = new Array(false, 16);
    private ImmutableArray<DataTrait> immutableDataTraitsArray = new ImmutableArray<DataTrait>(this.dataTraitsArray);
    private Bits dataTraitBits = new Bits();
    private Bits familyBits = new Bits();
    EntityEngine.DataTraitOperationHandler dataTraitOperationHandler;
    private Object userObject;

    public Entity() {
        this.index = nextIndex++;
        this.dataTraitAdded = new Signal();
        this.dataTraitRemoved = new Signal();
    }

    public int getIndex() {
        return this.index;
    }

    public Entity add(DataTrait dataTrait) {
        if (this.dataTraitOperationHandler != null) {
            this.dataTraitOperationHandler.add(this, dataTrait);
        } else {
            this.addInternal(dataTrait);
        }
        return this;
    }

    public DataTrait remove(Class<? extends DataTrait> dataTraitClass) {
        DataTraitType dataTraitType = DataTraitType.getFor(dataTraitClass);
        int dataTraitTypeIndex = dataTraitType.getIndex();
        DataTrait removeDataTrait = this.dataTraits.get(dataTraitTypeIndex);
        if (this.dataTraitOperationHandler != null) {
            this.dataTraitOperationHandler.remove(this, dataTraitClass);
        } else {
            this.removeInternal(dataTraitClass);
        }
        return removeDataTrait;
    }

    public void removeAll() {
        while (this.dataTraitsArray.size > 0) {
            this.removeInternal(this.dataTraitsArray.get(0).getClass());
        }
    }

    public ImmutableArray<DataTrait> getDataTraits() {
        return this.immutableDataTraitsArray;
    }

    public <T extends DataTrait> T getDataTrait(Class<T> dataTraitClass) {
        return this.getDataTrait(DataTraitType.getFor(dataTraitClass));
    }

    <T extends DataTrait> T getDataTrait(DataTraitType dataTraitType) {
        int dataTraitTypeIndex = dataTraitType.getIndex();
        if (dataTraitTypeIndex < this.dataTraits.getCapacity()) {
            return (T)this.dataTraits.get(dataTraitType.getIndex());
        }
        return null;
    }

    boolean hasDataTrait(DataTraitType dataTraitType) {
        return this.dataTraitBits.get(dataTraitType.getIndex());
    }

    Bits getDataTraitBits() {
        return this.dataTraitBits;
    }

    Bits getFamilyBits() {
        return this.familyBits;
    }

    Entity addInternal(DataTrait dataTrait) {
        Class<?> dataTraitClass = dataTrait.getClass();
        for (int i = 0; i < this.dataTraitsArray.size; ++i) {
            if (this.dataTraitsArray.get(i).getClass() != dataTraitClass) continue;
            this.dataTraitsArray.removeIndex(i);
            break;
        }
        int dataTraitTypeIndex = DataTraitType.getIndexFor(dataTrait.getClass());
        this.dataTraits.set(dataTraitTypeIndex, dataTrait);
        this.dataTraitsArray.add(dataTrait);
        this.dataTraitBits.set(dataTraitTypeIndex);
        this.dataTraitAdded.dispatch(this);
        return this;
    }

    DataTrait removeInternal(Class<? extends DataTrait> dataTraitClass) {
        DataTraitType dataTraitType = DataTraitType.getFor(dataTraitClass);
        int dataTraitTypeIndex = dataTraitType.getIndex();
        DataTrait removeDataTrait = this.dataTraits.get(dataTraitTypeIndex);
        if (removeDataTrait != null) {
            this.dataTraits.set(dataTraitTypeIndex, null);
            this.dataTraitsArray.removeValue(removeDataTrait, true);
            this.dataTraitBits.clear(dataTraitTypeIndex);
            this.dataTraitRemoved.dispatch(this);
        }
        return removeDataTrait;
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Entity)) {
            return false;
        }
        Entity other = (Entity)obj;
        return this.index == other.index;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }
}

