/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.math;

public final class MathEx {
    private static final double PRECISION = 1.0E-12;
    public static final double PI = Math.PI;
    public static final double E = Math.E;
    public static final double LOGdiv2 = -0.6931471805599453;

    private MathEx() {
    }

    public static double abs(double a) {
        return Math.abs(a);
    }

    public static float abs(float a) {
        return Math.abs(a);
    }

    public static int abs(int a) {
        return Math.abs(a);
    }

    public static long abs(long a) {
        return Math.abs(a);
    }

    public static double ceil(double a) {
        return Math.ceil(a);
    }

    public static double cos(double a) {
        return Math.cos(a);
    }

    public static double floor(double a) {
        return Math.floor(a);
    }

    public static double max(double a, double b) {
        return Math.max(a, b);
    }

    public static float max(float a, float b) {
        return Math.max(a, b);
    }

    public static int max(int a, int b) {
        return Math.max(a, b);
    }

    public static long max(long a, long b) {
        return Math.max(a, b);
    }

    public static double min(double a, double b) {
        return Math.min(a, b);
    }

    public static float min(float a, float b) {
        return Math.min(a, b);
    }

    public static int min(int a, int b) {
        return Math.min(a, b);
    }

    public static long min(long a, long b) {
        return Math.min(a, b);
    }

    public static double sin(double a) {
        return Math.sin(a);
    }

    public static double sqrt(double a) {
        return Math.sqrt(a);
    }

    public static double tan(double a) {
        return Math.tan(a);
    }

    public static double toDegrees(double angrad) {
        return Math.toDegrees(angrad);
    }

    public static double toRadians(double angdeg) {
        return Math.toRadians(angdeg);
    }

    public static double atan(double a) {
        boolean signChange = false;
        boolean Invert = false;
        if (a < 0.0) {
            a = -a;
            signChange = true;
        }
        if (a > 1.0) {
            a = 1.0 / a;
            Invert = true;
        }
        if (a == 0.0) {
            return 0.0;
        }
        if (a == 1.0) {
            return 0.7853981633974483;
        }
        double a0 = a;
        double n = 1.0;
        double a1 = -1.0 * a * a * (2.0 * n - 1.0) / (2.0 * n + 1.0) * a0;
        double s = a0;
        while (Math.abs(a1) > 1.0E-12) {
            s += a1;
            a0 = a1;
            a1 = -1.0 * a * a * (2.0 * (n += 1.0) - 1.0) / (2.0 * n + 1.0) * a0;
        }
        if (Invert) {
            s = 1.5707963267948966 - s;
        }
        if (signChange) {
            s = -s;
        }
        return s;
    }

    public static double atan2(double y, double x) {
        if (y == 0.0 && x == 0.0) {
            return 0.0;
        }
        if (x > 0.0) {
            return MathEx.atan(y / x);
        }
        if (x < 0.0) {
            if (y < 0.0) {
                return -(Math.PI - MathEx.atan(y / x));
            }
            return Math.PI - MathEx.atan(-y / x);
        }
        if (y < 0.0) {
            return -1.5707963267948966;
        }
        return 1.5707963267948966;
    }

    public static int round(float a) {
        return (int)Math.floor(a + 0.5f);
    }

    public static long round(double a) {
        return (long)Math.floor(a + 0.5);
    }

    public static double exp(double x) {
        boolean isless;
        if (x == 0.0) {
            return 1.0;
        }
        double f = 1.0;
        long d = 1L;
        boolean bl = isless = x < 0.0;
        if (isless) {
            x = -x;
        }
        double k = x / (double)d;
        for (long i = 2L; i < 50L; ++i) {
            f += k;
            k = k * x / (double)i;
        }
        if (isless) {
            return 1.0 / f;
        }
        return f;
    }

    public static double exp1(double a) {
        boolean isless;
        if (a == 0.0) {
            return 1.0;
        }
        boolean bl = isless = a < 0.0;
        if (isless) {
            a = -a;
        }
        long intPart = (int)a;
        double fractionPart = a - (double)intPart;
        double ret = 1.0;
        for (long i = 0L; i < intPart; ++i) {
            ret *= Math.E;
        }
        double n = 1.0;
        double an = fractionPart;
        double sn = 1.0;
        double subRes = 1.0;
        if (fractionPart > 0.0) {
            subRes += fractionPart;
            while (an > 1.0E-12) {
                subRes += (an *= fractionPart) / (sn *= (n += 1.0));
            }
        }
        ret *= subRes;
        if (isless) {
            return 1.0 / ret;
        }
        return ret;
    }

    private static double _log(double x) {
        double y;
        if (!(x > 0.0)) {
            return Double.NaN;
        }
        double f = 0.0;
        int appendix = 0;
        while (x > 0.0 && x <= 1.0) {
            x *= 2.0;
            ++appendix;
        }
        --appendix;
        double y1 = (x /= 2.0) - 1.0;
        double y2 = x + 1.0;
        double k = y = y1 / y2;
        y2 = k * y;
        for (long i = 1L; i < 50L; i += 2L) {
            f += k / (double)i;
            k *= y2;
        }
        f *= 2.0;
        for (int i = 0; i < appendix; ++i) {
            f += -0.6931471805599453;
        }
        return f;
    }

    public static double log(double x) {
        if (!(x > 0.0)) {
            return Double.NaN;
        }
        if (x == 1.0) {
            return 0.0;
        }
        if (x > 1.0) {
            x = 1.0 / x;
            return -MathEx._log(x);
        }
        return MathEx._log(x);
    }

    public static double log1(double a) {
        double x;
        if (a <= 0.0) {
            return Double.NaN;
        }
        boolean invert = false;
        if (a > 1.0) {
            invert = true;
            a = 1.0 / a;
        }
        if (a == 1.0) {
            return 0.0;
        }
        double a0 = x = a - 1.0;
        double n = 1.0;
        double a1 = -1.0 * x * n / (n + 1.0) * a0;
        double s = a0;
        while (Math.abs(a1) > 1.0E-12) {
            s += a1;
            a0 = a1;
            a1 = -1.0 * x * (n += 1.0) / (n + 1.0) * a0;
        }
        if (invert) {
            return -s;
        }
        return s;
    }

    public static double pow(double a, double b) {
        boolean integerValue;
        if (a == 0.0) {
            return 0.0;
        }
        if (a == 1.0) {
            return 1.0;
        }
        if (b == 0.0) {
            return 1.0;
        }
        if (b == 1.0) {
            return a;
        }
        long l = (long)Math.floor(b);
        boolean bl = integerValue = b == (double)l;
        if (integerValue) {
            boolean neg = false;
            if (b < 0.0) {
                neg = true;
            }
            double result = a;
            for (long i = 1L; i < (neg ? -l : l); ++i) {
                result *= a;
            }
            if (neg) {
                return 1.0 / result;
            }
            return result;
        }
        if (a > 0.0) {
            return MathEx.exp(b * MathEx.log(a));
        }
        return Double.NaN;
    }

    public static double asin(double a) {
        if (a < -1.0 || a > 1.0) {
            return Double.NaN;
        }
        if (a == -1.0) {
            return -1.5707963267948966;
        }
        if (a == 1.0) {
            return 1.5707963267948966;
        }
        return MathEx.atan(a / Math.sqrt(1.0 - a * a));
    }

    public static double acos(double a) {
        double f = MathEx.asin(a);
        if (f == Double.NaN) {
            return f;
        }
        return 1.5707963267948966 - f;
    }

    public static double sign(double a) {
        if (a == 0.0) {
            return 0.0;
        }
        if (a > 0.0) {
            return 1.0;
        }
        return -1.0;
    }

    private static double rawCopySign(double magnitude, double sign) {
        return Double.longBitsToDouble(Double.doubleToLongBits(sign) & Long.MIN_VALUE | Double.doubleToLongBits(magnitude) & Long.MAX_VALUE);
    }

    public static double rint(double a) {
        double twoToThe52 = 4.503599627370496E15;
        double sign = MathEx.rawCopySign(1.0, a);
        if ((a = Math.abs(a)) < twoToThe52) {
            a = twoToThe52 + a - twoToThe52;
        }
        return sign * a;
    }

    public static double IEEEremainder(double f1, double f2) {
        if (f2 == 0.0) {
            return Double.NaN;
        }
        double divide = MathEx.rint(f1 / f2);
        return f1 - divide * f2;
    }
}

