/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.math;

import com.guidebee.math.Utils;
import java.io.IOException;
import java.io.Reader;

public final class HTML2Text {
    private boolean body_found = false;
    private boolean in_body = false;
    private boolean pre = false;
    private boolean center = false;
    private String href = "";

    public String removeDoubleBackSlash(String source) {
        StringBuffer result2 = new StringBuffer();
        StringReader input = new StringReader(source);
        try {
            String text = null;
            int c = input.read();
            while (c != -1) {
                text = "";
                text = c == 92 ? ((c = input.read()) == 92 ? "\\" : "\\" + (char)c) : "" + (char)c;
                StringBuffer s = result2;
                s.append(text);
                c = input.read();
            }
        }
        catch (Exception e) {
            input.close();
        }
        StringBuffer s = result2;
        return s.toString().trim();
    }

    public String convertUTF8(String source) {
        StringBuffer result2 = new StringBuffer();
        StringReader input = new StringReader(source);
        try {
            String text = null;
            int c = input.read();
            while (c != -1) {
                text = "";
                if (c == 92) {
                    c = input.read();
                    switch (c) {
                        case 117: {
                            text = "";
                            for (int i = 0; i < 4; ++i) {
                                text = text + String.valueOf((char)input.read());
                            }
                            text = String.valueOf((char)Integer.parseInt(text, 16));
                            break;
                        }
                        case 120: {
                            text = "";
                            for (int i = 0; i < 2; ++i) {
                                text = text + String.valueOf((char)input.read());
                            }
                            text = String.valueOf((char)Integer.parseInt(text, 16));
                            break;
                        }
                        default: {
                            text = "\\" + (char)c;
                            break;
                        }
                    }
                } else {
                    text = "" + (char)c;
                }
                StringBuffer s = result2;
                s.append(text);
                c = input.read();
            }
        }
        catch (Exception e) {
            input.close();
        }
        StringBuffer s = result2;
        return s.toString().trim();
    }

    public static String utf8decoder(String input) {
        String[] letters = Utils.tokenize(input, '%');
        if (letters.length > 1) {
            try {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < letters.length; ++i) {
                    if (letters[i].length() <= 0) continue;
                    sb.append(String.valueOf((char)Integer.parseInt(letters[i], 16)));
                }
                return sb.toString();
            }
            catch (Exception e) {
                return input;
            }
        }
        return input;
    }

    public static String encodeutf8(byte[] b) {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + "%" + Integer.toString((b[i] & 0xFF) + 256, 16).substring(1);
        }
        return result;
    }

    public String convert(String source) {
        StringBuffer result = new StringBuffer();
        StringBuffer result2 = new StringBuffer();
        StringReader input = new StringReader(source);
        try {
            String text = null;
            int c = input.read();
            while (c != -1) {
                StringBuffer s;
                text = "";
                if (c == 60) {
                    String CurrentTag = this.getTag(input);
                    text = this.convertTag(CurrentTag);
                } else if (c == 38) {
                    String specialchar = this.getSpecial(input);
                    text = specialchar.equals("lt;") || specialchar.equals("#60") ? "<" : (specialchar.equals("gt;") || specialchar.equals("#62") ? ">" : (specialchar.equals("amp;") || specialchar.equals("#38") ? "&" : (specialchar.equals("nbsp;") ? " " : (specialchar.equals("#39") ? "'" : (specialchar.equals("quot;") || specialchar.equals("#34") ? "\"" : (specialchar.equals("copy;") || specialchar.equals("#169") ? "[Copyright]" : (specialchar.equals("reg;") || specialchar.equals("#174") ? "[Registered]" : (specialchar.equals("trade;") || specialchar.equals("#153") ? "[Trademark]" : "&" + specialchar))))))));
                } else if (!this.pre && this.isWhitespace((char)c)) {
                    StringBuffer stringBuffer = s = this.in_body ? result : result2;
                    text = s.length() > 0 && this.isWhitespace(s.charAt(s.length() - 1)) ? "" : " ";
                } else {
                    text = "" + (char)c;
                }
                s = this.in_body ? result : result2;
                s.append(text);
                c = input.read();
            }
        }
        catch (Exception e) {
            input.close();
        }
        StringBuffer s = this.body_found ? result : result2;
        return s.toString().trim();
    }

    private String getTag(Reader r) throws IOException {
        int c;
        StringBuffer result = new StringBuffer();
        int level = 1;
        result.append('<');
        while (level > 0 && (c = r.read()) != -1) {
            result.append((char)c);
            if (c == 60) {
                ++level;
                continue;
            }
            if (c != 62) continue;
            --level;
        }
        return result.toString();
    }

    private String getSpecial(Reader r) throws IOException {
        StringBuffer result = new StringBuffer();
        r.mark(1);
        int c = r.read();
        while (this.isLetter((char)c)) {
            result.append((char)c);
            r.mark(1);
            c = r.read();
        }
        if (c == 59) {
            result.append(';');
        } else {
            r.reset();
        }
        return result.toString();
    }

    private boolean isTag(String s1, String s2) {
        s1 = s1.toLowerCase();
        String t1 = "<" + s2.toLowerCase() + ">";
        String t2 = "<" + s2.toLowerCase() + " ";
        return s1.startsWith(t1) || s1.startsWith(t2);
    }

    private String convertTag(String t) throws IOException {
        String result = "";
        if (this.isTag(t, "body")) {
            this.in_body = true;
            this.body_found = true;
        } else if (this.isTag(t, "/body")) {
            this.in_body = false;
            result = "";
        } else if (this.isTag(t, "center")) {
            result = "";
            this.center = true;
        } else if (this.isTag(t, "/center")) {
            result = "";
            this.center = false;
        } else if (this.isTag(t, "pre")) {
            result = "";
            this.pre = true;
        } else if (this.isTag(t, "/pre")) {
            result = "";
            this.pre = false;
        } else if (this.isTag(t, "p")) {
            result = "";
        } else if (this.isTag(t, "br")) {
            result = "";
        } else if (this.isTag(t, "h1") || this.isTag(t, "h2") || this.isTag(t, "h3") || this.isTag(t, "h4") || this.isTag(t, "h5") || this.isTag(t, "h6") || this.isTag(t, "h7")) {
            result = "";
        } else if (this.isTag(t, "/h1") || this.isTag(t, "/h2") || this.isTag(t, "/h3") || this.isTag(t, "/h4") || this.isTag(t, "/h5") || this.isTag(t, "/h6") || this.isTag(t, "/h7")) {
            result = "";
        } else if (this.isTag(t, "/dl")) {
            result = "";
        } else if (this.isTag(t, "dd")) {
            result = "  * ";
        } else if (this.isTag(t, "dt")) {
            result = "      ";
        } else if (this.isTag(t, "li")) {
            result = "  * ";
        } else if (this.isTag(t, "/ul")) {
            result = "";
        } else if (this.isTag(t, "/ol")) {
            result = "";
        } else if (this.isTag(t, "hr")) {
            result = "_________________________________________";
        } else if (this.isTag(t, "table")) {
            result = "";
        } else if (this.isTag(t, "/table")) {
            result = "";
        } else if (this.isTag(t, "form")) {
            result = "";
        } else if (this.isTag(t, "/form")) {
            result = "";
        } else if (this.isTag(t, "b")) {
            result = "";
        } else if (this.isTag(t, "/b")) {
            result = "";
        } else if (this.isTag(t, "i")) {
            result = "\"";
        } else if (this.isTag(t, "/i")) {
            result = "\"";
        } else if (this.isTag(t, "img")) {
            int idx = t.indexOf("alt=\"");
            if (idx != -1) {
                int idx2 = t.indexOf("\"", idx += 5);
                result = t.substring(idx, idx2);
            }
        } else if (this.isTag(t, "a")) {
            int idx = t.indexOf("href=\"");
            if (idx != -1) {
                int idx2 = t.indexOf("\"", idx += 6);
                this.href = t.substring(idx, idx2);
            } else {
                this.href = "";
            }
        } else if (this.isTag(t, "/a") && this.href.length() > 0) {
            result = " [ " + this.href + " ]";
            this.href = "";
        }
        return result;
    }

    private boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n';
    }

    private boolean isLetter(char ch) {
        return ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z';
    }

    private class StringReader
    extends Reader {
        private String str;
        private int length;
        private int next = 0;
        private int mark = 0;
        private final Object stringLock = new Object();

        public StringReader(String s) {
            this.str = s;
            this.length = s.length();
        }

        private void ensureOpen() throws IOException {
            if (this.str == null) {
                throw new IOException("Stream closed");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = this.stringLock;
            synchronized (object) {
                this.ensureOpen();
                if (this.next >= this.length) {
                    return -1;
                }
                return this.str.charAt(this.next++);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            Object object = this.stringLock;
            synchronized (object) {
                this.ensureOpen();
                if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return 0;
                }
                if (this.next >= this.length) {
                    return -1;
                }
                int n = Math.min(this.length - this.next, len);
                this.str.getChars(this.next, this.next + n, cbuf, off);
                this.next += n;
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long ns) throws IOException {
            Object object = this.stringLock;
            synchronized (object) {
                this.ensureOpen();
                if (this.next >= this.length) {
                    return 0L;
                }
                long n = Math.min((long)(this.length - this.next), ns);
                n = Math.max((long)(-this.next), n);
                this.next = (int)((long)this.next + n);
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean ready() throws IOException {
            Object object = this.stringLock;
            synchronized (object) {
                this.ensureOpen();
                return true;
            }
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mark(int readAheadLimit) throws IOException {
            if (readAheadLimit < 0) {
                throw new IllegalArgumentException("Read-ahead limit < 0");
            }
            Object object = this.stringLock;
            synchronized (object) {
                this.ensureOpen();
                this.mark = this.next;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() throws IOException {
            Object object = this.stringLock;
            synchronized (object) {
                this.ensureOpen();
                this.next = this.mark;
            }
        }

        @Override
        public void close() {
            this.str = null;
        }
    }
}

