/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.maps.tiled;

import com.guidebee.game.GameEngineRuntimeException;
import com.guidebee.game.engine.assets.AssetDescriptor;
import com.guidebee.game.engine.assets.AssetLoaderParameters;
import com.guidebee.game.engine.assets.AssetManager;
import com.guidebee.game.engine.assets.loaders.AsynchronousAssetLoader;
import com.guidebee.game.engine.assets.loaders.FileHandleResolver;
import com.guidebee.game.engine.assets.loaders.resolvers.InternalFileHandleResolver;
import com.guidebee.game.files.FileHandle;
import com.guidebee.game.graphics.Texture;
import com.guidebee.game.graphics.TextureAtlas;
import com.guidebee.game.maps.MapLayer;
import com.guidebee.game.maps.MapObject;
import com.guidebee.game.maps.MapProperties;
import com.guidebee.game.maps.objects.EllipseMapObject;
import com.guidebee.game.maps.objects.PolygonMapObject;
import com.guidebee.game.maps.objects.PolylineMapObject;
import com.guidebee.game.maps.objects.RectangleMapObject;
import com.guidebee.game.maps.tiled.TiledMap;
import com.guidebee.game.maps.tiled.TiledMapTile;
import com.guidebee.game.maps.tiled.TiledMapTileLayer;
import com.guidebee.game.maps.tiled.TiledMapTileSet;
import com.guidebee.game.maps.tiled.TiledMapTileSets;
import com.guidebee.game.maps.tiled.TmxMapHelper;
import com.guidebee.game.maps.tiled.tiles.StaticTiledMapTile;
import com.guidebee.math.geometry.Polygon;
import com.guidebee.math.geometry.Polyline;
import com.guidebee.utils.XmlReader;
import com.guidebee.utils.collections.Array;
import com.guidebee.utils.collections.ObjectMap;
import java.io.IOException;
import java.util.StringTokenizer;

public class AtlasTmxMapLoader
extends AsynchronousAssetLoader<TiledMap, AtlasTiledMapLoaderParameters> {
    protected static final int FLAG_FLIP_HORIZONTALLY = Integer.MIN_VALUE;
    protected static final int FLAG_FLIP_VERTICALLY = 0x40000000;
    protected static final int FLAG_FLIP_DIAGONALLY = 0x20000000;
    protected static final int MASK_CLEAR = -536870912;
    protected XmlReader xml = new XmlReader();
    protected XmlReader.Element root;
    protected boolean convertObjectToTileSpace;
    protected int mapTileWidth;
    protected int mapTileHeight;
    protected int mapWidthInPixels;
    protected int mapHeightInPixels;
    protected TiledMap map;
    protected Array<Texture> trackedTextures = new Array();

    public AtlasTmxMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public AtlasTmxMapLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public TiledMap load(String fileName) {
        return this.load(fileName, new AtlasTiledMapLoaderParameters());
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle tmxFile, AtlasTiledMapLoaderParameters parameter) {
        Array<AssetDescriptor> dependencies = new Array<AssetDescriptor>();
        try {
            this.root = this.xml.parse(tmxFile);
            XmlReader.Element properties = this.root.getChildByName("properties");
            if (properties != null) {
                for (XmlReader.Element property : properties.getChildrenByName("property")) {
                    String name = property.getAttribute("name");
                    String value = property.getAttribute("value");
                    if (!name.startsWith("atlas")) continue;
                    FileHandle atlasHandle = AtlasTmxMapLoader.getRelativeFileHandle(tmxFile, value);
                    dependencies.add(new AssetDescriptor<TextureAtlas>(atlasHandle, TextureAtlas.class));
                }
            }
        }
        catch (IOException e) {
            throw new GameEngineRuntimeException("Unable to parse .tmx file.");
        }
        return dependencies;
    }

    public TiledMap load(String fileName, AtlasTiledMapLoaderParameters parameter) {
        try {
            this.convertObjectToTileSpace = parameter != null ? parameter.convertObjectToTileSpace : false;
            FileHandle tmxFile = this.resolve(fileName);
            this.root = this.xml.parse(tmxFile);
            ObjectMap<String, TextureAtlas> atlases = new ObjectMap<String, TextureAtlas>();
            FileHandle atlasFile = this.loadAtlas(this.root, tmxFile);
            if (atlasFile == null) {
                throw new GameEngineRuntimeException("Couldn't load atlas");
            }
            TextureAtlas atlas = new TextureAtlas(atlasFile);
            atlases.put(atlasFile.path(), atlas);
            AtlasResolver.DirectAtlasResolver atlasResolver = new AtlasResolver.DirectAtlasResolver(atlases);
            TiledMap map = this.loadMap(this.root, tmxFile, atlasResolver, parameter);
            map.setOwnedResources(atlases.values().toArray());
            this.setTextureFilters(parameter.textureMinFilter, parameter.textureMagFilter);
            return map;
        }
        catch (IOException e) {
            throw new GameEngineRuntimeException("Couldn't load tilemap '" + fileName + "'", e);
        }
    }

    protected FileHandle loadAtlas(XmlReader.Element root, FileHandle tmxFile) throws IOException {
        XmlReader.Element e = root.getChildByName("properties");
        if (e != null) {
            for (XmlReader.Element property : e.getChildrenByName("property")) {
                String name = property.getAttribute("name", null);
                String value = property.getAttribute("value", null);
                if (!name.equals("atlas")) continue;
                if (value == null) {
                    value = property.getText();
                }
                if (value == null || value.length() == 0) continue;
                return AtlasTmxMapLoader.getRelativeFileHandle(tmxFile, value);
            }
        } else {
            FileHandle atlasFile = tmxFile.sibling(tmxFile.nameWithoutExtension() + ".atlas");
            return atlasFile.exists() ? atlasFile : null;
        }
        return null;
    }

    private void setTextureFilters(Texture.TextureFilter min, Texture.TextureFilter mag) {
        for (Texture texture : this.trackedTextures) {
            texture.setFilter(min, mag);
        }
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle tmxFile, AtlasTiledMapLoaderParameters parameter) {
        this.map = null;
        this.convertObjectToTileSpace = parameter != null ? parameter.convertObjectToTileSpace : false;
        try {
            this.map = this.loadMap(this.root, tmxFile, new AtlasResolver.AssetManagerAtlasResolver(manager), parameter);
        }
        catch (Exception e) {
            throw new GameEngineRuntimeException("Couldn't load tilemap '" + fileName + "'", e);
        }
    }

    @Override
    public TiledMap loadSync(AssetManager manager, String fileName, FileHandle file, AtlasTiledMapLoaderParameters parameter) {
        if (parameter != null) {
            this.setTextureFilters(parameter.textureMinFilter, parameter.textureMagFilter);
        }
        return this.map;
    }

    protected TiledMap loadMap(XmlReader.Element root, FileHandle tmxFile, AtlasResolver resolver, AtlasTiledMapLoaderParameters parameter) {
        TiledMap map = new TiledMap();
        String mapOrientation = root.getAttribute("orientation", null);
        int mapWidth = root.getIntAttribute("width", 0);
        int mapHeight = root.getIntAttribute("height", 0);
        int tileWidth = root.getIntAttribute("tilewidth", 0);
        int tileHeight = root.getIntAttribute("tileheight", 0);
        String mapBackgroundColor = root.getAttribute("backgroundcolor", null);
        MapProperties mapProperties = map.getProperties();
        if (mapOrientation != null) {
            mapProperties.put("orientation", mapOrientation);
        }
        mapProperties.put("width", mapWidth);
        mapProperties.put("height", mapHeight);
        mapProperties.put("tilewidth", tileWidth);
        mapProperties.put("tileheight", tileHeight);
        if (mapBackgroundColor != null) {
            mapProperties.put("backgroundcolor", mapBackgroundColor);
        }
        this.mapTileWidth = tileWidth;
        this.mapTileHeight = tileHeight;
        this.mapWidthInPixels = mapWidth * tileWidth;
        this.mapHeightInPixels = mapHeight * tileHeight;
        int j = root.getChildCount();
        for (int i = 0; i < j; ++i) {
            XmlReader.Element element = root.getChild(i);
            String elementName = element.getName();
            if (elementName.equals("properties")) {
                this.loadProperties(map.getProperties(), element);
                continue;
            }
            if (elementName.equals("tileset")) {
                this.loadTileset(map, element, tmxFile, resolver, parameter);
                continue;
            }
            if (elementName.equals("layer")) {
                this.loadTileLayer(map, element);
                continue;
            }
            if (!elementName.equals("objectgroup")) continue;
            this.loadObjectGroup(map, element);
        }
        return map;
    }

    protected void loadTileset(TiledMap map, XmlReader.Element element, FileHandle tmxFile, AtlasResolver resolver, AtlasTiledMapLoaderParameters parameter) {
        if (element.getName().equals("tileset")) {
            FileHandle atlasFile;
            String atlasFilePath;
            String name = element.get("name", null);
            int firstgid = element.getIntAttribute("firstgid", 1);
            int tilewidth = element.getIntAttribute("tilewidth", 0);
            int tileheight = element.getIntAttribute("tileheight", 0);
            int spacing = element.getIntAttribute("spacing", 0);
            int margin = element.getIntAttribute("margin", 0);
            String source = element.getAttribute("source", null);
            int offsetX = 0;
            int offsetY = 0;
            String imageSource = "";
            int imageWidth = 0;
            int imageHeight = 0;
            Object image = null;
            if (source != null) {
                FileHandle tsx = AtlasTmxMapLoader.getRelativeFileHandle(tmxFile, source);
                try {
                    element = this.xml.parse(tsx);
                    name = element.get("name", null);
                    tilewidth = element.getIntAttribute("tilewidth", 0);
                    tileheight = element.getIntAttribute("tileheight", 0);
                    spacing = element.getIntAttribute("spacing", 0);
                    margin = element.getIntAttribute("margin", 0);
                    XmlReader.Element offset = element.getChildByName("tileoffset");
                    if (offset != null) {
                        offsetX = offset.getIntAttribute("x", 0);
                        offsetY = offset.getIntAttribute("y", 0);
                    }
                    XmlReader.Element imageElement = element.getChildByName("image");
                    imageSource = imageElement.getAttribute("source");
                    imageWidth = imageElement.getIntAttribute("width", 0);
                    imageHeight = imageElement.getIntAttribute("height", 0);
                }
                catch (IOException e) {
                    throw new GameEngineRuntimeException("Error parsing external tileset.");
                }
            } else {
                XmlReader.Element imageElement;
                XmlReader.Element offset = element.getChildByName("tileoffset");
                if (offset != null) {
                    offsetX = offset.getIntAttribute("x", 0);
                    offsetY = offset.getIntAttribute("y", 0);
                }
                if ((imageElement = element.getChildByName("image")) != null) {
                    imageSource = imageElement.getAttribute("source");
                    imageWidth = imageElement.getIntAttribute("width", 0);
                    imageHeight = imageElement.getIntAttribute("height", 0);
                }
            }
            if ((atlasFilePath = map.getProperties().get("atlas", String.class)) == null && (atlasFile = tmxFile.sibling(tmxFile.nameWithoutExtension() + ".atlas")).exists()) {
                atlasFilePath = atlasFile.name();
            }
            if (atlasFilePath == null) {
                throw new GameEngineRuntimeException("The map is missing the 'atlas' property");
            }
            FileHandle atlasHandle = AtlasTmxMapLoader.getRelativeFileHandle(tmxFile, atlasFilePath);
            atlasHandle = this.resolve(atlasHandle.path());
            TextureAtlas atlas = resolver.getAtlas(atlasHandle.path());
            String regionsName = atlasHandle.nameWithoutExtension();
            if (parameter != null && parameter.forceTextureFilters) {
                for (Texture texture : atlas.getTextures()) {
                    this.trackedTextures.add(texture);
                }
            }
            TiledMapTileSet tileset = new TiledMapTileSet();
            MapProperties props = tileset.getProperties();
            tileset.setName(name);
            props.put("firstgid", firstgid);
            props.put("imagesource", imageSource);
            props.put("imagewidth", imageWidth);
            props.put("imageheight", imageHeight);
            props.put("tilewidth", tilewidth);
            props.put("tileheight", tileheight);
            props.put("margin", margin);
            props.put("spacing", spacing);
            for (TextureAtlas.AtlasRegion region : atlas.findRegions(regionsName)) {
                if (region == null) continue;
                StaticTiledMapTile tile = new StaticTiledMapTile(region);
                int tileid = firstgid + region.index;
                tile.setId(tileid);
                tile.setOffsetX(offsetX);
                tile.setOffsetY(-offsetY);
                tileset.putTile(tileid, tile);
            }
            for (XmlReader.Element tileElement : element.getChildrenByName("tile")) {
                XmlReader.Element properties;
                String probability;
                XmlReader.Element imageElement;
                int tileid = firstgid + tileElement.getIntAttribute("id", 0);
                TiledMapTile tile = tileset.getTile(tileid);
                if (tile == null && (imageElement = tileElement.getChildByName("image")) != null) {
                    String regionName = imageElement.getAttribute("source");
                    TextureAtlas.AtlasRegion region = atlas.findRegion(regionName = regionName.substring(0, regionName.lastIndexOf(46)));
                    if (region == null) {
                        throw new GameEngineRuntimeException("Tileset region not found: " + regionName);
                    }
                    tile = new StaticTiledMapTile(region);
                    tile.setId(tileid);
                    tile.setOffsetX(offsetX);
                    tile.setOffsetY(-offsetY);
                    tileset.putTile(tileid, tile);
                }
                if (tile == null) continue;
                String terrain = tileElement.getAttribute("terrain", null);
                if (terrain != null) {
                    tile.getProperties().put("terrain", terrain);
                }
                if ((probability = tileElement.getAttribute("probability", null)) != null) {
                    tile.getProperties().put("probability", probability);
                }
                if ((properties = tileElement.getChildByName("properties")) == null) continue;
                this.loadProperties(tile.getProperties(), properties);
            }
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                this.loadProperties(tileset.getProperties(), properties);
            }
            map.getTileSets().addTileSet(tileset);
        }
    }

    protected void loadTileLayer(TiledMap map, XmlReader.Element element) {
        if (element.getName().equals("layer")) {
            String name = element.getAttribute("name", null);
            int width = element.getIntAttribute("width", 0);
            int height = element.getIntAttribute("height", 0);
            int tileWidth = element.getParent().getIntAttribute("tilewidth", 0);
            int tileHeight = element.getParent().getIntAttribute("tileheight", 0);
            boolean visible = element.getIntAttribute("visible", 1) == 1;
            float opacity = element.getFloatAttribute("opacity", 1.0f);
            TiledMapTileLayer layer = new TiledMapTileLayer(width, height, tileWidth, tileHeight);
            layer.setVisible(visible);
            layer.setOpacity(opacity);
            layer.setName(name);
            int[] ids = TmxMapHelper.getTileIds(element, width, height);
            TiledMapTileSets tilesets = map.getTileSets();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    int id = ids[y * width + x];
                    boolean flipHorizontally = (id & Integer.MIN_VALUE) != 0;
                    boolean flipVertically = (id & 0x40000000) != 0;
                    boolean flipDiagonally = (id & 0x20000000) != 0;
                    TiledMapTile tile = tilesets.getTile(id & 0x1FFFFFFF);
                    if (tile == null) continue;
                    TiledMapTileLayer.Cell cell = this.createTileLayerCell(flipHorizontally, flipVertically, flipDiagonally);
                    cell.setTile(tile);
                    layer.setCell(x, height - 1 - y, cell);
                }
            }
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                this.loadProperties(layer.getProperties(), properties);
            }
            map.getLayers().add(layer);
        }
    }

    protected void loadObjectGroup(TiledMap map, XmlReader.Element element) {
        if (element.getName().equals("objectgroup")) {
            String name = element.getAttribute("name", null);
            MapLayer layer = new MapLayer();
            layer.setName(name);
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                this.loadProperties(layer.getProperties(), properties);
            }
            for (XmlReader.Element objectElement : element.getChildrenByName("object")) {
                this.loadObject(layer, objectElement);
            }
            map.getLayers().add(layer);
        }
    }

    protected void loadObject(MapLayer layer, XmlReader.Element element) {
        if (element.getName().equals("object")) {
            int gid;
            String type;
            MapObject object = null;
            float scaleX = this.convertObjectToTileSpace ? 1.0f / (float)this.mapTileWidth : 1.0f;
            float scaleY = this.convertObjectToTileSpace ? 1.0f / (float)this.mapTileHeight : 1.0f;
            float x = element.getFloatAttribute("x", 0.0f) * scaleX;
            float y = ((float)this.mapHeightInPixels - element.getFloatAttribute("y", 0.0f)) * scaleY;
            float width = element.getFloatAttribute("width", 0.0f) * scaleX;
            float height = element.getFloatAttribute("height", 0.0f) * scaleY;
            if (element.getChildCount() > 0) {
                float[] vertices;
                String[] points;
                XmlReader.Element child = null;
                child = element.getChildByName("polygon");
                if (child != null) {
                    points = child.getAttribute("points").split(" ");
                    vertices = new float[points.length * 2];
                    for (int i = 0; i < points.length; ++i) {
                        String[] point = points[i].split(",");
                        vertices[i * 2] = Float.parseFloat(point[0]) * scaleX;
                        vertices[i * 2 + 1] = -Float.parseFloat(point[1]) * scaleY;
                    }
                    Polygon polygon = new Polygon(vertices);
                    polygon.setPosition(x, y);
                    object = new PolygonMapObject(polygon);
                } else {
                    child = element.getChildByName("polyline");
                    if (child != null) {
                        points = child.getAttribute("points").split(" ");
                        vertices = new float[points.length * 2];
                        for (int i = 0; i < points.length; ++i) {
                            String[] point = points[i].split(",");
                            vertices[i * 2] = Float.parseFloat(point[0]) * scaleX;
                            vertices[i * 2 + 1] = -Float.parseFloat(point[1]) * scaleY;
                        }
                        Polyline polyline = new Polyline(vertices);
                        polyline.setPosition(x, y);
                        object = new PolylineMapObject(polyline);
                    } else {
                        child = element.getChildByName("ellipse");
                        if (child != null) {
                            object = new EllipseMapObject(x, y - height, width, height);
                        }
                    }
                }
            }
            if (object == null) {
                object = new RectangleMapObject(x, y - height, width, height);
            }
            object.setName(element.getAttribute("name", null));
            String rotation = element.getAttribute("rotation", null);
            if (rotation != null) {
                object.getProperties().put("rotation", Float.valueOf(Float.parseFloat(rotation)));
            }
            if ((type = element.getAttribute("type", null)) != null) {
                object.getProperties().put("type", type);
            }
            if ((gid = element.getIntAttribute("gid", -1)) != -1) {
                object.getProperties().put("gid", gid);
            }
            object.getProperties().put("x", Float.valueOf(x * scaleX));
            object.getProperties().put("y", Float.valueOf((y - height) * scaleY));
            object.setVisible(element.getIntAttribute("visible", 1) == 1);
            XmlReader.Element properties = element.getChildByName("properties");
            if (properties != null) {
                this.loadProperties(object.getProperties(), properties);
            }
            layer.getObjects().add(object);
        }
    }

    protected void loadProperties(MapProperties properties, XmlReader.Element element) {
        if (element.getName().equals("properties")) {
            for (XmlReader.Element property : element.getChildrenByName("property")) {
                String name = property.getAttribute("name", null);
                String value = property.getAttribute("value", null);
                if (value == null) {
                    value = property.getText();
                }
                properties.put(name, value);
            }
        }
    }

    protected TiledMapTileLayer.Cell createTileLayerCell(boolean flipHorizontally, boolean flipVertically, boolean flipDiagonally) {
        TiledMapTileLayer.Cell cell = new TiledMapTileLayer.Cell();
        if (flipDiagonally) {
            if (flipHorizontally && flipVertically) {
                cell.setFlipHorizontally(true);
                cell.setRotation(3);
            } else if (flipHorizontally) {
                cell.setRotation(3);
            } else if (flipVertically) {
                cell.setRotation(1);
            } else {
                cell.setFlipVertically(true);
                cell.setRotation(3);
            }
        } else {
            cell.setFlipHorizontally(flipHorizontally);
            cell.setFlipVertically(flipVertically);
        }
        return cell;
    }

    public static FileHandle getRelativeFileHandle(FileHandle file, String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, "\\/");
        FileHandle result = file.parent();
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            if (token.equals("..")) {
                result = result.parent();
                continue;
            }
            result = result.child(token);
        }
        return result;
    }

    private static interface AtlasResolver {
        public TextureAtlas getAtlas(String var1);

        public static class AssetManagerAtlasResolver
        implements AtlasResolver {
            private final AssetManager assetManager;

            public AssetManagerAtlasResolver(AssetManager assetManager) {
                this.assetManager = assetManager;
            }

            @Override
            public TextureAtlas getAtlas(String name) {
                return this.assetManager.get(name, TextureAtlas.class);
            }
        }

        public static class DirectAtlasResolver
        implements AtlasResolver {
            private final ObjectMap<String, TextureAtlas> atlases;

            public DirectAtlasResolver(ObjectMap<String, TextureAtlas> atlases) {
                this.atlases = atlases;
            }

            @Override
            public TextureAtlas getAtlas(String name) {
                return this.atlases.get(name);
            }
        }
    }

    public static class AtlasTiledMapLoaderParameters
    extends AssetLoaderParameters<TiledMap> {
        public boolean forceTextureFilters = false;
        public Texture.TextureFilter textureMinFilter = Texture.TextureFilter.Nearest;
        public Texture.TextureFilter textureMagFilter = Texture.TextureFilter.Nearest;
        public boolean convertObjectToTileSpace = false;
    }
}

