/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.graphics.opengles;

import com.guidebee.game.GameEngineRuntimeException;
import com.guidebee.game.engine.graphics.GLTexture;
import com.guidebee.game.graphics.Pixmap;
import com.guidebee.game.graphics.TextureData;

public class MipMapTextureData
implements TextureData {
    TextureData[] mips;

    public MipMapTextureData(TextureData ... mipMapData) {
        this.mips = new TextureData[mipMapData.length];
        System.arraycopy(mipMapData, 0, this.mips, 0, mipMapData.length);
    }

    @Override
    public TextureData.TextureDataType getType() {
        return TextureData.TextureDataType.Custom;
    }

    @Override
    public boolean isPrepared() {
        return true;
    }

    @Override
    public void prepare() {
    }

    @Override
    public Pixmap consumePixmap() {
        throw new GameEngineRuntimeException("It's compressed, use the compressed method");
    }

    @Override
    public boolean disposePixmap() {
        return false;
    }

    @Override
    public void consumeCustomData(int target) {
        for (int i = 0; i < this.mips.length; ++i) {
            GLTexture.uploadImageData(target, this.mips[i], i);
        }
    }

    @Override
    public int getWidth() {
        return this.mips[0].getWidth();
    }

    @Override
    public int getHeight() {
        return this.mips[0].getHeight();
    }

    @Override
    public Pixmap.Format getFormat() {
        return this.mips[0].getFormat();
    }

    @Override
    public boolean useMipMaps() {
        return false;
    }

    @Override
    public boolean isManaged() {
        return true;
    }
}

