/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.graphics.opengles;

import com.guidebee.game.GameEngine;
import com.guidebee.game.GameEngineRuntimeException;
import com.guidebee.game.graphics.Pixmap;
import com.guidebee.game.graphics.TextureData;
import com.guidebee.utils.collections.BufferUtils;
import java.nio.FloatBuffer;

public class FloatTextureData
implements TextureData {
    int width = 0;
    int height = 0;
    boolean isPrepared = false;
    FloatBuffer buffer;

    public FloatTextureData(int w, int h) {
        this.width = w;
        this.height = h;
    }

    @Override
    public TextureData.TextureDataType getType() {
        return TextureData.TextureDataType.Custom;
    }

    @Override
    public boolean isPrepared() {
        return this.isPrepared;
    }

    @Override
    public void prepare() {
        if (this.isPrepared) {
            throw new GameEngineRuntimeException("Already prepared");
        }
        this.buffer = BufferUtils.newFloatBuffer(this.width * this.height * 4);
        this.isPrepared = true;
    }

    @Override
    public void consumeCustomData(int target) {
        if (!GameEngine.graphics.supportsExtension("texture_float")) {
            throw new GameEngineRuntimeException("Extension OES_TEXTURE_FLOAT not supported!");
        }
        int GL_RGBA32F = 34836;
        GameEngine.gl.glTexImage2D(target, 0, 6408, this.width, this.height, 0, 6408, 5126, this.buffer);
    }

    @Override
    public Pixmap consumePixmap() {
        throw new GameEngineRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    @Override
    public boolean disposePixmap() {
        throw new GameEngineRuntimeException("This TextureData implementation does not return a Pixmap");
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Pixmap.Format getFormat() {
        return Pixmap.Format.RGBA8888;
    }

    @Override
    public boolean useMipMaps() {
        return false;
    }

    @Override
    public boolean isManaged() {
        return true;
    }
}

