/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

import com.guidebee.game.engine.drawing.core.BrushFP;
import com.guidebee.game.engine.drawing.core.PointFP;

public final class TextureBrushFP
extends BrushFP {
    private int width = 1;
    private int height = 1;
    private int[] textureBuffer = null;
    private final PointFP nextPt = new PointFP(0, 0);

    @Override
    public boolean isMonoColor() {
        return false;
    }

    public TextureBrushFP(int[] image, int width, int height) {
        this.textureBuffer = new int[image.length];
        System.arraycopy(image, 0, this.textureBuffer, 0, this.textureBuffer.length);
        this.width = width;
        this.height = height;
    }

    @Override
    public int getColorAt(int x, int y, boolean singlePoint) {
        PointFP p = new PointFP(x << 16, y << 16);
        this.nextPt.x = p.x + 65536;
        this.nextPt.y = p.y;
        if (this.finalMatrix != null) {
            p.transform(this.finalMatrix);
        }
        int xPos = (p.x >> 16) % this.width;
        int yPos = (p.y >> 16) % this.height;
        if (xPos < 0) {
            xPos += this.width;
        }
        if (yPos < 0) {
            yPos += this.height;
        }
        return this.textureBuffer[xPos + yPos * this.width];
    }

    @Override
    public int getNextColor() {
        PointFP p = new PointFP(this.nextPt);
        this.nextPt.x += 65536;
        this.nextPt.y = p.y;
        if (this.finalMatrix != null) {
            p.transform(this.finalMatrix);
        }
        int xPos = (p.x >> 16) % this.width;
        int yPos = (p.y >> 16) % this.height;
        if (xPos < 0) {
            xPos += this.width;
        }
        if (yPos < 0) {
            yPos += this.height;
        }
        return this.textureBuffer[xPos + yPos * this.width];
    }
}

