/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

import com.guidebee.game.engine.drawing.core.MathFP;
import com.guidebee.game.engine.drawing.core.PointFP;
import com.guidebee.game.engine.drawing.core.SingleFP;

public class RectangleFP {
    public static final RectangleFP EMPTY = new RectangleFP();
    private int ff_xmin;
    private int ff_xmax;
    private int ff_ymin;
    private int ff_ymax;

    public int getBottom() {
        return this.ff_ymax;
    }

    public int getTop() {
        return this.ff_ymin;
    }

    public int getLeft() {
        return this.ff_xmin;
    }

    public int getRight() {
        return this.ff_xmax;
    }

    public int getWidth() {
        return this.ff_xmax - this.ff_xmin;
    }

    public void setWidth(int value) {
        if (value < 0) {
            return;
        }
        this.ff_xmax = this.ff_xmin + value;
    }

    public int getHeight() {
        return this.ff_ymax - this.ff_ymin;
    }

    public void setHeight(int value) {
        if (value < 0) {
            return;
        }
        this.ff_ymax = this.ff_ymin + value;
    }

    public int getX() {
        return this.ff_xmin;
    }

    public void setX(int value) {
        this.ff_xmin = value;
    }

    public int getY() {
        return this.ff_ymin;
    }

    public void setY(int value) {
        this.ff_ymin = value;
    }

    public RectangleFP() {
        this.ff_ymax = -2147483647;
        this.ff_ymin = -2147483647;
        this.ff_xmax = -2147483647;
        this.ff_xmin = -2147483647;
    }

    public RectangleFP(RectangleFP r) {
        this.reset(r);
    }

    public RectangleFP(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax) {
        this.reset(ff_xmin, ff_ymin, ff_xmax, ff_ymax);
    }

    public RectangleFP reset(int ff_xmin, int ff_ymin, int ff_xmax, int ff_ymax) {
        this.ff_xmin = MathFP.min(ff_xmin, ff_xmax);
        this.ff_xmax = MathFP.max(ff_xmin, ff_xmax);
        this.ff_ymin = MathFP.min(ff_ymin, ff_ymax);
        this.ff_ymax = MathFP.max(ff_ymin, ff_ymax);
        return this;
    }

    public RectangleFP reset(RectangleFP r) {
        return this.reset(r.ff_xmin, r.ff_ymin, r.ff_xmax, r.ff_ymax);
    }

    public boolean isEmpty() {
        return this.ff_xmin == -2147483647 || this.ff_xmax == -2147483647 || this.ff_ymin == -2147483647 || this.ff_ymax == -2147483647;
    }

    public void offset(int ff_dx, int ff_dy) {
        if (!this.isEmpty()) {
            this.ff_xmin += ff_dx;
            this.ff_xmax += ff_dx;
            this.ff_ymin += ff_dy;
            this.ff_ymax += ff_dy;
        }
    }

    public RectangleFP union(RectangleFP r) {
        if (!r.isEmpty()) {
            if (this.isEmpty()) {
                this.reset(r);
            } else {
                this.reset(MathFP.min(this.ff_xmin, r.ff_xmin), MathFP.max(this.ff_xmax, r.ff_xmax), MathFP.min(this.ff_ymin, r.ff_ymin), MathFP.max(this.ff_ymax, r.ff_ymax));
            }
        }
        return this;
    }

    public RectangleFP union(PointFP p) {
        if (!this.isEmpty()) {
            this.reset(MathFP.min(this.ff_xmin, p.x), MathFP.max(this.ff_xmax, p.x), MathFP.min(this.ff_ymin, p.y), MathFP.max(this.ff_ymax, p.y));
        }
        return this;
    }

    public boolean intersectsWith(RectangleFP r) {
        return this.ff_xmin <= r.ff_xmax && r.ff_xmin <= this.ff_xmax && this.ff_ymin <= r.ff_ymax && r.ff_ymin <= this.ff_ymax;
    }

    public boolean contains(PointFP p) {
        return this.ff_xmin <= p.x && p.x <= this.ff_xmax && this.ff_ymin <= p.y && p.y <= this.ff_ymax;
    }

    public boolean equals(Object o) {
        if (o instanceof RectangleFP) {
            RectangleFP r = (RectangleFP)o;
            if (r == null) {
                return false;
            }
            return r.ff_xmax == this.ff_xmax && r.ff_xmin == this.ff_xmin && r.ff_ymax == this.ff_ymax && r.ff_ymin == this.ff_ymin;
        }
        return false;
    }

    public int hashCode() {
        int bits = this.ff_xmin & -65536 + this.ff_ymin & 0xFFFF;
        return bits;
    }

    public String toString() {
        return "Rectangle (" + new SingleFP(this.ff_xmin) + "," + new SingleFP(this.ff_ymin) + ")-(" + new SingleFP(this.ff_xmax) + "," + new SingleFP(this.ff_ymax) + ")";
    }
}

