/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

import com.guidebee.game.engine.drawing.core.MathFP;
import com.guidebee.game.engine.drawing.core.MatrixFP;
import com.guidebee.game.engine.drawing.core.SingleFP;

public class PointFP {
    public int x = 0;
    public int y = 0;
    public static final PointFP ORIGIN = new PointFP(0, 0);
    public static final PointFP EMPTY = new PointFP(-2147483647, -2147483647);

    public PointFP() {
    }

    public PointFP(PointFP p) {
        this.reset(p);
    }

    public PointFP(int ff_x, int ff_y) {
        this.reset(ff_x, ff_y);
    }

    public static boolean isEmpty(PointFP p) {
        return EMPTY.equals(p);
    }

    public PointFP reset(PointFP p) {
        return this.reset(p.x, p.y);
    }

    public PointFP reset(int ff_x, int ff_y) {
        this.x = ff_x;
        this.y = ff_y;
        return this;
    }

    public PointFP transform(MatrixFP m) {
        this.reset(MathFP.mul(this.x, m.scaleX) + MathFP.mul(this.y, m.rotateY) + m.translateX, MathFP.mul(this.y, m.scaleY) + MathFP.mul(this.x, m.rotateX) + m.translateY);
        return this;
    }

    public static int distance(PointFP p1, PointFP p2) {
        return PointFP.distance(p1.x - p2.x, p1.y - p2.y);
    }

    public static int distance(int dx, int dy) {
        dx = MathFP.abs(dx);
        dy = MathFP.abs(dy);
        if (dx == 0) {
            return dy;
        }
        if (dy == 0) {
            return dx;
        }
        long len = ((long)dx * (long)dx >> 16) + ((long)dy * (long)dy >> 16);
        long s = dx + dy - (MathFP.min(dx, dy) >> 1);
        s = s + (len << 16) / s >> 1;
        s = s + (len << 16) / s >> 1;
        return (int)s;
    }

    public PointFP add(PointFP p) {
        this.reset(this.x + p.x, this.y + p.y);
        return this;
    }

    public PointFP sub(PointFP p) {
        this.reset(this.x - p.x, this.y - p.y);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PointFP) {
            PointFP p = (PointFP)obj;
            if (p != null) {
                return this.x == p.x && this.y == p.y;
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        int bits = this.x << 16 & 0xFFFF0000;
        return bits ^= this.y;
    }

    public String toString() {
        return "Point(" + new SingleFP(this.x) + "," + new SingleFP(this.y) + ")";
    }
}

