/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

import com.guidebee.game.engine.drawing.core.MathFP;
import com.guidebee.game.engine.drawing.core.SingleFP;

public class MatrixFP {
    public int scaleX = 0;
    public int scaleY = 0;
    public int rotateX = 0;
    public int rotateY = 0;
    public int translateX = 0;
    public int translateY = 0;
    public static MatrixFP IDENTITY = new MatrixFP(65536, 65536, 0, 0, 0, 0);

    public MatrixFP() {
        this.scaleY = 65536;
        this.scaleX = 65536;
    }

    public MatrixFP(int ff_sx, int ff_sy, int ff_rx, int ff_ry, int ff_tx, int ff_ty) {
        this.reset(ff_sx, ff_sy, ff_rx, ff_ry, ff_tx, ff_ty);
    }

    public MatrixFP(MatrixFP m) {
        this.reset(m.scaleX, m.scaleY, m.rotateX, m.rotateY, m.translateX, m.translateY);
    }

    public void reset() {
        this.reset(65536, 65536, 0, 0, 0, 0);
    }

    public boolean isIdentity() {
        return this.scaleX == 65536 && this.scaleY == 65536 && this.rotateX == 0 && this.rotateY == 0 && this.translateX == 0 && this.translateY == 0;
    }

    public boolean isInvertible() {
        return this.determinant() != 0;
    }

    public void reset(int ff_sx, int ff_sy, int ff_rx, int ff_ry, int ff_tx, int ff_ty) {
        this.scaleX = ff_sx;
        this.scaleY = ff_sy;
        this.rotateX = ff_rx;
        this.rotateY = ff_ry;
        this.translateX = ff_tx;
        this.translateY = ff_ty;
    }

    public MatrixFP rotate(int ff_ang) {
        int ff_sin = MathFP.sin(ff_ang);
        int ff_cos = MathFP.cos(ff_ang);
        return this.multiply(new MatrixFP(ff_cos, ff_cos, ff_sin, -ff_sin, 0, 0));
    }

    public MatrixFP rotateSkew(int ff_rx, int ff_ry) {
        return this.multiply(new MatrixFP(65536, 65536, ff_rx, ff_ry, 0, 0));
    }

    public MatrixFP translate(int ff_dx, int ff_dy) {
        this.translateX += ff_dx;
        this.translateY += ff_dy;
        return this;
    }

    public MatrixFP scale(int ff_sx, int ff_sy) {
        this.reset(MathFP.mul(ff_sx, this.scaleX), MathFP.mul(ff_sy, this.scaleY), MathFP.mul(ff_sy, this.rotateX), MathFP.mul(ff_sx, this.rotateY), MathFP.mul(ff_sx, this.translateX), MathFP.mul(ff_sy, this.translateY));
        return this;
    }

    public MatrixFP multiply(MatrixFP m) {
        this.reset(MathFP.mul(m.scaleX, this.scaleX) + MathFP.mul(m.rotateY, this.rotateX), MathFP.mul(m.rotateX, this.rotateY) + MathFP.mul(m.scaleY, this.scaleY), MathFP.mul(m.rotateX, this.scaleX) + MathFP.mul(m.scaleY, this.rotateX), MathFP.mul(m.scaleX, this.rotateY) + MathFP.mul(m.rotateY, this.scaleY), MathFP.mul(m.scaleX, this.translateX) + MathFP.mul(m.rotateY, this.translateY) + m.translateX, MathFP.mul(m.rotateX, this.translateX) + MathFP.mul(m.scaleY, this.translateY) + m.translateY);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MatrixFP) {
            MatrixFP m = (MatrixFP)obj;
            return m != null && m.rotateX == this.rotateX && m.rotateY == this.rotateY && m.scaleX == this.scaleX && m.scaleY == this.scaleY && m.translateX == this.translateX && m.translateY == this.translateY;
        }
        return false;
    }

    public int hashCode() {
        return this.rotateX << 24 + this.rotateY << 20 + this.scaleX << 16 + this.scaleY << 8 + this.translateX << 4 + this.translateY;
    }

    private int determinant() {
        int ff_det = MathFP.mul(this.scaleX, this.scaleY) - MathFP.mul(this.rotateX, this.rotateY);
        return ff_det;
    }

    public MatrixFP invert() {
        int ff_det = this.determinant();
        if (ff_det == 0) {
            this.reset();
        } else {
            int ff_sx_new = MathFP.div(this.scaleY, ff_det);
            int ff_sy_new = MathFP.div(this.scaleX, ff_det);
            int ff_rx_new = -MathFP.div(this.rotateX, ff_det);
            int ff_ry_new = -MathFP.div(this.rotateY, ff_det);
            int ff_tx_new = MathFP.div(MathFP.mul(this.translateY, this.rotateY) - MathFP.mul(this.translateX, this.scaleY), ff_det);
            int ff_ty_new = -MathFP.div(MathFP.mul(this.translateY, this.scaleX) - MathFP.mul(this.translateX, this.rotateX), ff_det);
            this.reset(ff_sx_new, ff_sy_new, ff_rx_new, ff_ry_new, ff_tx_new, ff_ty_new);
        }
        return this;
    }

    public String toString() {
        return " Matrix(sx,sy,rx,ry,tx,ty)=(" + new SingleFP(this.scaleX) + "," + new SingleFP(this.scaleY) + "," + new SingleFP(this.rotateX) + "," + new SingleFP(this.rotateY) + "," + new SingleFP(this.translateX) + "," + new SingleFP(this.translateY) + ")";
    }
}

