/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

import com.guidebee.game.engine.drawing.core.MathFP;
import com.guidebee.game.engine.drawing.core.PointFP;

public class LineFP {
    public PointFP pt1 = new PointFP(0, 0);
    public PointFP pt2 = new PointFP(0, 0);

    public int getLength() {
        return PointFP.distance(this.pt1, this.pt2);
    }

    public PointFP getCenter() {
        return new PointFP((this.pt1.x + this.pt2.x) / 2, (this.pt1.y + this.pt2.y) / 2);
    }

    public LineFP() {
    }

    public LineFP(LineFP l) {
        this.reset(l.pt1, l.pt2);
    }

    public LineFP(PointFP p1, PointFP p2) {
        this.reset(p1, p2);
    }

    public LineFP(int ff_x1, int ff_y1, int ff_x2, int ff_y2) {
        this.reset(ff_x1, ff_y1, ff_x2, ff_y2);
    }

    public void reset(LineFP l) {
        this.reset(l.pt1, l.pt2);
    }

    public void reset(PointFP p1, PointFP p2) {
        this.pt1.reset(p1);
        this.pt2.reset(p2);
    }

    public void reset(int ff_x1, int ff_y1, int ff_x2, int ff_y2) {
        this.pt1.reset(ff_x1, ff_y1);
        this.pt2.reset(ff_x2, ff_y2);
    }

    public LineFP getHeadOutline(int ff_rad) {
        PointFP p = new PointFP(this.pt1.x - this.pt2.x, this.pt1.y - this.pt2.y);
        int len = this.getLength();
        if (len != 0) {
            p.reset(MathFP.div(-p.y, len), MathFP.div(p.x, len));
            p.reset(MathFP.mul(p.x, ff_rad), MathFP.mul(p.y, ff_rad));
        }
        return new LineFP(this.pt1.x - p.x, this.pt1.y - p.y, this.pt1.x + p.x, this.pt1.y + p.y);
    }

    public LineFP getTailOutline(int ff_rad) {
        PointFP c = this.getCenter();
        PointFP p = new PointFP(this.pt2.x - c.x, this.pt2.y - c.y);
        p.reset(p.y, -p.x);
        int dis = PointFP.distance(PointFP.ORIGIN, p);
        if (dis == 0) {
            dis = 1;
        }
        p.reset(MathFP.div(MathFP.mul(p.x, ff_rad), dis), MathFP.div(MathFP.mul(p.y, ff_rad), dis));
        return new LineFP(this.pt2.x - p.x, this.pt2.y - p.y, this.pt2.x + p.x, this.pt2.y + p.y);
    }

    private static boolean isEqual(int ff_val1, int ff_val2) {
        return LineFP.isZero(ff_val1 - ff_val2);
    }

    private static boolean isZero(int ff_val) {
        return MathFP.abs(ff_val) < 256;
    }

    public static boolean intersects(LineFP l1, LineFP l2, PointFP intersection) {
        int x = -2147483647;
        int y = -2147483647;
        if (intersection != null) {
            intersection.reset(x, y);
        }
        int ax0 = l1.pt1.x;
        int ax1 = l1.pt2.x;
        int ay0 = l1.pt1.y;
        int ay1 = l1.pt2.y;
        int bx0 = l2.pt1.x;
        int bx1 = l2.pt2.x;
        int by0 = l2.pt1.y;
        int by1 = l2.pt2.y;
        int adx = ax1 - ax0;
        int ady = ay1 - ay0;
        int bdx = bx1 - bx0;
        int bdy = by1 - by0;
        if (LineFP.isZero(adx) && LineFP.isZero(bdx)) {
            return LineFP.isEqual(ax0, bx0);
        }
        if (LineFP.isZero(ady) && LineFP.isZero(bdy)) {
            return LineFP.isEqual(ay0, by0);
        }
        if (LineFP.isZero(adx)) {
            x = ax0;
            y = LineFP.isZero(bdy) ? by0 : MathFP.mul(MathFP.div(bdy, bdx), x - bx0) + by0;
        } else if (LineFP.isZero(bdx)) {
            x = bx0;
            y = LineFP.isZero(ady) ? ay0 : MathFP.mul(MathFP.div(ady, adx), x - ax0) + ay0;
        } else if (LineFP.isZero(ady)) {
            y = ay0;
            x = MathFP.mul(MathFP.div(bdx, bdy), y - by0) + bx0;
        } else if (LineFP.isZero(bdy)) {
            y = by0;
            x = MathFP.mul(MathFP.div(adx, ady), y - ay0) + ax0;
        } else {
            int xma = MathFP.div(ady, adx);
            int xba = ay0 - MathFP.mul(ax0, xma);
            int xmb = MathFP.div(bdy, bdx);
            int xbb = by0 - MathFP.mul(bx0, xmb);
            if (xma == xmb) {
                return xba == xbb;
            }
            x = MathFP.div(xbb - xba, xma - xmb);
            y = MathFP.mul(xma, x) + xba;
        }
        int minxa = MathFP.min(ax0, ax1);
        int maxxa = MathFP.max(ax0, ax1);
        int minya = MathFP.min(ay0, ay1);
        int maxya = MathFP.max(ay0, ay1);
        int minxb = MathFP.min(bx0, bx1);
        int maxxb = MathFP.max(bx0, bx1);
        int minyb = MathFP.min(by0, by1);
        int maxyb = MathFP.max(by0, by1);
        if (intersection != null) {
            intersection.reset(x, y);
        }
        return x >= minxa && x <= maxxa && y >= minya && y <= maxya && x >= minxb && x <= maxxb && y >= minyb && y <= maxyb;
    }

    PointFP getPointAtDistance(int distance) {
        int lineLength = this.getLength();
        if (distance > lineLength) {
            return null;
        }
        if (distance == lineLength) {
            return new PointFP(this.pt2);
        }
        int scale = MathFP.div(distance, lineLength);
        PointFP pointFP = new PointFP();
        pointFP.reset(this.pt1.x + MathFP.mul(this.pt2.x - this.pt1.x, scale), this.pt1.y + MathFP.mul(this.pt2.y - this.pt1.y, scale));
        return pointFP;
    }
}

