/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.engine.drawing.core;

import com.guidebee.game.engine.drawing.core.IGraphicsPathIteratorFP;
import com.guidebee.game.engine.drawing.core.PointFP;

public class GraphicsPathSketchFP
implements IGraphicsPathIteratorFP {
    protected static final int SUBDIVIDE = 24;
    protected static final int SUBDIVIDE2 = 576;
    protected static final int SUBDIVIDE3 = 13824;
    protected final PointFP startPoint = new PointFP();
    protected final PointFP currPoint = new PointFP();
    protected boolean started;

    public PointFP currentPoint() {
        return this.currPoint;
    }

    public PointFP startPoint() {
        return this.startPoint;
    }

    @Override
    public void begin() {
        this.started = false;
    }

    @Override
    public void end() {
    }

    @Override
    public void moveTo(PointFP point) {
        if (!this.started) {
            this.startPoint.reset(point);
            this.started = true;
        }
        this.currPoint.reset(point);
    }

    @Override
    public void lineTo(PointFP point) {
        this.currPoint.reset(point);
    }

    @Override
    public void quadTo(PointFP control, PointFP point) {
        PointFP f = new PointFP(this.currPoint);
        PointFP tmp = new PointFP((this.currPoint.x - control.x * 2 + point.x) / 576, (this.currPoint.y - control.y * 2 + point.y) / 576);
        PointFP ddf = new PointFP(tmp.x * 2, tmp.y * 2);
        PointFP df = new PointFP(tmp.x + (control.x - this.currPoint.x) * 2 / 24, tmp.y + (control.y - this.currPoint.y) * 2 / 24);
        for (int c = 0; c < 23; ++c) {
            f.add(df);
            df.add(ddf);
            this.lineTo(f);
        }
        this.lineTo(point);
    }

    @Override
    public void curveTo(PointFP control1, PointFP control2, PointFP point) {
        PointFP tmp1 = new PointFP(this.currPoint.x - control1.x * 2 + control2.x, this.currPoint.y - control1.y * 2 + control2.y);
        PointFP tmp2 = new PointFP((control1.x - control2.x) * 3 - this.currPoint.x + point.x, (control1.y - control2.y) * 3 - this.currPoint.y + point.y);
        PointFP f = new PointFP(this.currPoint);
        PointFP df = new PointFP((control1.x - this.currPoint.x) * 3 / 24 + tmp1.x * 3 / 576 + tmp2.x / 13824, (control1.y - this.currPoint.y) * 3 / 24 + tmp1.y * 3 / 576 + tmp2.y / 13824);
        PointFP ddf = new PointFP(tmp1.x * 6 / 576 + tmp2.x * 6 / 13824, tmp1.y * 6 / 576 + tmp2.y * 6 / 13824);
        PointFP dddf = new PointFP(tmp2.x * 6 / 13824, tmp2.y * 6 / 13824);
        for (int c = 0; c < 23; ++c) {
            f.add(df);
            df.add(ddf);
            ddf.add(dddf);
            this.lineTo(f);
        }
        this.lineTo(point);
    }

    @Override
    public void close() {
        this.lineTo(this.startPoint);
        this.started = false;
    }
}

