/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.game.activity;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Debug;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import com.guidebee.game.ApplicationListener;
import com.guidebee.game.Audio;
import com.guidebee.game.Configuration;
import com.guidebee.game.Files;
import com.guidebee.game.GameEngine;
import com.guidebee.game.GameEngineRuntimeException;
import com.guidebee.game.Graphics;
import com.guidebee.game.LifecycleListener;
import com.guidebee.game.Net;
import com.guidebee.game.Preferences;
import com.guidebee.game.ResourceManager;
import com.guidebee.game.activity.BaseActivity;
import com.guidebee.game.engine.platform.Input;
import com.guidebee.game.engine.platform.InputFactory;
import com.guidebee.game.engine.platform.surfaceview.FillResolutionStrategy;
import com.guidebee.game.engine.utils.GameEngineiNativesLoader;
import com.guidebee.utils.Clipboard;
import com.guidebee.utils.collections.Array;
import java.lang.reflect.Method;

public class GameActivityWrapper
implements BaseActivity {
    protected Activity activity;
    protected com.guidebee.game.engine.platform.Graphics graphics;
    protected Input input;
    protected com.guidebee.game.engine.platform.Audio audio;
    protected com.guidebee.game.engine.platform.Files files;
    protected com.guidebee.game.engine.platform.Net net;
    protected ApplicationListener listener;
    public Handler handler;
    protected boolean firstResume = true;
    protected final Array<Runnable> runnables = new Array();
    protected final Array<Runnable> executedRunnables = new Array();
    protected final Array<LifecycleListener> lifecycleListeners = new Array();
    protected int logLevel = 2;
    protected boolean useImmersiveMode = false;
    protected boolean hideStatusBar = false;
    private int wasFocusChanged = -1;
    private boolean isWaitingForAudio = false;
    com.guidebee.game.engine.platform.Clipboard clipboard;

    public GameActivityWrapper(Activity activity) {
        this.activity = activity;
    }

    public void initialize(ApplicationListener listener) {
        Configuration config = new Configuration();
        this.initialize(listener, config);
    }

    public void initialize(ApplicationListener listener, Configuration config) {
        this.init(listener, config, false);
    }

    public View initializeForView(ApplicationListener listener) {
        Configuration config = new Configuration();
        return this.initializeForView(listener, config);
    }

    public View initializeForView(ApplicationListener listener, Configuration config) {
        this.init(listener, config, true);
        return this.graphics.getView();
    }

    private void init(ApplicationListener listener, Configuration config, boolean isForView) {
        if (this.getVersion() < 8) {
            throw new GameEngineRuntimeException("GameEngine requires Android API Level 8 or later.");
        }
        this.graphics = new com.guidebee.game.engine.platform.Graphics(this, config, config.resolutionStrategy == null ? new FillResolutionStrategy() : config.resolutionStrategy);
        this.input = InputFactory.newAndroidInput(this, (Context)this.activity, this.graphics.view, config);
        this.audio = new com.guidebee.game.engine.platform.Audio((Context)this.activity, config);
        this.activity.getFilesDir();
        this.files = new com.guidebee.game.engine.platform.Files(this.activity.getAssets(), this.activity.getFilesDir().getAbsolutePath());
        this.net = new com.guidebee.game.engine.platform.Net(this);
        this.listener = listener;
        this.handler = new Handler();
        this.useImmersiveMode = config.useImmersiveMode;
        this.hideStatusBar = config.hideStatusBar;
        this.addLifecycleListener(new LifecycleListener(){

            @Override
            public void resume() {
            }

            @Override
            public void pause() {
                GameActivityWrapper.this.audio.pause();
            }

            @Override
            public void dispose() {
                GameActivityWrapper.this.audio.dispose();
            }
        });
        GameEngine.app = this;
        GameEngine.input = this.getInput();
        GameEngine.audio = this.getAudio();
        GameEngine.files = this.getFiles();
        GameEngine.graphics = this.getGraphics();
        GameEngine.net = this.getNet();
        GameEngine.assetManager = new ResourceManager();
        GameEngine.pixelToBox2DUnit = config.pixelToBox2DUnit;
        if (!isForView) {
            try {
                this.activity.requestWindowFeature(1);
            }
            catch (Exception ex) {
                this.log("Application", "Content already displayed, cannot request FEATURE_NO_TITLE", ex);
            }
            this.activity.getWindow().setFlags(1024, 1024);
            this.activity.getWindow().clearFlags(2048);
            this.activity.setContentView(this.graphics.getView(), (ViewGroup.LayoutParams)this.createLayoutParams());
        }
        this.createWakeLock(config.useWakelock);
        this.hideStatusBar(this.hideStatusBar);
        this.useImmersiveMode(this.useImmersiveMode);
        if (this.useImmersiveMode && this.getVersion() >= 19) {
            try {
                Class<?> vlistener = Class.forName("com.guidebee.game.engine.platform.VisibilityListener");
                Object o = vlistener.newInstance();
                Method method = vlistener.getDeclaredMethod("createListener", BaseActivity.class);
                method.invoke(o, this);
            }
            catch (Exception e) {
                this.log("Application", "Failed to create VisibilityListener", e);
            }
        }
    }

    protected FrameLayout.LayoutParams createLayoutParams() {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.gravity = 17;
        return layoutParams;
    }

    protected void createWakeLock(boolean use) {
        if (use) {
            this.activity.getWindow().addFlags(128);
        }
    }

    protected void hideStatusBar(boolean hide) {
        if (!hide || this.getVersion() < 11) {
            return;
        }
        View rootView = this.activity.getWindow().getDecorView();
        try {
            Method m = View.class.getMethod("setSystemUiVisibility", Integer.TYPE);
            if (this.getVersion() <= 13) {
                m.invoke((Object)rootView, 0);
            }
            m.invoke((Object)rootView, 1);
        }
        catch (Exception e) {
            this.log("Application", "Can't hide status bar", e);
        }
    }

    @Override
    @TargetApi(value=19)
    public void useImmersiveMode(boolean use) {
        if (!use || this.getVersion() < 19) {
            return;
        }
        View view = this.activity.getWindow().getDecorView();
        try {
            Method m = View.class.getMethod("setSystemUiVisibility", Integer.TYPE);
            int code = 256;
            code ^= 0x200;
            code ^= 0x400;
            code ^= 4;
            code ^= 2;
            m.invoke((Object)view, code ^= 0x1000);
        }
        catch (Exception e) {
            this.log("Application", "Can't set immersive mode", e);
        }
    }

    @Override
    public ApplicationListener getApplicationListener() {
        return this.listener;
    }

    @Override
    public Audio getAudio() {
        return this.audio;
    }

    @Override
    public Files getFiles() {
        return this.files;
    }

    @Override
    public Graphics getGraphics() {
        return this.graphics;
    }

    @Override
    public Input getInput() {
        return this.input;
    }

    @Override
    public Net getNet() {
        return this.net;
    }

    @Override
    public int getVersion() {
        return Build.VERSION.SDK_INT;
    }

    @Override
    public long getJavaHeap() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    @Override
    public long getNativeHeap() {
        return Debug.getNativeHeapAllocatedSize();
    }

    @Override
    public Preferences getPreferences(String name) {
        return new com.guidebee.game.engine.platform.Preferences(this.activity.getSharedPreferences(name, 0));
    }

    @Override
    public Clipboard getClipboard() {
        if (this.clipboard == null) {
            this.clipboard = new com.guidebee.game.engine.platform.Clipboard((Context)this.activity);
        }
        return this.clipboard;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRunnable(Runnable runnable) {
        Array<Runnable> array = this.runnables;
        synchronized (array) {
            this.runnables.add(runnable);
            GameEngine.graphics.requestRendering();
        }
    }

    @Override
    public void exit() {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                GameActivityWrapper.this.activity.finish();
            }
        });
    }

    @Override
    public void debug(String tag, String message) {
        if (this.logLevel >= 3) {
            Log.d((String)tag, (String)message);
        }
    }

    @Override
    public void debug(String tag, String message, Throwable exception) {
        if (this.logLevel >= 3) {
            Log.d((String)tag, (String)message, (Throwable)exception);
        }
    }

    @Override
    public void log(String tag, String message) {
        if (this.logLevel >= 2) {
            Log.i((String)tag, (String)message);
        }
    }

    @Override
    public void log(String tag, String message, Throwable exception) {
        if (this.logLevel >= 2) {
            Log.i((String)tag, (String)message, (Throwable)exception);
        }
    }

    @Override
    public void error(String tag, String message) {
        if (this.logLevel >= 1) {
            Log.e((String)tag, (String)message);
        }
    }

    @Override
    public void error(String tag, String message, Throwable exception) {
        if (this.logLevel >= 1) {
            Log.e((String)tag, (String)message, (Throwable)exception);
        }
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        Array<LifecycleListener> array = this.lifecycleListeners;
        synchronized (array) {
            this.lifecycleListeners.removeValue(listener, true);
        }
    }

    @Override
    public Context getContext() {
        return this.activity;
    }

    @Override
    public Array<Runnable> getRunnables() {
        return this.runnables;
    }

    @Override
    public Array<Runnable> getExecutedRunnables() {
        return this.executedRunnables;
    }

    @Override
    public void runOnUiThread(Runnable runnable) {
        this.activity.runOnUiThread(runnable);
    }

    @Override
    public void startActivity(Intent intent) {
        this.activity.startActivity(intent);
    }

    @Override
    public Array<LifecycleListener> getLifecycleListeners() {
        return this.lifecycleListeners;
    }

    @Override
    public Window getApplicationWindow() {
        return this.activity.getWindow();
    }

    @Override
    public WindowManager getWindowManager() {
        return this.activity.getWindowManager();
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    public void onConfigurationChanged(android.content.res.Configuration config) {
        boolean keyboardAvailable = false;
        if (config.hardKeyboardHidden == 1) {
            keyboardAvailable = true;
        }
        this.input.keyboardAvailable = keyboardAvailable;
    }

    protected void onPause() {
        boolean isContinuous = this.graphics.isContinuousRendering();
        this.graphics.setContinuousRendering(true);
        this.graphics.pause();
        this.input.onPause();
        if (this.activity.isFinishing()) {
            this.graphics.clearManagedCaches();
            this.graphics.destroy();
        }
        this.graphics.setContinuousRendering(isContinuous);
        this.graphics.onPauseGLSurfaceView();
    }

    protected void onResume() {
        GameEngine.app = this;
        GameEngine.input = this.getInput();
        GameEngine.audio = this.getAudio();
        GameEngine.files = this.getFiles();
        GameEngine.graphics = this.getGraphics();
        GameEngine.net = this.getNet();
        this.input.onResume();
        if (this.graphics != null) {
            this.graphics.onResumeGLSurfaceView();
        }
        if (!this.firstResume) {
            this.graphics.resume();
        } else {
            this.firstResume = false;
        }
        this.isWaitingForAudio = true;
        if (this.wasFocusChanged == 1 || this.wasFocusChanged == -1) {
            this.audio.resume();
            this.isWaitingForAudio = false;
        }
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        this.useImmersiveMode(this.useImmersiveMode);
        this.hideStatusBar(this.hideStatusBar);
        if (hasFocus) {
            this.wasFocusChanged = 1;
            if (this.isWaitingForAudio) {
                this.audio.resume();
                this.isWaitingForAudio = false;
            }
        } else {
            this.wasFocusChanged = 0;
        }
    }

    static {
        GameEngineiNativesLoader.load();
    }
}

