/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.Rectangle;
import com.guidebee.drawing.geometry.RectangularShape;
import com.guidebee.drawing.geometry.RoundRectIterator;

public class RoundRectangle
extends RectangularShape {
    public double x;
    public double y;
    public double width;
    public double height;
    public double arcwidth;
    public double archeight;

    public RoundRectangle() {
    }

    public RoundRectangle(double x, double y, double w, double h, double arcw, double arch) {
        this.setRoundRect(x, y, w, h, arcw, arch);
    }

    @Override
    public int getX() {
        return (int)(this.x + 0.5);
    }

    @Override
    public int getY() {
        return (int)(this.y + 0.5);
    }

    @Override
    public int getWidth() {
        return (int)(this.width + 0.5);
    }

    @Override
    public int getHeight() {
        return (int)(this.height + 0.5);
    }

    public double getArcWidth() {
        return this.arcwidth;
    }

    public double getArcHeight() {
        return this.archeight;
    }

    @Override
    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public void setRoundRect(double x, double y, double w, double h, double arcw, double arch) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.arcwidth = arcw;
        this.archeight = arch;
    }

    public void setRoundRect(RoundRectangle rr) {
        this.x = rr.getX();
        this.y = rr.getY();
        this.width = rr.getWidth();
        this.height = rr.getHeight();
        this.arcwidth = rr.getArcWidth();
        this.archeight = rr.getArcHeight();
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle((int)(this.x + 0.5), (int)(this.y + 0.5), (int)(this.width + 0.5), (int)(this.height + 0.5));
    }

    @Override
    public void setFrame(int x, int y, int w, int h) {
        this.setRoundRect(x, y, w, h, this.getArcWidth(), this.getArcHeight());
    }

    @Override
    public boolean contains(int x, int y) {
        double yp;
        double xp;
        double d;
        double d2;
        if (this.isEmpty()) {
            return false;
        }
        double rrx0 = this.getX();
        double rry0 = this.getY();
        double rrx1 = rrx0 + (double)this.getWidth();
        double rry1 = rry0 + (double)this.getHeight();
        if ((double)x < rrx0 || (double)y < rry0 || (double)x >= rrx1 || (double)y >= rry1) {
            return false;
        }
        double aw = Math.min((double)this.getWidth(), Math.abs(this.getArcWidth())) / 2.0;
        double ah = Math.min((double)this.getHeight(), Math.abs(this.getArcHeight())) / 2.0;
        rrx0 += aw;
        if ((double)x >= d2) {
            double d3;
            rrx0 = rrx1 - aw;
            if ((double)x < d3) {
                return true;
            }
        }
        rry0 += ah;
        if ((double)y >= d) {
            double d4;
            rry0 = rry1 - ah;
            if ((double)y < d4) {
                return true;
            }
        }
        return (xp = ((double)x - rrx0) / aw) * xp + (yp = ((double)y - rry0) / ah) * yp <= 1.0;
    }

    @Override
    public boolean intersects(int x, int y, int w, int h) {
        if (this.isEmpty() || w <= 0 || h <= 0) {
            return false;
        }
        double rrx0 = this.getX();
        double rry0 = this.getY();
        double rrx1 = rrx0 + (double)this.getWidth();
        double rry1 = rry0 + (double)this.getHeight();
        if ((double)(x + w) <= rrx0 || (double)x >= rrx1 || (double)(y + h) <= rry0 || (double)y >= rry1) {
            return false;
        }
        double aw = Math.min((double)this.getWidth(), Math.abs(this.getArcWidth())) / 2.0;
        double ah = Math.min((double)this.getHeight(), Math.abs(this.getArcHeight())) / 2.0;
        int x0class = this.classify(x, rrx0, rrx1, aw);
        int x1class = this.classify(x + w, rrx0, rrx1, aw);
        int y0class = this.classify(y, rry0, rry1, ah);
        int y1class = this.classify(y + h, rry0, rry1, ah);
        if (x0class == 2 || x1class == 2 || y0class == 2 || y1class == 2) {
            return true;
        }
        if (x0class < 2 && x1class > 2 || y0class < 2 && y1class > 2) {
            return true;
        }
        double xp = x;
        double yp = y;
        xp = x1class == 1 ? (xp = xp + (double)w - (rrx0 + aw)) : (xp = xp - (rrx1 - aw));
        yp = y1class == 1 ? (yp = yp + (double)h - (rry0 + ah)) : (yp = yp - (rry1 - ah));
        return (xp /= aw) * xp + (yp /= ah) * yp <= 1.0;
    }

    @Override
    public boolean contains(int x, int y, int w, int h) {
        if (this.isEmpty() || w <= 0 || h <= 0) {
            return false;
        }
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at) {
        return new RoundRectIterator(this, at);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getX());
        bits += Double.doubleToLongBits(this.getY()) * 37L;
        bits += Double.doubleToLongBits(this.getWidth()) * 43L;
        bits += Double.doubleToLongBits(this.getHeight()) * 47L;
        bits += Double.doubleToLongBits(this.getArcWidth()) * 53L;
        return (int)(bits += Double.doubleToLongBits(this.getArcHeight()) * 59L) ^ (int)(bits >> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RoundRectangle) {
            RoundRectangle rr2d = (RoundRectangle)obj;
            return this.getX() == rr2d.getX() && this.getY() == rr2d.getY() && this.getWidth() == rr2d.getWidth() && this.getHeight() == rr2d.getHeight() && this.getArcWidth() == rr2d.getArcWidth() && this.getArcHeight() == rr2d.getArcHeight();
        }
        return false;
    }

    private int classify(double coord, double left, double right, double arcsize) {
        if (coord < left) {
            return 0;
        }
        if (coord < left + arcsize) {
            return 1;
        }
        if (coord < right - arcsize) {
            return 2;
        }
        if (coord < right) {
            return 3;
        }
        return 4;
    }
}

