/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.Dimension;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.IShape;
import com.guidebee.drawing.geometry.Line;
import com.guidebee.drawing.geometry.Point;
import com.guidebee.drawing.geometry.RectIterator;
import com.guidebee.drawing.geometry.RectangularShape;

public class Rectangle
extends RectangularShape
implements IShape {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;
    public int x;
    public int y;
    public int width;
    public int height;
    private Dimension size;

    public Rectangle() {
        this(0, 0, 0, 0);
    }

    public Rectangle(Rectangle r) {
        this(r.x, r.y, r.width, r.height);
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.size = new Dimension(width, height);
    }

    public Rectangle(int width, int height) {
        this(0, 0, width, height);
    }

    public Rectangle(Point p1, Point p2) {
        this(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.abs(p1.x - p2.x), Math.abs(p1.y - p2.y));
    }

    public Rectangle(int x, int y, Dimension d) {
        this(x, y, d.width, d.height);
    }

    public Rectangle(Point p, Dimension d) {
        this(p.x, p.y, d.width, d.height);
    }

    public Rectangle(Point p) {
        this(p.x, p.y, 0, 0);
    }

    public Rectangle(Dimension d) {
        this(0, 0, d.width, d.height);
    }

    public void setRect(Rectangle r) {
        this.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public void setRect(int x, int y, int width, int height) {
        int newh;
        int newy;
        int neww;
        int newx;
        if (x > 0x3FFFFFFF) {
            newx = 0x3FFFFFFF;
            neww = -1;
        } else {
            newx = Rectangle.clip(x, false);
            if (width >= 0) {
                width += x - newx;
            }
            neww = Rectangle.clip(width, width >= 0);
        }
        if (y > Integer.MAX_VALUE) {
            newy = 0x3FFFFFFF;
            newh = -1;
        } else {
            newy = Rectangle.clip(y, false);
            if (height >= 0) {
                height += y - newy;
            }
            newh = Rectangle.clip(height, height >= 0);
        }
        this.reshape(newx, newy, neww, newh);
    }

    public boolean intersectsLine(int x1, int y1, int x2, int y2) {
        int out1;
        int out2 = this.outcode(x2, y2);
        if (out2 == 0) {
            return true;
        }
        while ((out1 = this.outcode(x1, y1)) != 0) {
            if ((out1 & out2) != 0) {
                return false;
            }
            if ((out1 & 5) != 0) {
                int xp = this.getX();
                if ((out1 & 4) != 0) {
                    xp += this.getWidth();
                }
                y1 += (xp - x1) * (y2 - y1) / (x2 - x1);
                x1 = xp;
                continue;
            }
            int yp = this.getY();
            if ((out1 & 8) != 0) {
                yp += this.getHeight();
            }
            x1 += (yp - y1) * (x2 - x1) / (y2 - y1);
            y1 = yp;
        }
        return true;
    }

    public boolean intersectsLine(Line l) {
        return this.intersectsLine(l.getX1(), l.getY1(), l.getX2(), l.getY2());
    }

    public int outcode(Point p) {
        return this.outcode(p.getX(), p.getY());
    }

    @Override
    public void setFrame(int x, int y, int w, int h) {
        this.setRect(x, y, w, h);
    }

    @Override
    public boolean contains(int rX, int rY) {
        return this.inside(rX, rY);
    }

    @Override
    public boolean intersects(int x, int y, int width, int height) {
        int tw = this.size.getWidth();
        int th = this.size.getHeight();
        return Rectangle.intersects(this.x, this.y, tw, th, x, y, width, height);
    }

    @Override
    public boolean intersects(Rectangle rect) {
        return this.intersects(rect.getX(), rect.getY(), rect.getSize().getWidth(), rect.getSize().getHeight());
    }

    public static boolean intersects(int tx, int ty, int tw, int th, int x, int y, int width, int height) {
        int rw = width;
        int rh = height;
        if (rw <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int rx = x;
        int ry = y;
        rh += ry;
        tw += tx;
        th += ty;
        return !((rw += rx) >= rx && rw <= tx || rh >= ry && rh <= ty || tw >= tx && tw <= rx || th >= ty && th <= ry);
    }

    @Override
    public boolean contains(int rX, int rY, int rWidth, int rHeight) {
        return this.x <= rX && this.y <= rY && this.x + this.getWidth() >= rX + rWidth && this.y + this.getHeight() >= rY + rHeight;
    }

    public static void intersect(Rectangle src1, Rectangle src2, Rectangle dest) {
        int x1 = Math.max(src1.getMinX(), src2.getMinX());
        int y1 = Math.max(src1.getMinY(), src2.getMinY());
        int x2 = Math.min(src1.getMaxX(), src2.getMaxX());
        int y2 = Math.min(src1.getMaxY(), src2.getMaxY());
        dest.setFrame(x1, y1, x2 - x1, y2 - y1);
    }

    public static void union(Rectangle src1, Rectangle src2, Rectangle dest) {
        int x1 = Math.min(src1.getMinX(), src2.getMinX());
        int y1 = Math.min(src1.getMinY(), src2.getMinY());
        int x2 = Math.max(src1.getMaxX(), src2.getMaxX());
        int y2 = Math.max(src1.getMaxY(), src2.getMaxY());
        dest.setFrameFromDiagonal(x1, y1, x2, y2);
    }

    public void add(int newx, int newy) {
        int x1 = Math.min(this.getMinX(), newx);
        int x2 = Math.max(this.getMaxX(), newx);
        int y1 = Math.min(this.getMinY(), newy);
        int y2 = Math.max(this.getMaxY(), newy);
        this.setRect(x1, y1, x2 - x1, y2 - y1);
    }

    public void add(Point pt) {
        this.add(pt.x, pt.y);
    }

    public void add(Rectangle r) {
        int x1 = Math.min(this.getMinX(), r.getMinX());
        int x2 = Math.max(this.getMaxX(), r.getMaxX());
        int y1 = Math.min(this.getMinY(), r.getMinY());
        int y2 = Math.max(this.getMaxY(), r.getMaxY());
        this.setRect(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at) {
        return new RectIterator(this, at);
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at, int flatness) {
        return new RectIterator(this, at);
    }

    public int hashCode() {
        int bits = this.x & -65536 + this.y & 0xFFFF;
        return bits;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangle) {
            Rectangle r2d = (Rectangle)obj;
            return this.x == r2d.x && this.x == r2d.y && this.width == r2d.width && this.height == r2d.height;
        }
        return false;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(Rectangle r) {
        this.setFrame(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.reshape(x, y, width, height);
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public void setLocation(int x, int y) {
        this.move(x, y);
    }

    public void translate(int dx, int dy) {
        int oldv = this.x;
        int newv = oldv + dx;
        if (dx < 0) {
            if (newv > oldv) {
                if (this.width >= 0) {
                    this.width += newv - Integer.MIN_VALUE;
                }
                newv = Integer.MIN_VALUE;
            }
        } else if (newv < oldv) {
            if (this.width >= 0) {
                this.width += newv - Integer.MAX_VALUE;
                if (this.width < 0) {
                    this.width = Integer.MAX_VALUE;
                }
            }
            newv = Integer.MAX_VALUE;
        }
        this.x = newv;
        oldv = this.y;
        newv = oldv + dy;
        if (dy < 0) {
            if (newv > oldv) {
                if (this.height >= 0) {
                    this.height += newv - Integer.MIN_VALUE;
                }
                newv = Integer.MIN_VALUE;
            }
        } else if (newv < oldv) {
            if (this.height >= 0) {
                this.height += newv - Integer.MAX_VALUE;
                if (this.height < 0) {
                    this.height = Integer.MAX_VALUE;
                }
            }
            newv = Integer.MAX_VALUE;
        }
        this.y = newv;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int width, int height) {
        this.resize(width, height);
    }

    @Override
    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    @Override
    public boolean contains(Rectangle rect) {
        return this.contains(rect.x, rect.y, rect.size.getWidth(), rect.size.getHeight());
    }

    public Rectangle intersection(Rectangle r) {
        int tx1 = this.x;
        int ty1 = this.y;
        int rx1 = r.x;
        int ry1 = r.y;
        int tx2 = tx1;
        tx2 += this.width;
        int ty2 = ty1;
        ty2 += this.height;
        int rx2 = rx1;
        rx2 += r.width;
        int ry2 = ry1;
        ry2 += r.height;
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= ty1;
        if ((tx2 -= tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        return new Rectangle(tx1, ty1, tx2, ty2);
    }

    public Rectangle union(Rectangle r) {
        int tx2 = this.width;
        int ty2 = this.height;
        if ((tx2 | ty2) < 0) {
            return new Rectangle(r);
        }
        int rx2 = r.width;
        int ry2 = r.height;
        if ((rx2 | ry2) < 0) {
            return new Rectangle(this);
        }
        int tx1 = this.x;
        int ty1 = this.y;
        tx2 += tx1;
        ty2 += ty1;
        int rx1 = r.x;
        int ry1 = r.y;
        rx2 += rx1;
        ry2 += ry1;
        if (tx1 > rx1) {
            tx1 = rx1;
        }
        if (ty1 > ry1) {
            ty1 = ry1;
        }
        if (tx2 < rx2) {
            tx2 = rx2;
        }
        if (ty2 < ry2) {
            ty2 = ry2;
        }
        ty2 -= ty1;
        if ((tx2 -= tx1) > Integer.MAX_VALUE) {
            tx2 = Integer.MAX_VALUE;
        }
        if (ty2 > Integer.MAX_VALUE) {
            ty2 = Integer.MAX_VALUE;
        }
        return new Rectangle(tx1, ty1, tx2, ty2);
    }

    public void grow(int h, int v) {
        int x0 = this.x;
        int y0 = this.y;
        int x1 = this.width;
        int y1 = this.height;
        x1 += x0;
        y1 += y0;
        y0 -= v;
        y1 += v;
        if ((x1 += h) < (x0 -= h)) {
            if ((x1 -= x0) < Integer.MIN_VALUE) {
                x1 = Integer.MIN_VALUE;
            }
            if (x0 < Integer.MIN_VALUE) {
                x0 = Integer.MIN_VALUE;
            } else if (x0 > Integer.MAX_VALUE) {
                x0 = Integer.MAX_VALUE;
            }
        } else {
            if (x0 < Integer.MIN_VALUE) {
                x0 = Integer.MIN_VALUE;
            } else if (x0 > Integer.MAX_VALUE) {
                x0 = Integer.MAX_VALUE;
            }
            if ((x1 -= x0) < Integer.MIN_VALUE) {
                x1 = Integer.MIN_VALUE;
            } else if (x1 > Integer.MAX_VALUE) {
                x1 = Integer.MAX_VALUE;
            }
        }
        if (y1 < y0) {
            if ((y1 -= y0) < Integer.MIN_VALUE) {
                y1 = Integer.MIN_VALUE;
            }
            if (y0 < Integer.MIN_VALUE) {
                y0 = Integer.MIN_VALUE;
            } else if (y0 > Integer.MAX_VALUE) {
                y0 = Integer.MAX_VALUE;
            }
        } else {
            if (y0 < Integer.MIN_VALUE) {
                y0 = Integer.MIN_VALUE;
            } else if (y0 > Integer.MAX_VALUE) {
                y0 = Integer.MAX_VALUE;
            }
            if ((y1 -= y0) < Integer.MIN_VALUE) {
                y1 = Integer.MIN_VALUE;
            } else if (y1 > Integer.MAX_VALUE) {
                y1 = Integer.MAX_VALUE;
            }
        }
        this.reshape(x0, y0, x1, y1);
    }

    @Override
    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public void setEmpty() {
        this.height = 0;
        this.width = 0;
        this.y = 0;
        this.x = 0;
    }

    public int outcode(int x, int y) {
        int out = 0;
        if (this.width <= 0) {
            out |= 5;
        } else if (x < this.x) {
            out |= 1;
        } else if ((long)x > (long)this.x + (long)this.width) {
            out |= 4;
        }
        if (this.height <= 0) {
            out |= 0xA;
        } else if (y < this.y) {
            out |= 2;
        } else if ((long)y > (long)this.y + (long)this.height) {
            out |= 8;
        }
        return out;
    }

    public Rectangle createIntersection(Rectangle r) {
        if (r instanceof Rectangle) {
            return this.intersection(r);
        }
        Rectangle dest = new Rectangle();
        Rectangle.intersect(this, r, dest);
        return dest;
    }

    public Rectangle createUnion(Rectangle r) {
        if (r instanceof Rectangle) {
            return this.union(r);
        }
        Rectangle dest = new Rectangle();
        Rectangle.union(this, r, dest);
        return dest;
    }

    public String toString() {
        return "RECT [x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    private static int clip(int v, boolean doceil) {
        if (v <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (v >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)(doceil ? Math.ceil(v) : Math.floor(v));
    }

    private void reshape(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.size.width = width;
        this.size.height = height;
    }

    private void move(int x, int y) {
        this.x = x;
        this.y = y;
    }

    private void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.size.width = width;
        this.size.height = height;
    }

    private boolean inside(int X, int Y) {
        int w = this.width;
        int h = this.height;
        if ((w | h) < 0) {
            return false;
        }
        int xp = this.x;
        int yp = this.y;
        if (X < xp || Y < yp) {
            return false;
        }
        h += yp;
        return !((w += xp) >= xp && w <= X || h >= yp && h <= Y);
    }
}

