/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.MathFP;
import com.guidebee.game.engine.drawing.parser.NumberListParser;

public class Point {
    public int x;
    public int y;
    private static final NumberListParser numberListParser = new NumberListParser();

    public Point() {
        this(0, 0);
    }

    public Point(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public Point(int x, int y) {
        this.x = x;
        this.y = y;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point[] fromString(String input) {
        NumberListParser numberListParser = Point.numberListParser;
        synchronized (numberListParser) {
            float[] coords = Point.numberListParser.parseNumberList(input);
            int length = coords.length / 2;
            Point[] points = new Point[length];
            if (length >= 2) {
                for (int i = 0; i < length; ++i) {
                    points[i] = new Point();
                    points[i].x = (int)coords[i * 2];
                    points[i].y = (int)coords[i * 2 + 1];
                }
                return points;
            }
            return null;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void move(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void translate(int dx, int dy) {
        this.x += dx;
        this.y += dy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Point) {
            Point pt = (Point)obj;
            return this.x == pt.x && this.y == pt.y;
        }
        return super.equals(obj);
    }

    public String toString() {
        return "POINT [" + this.x + "," + this.y + "]";
    }

    public static int distanceSq(int x1, int y1, int x2, int y2) {
        return (x1 -= x2) * x1 + (y1 -= y2) * y1;
    }

    public static int distance(int x1, int y1, int x2, int y2) {
        long disSQ = (x1 -= x2) * x1 + (y1 -= y2) * y1;
        long dis = MathFP.sqrt(disSQ << 20);
        return MathFP.toInt(dis);
    }

    public int distanceSq(int px, int py) {
        return (px -= this.getX()) * px + (py -= this.getY()) * py;
    }

    public int distanceSq(Point pt) {
        int px = pt.getX() - this.getX();
        int py = pt.getY() - this.getY();
        return px * px + py * py;
    }

    public int distance(int px, int py) {
        long disSQ = (px -= this.getX()) * px + (py -= this.getY()) * py;
        long dis = MathFP.sqrt(disSQ << 20);
        return MathFP.toInt(dis);
    }

    public int distance(Point pt) {
        int px = pt.getX() - this.getX();
        int py = pt.getY() - this.getY();
        long disSQ = px * px + py * py;
        long dis = MathFP.sqrt(disSQ << 20);
        return MathFP.toInt(dis);
    }

    public int hashCode() {
        int bits = this.getX() << 16 & 0xFFFF0000;
        return bits ^= this.getY();
    }
}

