/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.Curve;
import com.guidebee.drawing.geometry.FlatteningPathIterator;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.IShape;
import com.guidebee.drawing.geometry.IllegalPathStateException;
import com.guidebee.drawing.geometry.Point;
import com.guidebee.drawing.geometry.Rectangle;
import com.guidebee.game.engine.collections.Arrays;
import com.guidebee.game.engine.drawing.parser.PathParser;

public class Path
implements IShape {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    protected static final byte SEG_MOVETO = 0;
    protected static final byte SEG_LINETO = 1;
    protected static final byte SEG_QUADTO = 2;
    protected static final byte SEG_CUBICTO = 3;
    protected static final byte SEG_CLOSE = 4;
    protected transient byte[] pointTypes;
    protected transient int numTypes;
    public transient int numCoords;
    protected transient int windingRule;
    protected static final int INIT_SIZE = 20;
    protected static final int EXPAND_MAX = 500;
    public transient int[] intCoords;
    private static final PathParser pathParser = new PathParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path fromString(String input) {
        PathParser pathParser = Path.pathParser;
        synchronized (pathParser) {
            return Path.pathParser.parsePath(input);
        }
    }

    public Path(IShape s, AffineTransform at) {
        if (s instanceof Path) {
            Path p2d = (Path)s;
            this.setWindingRule(p2d.windingRule);
            this.numTypes = p2d.numTypes;
            this.pointTypes = Arrays.copyOf(p2d.pointTypes, p2d.pointTypes.length);
            this.numCoords = p2d.numCoords;
            this.intCoords = p2d.cloneCoords(at);
        } else {
            IPathIterator pi = s.getPathIterator(at);
            this.setWindingRule(pi.getWindingRule());
            this.pointTypes = new byte[20];
            this.intCoords = new int[40];
            this.append(pi, false);
        }
    }

    public Path() {
        this(1, 20);
    }

    public Path(int rule) {
        this(rule, 20);
    }

    public Path(int rule, int initialTypes) {
        this.setWindingRule(rule);
        this.pointTypes = new byte[initialTypes];
        this.intCoords = new int[initialTypes * 2];
    }

    public Path(IShape s) {
        this(s, null);
    }

    public final Object clone() {
        return new Path(this);
    }

    public final synchronized void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 4) {
            this.needRoom(true, 0);
            this.pointTypes[this.numTypes++] = 4;
        }
    }

    public final void append(IShape s, boolean connect) {
        this.append(s.getPathIterator(null), connect);
    }

    public final synchronized int getWindingRule() {
        return this.windingRule;
    }

    public final void setWindingRule(int rule) {
        if (rule != 0 && rule != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = rule;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final synchronized Point getCurrentPoint() {
        int index = this.numCoords;
        if (this.numTypes < 1) return null;
        if (index < 1) {
            return null;
        }
        if (this.pointTypes[this.numTypes - 1] != 4) return this.getPoint(index - 2);
        int i = this.numTypes - 2;
        while (i > 0) {
            switch (this.pointTypes[i]) {
                case 0: {
                    return this.getPoint(index - 2);
                }
                case 1: {
                    index -= 2;
                    break;
                }
                case 2: {
                    index -= 4;
                    break;
                }
                case 3: {
                    index -= 6;
                }
            }
            --i;
        }
        return this.getPoint(index - 2);
    }

    public final synchronized void reset() {
        this.numCoords = 0;
        this.numTypes = 0;
    }

    public final synchronized IShape createTransformedShape(AffineTransform at) {
        Path p2d = (Path)this.clone();
        if (at != null) {
            p2d.transform(at);
        }
        return p2d;
    }

    public static boolean contains(IPathIterator pi, int x, int y) {
        if (x * 0 + y * 0 == 0) {
            int mask = pi.getWindingRule() == 1 ? -1 : 1;
            int cross = Curve.pointCrossingsForPath(pi, x, y);
            return (cross & mask) != 0;
        }
        return false;
    }

    public static boolean contains(IPathIterator pi, Point p) {
        return Path.contains(pi, p.x, p.y);
    }

    @Override
    public final boolean contains(int x, int y) {
        if (x * 0 + y * 0 == 0) {
            if (this.numTypes < 2) {
                return false;
            }
            int mask = this.windingRule == 1 ? -1 : 1;
            return (this.pointCrossings(x, y) & mask) != 0;
        }
        return false;
    }

    @Override
    public final boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public static boolean contains(IPathIterator pi, int x, int y, int w, int h) {
        if (Double.isNaN(x + w) || Double.isNaN(y + h)) {
            return false;
        }
        if (w <= 0 || h <= 0) {
            return false;
        }
        int mask = pi.getWindingRule() == 1 ? -1 : 2;
        int crossings = Curve.rectCrossingsForPath(pi, x, y, x + w, y + h);
        return crossings != Integer.MIN_VALUE && (crossings & mask) != 0;
    }

    public static boolean contains(IPathIterator pi, Rectangle r) {
        return Path.contains(pi, r.x, r.y, r.width, r.height);
    }

    @Override
    public final boolean contains(int x, int y, int w, int h) {
        if (Double.isNaN(x + w) || Double.isNaN(y + h)) {
            return false;
        }
        if (w <= 0 || h <= 0) {
            return false;
        }
        int mask = this.windingRule == 1 ? -1 : 2;
        int crossings = this.rectCrossings(x, y, x + w, y + h);
        return crossings != Integer.MIN_VALUE && (crossings & mask) != 0;
    }

    @Override
    public final boolean contains(Rectangle r) {
        return this.contains(r.x, r.y, r.width, r.height);
    }

    public static boolean intersects(IPathIterator pi, int x, int y, int w, int h) {
        if (Double.isNaN(x + w) || Double.isNaN(y + h)) {
            return false;
        }
        if (w <= 0 || h <= 0) {
            return false;
        }
        int mask = pi.getWindingRule() == 1 ? -1 : 2;
        int crossings = Curve.rectCrossingsForPath(pi, x, y, x + w, y + h);
        return crossings == Integer.MIN_VALUE || (crossings & mask) != 0;
    }

    public static boolean intersects(IPathIterator pi, Rectangle r) {
        return Path.intersects(pi, r.x, r.y, r.width, r.height);
    }

    @Override
    public final boolean intersects(int x, int y, int w, int h) {
        if (Double.isNaN(x + w) || Double.isNaN(y + h)) {
            return false;
        }
        if (w <= 0 || h <= 0) {
            return false;
        }
        int mask = this.windingRule == 1 ? -1 : 2;
        int crossings = this.rectCrossings(x, y, x + w, y + h);
        return crossings == Integer.MIN_VALUE || (crossings & mask) != 0;
    }

    @Override
    public final boolean intersects(Rectangle r) {
        return this.intersects(r.x, r.y, r.width, r.height);
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at, int flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    public final synchronized void moveTo(int x, int y) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            this.intCoords[this.numCoords - 2] = x;
            this.intCoords[this.numCoords - 1] = y;
        } else {
            this.needRoom(false, 2);
            this.pointTypes[this.numTypes++] = 0;
            this.intCoords[this.numCoords++] = x;
            this.intCoords[this.numCoords++] = y;
        }
    }

    public final synchronized void lineTo(int x, int y) {
        this.needRoom(true, 2);
        this.pointTypes[this.numTypes++] = 1;
        this.intCoords[this.numCoords++] = x;
        this.intCoords[this.numCoords++] = y;
    }

    public final synchronized void quadTo(int x1, int y1, int x2, int y2) {
        this.needRoom(true, 4);
        this.pointTypes[this.numTypes++] = 2;
        this.intCoords[this.numCoords++] = x1;
        this.intCoords[this.numCoords++] = y1;
        this.intCoords[this.numCoords++] = x2;
        this.intCoords[this.numCoords++] = y2;
    }

    public final synchronized void curveTo(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.needRoom(true, 6);
        this.pointTypes[this.numTypes++] = 3;
        this.intCoords[this.numCoords++] = x1;
        this.intCoords[this.numCoords++] = y1;
        this.intCoords[this.numCoords++] = x2;
        this.intCoords[this.numCoords++] = y2;
        this.intCoords[this.numCoords++] = x3;
        this.intCoords[this.numCoords++] = y3;
    }

    public final void append(IPathIterator pi, boolean connect) {
        int[] coords = new int[6];
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    if (!connect || this.numTypes < 1 || this.numCoords < 1) {
                        this.moveTo(coords[0], coords[1]);
                        break;
                    }
                    if (this.pointTypes[this.numTypes - 1] != 4 && this.intCoords[this.numCoords - 2] == coords[0] && this.intCoords[this.numCoords - 1] == coords[1]) break;
                }
                case 1: {
                    this.lineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    this.quadTo(coords[0], coords[1], coords[2], coords[3]);
                    break;
                }
                case 3: {
                    this.curveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    this.closePath();
                }
            }
            pi.next();
            connect = false;
        }
    }

    public final void transform(AffineTransform at) {
        at.transform(this.intCoords, 0, this.intCoords, 0, this.numCoords / 2);
    }

    @Override
    public final synchronized Rectangle getBounds() {
        int x1;
        int x2;
        int y1;
        int y2;
        int i = this.numCoords;
        if (i > 0) {
            y1 = y2 = this.intCoords[--i];
            x1 = x2 = this.intCoords[--i];
            while (i > 0) {
                int x;
                int y = this.intCoords[--i];
                if ((x = this.intCoords[--i]) < x1) {
                    x1 = x;
                }
                if (y < y1) {
                    y1 = y;
                }
                if (x > x2) {
                    x2 = x;
                }
                if (y <= y2) continue;
                y2 = y;
            }
        } else {
            y2 = 0;
            x2 = 0;
            y1 = 0;
            x1 = 0;
        }
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at) {
        if (at == null) {
            return new CopyIterator(this);
        }
        return new TxIterator(this, at);
    }

    public static String toSVG(IShape shape) {
        IPathIterator pathIterator = shape.getPathIterator(null);
        StringBuffer svgString = new StringBuffer("<path d='");
        int[] coords = new int[6];
        while (!pathIterator.isDone()) {
            int type = pathIterator.currentSegment(coords);
            switch (type) {
                case 4: {
                    svgString.append("Z ");
                    break;
                }
                case 3: {
                    svgString.append("C ");
                    svgString.append(coords[0] + " ");
                    svgString.append(coords[1] + " ");
                    svgString.append(coords[2] + " ");
                    svgString.append(coords[3] + " ");
                    svgString.append(coords[4] + " ");
                    svgString.append(coords[5]);
                    break;
                }
                case 1: {
                    svgString.append("L ");
                    svgString.append(coords[0] + " ");
                    svgString.append(coords[1]);
                    break;
                }
                case 0: {
                    svgString.append("M ");
                    svgString.append(coords[0] + " ");
                    svgString.append(coords[1]);
                    break;
                }
                case 2: {
                    svgString.append("Q ");
                    svgString.append(coords[0] + " ");
                    svgString.append(coords[1] + " ");
                    svgString.append(coords[2] + " ");
                    svgString.append(coords[3]);
                }
            }
            pathIterator.next();
        }
        svgString.append("' />");
        return svgString.toString();
    }

    private int pointCrossings(int px, int py) {
        int movy;
        int movx;
        int[] coords = this.intCoords;
        int curx = movx = coords[0];
        int cury = movy = coords[1];
        int crossings = 0;
        int ci = 2;
        block7: for (int i = 1; i < this.numTypes; ++i) {
            switch (this.pointTypes[i]) {
                case 0: {
                    if (cury != movy) {
                        crossings += Curve.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                    }
                    movx = curx = coords[ci++];
                    movy = cury = coords[ci++];
                    continue block7;
                }
                case 1: {
                    int endx = coords[ci++];
                    int endy = coords[ci++];
                    crossings += Curve.pointCrossingsForLine(px, py, curx, cury, endx, endy);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 2: {
                    int n = ci++;
                    int n2 = ci++;
                    int endx = coords[ci++];
                    int endy = coords[ci++];
                    crossings += Curve.pointCrossingsForQuad(px, py, curx, cury, coords[n], coords[n2], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 3: {
                    int n = ci++;
                    int n3 = ci++;
                    int n4 = ci++;
                    int n5 = ci++;
                    int endx = coords[ci++];
                    int endy = coords[ci++];
                    crossings += Curve.pointCrossingsForCubic(px, py, curx, cury, coords[n], coords[n3], coords[n4], coords[n5], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 4: {
                    if (cury != movy) {
                        crossings += Curve.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                    }
                    curx = movx;
                    cury = movy;
                }
            }
        }
        if (cury != movy) {
            crossings += Curve.pointCrossingsForLine(px, py, curx, cury, movx, movy);
        }
        return crossings;
    }

    private int[] cloneCoords(AffineTransform at) {
        int[] ret;
        if (at == null) {
            ret = Arrays.copyOf(this.intCoords, this.intCoords.length);
        } else {
            ret = new int[this.intCoords.length];
            at.transform(this.intCoords, 0, ret, 0, this.numCoords / 2);
        }
        return ret;
    }

    private Point getPoint(int coordindex) {
        Point pt = new Point();
        pt.x = this.intCoords[coordindex];
        pt.y = this.intCoords[coordindex + 1];
        return pt;
    }

    private void needRoom(boolean needMove, int newCoords) {
        int grow;
        if (needMove && this.numTypes == 0) {
            throw new IllegalPathStateException("missing initial moveto in path definition");
        }
        int size = this.pointTypes.length;
        if (this.numTypes >= size) {
            grow = size;
            if (grow > 500) {
                grow = 500;
            }
            this.pointTypes = Arrays.copyOf(this.pointTypes, size + grow);
        }
        if (this.numCoords + newCoords > (size = this.intCoords.length)) {
            grow = size;
            if (grow > 1000) {
                grow = 1000;
            }
            if (grow < newCoords) {
                grow = newCoords;
            }
            this.intCoords = Arrays.copyOf(this.intCoords, size + grow);
        }
    }

    private int rectCrossings(int rxmin, int rymin, int rxmax, int rymax) {
        int movy;
        int movx;
        int[] coords = this.intCoords;
        int curx = movx = coords[0];
        int cury = movy = coords[1];
        int crossings = 0;
        int ci = 2;
        block7: for (int i = 1; crossings != Integer.MIN_VALUE && i < this.numTypes; ++i) {
            switch (this.pointTypes[i]) {
                case 0: {
                    if (curx != movx || cury != movy) {
                        crossings = Curve.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
                    }
                    movx = curx = coords[ci++];
                    movy = cury = coords[ci++];
                    continue block7;
                }
                case 1: {
                    int endx = coords[ci++];
                    int endy = coords[ci++];
                    crossings = Curve.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, endx, endy);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 2: {
                    int n = ci++;
                    int n2 = ci++;
                    int endx = coords[ci++];
                    int endy = coords[ci++];
                    crossings = Curve.rectCrossingsForQuad(crossings, rxmin, rymin, rxmax, rymax, curx, cury, coords[n], coords[n2], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 3: {
                    int n = ci++;
                    int n3 = ci++;
                    int n4 = ci++;
                    int n5 = ci++;
                    int endx = coords[ci++];
                    int endy = coords[ci++];
                    crossings = Curve.rectCrossingsForCubic(crossings, rxmin, rymin, rxmax, rymax, curx, cury, coords[n], coords[n3], coords[n4], coords[n5], endx, endy, 0);
                    curx = endx;
                    cury = endy;
                    continue block7;
                }
                case 4: {
                    if (curx != movx || cury != movy) {
                        crossings = Curve.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
                    }
                    curx = movx;
                    cury = movy;
                }
            }
        }
        if (crossings != Integer.MIN_VALUE && (curx != movx || cury != movy)) {
            crossings = Curve.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
        }
        return crossings;
    }

    static class TxIterator
    extends Iterator {
        int[] intCoords;
        AffineTransform affine;

        TxIterator(Path p2dd, AffineTransform at) {
            super(p2dd);
            this.intCoords = p2dd.intCoords;
            this.affine = at;
        }

        @Override
        public int currentSegment(int[] coords) {
            byte type = this.path.pointTypes[this.typeIdx];
            int numCoords = curvecoords[type];
            if (numCoords > 0) {
                this.affine.transform(this.intCoords, this.pointIdx, coords, 0, numCoords / 2);
            }
            return type;
        }
    }

    static class CopyIterator
    extends Iterator {
        int[] intCoords;

        CopyIterator(Path p2dd) {
            super(p2dd);
            this.intCoords = p2dd.intCoords;
        }

        @Override
        public int currentSegment(int[] coords) {
            byte type = this.path.pointTypes[this.typeIdx];
            int numCoords = curvecoords[type];
            if (numCoords > 0) {
                for (int i = 0; i < numCoords; ++i) {
                    coords[i] = this.intCoords[this.pointIdx + i];
                }
            }
            return type;
        }
    }

    static abstract class Iterator
    implements IPathIterator {
        int typeIdx;
        int pointIdx;
        Path path;
        static final int[] curvecoords = new int[]{2, 2, 4, 6, 0};

        Iterator(Path path) {
            this.path = path;
        }

        @Override
        public int getWindingRule() {
            return this.path.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.typeIdx >= this.path.numTypes;
        }

        @Override
        public void next() {
            byte type = this.path.pointTypes[this.typeIdx++];
            this.pointIdx += curvecoords[type];
        }
    }
}

