/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.Crossings;
import com.guidebee.drawing.geometry.Curve;
import com.guidebee.drawing.geometry.Rectangle;

final class Order1
extends Curve {
    private double x0;
    private double y0;
    private double x1;
    private double y1;
    private double xmin;
    private double xmax;

    public Order1(double x0, double y0, double x1, double y1, int direction) {
        super(direction);
        this.x0 = x0;
        this.y0 = y0;
        this.x1 = x1;
        this.y1 = y1;
        if (x0 < x1) {
            this.xmin = x0;
            this.xmax = x1;
        } else {
            this.xmin = x1;
            this.xmax = x0;
        }
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public double getXTop() {
        return this.x0;
    }

    @Override
    public double getYTop() {
        return this.y0;
    }

    @Override
    public double getXBot() {
        return this.x1;
    }

    @Override
    public double getYBot() {
        return this.y1;
    }

    @Override
    public double getXMin() {
        return this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getX0() {
        return this.direction == 1 ? this.x0 : this.x1;
    }

    @Override
    public double getY0() {
        return this.direction == 1 ? this.y0 : this.y1;
    }

    @Override
    public double getX1() {
        return this.direction == -1 ? this.x0 : this.x1;
    }

    @Override
    public double getY1() {
        return this.direction == -1 ? this.y0 : this.y1;
    }

    @Override
    public double XforY(double y) {
        if (this.x0 == this.x1 || y <= this.y0) {
            return this.x0;
        }
        if (y >= this.y1) {
            return this.x1;
        }
        return this.x0 + (y - this.y0) * (this.x1 - this.x0) / (this.y1 - this.y0);
    }

    @Override
    public double TforY(double y) {
        if (y <= this.y0) {
            return 0.0;
        }
        if (y >= this.y1) {
            return 1.0;
        }
        return (y - this.y0) / (this.y1 - this.y0);
    }

    @Override
    public double XforT(double t) {
        return this.x0 + t * (this.x1 - this.x0);
    }

    @Override
    public double YforT(double t) {
        return this.y0 + t * (this.y1 - this.y0);
    }

    @Override
    public double dXforT(double t, int deriv) {
        switch (deriv) {
            case 0: {
                return this.x0 + t * (this.x1 - this.x0);
            }
            case 1: {
                return this.x1 - this.x0;
            }
        }
        return 0.0;
    }

    @Override
    public double dYforT(double t, int deriv) {
        switch (deriv) {
            case 0: {
                return this.y0 + t * (this.y1 - this.y0);
            }
            case 1: {
                return this.y1 - this.y0;
            }
        }
        return 0.0;
    }

    @Override
    public double nextVertical(double t0, double t1) {
        return t1;
    }

    @Override
    public boolean accumulateCrossings(Crossings c) {
        double xend;
        double yend;
        double xstart;
        double ystart;
        double xlo = c.getXLo();
        double ylo = c.getYLo();
        double xhi = c.getXHi();
        double yhi = c.getYHi();
        if (this.xmin >= xhi) {
            return false;
        }
        if (this.y0 < ylo) {
            if (this.y1 <= ylo) {
                return false;
            }
            ystart = ylo;
            xstart = this.XforY(ylo);
        } else {
            if (this.y0 >= yhi) {
                return false;
            }
            ystart = this.y0;
            xstart = this.x0;
        }
        if (this.y1 > yhi) {
            yend = yhi;
            xend = this.XforY(yhi);
        } else {
            yend = this.y1;
            xend = this.x1;
        }
        if (xstart >= xhi && xend >= xhi) {
            return false;
        }
        if (xstart > xlo || xend > xlo) {
            return true;
        }
        c.record((int)(ystart + 0.5), (int)(yend + 0.5), this.direction);
        return false;
    }

    @Override
    public void enlarge(Rectangle r) {
        r.add((int)(this.x0 + 0.5), (int)(this.y0 + 0.5));
        r.add((int)(this.x1 + 0.5), (int)(this.y1 + 0.5));
    }

    @Override
    public Curve getSubCurve(double ystart, double yend, int dir) {
        if (ystart == this.y0 && yend == this.y1) {
            return this.getWithDirection(dir);
        }
        if (this.x0 == this.x1) {
            return new Order1(this.x0, ystart, this.x1, yend, dir);
        }
        double num = this.x0 - this.x1;
        double denom = this.y0 - this.y1;
        double xstart = this.x0 + (ystart - this.y0) * num / denom;
        double xend = this.x0 + (yend - this.y0) * num / denom;
        return new Order1(xstart, ystart, xend, yend, dir);
    }

    @Override
    public Curve getReversedCurve() {
        return new Order1(this.x0, this.y0, this.x1, this.y1, -this.direction);
    }

    @Override
    public int compareTo(Curve other, double[] yrange) {
        double y;
        if (!(other instanceof Order1)) {
            return super.compareTo(other, yrange);
        }
        Order1 c1 = (Order1)other;
        if (yrange[1] <= yrange[0]) {
            throw new RuntimeException("yrange already screwed up...");
        }
        yrange[1] = Math.min(Math.min(yrange[1], this.y1), c1.y1);
        if (yrange[1] <= yrange[0]) {
            throw new RuntimeException("backstepping from " + yrange[0] + " to " + yrange[1]);
        }
        if (this.xmax <= c1.xmin) {
            return this.xmin == c1.xmax ? 0 : -1;
        }
        if (this.xmin >= c1.xmax) {
            return 1;
        }
        double dxb = c1.x1 - c1.x0;
        double dya = this.y1 - this.y0;
        double dxa = this.x1 - this.x0;
        double dyb = c1.y1 - c1.y0;
        double denom = dxb * dya - dxa * dyb;
        if (denom != 0.0) {
            double num = (this.x0 - c1.x0) * dya * dyb - this.y0 * dxa * dyb + c1.y0 * dxb * dya;
            y = num / denom;
            if (y <= yrange[0]) {
                y = Math.min(this.y1, c1.y1);
            } else {
                if (y < yrange[1]) {
                    yrange[1] = y;
                }
                y = Math.max(this.y0, c1.y0);
            }
        } else {
            y = Math.max(this.y0, c1.y0);
        }
        return Order1.orderof(this.XforY(y), c1.XforY(y));
    }

    @Override
    public int getSegment(double[] coords) {
        if (this.direction == 1) {
            coords[0] = this.x1;
            coords[1] = this.y1;
        } else {
            coords[0] = this.x0;
            coords[1] = this.y0;
        }
        return 1;
    }
}

