/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.Curve;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.game.engine.collections.Vector;
import java.util.NoSuchElementException;

class AreaIterator
implements IPathIterator {
    private AffineTransform transform;
    private Vector curves;
    private int index;
    private Curve prevcurve;
    private Curve thiscurve;

    public AreaIterator(Vector curves, AffineTransform at) {
        this.curves = curves;
        this.transform = at;
        if (curves.size() >= 1) {
            this.thiscurve = (Curve)curves.get(0);
        }
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.prevcurve == null && this.thiscurve == null;
    }

    @Override
    public void next() {
        if (this.prevcurve != null) {
            this.prevcurve = null;
        } else {
            this.prevcurve = this.thiscurve;
            ++this.index;
            if (this.index < this.curves.size()) {
                this.thiscurve = (Curve)this.curves.get(this.index);
                if (this.thiscurve.getOrder() != 0 && this.prevcurve.getX1() == this.thiscurve.getX0() && this.prevcurve.getY1() == this.thiscurve.getY0()) {
                    this.prevcurve = null;
                }
            } else {
                this.thiscurve = null;
            }
        }
    }

    @Override
    public int currentSegment(int[] coords) {
        int numpoints;
        int segtype;
        if (this.prevcurve != null) {
            if (this.thiscurve == null || this.thiscurve.getOrder() == 0) {
                return 4;
            }
            coords[0] = (int)(this.thiscurve.getX0() + 0.5);
            coords[1] = (int)(this.thiscurve.getY0() + 0.5);
            segtype = 1;
            numpoints = 1;
        } else {
            if (this.thiscurve == null) {
                throw new NoSuchElementException("area iterator out of bounds");
            }
            double[] dblCoords = new double[coords.length];
            segtype = this.thiscurve.getSegment(dblCoords);
            numpoints = this.thiscurve.getOrder();
            if (numpoints == 0) {
                numpoints = 1;
            }
            for (int i = 0; i < coords.length; ++i) {
                coords[i] = (int)(dblCoords[i] + 0.5);
            }
        }
        if (this.transform != null) {
            this.transform.transform(coords, 0, coords, 0, numpoints);
        }
        return segtype;
    }
}

