/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing.geometry;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.AreaIterator;
import com.guidebee.drawing.geometry.AreaOp;
import com.guidebee.drawing.geometry.Crossings;
import com.guidebee.drawing.geometry.Curve;
import com.guidebee.drawing.geometry.FlatteningPathIterator;
import com.guidebee.drawing.geometry.IPathIterator;
import com.guidebee.drawing.geometry.IShape;
import com.guidebee.drawing.geometry.Point;
import com.guidebee.drawing.geometry.Rectangle;
import com.guidebee.game.engine.collections.Vector;
import java.util.Enumeration;

public class Area
implements IShape {
    private static Vector EmptyCurves = new Vector();
    private Vector curves;
    private Rectangle cachedBounds;

    public Area() {
        this.curves = EmptyCurves;
    }

    public Area(IShape s) {
        this.curves = s instanceof Area ? ((Area)s).curves : Area.pathToCurves(s.getPathIterator(null));
    }

    public void add(Area rhs) {
        this.curves = new AreaOp.AddOp().calculate(this.curves, rhs.curves);
        this.invalidateBounds();
    }

    public void subtract(Area rhs) {
        this.curves = new AreaOp.SubOp().calculate(this.curves, rhs.curves);
        this.invalidateBounds();
    }

    public void intersect(Area rhs) {
        this.curves = new AreaOp.IntOp().calculate(this.curves, rhs.curves);
        this.invalidateBounds();
    }

    public void exclusiveOr(Area rhs) {
        this.curves = new AreaOp.XorOp().calculate(this.curves, rhs.curves);
        this.invalidateBounds();
    }

    public void reset() {
        this.curves = new Vector();
        this.invalidateBounds();
    }

    public boolean isEmpty() {
        return this.curves.size() == 0;
    }

    public boolean isPolygonal() {
        Enumeration enu = this.curves.elements();
        while (enu.hasMoreElements()) {
            if (((Curve)enu.nextElement()).getOrder() <= 1) continue;
            return false;
        }
        return true;
    }

    public boolean isRectangular() {
        int size = this.curves.size();
        if (size == 0) {
            return true;
        }
        if (size > 3) {
            return false;
        }
        Curve c1 = (Curve)this.curves.get(1);
        Curve c2 = (Curve)this.curves.get(2);
        if (c1.getOrder() != 1 || c2.getOrder() != 1) {
            return false;
        }
        if (c1.getXTop() != c1.getXBot() || c2.getXTop() != c2.getXBot()) {
            return false;
        }
        return c1.getYTop() == c2.getYTop() && c1.getYBot() == c2.getYBot();
    }

    public boolean isSingular() {
        if (this.curves.size() < 3) {
            return true;
        }
        Enumeration enum_ = this.curves.elements();
        enum_.nextElement();
        while (enum_.hasMoreElements()) {
            if (((Curve)enum_.nextElement()).getOrder() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Rectangle getBounds() {
        return this.getCachedBounds().getBounds();
    }

    public boolean equals(Area other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        Vector c = new AreaOp.XorOp().calculate(this.curves, other.curves);
        return c.isEmpty();
    }

    public void transform(AffineTransform t) {
        if (t == null) {
            throw new NullPointerException("transform must not be null");
        }
        this.curves = Area.pathToCurves(this.getPathIterator(t));
        this.invalidateBounds();
    }

    public Area createTransformedArea(AffineTransform t) {
        Area a = new Area(this);
        a.transform(t);
        return a;
    }

    @Override
    public boolean contains(int x, int y) {
        if (!this.getCachedBounds().contains(x, y)) {
            return false;
        }
        Enumeration enum_ = this.curves.elements();
        int crossings = 0;
        while (enum_.hasMoreElements()) {
            Curve c = (Curve)enum_.nextElement();
            crossings += c.crossingsFor(x, y);
        }
        return crossings & true;
    }

    @Override
    public boolean contains(Point p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(int x, int y, int w, int h) {
        if (w < 0 || h < 0) {
            return false;
        }
        if (!this.getCachedBounds().contains(x, y, w, h)) {
            return false;
        }
        Crossings c = Crossings.findCrossings(this.curves, (double)x, (double)y, (double)(x + w), (double)(y + h));
        return c != null && c.covers(y, y + h);
    }

    @Override
    public boolean contains(Rectangle r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean intersects(int x, int y, int w, int h) {
        if (w < 0 || h < 0) {
            return false;
        }
        if (!this.getCachedBounds().intersects(x, y, w, h)) {
            return false;
        }
        Crossings c = Crossings.findCrossings(this.curves, (double)x, (double)y, (double)(x + w), (double)(y + h));
        return c == null || !c.isEmpty();
    }

    @Override
    public boolean intersects(Rectangle r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at) {
        return new AreaIterator(this.curves, at);
    }

    @Override
    public IPathIterator getPathIterator(AffineTransform at, int flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    private static Vector pathToCurves(IPathIterator pi) {
        Vector curves = new Vector();
        int windingRule = pi.getWindingRule();
        int[] coords = new int[23];
        double movx = 0.0;
        double movy = 0.0;
        double curx = 0.0;
        double cury = 0.0;
        while (!pi.isDone()) {
            switch (pi.currentSegment(coords)) {
                case 0: {
                    Curve.insertLine(curves, curx, cury, movx, movy);
                    curx = movx = (double)coords[0];
                    cury = movy = (double)coords[1];
                    Curve.insertMove(curves, movx, movy);
                    break;
                }
                case 1: {
                    double newx = coords[0];
                    double newy = coords[1];
                    Curve.insertLine(curves, curx, cury, newx, newy);
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 2: {
                    int i;
                    double newx = coords[2];
                    double newy = coords[3];
                    double[] dblCoords = new double[coords.length];
                    for (i = 0; i < coords.length; ++i) {
                        dblCoords[i] = coords[i];
                    }
                    Curve.insertQuad(curves, curx, cury, dblCoords);
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 3: {
                    int i;
                    double newx = coords[4];
                    double newy = coords[5];
                    double[] dblCoords = new double[coords.length];
                    for (i = 0; i < coords.length; ++i) {
                        dblCoords[i] = coords[i];
                    }
                    Curve.insertCubic(curves, curx, cury, dblCoords);
                    curx = newx;
                    cury = newy;
                    break;
                }
                case 4: {
                    Curve.insertLine(curves, curx, cury, movx, movy);
                    curx = movx;
                    cury = movy;
                }
            }
            pi.next();
        }
        Curve.insertLine(curves, curx, cury, movx, movy);
        AreaOp operator = windingRule == 0 ? new AreaOp.EOWindOp() : new AreaOp.NZWindOp();
        return operator.calculate(curves, EmptyCurves);
    }

    private void invalidateBounds() {
        this.cachedBounds = null;
    }

    private Rectangle getCachedBounds() {
        if (this.cachedBounds != null) {
            return this.cachedBounds;
        }
        Rectangle r = new Rectangle();
        if (this.curves.size() > 0) {
            Curve c = (Curve)this.curves.get(0);
            r.setRect((int)(c.getX0() + 0.5), (int)(c.getY0() + 0.5), 0, 0);
            for (int i = 1; i < this.curves.size(); ++i) {
                ((Curve)this.curves.get(i)).enlarge(r);
            }
        }
        this.cachedBounds = r;
        return this.cachedBounds;
    }
}

