/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing;

import com.guidebee.drawing.FontHeader;
import com.guidebee.drawing.FontIndex;
import com.guidebee.drawing.Glyph;
import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.IShape;
import com.guidebee.game.engine.collections.Hashtable;
import com.guidebee.game.engine.drawing.parser.PathParser;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class VectorFont {
    public static final int TEXT_DIR_LR = 1;
    public static final int TEXT_DIR_RL = 2;
    public static final int TEXT_DIR_TB = 3;
    private InputStream fontStream;
    private FontHeader fontHeader;
    private DataInputStream dis;
    private static int CACHE_SIZE = 256;
    private static int FONT_HEAD_SIZE = 128;
    private static final PathParser pathParser = new PathParser();
    private final Hashtable glyphs = new Hashtable(CACHE_SIZE);
    private static VectorFont systemFont;
    private static String[] GLYPH_PATHDATA;

    public VectorFont(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return;
        }
        this.fontStream = inputStream;
        if (!inputStream.markSupported()) {
            throw new IOException("Mark not supported");
        }
        this.dis = new DataInputStream(this.fontStream);
        this.dis.mark(100000000);
        this.fontHeader = new FontHeader();
        this.fontHeader.name = this.dis.readUTF();
        this.fontHeader.type = this.dis.readInt();
        this.fontHeader.leading = this.dis.readInt();
        this.fontHeader.ascent = this.dis.readInt();
        this.fontHeader.descent = this.dis.readInt();
        this.fontHeader.height = this.dis.readInt();
        this.fontHeader.maxAdvance = this.dis.readInt();
        this.fontHeader.maxDescent = this.dis.readInt();
        this.fontHeader.maxAscent = this.dis.readInt();
    }

    public String getName() {
        if (this == systemFont) {
            return "System";
        }
        return this.fontHeader.name;
    }

    public static VectorFont getSystemFont() {
        return systemFont;
    }

    public IShape[] getGlyphArray(int fontSize, char[] ac, int off, int len, int tdir) {
        return this.getGlyphArray(fontSize, ac, off, len, tdir, null);
    }

    public IShape[] getGlyphArray(int fontSize, char[] ac, int off, int len, int tdir, AffineTransform transform) {
        if (this != systemFont) {
            for (int i = off; i < off + len; ++i) {
                this.loadGlyph(ac[i]);
            }
        }
        IShape[] shapes = new IShape[len];
        double scale = (double)fontSize / 256.0;
        int startIndex = off;
        int step = 1;
        int counter = 0;
        switch (tdir) {
            case 3: {
                startIndex = off;
                step = 1;
                break;
            }
            case 2: {
                startIndex = off + len - 1;
                step = -1;
                break;
            }
            default: {
                startIndex = off;
                step = 1;
            }
        }
        int i = startIndex;
        int offsetX = 0;
        int offsetY = 0;
        while (counter < len) {
            Glyph glyph = (Glyph)this.glyphs.get(new Integer(ac[i]));
            if (glyph != null) {
                IShape shape;
                AffineTransform matrix = new AffineTransform();
                matrix.scale(scale, -scale);
                matrix.translate(0.0, -200.0);
                matrix.translate(offsetX, offsetY);
                if (tdir == 3) {
                    offsetX = 0;
                    offsetY -= 256;
                } else {
                    offsetX += glyph.width;
                    offsetY = 0;
                }
                if (transform != null) {
                    matrix.preConcatenate(transform);
                }
                shapes[counter] = shape = matrix.createTransformedShape(glyph.path);
            }
            ++counter;
            i += step;
        }
        return shapes;
    }

    public int getHeight() {
        if (this == systemFont) {
            return 16;
        }
        return this.fontHeader.height;
    }

    public int charWidth(char ch, int fontSize) {
        if (this != systemFont) {
            this.loadGlyph(ch);
        }
        double scale = (double)fontSize / 256.0;
        Glyph glyph = (Glyph)this.glyphs.get(new Integer(ch));
        if (glyph != null) {
            return (int)((double)glyph.width * scale + 0.5);
        }
        return fontSize;
    }

    public int charsWidth(char[] ch, int offset, int length, int fontSize) {
        int retVal = 0;
        for (int i = 0; i < length; ++i) {
            retVal += this.charWidth(ch[i + offset], fontSize);
        }
        return retVal;
    }

    private void loadGlyph(int unicode) {
        switch (this.fontHeader.type) {
            case 1: {
                this.loadEnglishGlyph(unicode);
                break;
            }
            case 2: {
                this.loadChineseGlyph(unicode);
            }
        }
    }

    private void loadEnglishGlyph(int unicode) {
        Integer key = new Integer(unicode);
        if (this.glyphs.get(key) == null) {
            try {
                FontIndex fontIndex = new FontIndex();
                this.dis.reset();
                this.dis.skipBytes(FONT_HEAD_SIZE + unicode * 8);
                fontIndex.offset = this.dis.readInt();
                fontIndex.length = this.dis.readShort();
                fontIndex.width = this.dis.readShort();
                this.dis.reset();
                this.dis.skipBytes(fontIndex.offset);
                fontIndex.pathString = this.dis.readUTF();
                Glyph glyph = new Glyph();
                glyph.path = pathParser.parsePath(fontIndex.pathString);
                glyph.width = fontIndex.width;
                this.glyphs.put(key, glyph);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void loadChineseGlyph(int unicode) {
        Integer key = new Integer(unicode);
        if (this.glyphs.get(key) == null) {
            try {
                int skipbytes = 0;
                if (unicode < 256) {
                    skipbytes = FONT_HEAD_SIZE + unicode * 8;
                } else {
                    int w;
                    char[] chinese = new char[]{(char)unicode};
                    String chin = new String(chinese);
                    byte[] china = chin.getBytes();
                    int q = (china[0] + 256) % 256;
                    int index = (q - 176) * 94 + (w = (china[1] + 256) % 256) - 161 + 256;
                    if (index < 0) {
                        return;
                    }
                    skipbytes = FONT_HEAD_SIZE + index * 8;
                }
                FontIndex fontIndex = new FontIndex();
                this.dis.reset();
                this.dis.skipBytes(skipbytes);
                fontIndex.offset = this.dis.readInt();
                fontIndex.length = this.dis.readShort();
                fontIndex.width = this.dis.readShort();
                this.dis.reset();
                this.dis.skipBytes(fontIndex.offset);
                fontIndex.pathString = this.dis.readUTF();
                Glyph glyph = new Glyph();
                glyph.path = pathParser.parsePath(fontIndex.pathString);
                glyph.width = fontIndex.width;
                this.glyphs.put(key, glyph);
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
        }
    }

    static {
        GLYPH_PATHDATA = new String[]{"M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "", "", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "", "M 86 146L 82 61Q 81 57 80 55Q 79 54 76 54Q 74 54 73 55Q 71 57 71 61L 66 146Q 66 149 66 150Q 66 154 69 157Q 72 160 76 160Q 81 160 84 157Q 87 154 87 150Q 87 149 86 146ZM 74 22L 79 22Q 84 22 88 18Q 92 14 92 9Q 92 3 88 0Q 84 -3 79 -3L 74 -3Q 69 -3 65 0Q 61 3 61 9Q 61 14 65 18Q 69 22 74 22Z", "M 33 154L 66 154L 57 93Q 57 88 55 86Q 53 84 49 84Q 46 84 44 86Q 42 88 42 93L 33 154ZM 86 154L 120 154L 111 93Q 110 88 108 86Q 106 84 103 84Q 100 84 98 86Q 96 88 95 93L 86 154Z", "M 100 92L 97 59L 117 59Q 121 59 123 58Q 124 56 124 54Q 124 51 123 50Q 121 49 117 49L 97 49L 92 -9Q 92 -13 91 -14Q 89 -16 87 -16L 85 -15Q 82 -13 82 -10L 82 -8L 86 49L 62 49L 58 -9Q 58 -13 57 -14Q 55 -16 53 -16L 51 -15Q 48 -13 48 -10L 48 -8L 52 49L 30 49Q 26 49 25 50Q 23 51 23 54Q 23 56 25 58Q 26 59 30 59L 53 59L 55 92L 35 92Q 31 92 30 93Q 28 95 28 97Q 28 100 30 101Q 31 103 35 103L 56 103L 60 161Q 60 165 61 166Q 63 168 65 168L 67 167Q 70 165 70 162L 70 160L 66 103L 90 103L 94 161Q 94 165 96 166Q 97 168 99 168L 101 167Q 105 165 105 162L 104 160L 100 103L 123 103Q 126 103 128 101Q 130 100 130 97Q 130 95 128 93Q 126 92 123 92L 100 92ZM 89 92L 65 92L 63 59L 87 59L 89 92Z", "M 71 149L 71 163Q 71 166 72 168Q 74 170 76 170Q 79 170 80 168Q 81 166 81 163L 81 149Q 90 149 95 147Q 101 145 108 140Q 109 143 110 144Q 112 146 114 146Q 116 146 118 144Q 119 143 119 139L 119 123Q 119 119 118 118Q 116 116 114 116Q 112 116 110 117Q 109 119 108 122Q 108 128 101 133Q 90 139 77 139Q 62 139 53 131Q 44 123 44 112Q 44 102 52 97Q 58 92 78 89Q 98 85 105 82Q 115 77 120 70Q 125 62 125 52Q 125 37 113 27Q 102 16 81 14L 81 -16Q 81 -20 80 -22Q 79 -23 76 -23Q 74 -23 72 -22Q 71 -20 71 -16L 71 14Q 52 15 39 26Q 39 21 38 19Q 38 18 36 17Q 35 16 33 16Q 31 16 30 18Q 28 20 28 23L 28 44Q 28 48 29 49Q 31 51 33 51Q 36 51 37 49Q 38 48 39 44Q 39 38 49 31Q 59 24 76 24Q 94 24 104 32Q 114 41 114 52Q 114 59 110 64Q 107 70 99 73Q 93 75 77 78Q 52 83 43 91Q 33 98 33 113Q 33 126 44 137Q 54 147 71 149Z", "M 92 127Q 92 113 83 104Q 73 94 60 94Q 47 94 38 104Q 28 113 28 127Q 28 140 38 149Q 47 159 60 159Q 74 159 83 149Q 92 140 92 127ZM 85 127Q 85 137 78 144Q 70 151 60 151Q 50 151 43 144Q 36 137 36 127Q 36 116 43 109Q 50 102 60 102Q 70 102 78 109Q 85 116 85 127ZM 126 90L 29 59Q 27 58 26 58Q 25 58 24 59Q 23 60 23 62Q 23 63 24 64Q 24 65 27 66L 124 97Q 126 98 127 98Q 128 98 129 97Q 130 96 130 94Q 130 93 129 92Q 129 91 126 90ZM 125 29Q 125 15 115 6Q 106 -3 93 -3Q 79 -3 70 6Q 61 16 61 29Q 61 42 70 52Q 79 61 93 61Q 106 61 115 52Q 125 42 125 29ZM 117 29Q 117 39 110 47Q 103 54 93 54Q 82 54 75 47Q 68 39 68 29Q 68 19 75 11Q 82 4 93 4Q 103 4 110 11Q 117 19 117 29Z", "M 106 0L 98 12Q 87 -4 69 -4Q 54 -4 43 7Q 31 19 31 36Q 31 50 39 60Q 47 70 60 74Q 51 89 49 94Q 47 98 47 103Q 47 116 57 125Q 66 134 79 134Q 83 134 88 133Q 92 132 96 129Q 102 132 103 132Q 105 132 106 130Q 108 129 108 127Q 108 125 107 124Q 106 123 104 121L 96 117Q 92 120 88 122Q 84 124 79 124Q 71 124 64 117Q 58 111 58 103Q 58 95 69 77L 98 31Q 106 45 110 64L 120 64Q 124 64 126 63Q 127 61 127 59Q 127 57 126 56Q 125 55 124 54Q 123 54 118 54Q 112 32 104 21L 111 10L 120 10Q 124 10 126 9Q 127 7 127 5Q 127 3 126 1Q 124 0 120 0L 106 0ZM 65 65Q 54 62 48 55Q 42 47 42 36Q 42 24 50 15Q 58 6 69 6Q 83 6 92 22L 65 65Z", "M 60 156L 93 156L 84 91Q 83 86 81 83Q 79 81 76 81Q 73 81 71 83Q 69 86 68 91L 60 156Z", "M 75 62Q 75 76 79 92Q 83 108 93 130Q 104 151 109 155Q 110 156 112 156Q 114 156 116 155Q 117 153 117 151Q 117 150 117 149Q 103 123 97 103Q 91 82 91 62Q 91 41 97 21Q 103 0 117 -24Q 117 -26 117 -27Q 117 -29 116 -30Q 114 -32 112 -32Q 110 -32 109 -31Q 104 -26 94 -6Q 83 14 79 30Q 75 46 75 62Z", "M 79 62Q 79 47 76 31Q 72 15 61 -5Q 51 -26 46 -31Q 44 -32 43 -32Q 40 -32 39 -30Q 37 -29 37 -27Q 37 -26 38 -24Q 52 0 58 21Q 64 41 64 62Q 64 82 58 103Q 52 123 38 149Q 37 150 37 151Q 37 153 39 155Q 40 156 43 156Q 44 156 46 155Q 50 151 61 130Q 71 110 75 94Q 79 78 79 62Z", "M 71 113L 71 149Q 71 153 72 155Q 74 156 76 156Q 78 156 80 155Q 81 153 81 149L 81 113L 115 125Q 118 125 119 125Q 121 125 122 124Q 124 122 124 120Q 124 118 123 117Q 122 115 119 114L 84 103L 106 74Q 108 71 108 70Q 108 68 106 66Q 104 64 102 64Q 100 64 97 68L 76 97L 55 68Q 52 64 49 64Q 47 64 46 66Q 44 68 44 70Q 44 71 46 74L 67 103L 33 115Q 30 116 29 117Q 28 118 28 120Q 28 122 29 124Q 31 125 33 125Q 34 125 36 125L 71 113Z", "M 82 67L 82 15Q 82 11 80 10Q 79 8 76 8Q 74 8 73 10Q 71 11 71 15L 71 67L 25 67Q 21 67 19 69Q 18 70 18 73Q 18 75 19 76Q 21 78 25 78L 71 78L 71 130Q 71 134 73 136Q 74 137 76 137Q 79 137 80 136Q 82 134 82 130L 82 78L 128 78Q 132 78 134 76Q 135 75 135 73Q 135 70 134 69Q 132 67 128 67L 82 67Z", "M 56 37L 90 37L 53 -31Q 49 -37 44 -37Q 41 -37 39 -35Q 37 -33 37 -30Q 37 -28 37 -27L 56 37Z", "M 130 79L 130 64L 23 64L 23 79L 130 79Z", "M 74 30L 79 30Q 86 30 91 25Q 96 20 96 13Q 96 6 91 1Q 86 -3 79 -3L 74 -3Q 67 -3 62 1Q 57 6 57 13Q 57 20 62 25Q 67 30 74 30Z", "M 124 164L 39 -16Q 37 -21 34 -21Q 31 -21 30 -19Q 28 -18 28 -16Q 28 -14 30 -12L 114 169Q 115 171 117 172Q 118 173 120 173Q 122 173 123 172Q 125 170 125 168Q 125 167 124 164Z", "M 125 91L 125 65Q 125 31 108 11Q 96 -3 77 -3Q 67 -3 59 0Q 51 3 45 10Q 42 14 37 23Q 33 32 31 40Q 28 51 28 65L 28 91Q 28 125 44 145Q 57 160 76 160Q 86 160 94 156Q 102 153 108 146Q 111 142 116 133Q 120 124 122 116Q 125 105 125 91ZM 114 90Q 114 104 110 117Q 106 130 100 138Q 97 142 92 145Q 85 150 76 150Q 59 150 49 132Q 39 114 39 90L 39 66Q 39 52 43 39Q 47 26 52 18Q 55 14 60 11Q 68 6 77 6Q 94 6 104 24Q 114 42 114 66L 114 90Z", "M 82 159L 82 10L 118 10Q 121 10 123 9Q 125 7 125 5Q 125 3 123 1Q 121 0 118 0L 35 0Q 31 0 30 1Q 28 3 28 5Q 28 7 30 9Q 31 10 35 10L 71 10L 71 144L 37 133Q 34 133 33 133Q 31 133 30 134Q 28 136 28 138Q 28 140 29 141Q 30 142 34 143L 82 159Z", "M 31 10L 112 10L 112 14Q 112 18 113 20Q 115 21 117 21Q 119 21 121 20Q 122 18 122 14L 122 0L 21 0L 21 15Q 53 44 83 74Q 97 87 103 94Q 108 100 110 105Q 112 110 112 115Q 112 129 101 139Q 90 150 75 150Q 61 150 50 142Q 40 134 36 122Q 36 119 35 118Q 33 117 31 117Q 29 117 27 118Q 26 120 26 122Q 26 128 33 138Q 39 148 51 154Q 62 160 74 160Q 94 160 108 147Q 122 133 122 116Q 122 108 120 102Q 118 96 112 89Q 106 82 91 67Q 54 31 31 11L 31 10Z", "M 98 85Q 112 78 120 67Q 128 56 128 44Q 128 25 112 10Q 97 -3 74 -3Q 61 -3 46 2Q 32 7 26 13Q 24 15 24 18Q 24 20 25 21Q 27 23 29 23Q 31 23 33 21Q 53 6 74 6Q 93 6 105 18Q 117 29 117 43Q 117 53 111 62Q 105 71 94 76Q 82 81 71 81Q 67 81 65 82Q 64 84 64 86Q 64 88 65 90Q 67 91 70 91L 79 91Q 93 91 102 100Q 111 109 111 120Q 111 132 102 141Q 92 150 77 150Q 66 150 57 146Q 48 142 42 136Q 40 133 39 133Q 38 132 37 132Q 34 132 33 133Q 31 135 31 137Q 31 142 42 150Q 57 160 77 160Q 97 160 109 148Q 122 136 122 120Q 122 109 116 100Q 110 91 98 85Z", "M 96 43L 26 43L 26 56L 85 156L 107 156L 107 54L 115 54Q 119 54 121 52Q 122 51 122 49Q 122 46 121 45Q 119 43 115 43L 107 43L 107 10L 115 10Q 119 10 121 9Q 122 7 122 5Q 122 3 121 1Q 119 0 115 0L 76 0Q 72 0 71 1Q 69 3 69 5Q 69 7 71 9Q 72 10 76 10L 96 10L 96 43ZM 96 54L 96 146L 90 146L 37 54L 96 54Z", "M 47 146L 47 94Q 57 98 65 100Q 74 102 81 102Q 101 102 114 88Q 128 74 128 52Q 128 27 113 11Q 98 -3 75 -3Q 60 -3 47 2Q 37 7 29 14Q 24 18 24 21Q 24 23 26 25Q 27 26 29 26Q 31 26 34 24Q 52 6 75 6Q 93 6 105 19Q 117 31 117 52Q 117 70 107 81Q 96 92 80 92Q 64 92 48 83Q 44 81 42 81Q 40 81 38 83Q 37 84 37 87L 37 156L 110 156Q 114 156 116 155Q 117 153 117 151Q 117 149 116 147Q 114 146 110 146L 47 146Z", "M 45 66Q 55 80 65 87Q 75 94 88 94Q 105 94 118 80Q 131 66 131 46Q 131 27 119 11Q 107 -3 86 -3Q 73 -3 61 4Q 49 13 42 30Q 34 52 34 78Q 34 98 42 115Q 48 128 58 138Q 68 148 81 154Q 94 160 110 160Q 120 160 127 156Q 130 154 130 151Q 130 149 129 147Q 128 146 125 146Q 124 146 122 147Q 116 150 109 150Q 84 150 64 129Q 44 108 44 79Q 44 75 45 66ZM 47 49Q 52 26 62 16Q 73 6 86 6Q 100 6 110 17Q 120 28 120 46Q 120 62 110 73Q 100 84 88 84Q 76 84 64 73Q 57 66 47 49Z", "M 112 141L 112 146L 36 146L 36 137Q 36 133 35 131Q 34 130 31 130Q 29 130 27 131Q 26 133 26 137L 26 156L 122 156L 122 140L 80 5Q 79 1 78 0Q 76 0 75 0Q 72 0 71 1Q 69 2 69 4Q 69 6 70 8L 112 141Z", "M 98 81Q 111 75 118 64Q 124 54 124 42Q 124 23 110 9Q 96 -3 76 -3Q 56 -3 42 9Q 28 23 28 42Q 28 54 35 64Q 42 74 55 81Q 44 88 38 95Q 31 105 31 117Q 31 134 44 147Q 58 160 76 160Q 95 160 109 147Q 122 134 122 117Q 122 105 115 95Q 109 88 98 81ZM 111 117Q 111 130 101 140Q 91 150 76 150Q 62 150 52 140Q 42 130 42 117Q 42 105 52 95Q 62 86 76 86Q 91 86 101 95Q 111 105 111 117ZM 114 41Q 114 55 103 66Q 92 76 76 76Q 60 76 50 66Q 39 55 39 42Q 39 27 50 17Q 61 6 76 6Q 92 6 103 17Q 114 27 114 41Z", "M 119 88Q 111 74 100 67Q 89 59 77 59Q 66 59 56 66Q 46 72 40 84Q 34 96 34 109Q 34 129 46 144Q 58 160 78 160Q 92 160 104 151Q 116 142 122 126Q 130 104 130 75Q 130 53 123 38Q 119 28 109 19Q 100 10 89 4Q 73 -3 56 -3Q 45 -3 38 0Q 34 2 34 5Q 34 7 36 9Q 37 10 39 10Q 41 10 44 9Q 49 6 55 6Q 82 6 101 25Q 120 45 120 74Q 120 79 119 88ZM 117 106Q 111 131 101 140Q 91 150 78 150Q 65 150 55 138Q 44 127 44 109Q 44 92 55 81Q 65 70 77 70Q 85 70 92 74Q 99 78 106 86Q 110 91 117 106Z", "M 74 108L 79 108Q 86 108 91 103Q 96 98 96 91Q 96 84 91 79Q 86 74 79 74L 74 74Q 67 74 62 79Q 57 84 57 91Q 57 98 62 103Q 67 108 74 108ZM 74 30L 79 30Q 86 30 91 25Q 96 20 96 13Q 96 6 91 1Q 86 -3 79 -3L 74 -3Q 67 -3 62 1Q 57 6 57 13Q 57 20 62 25Q 67 30 74 30Z", "M 74 108L 79 108Q 86 108 91 103Q 96 98 96 91Q 96 84 91 79Q 86 74 79 74L 74 74Q 67 74 62 79Q 57 84 57 91Q 57 98 62 103Q 67 108 74 108ZM 56 37L 89 37L 53 -20Q 51 -24 49 -25Q 48 -26 46 -26Q 43 -26 41 -24Q 39 -23 39 -20Q 39 -18 39 -16L 56 37Z", "M 12 72L 125 136Q 128 137 129 137Q 132 137 133 136Q 135 134 135 132Q 135 129 130 126L 33 72L 130 18Q 135 16 135 13Q 135 11 133 9Q 131 8 129 8Q 128 8 125 9L 12 72Z", "M 134 86L 19 86Q 15 86 14 88Q 12 89 12 92Q 12 94 14 96Q 15 97 19 97L 134 97Q 137 97 139 96Q 141 94 141 92Q 141 89 139 88Q 137 86 134 86ZM 134 49L 19 49Q 15 49 14 50Q 12 52 12 54Q 12 56 14 58Q 15 59 19 59L 134 59Q 137 59 139 58Q 141 56 141 54Q 141 52 139 50Q 137 49 134 49Z", "M 141 72L 27 9Q 25 8 23 8Q 21 8 20 9Q 18 11 18 13Q 18 16 22 18L 120 72L 22 126Q 18 129 18 132Q 18 134 20 136Q 21 137 23 137Q 25 137 28 136L 141 72Z", "M 82 64L 82 53Q 82 49 81 48Q 79 46 77 46Q 74 46 73 48Q 71 49 71 53L 71 71Q 99 81 109 91Q 114 97 114 105Q 114 119 104 129Q 94 139 78 139Q 70 139 62 137Q 55 135 44 130L 44 119Q 44 116 43 114Q 42 112 39 112Q 37 112 35 114Q 34 116 34 119L 34 137Q 53 146 59 147Q 69 150 79 150Q 100 150 112 137Q 125 125 125 105Q 125 94 117 85Q 110 76 82 64ZM 71 22L 82 22Q 87 22 91 18Q 95 14 95 9Q 95 3 91 0Q 87 -3 82 -3L 71 -3Q 66 -3 62 0Q 58 3 58 9Q 58 14 62 18Q 66 22 71 22Z", "M 107 37L 107 39Q 104 38 101 38Q 99 38 96 38Q 81 38 71 47Q 61 57 61 70Q 61 86 73 97Q 86 108 107 108L 107 120Q 107 134 98 142Q 90 151 77 151Q 68 151 60 147Q 55 143 52 139Q 46 131 41 120Q 37 109 37 93L 37 51Q 37 27 48 10Q 59 -5 78 -5Q 97 -5 106 3Q 109 5 111 5Q 113 5 114 3Q 116 2 116 0Q 116 -3 108 -8Q 96 -16 77 -16Q 67 -16 58 -12Q 50 -8 45 -2Q 41 1 36 10Q 31 20 29 27Q 26 37 26 51L 26 93Q 26 125 43 145Q 57 162 77 162Q 87 162 96 157Q 104 153 111 143Q 117 133 117 120L 117 48Q 120 48 121 46Q 122 45 122 43Q 122 41 122 40Q 121 38 120 38Q 118 37 115 37L 107 37ZM 107 97Q 90 97 81 89Q 72 81 72 70Q 72 61 79 55Q 85 48 98 48Q 100 48 102 48Q 104 49 107 49L 107 97Z", "M 111 48L 42 48L 28 10L 48 10Q 52 10 53 9Q 55 7 55 5Q 55 3 53 1Q 52 0 48 0L 9 0Q 5 0 3 1Q 2 3 2 5Q 2 7 3 9Q 5 10 9 10L 17 10L 63 135L 32 135Q 28 135 27 137Q 25 138 25 141Q 25 143 27 144Q 28 146 32 146L 85 146L 136 10L 144 10Q 148 10 150 9Q 151 7 151 5Q 151 3 150 1Q 148 0 144 0L 105 0Q 101 0 100 1Q 98 3 98 5Q 98 7 100 9Q 101 10 105 10L 125 10L 111 48ZM 107 59L 78 135L 74 135L 46 59L 107 59Z", "M 32 10L 32 135L 17 135Q 14 135 12 137Q 10 138 10 141Q 10 143 12 144Q 14 146 17 146L 83 146Q 103 146 115 134Q 128 123 128 108Q 128 89 107 77Q 123 71 131 61Q 139 51 139 40Q 139 29 134 20Q 129 12 118 6Q 108 0 96 0L 17 0Q 14 0 12 1Q 10 3 10 5Q 10 7 12 9Q 14 10 17 10L 32 10ZM 42 81L 79 81Q 91 81 101 85Q 109 89 113 95Q 117 102 117 109Q 117 119 108 127Q 99 135 84 135L 42 135L 42 81ZM 42 10L 95 10Q 105 10 113 15Q 120 19 124 26Q 128 32 128 39Q 128 47 122 55Q 117 62 107 66Q 97 70 80 70L 42 70L 42 10Z", "M 123 131L 123 139Q 123 143 124 144Q 125 146 128 146Q 130 146 132 144Q 133 143 133 139L 133 110Q 133 106 132 104Q 130 103 128 103Q 126 103 124 104Q 123 106 123 109Q 122 119 111 128Q 97 139 78 139Q 66 139 55 133Q 47 129 43 124Q 34 114 29 102Q 26 93 26 82L 26 64Q 26 41 43 23Q 60 6 82 6Q 96 6 107 12Q 117 18 127 30Q 129 32 132 32Q 134 32 136 31Q 137 29 137 27Q 137 24 132 19Q 121 7 109 1Q 96 -4 83 -4Q 71 -4 60 0Q 51 3 45 8Q 39 12 30 23Q 22 34 19 43Q 15 52 15 63L 15 84Q 15 99 24 116Q 32 132 46 140Q 61 149 78 149Q 104 149 123 131Z", "M 35 10L 35 135L 26 135Q 23 135 21 137Q 19 138 19 141Q 19 143 21 144Q 23 146 26 146L 83 146Q 96 146 107 140Q 118 135 124 128Q 134 116 139 103Q 142 93 142 80L 142 65Q 142 49 135 34Q 128 19 111 8Q 99 0 83 0L 26 0Q 23 0 21 1Q 19 3 19 5Q 19 7 21 9Q 23 10 26 10L 35 10ZM 46 10L 84 10Q 97 10 109 19Q 120 27 126 39Q 132 51 132 63L 132 82Q 132 92 129 100Q 124 111 116 121Q 111 126 103 131Q 94 135 84 135L 46 135L 46 10Z", "M 42 70L 42 10L 123 10L 123 41Q 123 45 124 46Q 126 48 128 48Q 131 48 132 46Q 133 45 133 41L 133 0L 18 0Q 14 0 12 1Q 11 3 11 5Q 11 7 12 9Q 14 10 18 10L 32 10L 32 135L 18 135Q 14 135 12 137Q 11 138 11 141Q 11 143 12 144Q 14 146 18 146L 128 146L 128 110Q 128 106 126 104Q 125 103 123 103Q 120 103 119 104Q 117 106 117 110L 117 135L 42 135L 42 81L 80 81L 80 93Q 80 96 81 98Q 83 100 85 100Q 87 100 89 98Q 90 96 90 93L 90 58Q 90 55 89 53Q 87 51 85 51Q 83 51 81 53Q 80 55 80 58L 80 70L 42 70Z", "M 51 70L 51 10L 87 10Q 91 10 92 9Q 94 7 94 5Q 94 3 92 1Q 91 0 87 0L 26 0Q 23 0 21 1Q 19 3 19 5Q 19 7 21 9Q 23 10 26 10L 41 10L 41 135L 26 135Q 23 135 21 137Q 19 138 19 141Q 19 143 21 145Q 23 146 26 146L 142 146L 142 110Q 142 106 141 104Q 139 103 137 103Q 134 103 133 104Q 131 106 131 110L 131 135L 51 135L 51 81L 89 81L 89 93Q 89 96 90 98Q 92 100 94 100Q 96 100 98 98Q 99 96 99 93L 99 58Q 99 55 98 53Q 96 51 94 51Q 92 51 90 53Q 89 55 89 58L 89 70L 51 70Z", "M 133 54L 133 9Q 121 2 109 0Q 98 -4 86 -4Q 69 -4 56 0Q 43 5 34 14Q 25 23 20 35Q 16 46 16 63L 16 82Q 16 99 24 116Q 33 132 48 141Q 62 149 80 149Q 105 149 123 135Q 123 141 123 143Q 124 144 125 145Q 126 146 128 146Q 130 146 132 144Q 133 143 133 139L 133 115Q 133 111 132 110Q 130 108 128 108Q 126 108 125 109Q 123 111 123 115Q 122 125 109 132Q 96 139 81 139Q 66 139 55 132Q 43 126 33 108Q 26 97 26 82L 26 63Q 26 37 42 21Q 58 6 86 6Q 96 6 104 8Q 112 10 123 15L 123 54L 87 54Q 83 54 81 55Q 80 57 80 59Q 80 61 81 63Q 83 64 87 64L 137 64Q 141 64 143 63Q 144 61 144 59Q 144 57 143 56Q 142 55 141 54Q 140 54 133 54Z", "M 112 70L 42 70L 42 10L 56 10Q 60 10 62 9Q 63 7 63 5Q 63 3 62 1Q 60 0 56 0L 20 0Q 16 0 15 1Q 13 3 13 5Q 13 7 15 9Q 16 10 20 10L 32 10L 32 135L 25 135Q 21 135 20 137Q 18 138 18 141Q 18 143 20 144Q 21 146 25 146L 56 146Q 60 146 62 144Q 63 143 63 141Q 63 138 62 137Q 60 135 56 135L 42 135L 42 81L 112 81L 112 135L 98 135Q 94 135 93 137Q 91 138 91 141Q 91 143 92 144Q 94 146 98 146L 129 146Q 133 146 135 144Q 136 143 136 141Q 136 138 135 137Q 133 135 129 135L 123 135L 123 10L 134 10Q 138 10 140 9Q 141 7 141 5Q 141 3 140 1Q 138 0 134 0L 98 0Q 94 0 93 1Q 91 3 91 5Q 91 7 92 9Q 94 10 98 10L 112 10L 112 70Z", "M 82 135L 82 10L 118 10Q 121 10 123 9Q 125 7 125 5Q 125 3 123 1Q 121 0 118 0L 35 0Q 31 0 30 1Q 28 3 28 5Q 28 7 30 9Q 31 10 35 10L 71 10L 71 135L 35 135Q 31 135 30 137Q 28 138 28 141Q 28 143 30 144Q 31 146 35 146L 118 146Q 121 146 123 144Q 125 143 125 141Q 125 138 123 137Q 121 135 118 135L 82 135Z", "M 117 135L 117 43Q 117 23 103 9Q 89 -4 69 -4Q 57 -4 46 1Q 34 6 21 19L 21 57Q 21 61 22 63Q 24 64 26 64Q 29 64 30 63Q 32 61 32 57L 31 24Q 41 15 50 10Q 60 6 69 6Q 79 6 89 11Q 95 15 101 24Q 107 32 107 43L 107 135L 66 135Q 62 135 60 137Q 59 138 59 141Q 59 143 60 144Q 62 146 66 146L 142 146Q 146 146 148 144Q 149 143 149 141Q 149 138 148 137Q 146 135 142 135L 117 135Z", "M 42 57L 42 10L 62 10Q 66 10 67 9Q 69 7 69 5Q 69 3 67 1Q 66 0 62 0L 18 0Q 14 0 12 1Q 11 3 11 5Q 11 7 12 9Q 14 10 18 10L 32 10L 32 135L 18 135Q 14 135 12 137Q 11 138 11 141Q 11 143 12 144Q 14 146 18 146L 62 146Q 66 146 67 144Q 69 143 69 141Q 69 138 67 137Q 66 135 62 135L 42 135L 42 71L 115 135L 103 135Q 99 135 98 137Q 96 138 96 141Q 96 143 98 144Q 99 146 103 146L 134 146Q 138 146 140 144Q 141 143 141 141Q 141 138 140 137Q 138 135 134 135L 130 135L 72 84Q 85 78 94 71Q 102 63 110 48Q 114 40 126 10L 140 10Q 143 10 145 9Q 147 7 147 5Q 147 3 145 1Q 143 0 140 0L 119 0Q 103 45 92 58Q 80 71 63 76L 42 57Z", "M 58 135L 58 10L 128 10L 128 52Q 128 56 129 57Q 131 59 133 59Q 136 59 137 57Q 139 56 139 52L 139 0L 23 0Q 19 0 17 1Q 16 3 16 5Q 16 7 17 9Q 19 10 23 10L 48 10L 48 135L 23 135Q 19 135 17 137Q 16 138 16 141Q 16 143 17 144Q 19 146 23 146L 83 146Q 87 146 89 144Q 90 143 90 141Q 90 138 89 137Q 87 135 83 135L 58 135Z", "M 83 43L 71 43L 31 135L 29 135L 29 10L 48 10Q 52 10 54 9Q 55 7 55 5Q 55 3 54 1Q 52 0 48 0L 10 0Q 6 0 4 1Q 3 3 3 5Q 3 7 4 9Q 6 10 10 10L 18 10L 18 135L 12 135Q 8 135 6 137Q 5 138 5 141Q 5 143 6 144Q 8 146 12 146L 38 146L 77 55L 116 146L 142 146Q 146 146 148 144Q 149 143 149 141Q 149 138 148 137Q 146 135 142 135L 136 135L 136 10L 144 10Q 148 10 150 9Q 152 7 152 5Q 152 3 150 1Q 148 0 144 0L 106 0Q 102 0 100 1Q 99 3 99 5Q 99 7 100 9Q 102 10 106 10L 125 10L 125 135L 123 135L 83 43Z", "M 128 0L 114 0L 37 130L 37 10L 56 10Q 60 10 62 9Q 63 7 63 5Q 63 3 62 1Q 60 0 56 0L 18 0Q 14 0 12 1Q 11 3 11 5Q 11 7 12 9Q 14 10 18 10L 26 10L 26 135L 12 135Q 9 135 7 137Q 5 138 5 141Q 5 143 7 144Q 9 146 12 146L 40 146L 117 15L 117 135L 98 135Q 94 135 93 137Q 91 138 91 141Q 91 143 92 144Q 94 146 98 146L 137 146Q 140 146 142 144Q 144 143 144 141Q 144 138 142 137Q 140 135 137 135L 128 135L 128 0Z", "M 141 72Q 141 51 132 33Q 124 15 109 5Q 94 -4 77 -4Q 51 -4 32 17Q 13 39 13 72Q 13 106 32 128Q 51 149 77 149Q 94 149 109 139Q 123 129 132 111Q 141 93 141 72ZM 130 72Q 130 98 115 118Q 100 139 77 139Q 54 139 39 119Q 23 100 23 72Q 23 43 39 24Q 56 6 77 6Q 100 6 115 26Q 130 47 130 72Z", "M 54 60L 54 10L 90 10Q 93 10 95 9Q 97 7 97 5Q 97 3 95 1Q 93 0 90 0L 29 0Q 25 0 24 1Q 22 3 22 5Q 22 7 24 9Q 25 10 29 10L 43 10L 43 135L 29 135Q 25 135 24 137Q 22 138 22 141Q 22 143 24 144Q 25 146 29 146L 90 146Q 112 146 125 133Q 139 120 139 103Q 139 93 134 85Q 130 77 124 72Q 114 65 104 62Q 97 60 86 60L 54 60ZM 54 70L 87 70Q 99 70 109 75Q 119 80 124 88Q 128 95 128 103Q 128 116 118 125Q 107 135 91 135L 54 135L 54 70Z", "M 78 -4L 64 -14Q 74 -12 81 -12Q 92 -12 103 -16Q 110 -19 114 -19Q 121 -19 130 -13Q 134 -11 135 -11Q 138 -11 139 -12Q 140 -14 140 -16Q 140 -18 139 -19Q 137 -22 127 -26Q 120 -29 114 -29Q 108 -29 99 -26Q 90 -23 81 -23Q 75 -23 66 -24Q 53 -26 46 -28Q 43 -29 42 -29Q 40 -29 39 -28Q 37 -26 37 -24Q 37 -21 40 -19L 63 -2Q 42 2 27 23Q 13 43 13 72Q 13 106 32 128Q 51 149 77 149Q 102 149 121 128Q 141 106 141 72Q 141 39 122 17Q 103 -3 78 -4ZM 130 72Q 130 98 115 118Q 100 139 77 139Q 54 139 39 119Q 23 100 23 72Q 23 43 39 24Q 56 6 77 6Q 100 6 115 26Q 130 47 130 72Z", "M 42 65L 42 10L 62 10Q 65 10 67 9Q 69 7 69 5Q 69 3 67 1Q 65 0 62 0L 18 0Q 14 0 12 1Q 11 3 11 5Q 11 7 12 9Q 14 10 18 10L 32 10L 32 135L 18 135Q 14 135 12 137Q 11 138 11 141Q 11 143 12 144Q 14 146 18 146L 81 146Q 101 146 114 133Q 128 121 128 105Q 128 94 119 84Q 111 74 91 68Q 103 60 111 50Q 119 40 136 10L 144 10Q 148 10 150 9Q 151 7 151 5Q 151 3 150 1Q 148 0 144 0L 130 0Q 111 34 100 46Q 89 58 76 65L 42 65ZM 42 75L 71 75Q 85 75 96 80Q 107 85 112 92Q 117 99 117 106Q 117 116 106 126Q 96 135 81 135L 42 135L 42 75Z", "M 114 135L 114 139Q 114 143 115 144Q 117 146 119 146Q 122 146 123 144Q 124 143 124 139L 124 112Q 124 108 123 107Q 122 105 119 105Q 117 105 115 107Q 114 108 114 111Q 113 122 103 130Q 93 139 76 139Q 59 139 49 130Q 39 121 39 109Q 39 102 41 97Q 44 92 49 89Q 54 86 60 84Q 66 82 79 80Q 100 76 108 73Q 119 68 124 59Q 130 51 130 39Q 130 21 116 8Q 101 -4 77 -4Q 50 -4 33 13L 33 7Q 33 3 32 1Q 30 0 28 0Q 26 0 24 1Q 23 3 23 7L 23 36Q 23 39 24 41Q 26 43 28 43Q 30 43 32 41Q 33 40 33 36Q 34 25 45 15Q 57 6 77 6Q 97 6 108 16Q 120 26 120 39Q 120 47 115 54Q 111 60 102 64Q 96 67 77 70Q 51 74 40 83Q 28 92 28 109Q 28 125 41 137Q 54 149 76 149Q 98 149 114 135Z", "M 82 135L 82 10L 109 10Q 113 10 114 9Q 116 7 116 5Q 116 3 114 1Q 113 0 109 0L 44 0Q 40 0 38 1Q 37 3 37 5Q 37 7 38 9Q 40 10 44 10L 71 10L 71 135L 28 135L 28 99Q 28 95 26 93Q 25 92 23 92Q 20 92 19 93Q 17 95 17 99L 17 146L 135 146L 135 99Q 135 95 134 93Q 132 92 130 92Q 127 92 126 93Q 125 95 125 99L 125 135L 82 135Z", "M 127 135L 127 48Q 127 25 112 10Q 98 -4 77 -4Q 63 -4 52 2Q 41 8 33 20Q 26 33 26 48L 26 135L 17 135Q 13 135 12 137Q 10 138 10 141Q 10 143 12 145Q 13 146 17 146L 56 146Q 59 146 61 144Q 63 143 63 141Q 63 138 61 137Q 59 135 56 135L 36 135L 36 48Q 36 30 48 18Q 60 6 76 6Q 87 6 95 11Q 104 15 110 25Q 117 35 117 48L 117 135L 97 135Q 94 135 92 137Q 90 138 90 141Q 90 143 92 144Q 94 146 97 146L 136 146Q 140 146 141 144Q 143 143 143 141Q 143 138 141 137Q 140 135 136 135L 127 135Z", "M 84 0L 70 0L 17 135L 9 135Q 6 135 4 136Q 3 136 2 138Q 2 139 2 141Q 2 142 2 143Q 3 145 4 145Q 6 146 9 146L 48 146Q 51 146 52 145Q 53 145 54 143Q 55 142 55 141Q 55 139 54 138Q 53 136 52 136Q 51 135 48 135L 28 135L 76 10L 77 10L 125 135L 105 135Q 102 135 101 136Q 100 136 99 138Q 98 139 98 141Q 98 142 99 143Q 100 145 101 145Q 102 146 105 146L 144 146Q 147 146 148 145Q 150 145 150 143Q 151 142 151 141Q 151 139 150 138Q 150 136 148 136Q 147 135 144 135L 136 135L 84 0Z", "M 122 0L 106 0L 76 103L 47 0L 31 0L 15 135L 11 135Q 7 135 6 137Q 4 138 4 141Q 4 143 6 144Q 7 146 11 146L 50 146Q 54 146 56 144Q 57 143 57 141Q 57 138 56 137Q 54 135 50 135L 26 135L 40 12L 68 113L 84 113L 113 12L 127 135L 102 135Q 98 135 97 137Q 95 138 95 141Q 95 143 97 144Q 98 146 102 146L 141 146Q 145 146 146 144Q 148 143 148 141Q 148 138 146 137Q 145 135 141 135L 137 135L 122 0Z", "M 83 74L 133 10L 137 10Q 140 10 142 9Q 144 7 144 5Q 144 3 142 1Q 140 0 137 0L 103 0Q 99 0 97 1Q 96 3 96 5Q 96 7 97 9Q 99 10 103 10L 120 10L 76 66L 33 10L 50 10Q 54 10 55 9Q 57 7 57 5Q 57 3 55 1Q 54 0 50 0L 17 0Q 13 0 11 1Q 10 3 10 5Q 10 7 11 8Q 12 9 13 10Q 14 10 20 10L 70 74L 23 135L 19 135Q 15 135 13 137Q 12 138 12 141Q 12 143 13 144Q 15 146 19 146L 47 146Q 51 146 53 144Q 55 143 55 141Q 55 138 53 137Q 51 135 47 135L 36 135L 76 83L 116 135L 105 135Q 101 135 99 137Q 98 138 98 141Q 98 143 99 144Q 101 146 105 146L 133 146Q 137 146 139 144Q 140 143 140 141Q 140 138 139 137Q 137 135 133 135L 129 135L 83 74Z", "M 82 66L 82 10L 109 10Q 113 10 115 9Q 116 7 116 5Q 116 3 115 1Q 113 0 109 0L 44 0Q 40 0 39 1Q 37 3 37 5Q 37 7 39 9Q 40 10 44 10L 71 10L 71 66L 25 135L 19 135Q 15 135 14 137Q 12 138 12 141Q 12 143 14 144Q 15 146 19 146L 48 146Q 52 146 53 144Q 55 143 55 141Q 55 138 53 137Q 52 135 48 135L 37 135L 77 76L 115 135L 105 135Q 101 135 99 137Q 98 138 98 141Q 98 143 99 144Q 101 146 105 146L 134 146Q 137 146 139 144Q 141 143 141 141Q 141 138 139 137Q 137 135 134 135L 127 135L 82 66Z", "M 127 0L 26 0L 26 15L 111 134L 111 135L 42 135L 42 104Q 42 101 40 99Q 39 97 36 97Q 34 97 32 99Q 31 101 31 104L 31 146L 122 146L 122 131L 36 11L 36 10L 117 10L 117 47Q 117 51 118 52Q 120 54 122 54Q 124 54 126 52Q 127 51 127 47L 127 0Z", "M 82 146L 82 -21L 107 -21Q 111 -21 113 -23Q 114 -24 114 -27Q 114 -29 113 -30Q 111 -32 107 -32L 71 -32L 71 156L 107 156Q 111 156 113 155Q 114 153 114 151Q 114 149 113 147Q 111 146 107 146L 82 146Z", "M 39 168L 123 -12Q 124 -15 124 -16Q 124 -18 123 -20Q 121 -21 119 -21Q 116 -21 114 -17L 29 163Q 28 166 28 167Q 28 169 29 171Q 31 172 33 172Q 37 172 39 168Z", "M 71 -21L 71 146L 46 146Q 42 146 41 147Q 39 149 39 151Q 39 153 41 155Q 42 156 46 156L 82 156L 82 -32L 46 -32Q 42 -32 41 -30Q 39 -29 39 -27Q 39 -24 41 -23Q 42 -21 46 -21L 71 -21Z", "M 76 159L 122 102Q 125 99 125 97Q 125 95 123 93Q 122 92 119 92Q 117 92 114 95L 76 143L 39 95Q 36 92 33 92Q 31 92 30 93Q 28 95 28 97Q 28 99 30 102L 76 159Z", "M 146 -70L 7 -70Q 3 -70 1 -68Q 0 -67 0 -64Q 0 -62 1 -61Q 3 -59 7 -59L 146 -59Q 150 -59 152 -61Q 153 -62 153 -64Q 153 -67 152 -68Q 150 -70 146 -70Z", "M 65 163L 95 138L 97 135Q 98 134 98 133Q 98 130 96 129Q 95 127 92 127Q 91 127 88 130L 58 155Q 55 158 55 160Q 55 163 57 164Q 58 166 60 166Q 62 166 65 163Z", "M 107 0L 107 15Q 84 -4 58 -4Q 39 -4 28 5Q 18 15 18 28Q 18 44 32 55Q 46 66 72 66Q 80 66 88 65Q 97 65 107 63L 107 80Q 107 88 99 95Q 91 101 75 101Q 62 101 40 94Q 36 93 35 93Q 33 93 32 94Q 30 96 30 98Q 30 100 31 101Q 33 103 46 106Q 65 112 75 112Q 95 112 106 102Q 117 92 117 80L 117 10L 131 10Q 135 10 137 9Q 138 7 138 5Q 138 3 137 1Q 135 0 131 0L 107 0ZM 107 52Q 99 54 91 55Q 83 56 74 56Q 51 56 38 46Q 28 39 28 28Q 28 19 35 12Q 43 6 57 6Q 71 6 82 11Q 94 17 107 29L 107 52Z", "M 37 156L 37 87Q 56 112 83 112Q 106 112 122 95Q 138 78 138 54Q 138 29 122 12Q 105 -4 83 -4Q 55 -4 37 20L 37 0L 12 0Q 8 0 7 1Q 5 3 5 5Q 5 7 7 9Q 8 10 12 10L 26 10L 26 146L 12 146Q 8 146 7 147Q 5 149 5 151Q 5 153 7 155Q 8 156 12 156L 37 156ZM 128 53Q 128 73 114 87Q 101 101 82 101Q 64 101 51 87Q 37 73 37 53Q 37 34 51 20Q 64 6 82 6Q 101 6 114 20Q 128 34 128 53Z", "M 120 97L 120 101Q 120 105 122 106Q 123 108 125 108Q 128 108 129 106Q 131 105 131 101L 131 77Q 131 73 129 71Q 128 70 125 70Q 123 70 122 71Q 120 73 120 76Q 119 85 108 93Q 98 101 79 101Q 56 101 44 86Q 31 72 31 53Q 31 32 45 19Q 58 6 79 6Q 92 6 104 10Q 117 15 127 25Q 130 27 132 27Q 134 27 135 26Q 137 25 137 22Q 137 17 124 9Q 104 -4 79 -4Q 54 -4 37 12Q 21 28 21 53Q 21 78 38 95Q 54 112 80 112Q 104 112 120 97Z", "M 128 156L 128 10L 142 10Q 146 10 147 9Q 149 7 149 5Q 149 3 147 1Q 146 0 142 0L 117 0L 117 20Q 99 -4 71 -4Q 57 -4 43 3Q 30 11 23 25Q 15 39 15 53Q 15 68 23 82Q 30 96 43 104Q 57 112 71 112Q 98 112 117 87L 117 146L 103 146Q 99 146 98 147Q 96 149 96 151Q 96 153 98 155Q 99 156 103 156L 128 156ZM 117 53Q 117 73 104 87Q 90 101 72 101Q 53 101 39 87Q 26 73 26 53Q 26 34 39 20Q 53 6 72 6Q 90 6 104 20Q 117 34 117 53Z", "M 133 51L 26 51Q 29 31 43 18Q 58 6 79 6Q 90 6 103 10Q 116 14 124 20Q 127 22 128 22Q 130 22 132 20Q 133 19 133 17Q 133 15 131 13Q 125 6 110 1Q 95 -4 79 -4Q 52 -4 34 13Q 16 31 16 56Q 16 79 32 95Q 49 112 74 112Q 100 112 117 95Q 133 78 133 51ZM 123 62Q 119 79 106 90Q 93 101 74 101Q 56 101 43 90Q 30 79 26 62L 123 62Z", "M 69 97L 69 10L 116 10Q 119 10 121 9Q 123 7 123 5Q 123 3 121 1Q 119 0 116 0L 33 0Q 30 0 28 1Q 26 3 26 5Q 26 7 28 9Q 30 10 33 10L 59 10L 59 97L 36 97Q 32 97 31 99Q 29 100 29 103Q 29 105 31 106Q 32 108 36 108L 59 108L 59 124Q 59 137 70 147Q 80 156 98 156Q 113 156 130 154Q 136 153 137 151Q 139 150 139 148Q 139 145 137 144Q 136 143 133 143Q 132 143 130 143Q 111 146 98 146Q 84 146 77 139Q 69 132 69 124L 69 108L 119 108Q 122 108 124 106Q 126 105 126 102Q 126 100 124 99Q 122 97 119 97L 69 97Z", "M 112 89L 112 108L 136 108Q 140 108 142 106Q 143 105 143 102Q 143 100 142 99Q 140 97 136 97L 122 97L 122 -7Q 122 -17 118 -26Q 115 -31 108 -37Q 101 -43 95 -45Q 89 -48 80 -48L 50 -48Q 46 -48 44 -46Q 43 -45 43 -43Q 43 -40 44 -39Q 46 -37 50 -37L 80 -37Q 89 -37 97 -33Q 104 -28 109 -19Q 112 -13 112 -5L 112 25Q 95 2 68 2Q 47 2 31 18Q 15 34 15 57Q 15 80 31 96Q 47 112 68 112Q 95 112 112 89ZM 112 57Q 112 75 99 88Q 86 101 69 101Q 51 101 38 88Q 26 75 26 57Q 26 38 38 26Q 51 13 69 13Q 86 13 99 26Q 112 38 112 57Z", "M 42 156L 42 92Q 52 103 61 107Q 70 112 82 112Q 94 112 102 107Q 111 103 117 94Q 122 85 122 75L 122 10L 134 10Q 138 10 140 9Q 141 7 141 5Q 141 3 140 1Q 138 0 134 0L 100 0Q 96 0 95 1Q 93 3 93 5Q 93 7 95 9Q 96 10 100 10L 112 10L 112 74Q 112 86 104 93Q 95 101 81 101Q 69 101 61 95Q 55 91 42 77L 42 10L 54 10Q 57 10 59 9Q 61 7 61 5Q 61 3 59 1Q 57 0 54 0L 19 0Q 16 0 14 1Q 12 3 12 5Q 12 7 14 9Q 16 10 19 10L 31 10L 31 146L 17 146Q 13 146 12 147Q 10 149 10 151Q 10 153 12 155Q 13 156 17 156L 42 156Z", "M 82 162L 82 135L 66 135L 66 162L 82 162ZM 82 108L 82 10L 123 10Q 127 10 129 9Q 130 7 130 5Q 130 3 129 1Q 127 0 123 0L 30 0Q 26 0 25 1Q 23 3 23 5Q 23 7 25 9Q 26 10 30 10L 71 10L 71 97L 41 97Q 37 97 35 99Q 34 100 34 102Q 34 105 35 106Q 37 108 41 108L 82 108Z", "M 91 162L 91 135L 76 135L 76 162L 91 162ZM 92 97L 30 97Q 26 97 24 99Q 23 100 23 103Q 23 105 24 106Q 26 108 30 108L 103 108L 103 -7Q 103 -20 97 -29Q 92 -38 81 -44Q 73 -48 62 -48L 29 -48Q 25 -48 24 -46Q 22 -45 22 -43Q 22 -40 24 -39Q 25 -37 29 -37L 62 -37Q 76 -37 84 -29Q 92 -20 92 -7L 92 97Z", "M 55 46L 55 0L 30 0Q 27 0 25 1Q 23 3 23 5Q 23 7 25 9Q 27 10 30 10L 45 10L 45 146L 30 146Q 27 146 25 147Q 23 149 23 151Q 23 153 25 155Q 27 156 30 156L 55 156L 55 60L 100 97L 94 97Q 91 97 89 99Q 87 100 87 102Q 87 105 89 106Q 91 108 94 108L 128 108Q 132 108 133 106Q 135 105 135 102Q 135 100 133 99Q 132 97 128 97L 116 97L 75 63L 127 10L 139 10Q 143 10 144 9Q 146 7 146 5Q 146 3 144 1Q 143 0 139 0L 105 0Q 101 0 99 1Q 98 3 98 5Q 98 7 99 9Q 101 10 105 10L 112 10L 67 56L 55 46Z", "M 82 156L 82 10L 123 10Q 127 10 128 9Q 130 7 130 5Q 130 3 128 1Q 127 0 123 0L 30 0Q 26 0 25 1Q 23 3 23 5Q 23 7 25 9Q 26 10 30 10L 71 10L 71 146L 41 146Q 37 146 35 147Q 34 149 34 151Q 34 153 35 155Q 37 156 41 156L 82 156Z", "M 29 108L 29 97Q 42 112 55 112Q 64 112 70 107Q 76 103 80 94Q 87 103 94 107Q 101 112 109 112Q 120 112 127 104Q 136 95 136 83L 136 10L 144 10Q 148 10 150 9Q 151 7 151 5Q 151 3 150 1Q 148 0 144 0L 125 0L 125 82Q 125 90 120 96Q 115 101 109 101Q 103 101 97 97Q 90 92 82 80L 82 10L 91 10Q 95 10 96 9Q 98 7 98 5Q 98 3 96 1Q 95 0 91 0L 72 0L 72 82Q 72 90 67 95Q 62 101 56 101Q 50 101 45 97Q 37 92 29 80L 29 10L 37 10Q 41 10 43 9Q 44 7 44 5Q 44 3 43 1Q 41 0 37 0L 9 0Q 5 0 4 1Q 2 3 2 5Q 2 7 4 9Q 5 10 9 10L 18 10L 18 97L 9 97Q 5 97 4 99Q 2 100 2 103Q 2 105 4 106Q 5 108 9 108L 29 108Z", "M 42 108L 42 92Q 53 103 62 107Q 71 112 82 112Q 94 112 104 106Q 111 103 117 94Q 123 85 123 76L 123 10L 131 10Q 135 10 137 9Q 138 7 138 5Q 138 3 137 1Q 135 0 131 0L 103 0Q 99 0 98 1Q 96 3 96 5Q 96 7 98 9Q 99 10 103 10L 112 10L 112 74Q 112 86 104 93Q 96 101 82 101Q 72 101 64 97Q 57 93 42 76L 42 10L 54 10Q 58 10 60 9Q 61 7 61 5Q 61 3 60 1Q 58 0 54 0L 20 0Q 16 0 15 1Q 13 3 13 5Q 13 7 15 9Q 16 10 20 10L 32 10L 32 97L 23 97Q 19 97 18 99Q 16 100 16 103Q 16 105 18 106Q 19 108 23 108L 42 108Z", "M 135 53Q 135 29 118 12Q 101 -4 76 -4Q 52 -4 35 12Q 18 30 18 53Q 18 77 35 94Q 52 112 76 112Q 101 112 118 95Q 135 78 135 53ZM 124 53Q 124 73 110 87Q 96 101 76 101Q 56 101 42 87Q 28 73 28 53Q 28 34 42 20Q 56 6 76 6Q 96 6 110 20Q 124 34 124 53Z", "M 37 108L 37 89Q 46 100 57 106Q 68 112 82 112Q 98 112 111 104Q 124 97 131 84Q 138 71 138 57Q 138 34 122 18Q 106 2 82 2Q 54 2 37 25L 37 -37L 62 -37Q 66 -37 68 -39Q 69 -40 69 -43Q 69 -45 68 -46Q 66 -48 62 -48L 12 -48Q 8 -48 7 -46Q 5 -45 5 -43Q 5 -40 7 -39Q 8 -37 12 -37L 26 -37L 26 97L 12 97Q 8 97 7 99Q 5 100 5 103Q 5 105 7 106Q 8 108 12 108L 37 108ZM 128 57Q 128 75 115 88Q 101 101 82 101Q 63 101 50 88Q 37 75 37 57Q 37 39 50 26Q 63 13 82 13Q 101 13 115 26Q 128 39 128 57Z", "M 117 89L 117 108L 142 108Q 146 108 147 106Q 149 105 149 102Q 149 100 147 99Q 146 97 142 97L 128 97L 128 -37L 142 -37Q 146 -37 147 -39Q 149 -40 149 -43Q 149 -45 147 -46Q 146 -48 142 -48L 92 -48Q 88 -48 86 -46Q 85 -45 85 -43Q 85 -40 86 -39Q 88 -37 92 -37L 117 -37L 117 25Q 100 2 71 2Q 48 2 32 18Q 16 34 16 57Q 16 80 32 96Q 48 112 72 112Q 100 112 117 89ZM 117 57Q 117 75 104 88Q 91 101 72 101Q 53 101 39 88Q 26 75 26 57Q 26 39 39 26Q 53 13 72 13Q 91 13 104 26Q 117 39 117 57Z", "M 64 108L 64 81Q 84 100 94 105Q 105 110 113 110Q 123 110 131 104Q 139 98 139 95Q 139 92 137 91Q 136 89 133 89Q 132 89 131 89Q 130 90 128 92Q 124 97 120 98Q 117 100 114 100Q 107 100 97 94Q 88 89 64 68L 64 10L 110 10Q 114 10 116 9Q 117 7 117 5Q 117 3 116 1Q 114 0 110 0L 28 0Q 24 0 23 1Q 21 2 21 5Q 21 7 22 8Q 24 10 28 10L 53 10L 53 97L 34 97Q 30 97 29 99Q 27 100 27 103Q 27 105 28 106Q 30 108 34 108L 64 108Z", "M 111 101Q 111 105 113 106Q 114 108 116 108Q 119 108 120 106Q 122 105 122 101L 122 83Q 122 79 120 77Q 119 76 116 76Q 114 76 113 77Q 111 78 111 82Q 110 89 103 94Q 93 101 76 101Q 59 101 49 94Q 41 88 41 82Q 41 74 50 69Q 56 66 73 64Q 95 62 103 59Q 115 54 121 46Q 127 39 127 30Q 127 16 114 6Q 102 -4 77 -4Q 52 -4 36 8Q 36 4 35 3Q 35 1 34 0Q 32 0 31 0Q 28 0 27 1Q 25 3 25 7L 25 28Q 25 32 27 34Q 28 35 31 35Q 33 35 34 34Q 36 32 36 29Q 36 24 39 20Q 43 14 53 10Q 62 6 76 6Q 97 6 107 14Q 117 21 117 30Q 117 39 107 45Q 96 51 77 53Q 57 55 49 58Q 40 62 36 68Q 31 75 31 82Q 31 96 44 104Q 57 112 76 112Q 97 112 111 101Z", "M 55 108L 112 108Q 116 108 117 106Q 119 105 119 102Q 119 100 117 99Q 116 97 112 97L 55 97L 55 27Q 55 18 62 12Q 69 6 84 6Q 94 6 107 9Q 119 12 126 16Q 128 18 130 18Q 132 18 133 16Q 135 15 135 13Q 135 11 133 9Q 129 5 114 0Q 98 -4 84 -4Q 66 -4 55 4Q 44 13 44 27L 44 97L 25 97Q 21 97 19 99Q 18 100 18 103Q 18 105 19 106Q 21 108 25 108L 44 108L 44 139Q 44 143 46 144Q 47 146 49 146Q 52 146 53 144Q 55 143 55 139L 55 108Z", "M 112 0L 112 15Q 91 -4 66 -4Q 50 -4 42 4Q 32 15 32 29L 32 97L 18 97Q 14 97 13 99Q 11 100 11 103Q 11 105 13 106Q 14 108 18 108L 43 108L 43 29Q 43 19 49 13Q 56 6 65 6Q 91 6 112 29L 112 97L 93 97Q 89 97 88 99Q 86 100 86 103Q 86 105 88 106Q 89 108 93 108L 123 108L 123 10L 132 10Q 135 10 137 9Q 139 7 139 5Q 139 3 137 1Q 135 0 132 0L 112 0Z", "M 86 0L 68 0L 25 97L 14 97Q 10 97 9 99Q 7 100 7 103Q 7 105 9 106Q 10 108 14 108L 53 108Q 57 108 59 106Q 60 105 60 102Q 60 100 59 99Q 57 97 53 97L 36 97L 74 10L 79 10L 117 97L 99 97Q 96 97 94 99Q 92 100 92 103Q 92 105 94 106Q 96 108 99 108L 139 108Q 143 108 144 106Q 146 105 146 102Q 146 100 144 99Q 143 97 139 97L 128 97L 86 0Z", "M 113 0L 100 0L 76 67L 53 0L 40 0L 19 97L 14 97Q 10 97 8 99Q 7 100 7 103Q 7 105 8 106Q 10 108 14 108L 42 108Q 46 108 48 106Q 49 105 49 102Q 49 100 48 99Q 46 97 42 97L 29 97L 48 14L 70 80L 83 80L 106 14L 123 97L 110 97Q 106 97 105 99Q 103 100 103 103Q 103 105 105 106Q 106 108 110 108L 139 108Q 143 108 144 106Q 146 105 146 102Q 146 100 144 99Q 143 97 139 97L 134 97L 113 0Z", "M 84 56L 132 10Q 136 10 138 10Q 139 9 140 8Q 141 6 141 5Q 141 3 139 1Q 138 0 134 0L 100 0Q 96 0 94 1Q 93 3 93 5Q 93 7 94 9Q 96 10 100 10L 117 10L 76 49L 36 10L 53 10Q 57 10 59 9Q 60 7 60 5Q 60 3 59 1Q 57 0 53 0L 19 0Q 15 0 14 1Q 12 3 12 5Q 12 6 13 8Q 14 9 15 10Q 16 10 21 10L 69 56L 27 97Q 22 97 21 98Q 20 98 19 100Q 18 101 18 103Q 18 105 19 106Q 21 108 25 108L 54 108Q 57 108 59 106Q 61 105 61 102Q 61 100 59 99Q 57 97 54 97L 41 97L 76 63L 112 97L 100 97Q 96 97 94 99Q 92 100 92 103Q 92 105 94 106Q 96 108 100 108L 128 108Q 132 108 134 106Q 135 105 135 102Q 135 101 134 100Q 133 98 132 98Q 131 97 126 97L 84 56Z", "M 77 0L 28 97L 25 97Q 21 97 20 99Q 18 100 18 102Q 18 104 19 105Q 20 107 21 107Q 22 108 25 108L 54 108Q 58 108 59 106Q 61 105 61 102Q 61 100 59 99Q 58 97 54 97L 40 97L 83 11L 125 97L 111 97Q 107 97 105 99Q 104 100 104 103Q 104 105 105 106Q 107 108 111 108L 139 108Q 143 108 145 106Q 147 105 147 102Q 147 101 146 99Q 145 98 143 98Q 142 97 136 97L 70 -37L 86 -37Q 90 -37 92 -39Q 93 -40 93 -43Q 93 -45 92 -46Q 90 -48 86 -48L 26 -48Q 22 -48 20 -46Q 19 -45 19 -43Q 19 -40 20 -39Q 22 -37 26 -37L 59 -37L 77 0Z", "M 122 108L 122 98L 44 10L 115 10L 115 25Q 115 28 116 30Q 118 32 120 32Q 122 32 124 30Q 125 28 125 25L 125 0L 29 0L 29 9L 107 97L 42 97L 42 83Q 42 79 41 78Q 39 76 37 76Q 35 76 33 78Q 32 79 32 83L 32 108L 122 108Z", "M 70 62Q 77 57 79 53Q 82 47 82 39L 82 -5Q 82 -12 86 -16Q 90 -21 96 -21Q 100 -22 101 -23Q 103 -24 103 -27Q 103 -29 101 -30Q 100 -32 96 -32Q 87 -32 80 -26Q 71 -17 71 -5L 71 39Q 71 46 67 51Q 63 56 56 56Q 53 57 52 58Q 50 59 50 62Q 50 64 52 66Q 53 67 56 67Q 63 68 67 72Q 71 77 71 84L 71 129Q 71 141 79 149Q 86 156 97 156Q 100 156 101 155Q 103 153 103 151Q 103 149 101 147Q 100 146 96 146Q 90 145 86 141Q 82 136 82 129L 82 84Q 82 76 79 71Q 77 67 70 62Z", "M 82 149L 82 -25Q 82 -29 80 -30Q 79 -32 76 -32Q 74 -32 73 -30Q 71 -29 71 -25L 71 149Q 71 153 73 155Q 74 156 76 156Q 79 156 80 155Q 82 153 82 149Z", "M 83 62Q 76 67 74 71Q 71 76 71 84L 71 129Q 71 136 67 141Q 63 145 57 146Q 53 146 52 147Q 50 149 50 151Q 50 153 52 155Q 53 156 56 156Q 66 156 73 150Q 82 142 82 129L 82 84Q 82 77 86 72Q 90 68 96 67Q 100 67 101 66Q 103 64 103 62Q 103 59 101 58Q 100 57 96 56Q 90 56 86 51Q 82 46 82 39L 82 -5Q 82 -16 74 -24Q 67 -32 56 -32Q 53 -32 52 -31Q 50 -29 50 -27Q 50 -24 52 -23Q 53 -22 57 -21Q 63 -21 67 -16Q 71 -11 71 -5L 71 39Q 71 47 74 52Q 76 57 83 62Z", "M 125 83Q 127 83 128 82Q 130 80 130 78Q 130 74 119 64Q 108 54 99 54Q 93 54 88 57Q 82 60 71 70Q 64 77 60 79Q 57 81 54 81Q 50 81 47 79Q 43 76 35 68Q 31 63 30 63Q 29 62 28 62Q 26 62 24 64Q 23 65 23 67Q 23 69 26 73Q 34 84 41 87Q 47 91 54 91Q 59 91 64 89Q 69 87 77 79Q 89 68 92 66Q 95 64 98 64Q 107 64 117 77Q 121 82 122 82Q 123 83 125 83Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z", "M 12 0L 12 160L 140 160L 140 0L 12 0ZM 16 4L 136 4L 136 156L 16 156L 16 4Z"};
        try {
            systemFont = new VectorFont(null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < 256; ++i) {
            Glyph glyph = new Glyph();
            glyph.path = pathParser.parsePath(GLYPH_PATHDATA[i]);
            glyph.width = 136;
            VectorFont.systemFont.glyphs.put(new Integer(i), glyph);
        }
    }
}

