/*
 * Decompiled with CFR 0.152.
 */
package com.guidebee.drawing;

import com.guidebee.drawing.geometry.AffineTransform;
import com.guidebee.drawing.geometry.Point;
import com.guidebee.drawing.geometry.Rectangle;
import com.guidebee.game.engine.drawing.core.MatrixFP;
import com.guidebee.game.engine.drawing.core.PointFP;
import com.guidebee.game.engine.drawing.core.RectangleFP;
import com.guidebee.game.engine.drawing.core.SingleFP;

abstract class Utils {
    Utils() {
    }

    static MatrixFP toMatrixFP(AffineTransform matrix) {
        if (matrix == null) {
            return null;
        }
        if (matrix.isIdentity()) {
            return MatrixFP.IDENTITY;
        }
        MatrixFP matrixFP = new MatrixFP(SingleFP.fromDouble(matrix.getScaleX()), SingleFP.fromDouble(matrix.getScaleY()), SingleFP.fromDouble(-matrix.getShearX()), SingleFP.fromDouble(-matrix.getShearY()), SingleFP.fromDouble(matrix.getTranslateX()), SingleFP.fromDouble(matrix.getTranslateY()));
        return matrixFP;
    }

    static AffineTransform toMatrix(MatrixFP matrixFP) {
        if (matrixFP == null) {
            return null;
        }
        if (matrixFP.isIdentity()) {
            return new AffineTransform();
        }
        AffineTransform matrix = new AffineTransform(SingleFP.toDouble(matrixFP.scaleX), SingleFP.toDouble(-matrixFP.rotateX), SingleFP.toDouble(-matrixFP.rotateY), SingleFP.toDouble(matrixFP.scaleY), SingleFP.toDouble(matrixFP.translateX), SingleFP.toDouble(matrixFP.translateY));
        return matrix;
    }

    static RectangleFP toRectangleFP(Rectangle rect) {
        return new RectangleFP(SingleFP.fromInt(rect.getMinX()), SingleFP.fromInt(rect.getMinY()), SingleFP.fromInt(rect.getMaxX()), SingleFP.fromInt(rect.getMaxY()));
    }

    static PointFP toPointFP(Point pnt) {
        return new PointFP(SingleFP.fromInt(pnt.x), SingleFP.fromInt(pnt.y));
    }

    static Point toPoint(PointFP pnt) {
        return new Point(SingleFP.toInt(pnt.x), SingleFP.toInt(pnt.y));
    }

    static PointFP[] toPointFPArray(Point[] pnts) {
        PointFP[] result = new PointFP[pnts.length];
        for (int i = 0; i < pnts.length; ++i) {
            result[i] = Utils.toPointFP(pnts[i]);
        }
        return result;
    }

    static Point[] ToPointArray(PointFP[] pnts) {
        Point[] result = new Point[pnts.length];
        for (int i = 0; i < pnts.length; ++i) {
            result[i] = Utils.toPoint(pnts[i]);
        }
        return result;
    }
}

