/*******************************************************************************
 * Copyright 2011 See AUTHORS file.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
//--------------------------------- PACKAGE ------------------------------------
package com.guidebee.game.scene.actions;

//--------------------------------- IMPORTS ------------------------------------
import com.guidebee.game.ui.Touchable;

//[------------------------------ MAIN CLASS ----------------------------------]
/**
 * Sets the actor's {@link com.guidebee.game.engine.scene.Actor#setTouchable
 * (com.guidebee.game.ui.Touchable) touchability}.
 *
 * @author Nathan Sweet
 */
public class TouchableAction extends Action {
    private Touchable touchable;

    public boolean act(float delta) {
        actor.setTouchable(touchable);
        return true;
    }

    public Touchable getTouchable() {
        return touchable;
    }

    public void setTouchable(Touchable touchable) {
        this.touchable = touchable;
    }
}
