/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CSVFormatTest {
    private static void assertNotEquals(Object right, Object left) {
        Assertions.assertFalse((boolean)right.equals(left));
        Assertions.assertFalse((boolean)left.equals(right));
    }

    private static CSVFormat copy(CSVFormat format) {
        return format.withDelimiter(format.getDelimiter());
    }

    private void assertNotEquals(String name, String type, Object left, Object right) {
        if (left.equals(right) || right.equals(left)) {
            Assertions.fail((String)("Objects must not compare equal for " + name + "(" + type + ")"));
        }
        if (left.hashCode() == right.hashCode()) {
            Assertions.fail((String)("Hash code should not be equal for " + name + "(" + type + ")"));
        }
    }

    @Test
    public void testDelimiterSameAsCommentStartThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CSVFormat.DEFAULT.withDelimiter('!').withCommentMarker('!'));
    }

    @Test
    public void testDelimiterSameAsEscapeThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CSVFormat.DEFAULT.withDelimiter('!').withEscape('!'));
    }

    @Test
    public void testDuplicateHeaderElements() {
        Object[] header = new String[]{"A", "A"};
        CSVFormat format = CSVFormat.DEFAULT.withHeader((String[])header);
        Assertions.assertEquals((int)2, (int)format.getHeader().length);
        Assertions.assertArrayEquals((Object[])header, (Object[])format.getHeader());
    }

    @Test
    public void testDuplicateHeaderElementsFalse() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CSVFormat.DEFAULT.withAllowDuplicateHeaderNames(false).withHeader(new String[]{"A", "A"}));
    }

    public void testDuplicateHeaderElementsTrue() {
        CSVFormat.DEFAULT.withAllowDuplicateHeaderNames(true).withHeader(new String[]{"A", "A"});
    }

    @Test
    public void testEquals() {
        CSVFormat right = CSVFormat.DEFAULT;
        CSVFormat left = CSVFormatTest.copy(right);
        Assertions.assertFalse((boolean)right.equals(null));
        Assertions.assertFalse((boolean)right.equals((Object)"A String Instance"));
        Assertions.assertEquals((Object)right, (Object)right);
        Assertions.assertEquals((Object)right, (Object)left);
        Assertions.assertEquals((Object)left, (Object)right);
        Assertions.assertEquals((int)right.hashCode(), (int)right.hashCode());
        Assertions.assertEquals((int)right.hashCode(), (int)left.hashCode());
    }

    @Test
    public void testEqualsCommentStart() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withQuote('\"').withCommentMarker('#').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withCommentMarker('!');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsDelimiter() {
        CSVFormat right = CSVFormat.newFormat((char)'!');
        CSVFormat left = CSVFormat.newFormat((char)'?');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsEscape() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withQuote('\"').withCommentMarker('#').withEscape('+').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withEscape('!');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsHash() throws Exception {
        Method[] methods;
        for (Method method : methods = CSVFormat.class.getDeclaredMethods()) {
            String name;
            if (!Modifier.isPublic(method.getModifiers()) || !(name = method.getName()).startsWith("with")) continue;
            for (Class<?> cls : method.getParameterTypes()) {
                Object b;
                Object a;
                String type = cls.getCanonicalName();
                if ("boolean".equals(type)) {
                    Object defTrue = method.invoke((Object)CSVFormat.DEFAULT, Boolean.TRUE);
                    Object defFalse = method.invoke((Object)CSVFormat.DEFAULT, Boolean.FALSE);
                    this.assertNotEquals(name, type, defTrue, defFalse);
                    continue;
                }
                if ("char".equals(type)) {
                    a = method.invoke((Object)CSVFormat.DEFAULT, Character.valueOf('a'));
                    b = method.invoke((Object)CSVFormat.DEFAULT, Character.valueOf('b'));
                    this.assertNotEquals(name, type, a, b);
                    continue;
                }
                if ("java.lang.Character".equals(type)) {
                    a = method.invoke((Object)CSVFormat.DEFAULT, new Object[]{null});
                    b = method.invoke((Object)CSVFormat.DEFAULT, new Character('d'));
                    this.assertNotEquals(name, type, a, b);
                    continue;
                }
                if ("java.lang.String".equals(type)) {
                    a = method.invoke((Object)CSVFormat.DEFAULT, new Object[]{null});
                    b = method.invoke((Object)CSVFormat.DEFAULT, "e");
                    this.assertNotEquals(name, type, a, b);
                    continue;
                }
                if ("java.lang.String[]".equals(type)) {
                    a = method.invoke((Object)CSVFormat.DEFAULT, new Object[]{new String[]{null, null}});
                    b = method.invoke((Object)CSVFormat.DEFAULT, new Object[]{new String[]{"f", "g"}});
                    this.assertNotEquals(name, type, a, b);
                    continue;
                }
                if ("org.apache.commons.csv.QuoteMode".equals(type)) {
                    a = method.invoke((Object)CSVFormat.DEFAULT, QuoteMode.MINIMAL);
                    b = method.invoke((Object)CSVFormat.DEFAULT, QuoteMode.ALL);
                    this.assertNotEquals(name, type, a, b);
                    continue;
                }
                if ("java.lang.Object[]".equals(type)) {
                    a = method.invoke((Object)CSVFormat.DEFAULT, new Object[]{new Object[]{null, null}});
                    b = method.invoke((Object)CSVFormat.DEFAULT, new Object[]{new Object[]{new Object(), new Object()}});
                    this.assertNotEquals(name, type, a, b);
                    continue;
                }
                if ("withHeader".equals(name)) continue;
                Assertions.fail((String)("Unhandled method: " + name + "(" + type + ")"));
            }
        }
    }

    @Test
    public void testEqualsHeader() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withRecordSeparator('\r').withCommentMarker('#').withEscape('+').withHeader(new String[]{"One", "Two", "Three"}).withIgnoreEmptyLines().withIgnoreSurroundingSpaces().withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withHeader(new String[]{"Three", "Two", "One"});
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsIgnoreEmptyLines() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withCommentMarker('#').withEscape('+').withIgnoreEmptyLines().withIgnoreSurroundingSpaces().withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withIgnoreEmptyLines(false);
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsIgnoreSurroundingSpaces() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withCommentMarker('#').withEscape('+').withIgnoreSurroundingSpaces().withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withIgnoreSurroundingSpaces(false);
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsLeftNoQuoteRightQuote() {
        CSVFormat left = CSVFormat.newFormat((char)',').withQuote(null);
        CSVFormat right = left.withQuote('#');
        CSVFormatTest.assertNotEquals(left, right);
    }

    @Test
    public void testEqualsNoQuotes() {
        CSVFormat left = CSVFormat.newFormat((char)',').withQuote(null);
        CSVFormat right = left.withQuote(null);
        Assertions.assertEquals((Object)left, (Object)right);
    }

    @Test
    public void testEqualsNullString() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withRecordSeparator('\r').withCommentMarker('#').withEscape('+').withIgnoreEmptyLines().withIgnoreSurroundingSpaces().withQuote('\"').withQuoteMode(QuoteMode.ALL).withNullString("null");
        CSVFormat left = right.withNullString("---");
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsOne() {
        CSVFormat csvFormatOne = CSVFormat.INFORMIX_UNLOAD;
        CSVFormat csvFormatTwo = CSVFormat.MYSQL;
        Assertions.assertEquals((char)'\\', (char)csvFormatOne.getEscapeCharacter().charValue());
        Assertions.assertNull((Object)csvFormatOne.getQuoteMode());
        Assertions.assertTrue((boolean)csvFormatOne.getIgnoreEmptyLines());
        Assertions.assertFalse((boolean)csvFormatOne.getSkipHeaderRecord());
        Assertions.assertFalse((boolean)csvFormatOne.getIgnoreHeaderCase());
        Assertions.assertNull((Object)csvFormatOne.getCommentMarker());
        Assertions.assertFalse((boolean)csvFormatOne.isCommentMarkerSet());
        Assertions.assertTrue((boolean)csvFormatOne.isQuoteCharacterSet());
        Assertions.assertEquals((char)'|', (char)csvFormatOne.getDelimiter());
        Assertions.assertFalse((boolean)csvFormatOne.getAllowMissingColumnNames());
        Assertions.assertTrue((boolean)csvFormatOne.isEscapeCharacterSet());
        Assertions.assertEquals((Object)"\n", (Object)csvFormatOne.getRecordSeparator());
        Assertions.assertEquals((char)'\"', (char)csvFormatOne.getQuoteCharacter().charValue());
        Assertions.assertFalse((boolean)csvFormatOne.getTrailingDelimiter());
        Assertions.assertFalse((boolean)csvFormatOne.getTrim());
        Assertions.assertFalse((boolean)csvFormatOne.isNullStringSet());
        Assertions.assertNull((Object)csvFormatOne.getNullString());
        Assertions.assertFalse((boolean)csvFormatOne.getIgnoreSurroundingSpaces());
        Assertions.assertTrue((boolean)csvFormatTwo.isEscapeCharacterSet());
        Assertions.assertNull((Object)csvFormatTwo.getQuoteCharacter());
        Assertions.assertFalse((boolean)csvFormatTwo.getAllowMissingColumnNames());
        Assertions.assertEquals((Object)QuoteMode.ALL_NON_NULL, (Object)csvFormatTwo.getQuoteMode());
        Assertions.assertEquals((char)'\t', (char)csvFormatTwo.getDelimiter());
        Assertions.assertEquals((Object)"\n", (Object)csvFormatTwo.getRecordSeparator());
        Assertions.assertFalse((boolean)csvFormatTwo.isQuoteCharacterSet());
        Assertions.assertTrue((boolean)csvFormatTwo.isNullStringSet());
        Assertions.assertEquals((char)'\\', (char)csvFormatTwo.getEscapeCharacter().charValue());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreHeaderCase());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrim());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreEmptyLines());
        Assertions.assertEquals((Object)"\\N", (Object)csvFormatTwo.getNullString());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreSurroundingSpaces());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrailingDelimiter());
        Assertions.assertFalse((boolean)csvFormatTwo.getSkipHeaderRecord());
        Assertions.assertNull((Object)csvFormatTwo.getCommentMarker());
        Assertions.assertFalse((boolean)csvFormatTwo.isCommentMarkerSet());
        Assertions.assertNotSame((Object)csvFormatTwo, (Object)csvFormatOne);
        Assertions.assertFalse((boolean)csvFormatTwo.equals((Object)csvFormatOne));
        Assertions.assertEquals((char)'\\', (char)csvFormatOne.getEscapeCharacter().charValue());
        Assertions.assertNull((Object)csvFormatOne.getQuoteMode());
        Assertions.assertTrue((boolean)csvFormatOne.getIgnoreEmptyLines());
        Assertions.assertFalse((boolean)csvFormatOne.getSkipHeaderRecord());
        Assertions.assertFalse((boolean)csvFormatOne.getIgnoreHeaderCase());
        Assertions.assertNull((Object)csvFormatOne.getCommentMarker());
        Assertions.assertFalse((boolean)csvFormatOne.isCommentMarkerSet());
        Assertions.assertTrue((boolean)csvFormatOne.isQuoteCharacterSet());
        Assertions.assertEquals((char)'|', (char)csvFormatOne.getDelimiter());
        Assertions.assertFalse((boolean)csvFormatOne.getAllowMissingColumnNames());
        Assertions.assertTrue((boolean)csvFormatOne.isEscapeCharacterSet());
        Assertions.assertEquals((Object)"\n", (Object)csvFormatOne.getRecordSeparator());
        Assertions.assertEquals((char)'\"', (char)csvFormatOne.getQuoteCharacter().charValue());
        Assertions.assertFalse((boolean)csvFormatOne.getTrailingDelimiter());
        Assertions.assertFalse((boolean)csvFormatOne.getTrim());
        Assertions.assertFalse((boolean)csvFormatOne.isNullStringSet());
        Assertions.assertNull((Object)csvFormatOne.getNullString());
        Assertions.assertFalse((boolean)csvFormatOne.getIgnoreSurroundingSpaces());
        Assertions.assertTrue((boolean)csvFormatTwo.isEscapeCharacterSet());
        Assertions.assertNull((Object)csvFormatTwo.getQuoteCharacter());
        Assertions.assertFalse((boolean)csvFormatTwo.getAllowMissingColumnNames());
        Assertions.assertEquals((Object)QuoteMode.ALL_NON_NULL, (Object)csvFormatTwo.getQuoteMode());
        Assertions.assertEquals((char)'\t', (char)csvFormatTwo.getDelimiter());
        Assertions.assertEquals((Object)"\n", (Object)csvFormatTwo.getRecordSeparator());
        Assertions.assertFalse((boolean)csvFormatTwo.isQuoteCharacterSet());
        Assertions.assertTrue((boolean)csvFormatTwo.isNullStringSet());
        Assertions.assertEquals((char)'\\', (char)csvFormatTwo.getEscapeCharacter().charValue());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreHeaderCase());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrim());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreEmptyLines());
        Assertions.assertEquals((Object)"\\N", (Object)csvFormatTwo.getNullString());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreSurroundingSpaces());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrailingDelimiter());
        Assertions.assertFalse((boolean)csvFormatTwo.getSkipHeaderRecord());
        Assertions.assertNull((Object)csvFormatTwo.getCommentMarker());
        Assertions.assertFalse((boolean)csvFormatTwo.isCommentMarkerSet());
        Assertions.assertNotSame((Object)csvFormatOne, (Object)csvFormatTwo);
        Assertions.assertNotSame((Object)csvFormatTwo, (Object)csvFormatOne);
        Assertions.assertFalse((boolean)csvFormatOne.equals((Object)csvFormatTwo));
        Assertions.assertFalse((boolean)csvFormatTwo.equals((Object)csvFormatOne));
        Assertions.assertFalse((boolean)csvFormatTwo.equals((Object)csvFormatOne));
    }

    @Test
    public void testEqualsQuoteChar() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withQuote('\"');
        CSVFormat left = right.withQuote('!');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsQuotePolicy() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withQuoteMode(QuoteMode.MINIMAL);
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsRecordSeparator() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withRecordSeparator('\r').withCommentMarker('#').withEscape('+').withIgnoreEmptyLines().withIgnoreSurroundingSpaces().withQuote('\"').withQuoteMode(QuoteMode.ALL);
        CSVFormat left = right.withRecordSeparator('\n');
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsSkipHeaderRecord() {
        CSVFormat right = CSVFormat.newFormat((char)'\'').withRecordSeparator('\r').withCommentMarker('#').withEscape('+').withIgnoreEmptyLines().withIgnoreSurroundingSpaces().withQuote('\"').withQuoteMode(QuoteMode.ALL).withNullString("null").withSkipHeaderRecord();
        CSVFormat left = right.withSkipHeaderRecord(false);
        CSVFormatTest.assertNotEquals(right, left);
    }

    @Test
    public void testEqualsWithNull() {
        CSVFormat csvFormat = CSVFormat.POSTGRESQL_TEXT;
        Assertions.assertEquals((char)'\\', (char)csvFormat.getEscapeCharacter().charValue());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreSurroundingSpaces());
        Assertions.assertFalse((boolean)csvFormat.getTrailingDelimiter());
        Assertions.assertFalse((boolean)csvFormat.getTrim());
        Assertions.assertTrue((boolean)csvFormat.isQuoteCharacterSet());
        Assertions.assertEquals((Object)"\\N", (Object)csvFormat.getNullString());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreHeaderCase());
        Assertions.assertTrue((boolean)csvFormat.isEscapeCharacterSet());
        Assertions.assertFalse((boolean)csvFormat.isCommentMarkerSet());
        Assertions.assertNull((Object)csvFormat.getCommentMarker());
        Assertions.assertFalse((boolean)csvFormat.getAllowMissingColumnNames());
        Assertions.assertEquals((Object)QuoteMode.ALL_NON_NULL, (Object)csvFormat.getQuoteMode());
        Assertions.assertEquals((char)'\t', (char)csvFormat.getDelimiter());
        Assertions.assertFalse((boolean)csvFormat.getSkipHeaderRecord());
        Assertions.assertEquals((Object)"\n", (Object)csvFormat.getRecordSeparator());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreEmptyLines());
        Assertions.assertEquals((char)'\"', (char)csvFormat.getQuoteCharacter().charValue());
        Assertions.assertTrue((boolean)csvFormat.isNullStringSet());
        Assertions.assertEquals((char)'\\', (char)csvFormat.getEscapeCharacter().charValue());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreSurroundingSpaces());
        Assertions.assertFalse((boolean)csvFormat.getTrailingDelimiter());
        Assertions.assertFalse((boolean)csvFormat.getTrim());
        Assertions.assertTrue((boolean)csvFormat.isQuoteCharacterSet());
        Assertions.assertEquals((Object)"\\N", (Object)csvFormat.getNullString());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreHeaderCase());
        Assertions.assertTrue((boolean)csvFormat.isEscapeCharacterSet());
        Assertions.assertFalse((boolean)csvFormat.isCommentMarkerSet());
        Assertions.assertNull((Object)csvFormat.getCommentMarker());
        Assertions.assertFalse((boolean)csvFormat.getAllowMissingColumnNames());
        Assertions.assertEquals((Object)QuoteMode.ALL_NON_NULL, (Object)csvFormat.getQuoteMode());
        Assertions.assertEquals((char)'\t', (char)csvFormat.getDelimiter());
        Assertions.assertFalse((boolean)csvFormat.getSkipHeaderRecord());
        Assertions.assertEquals((Object)"\n", (Object)csvFormat.getRecordSeparator());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreEmptyLines());
        Assertions.assertEquals((char)'\"', (char)csvFormat.getQuoteCharacter().charValue());
        Assertions.assertTrue((boolean)csvFormat.isNullStringSet());
        Assertions.assertFalse((boolean)csvFormat.equals(null));
    }

    @Test
    public void testEscapeSameAsCommentStartThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CSVFormat.DEFAULT.withEscape('!').withCommentMarker('!'));
    }

    @Test
    public void testEscapeSameAsCommentStartThrowsExceptionForWrapperType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CSVFormat.DEFAULT.withEscape(new Character('!')).withCommentMarker(new Character('!')));
    }

    @Test
    public void testFormat() {
        CSVFormat format = CSVFormat.DEFAULT;
        Assertions.assertEquals((Object)"", (Object)format.format(new Object[0]));
        Assertions.assertEquals((Object)"a,b,c", (Object)format.format(new Object[]{"a", "b", "c"}));
        Assertions.assertEquals((Object)"\"x,y\",z", (Object)format.format(new Object[]{"x,y", "z"}));
    }

    @Test
    public void testFormatThrowsNullPointerException() {
        CSVFormat csvFormat = CSVFormat.MYSQL;
        NullPointerException e = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> csvFormat.format((Object[])null));
        Assertions.assertEquals((Object)CSVFormat.class.getName(), (Object)e.getStackTrace()[0].getClassName());
    }

    @Test
    public void testGetHeader() {
        String[] header = new String[]{"one", "two", "three"};
        CSVFormat formatWithHeader = CSVFormat.DEFAULT.withHeader(header);
        Object[] headerCopy = formatWithHeader.getHeader();
        headerCopy[0] = "A";
        headerCopy[1] = "B";
        headerCopy[2] = "C";
        Assertions.assertFalse((boolean)Arrays.equals(formatWithHeader.getHeader(), headerCopy));
        Assertions.assertNotSame((Object)formatWithHeader.getHeader(), (Object)headerCopy);
    }

    @Test
    public void testHashCodeAndWithIgnoreHeaderCase() {
        CSVFormat csvFormat = CSVFormat.INFORMIX_UNLOAD_CSV;
        CSVFormat csvFormatTwo = csvFormat.withIgnoreHeaderCase();
        csvFormatTwo.hashCode();
        Assertions.assertFalse((boolean)csvFormat.getIgnoreHeaderCase());
        Assertions.assertTrue((boolean)csvFormatTwo.getIgnoreHeaderCase());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrailingDelimiter());
        Assertions.assertFalse((boolean)csvFormatTwo.equals((Object)csvFormat));
        Assertions.assertFalse((boolean)csvFormatTwo.getAllowMissingColumnNames());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrim());
    }

    @Test
    public void testJiraCsv236() {
        CSVFormat.DEFAULT.withAllowDuplicateHeaderNames().withHeader(new String[]{"CC", "VV", "VV"});
    }

    @Test
    public void testNewFormat() {
        CSVFormat csvFormat = CSVFormat.newFormat((char)'X');
        Assertions.assertFalse((boolean)csvFormat.getSkipHeaderRecord());
        Assertions.assertFalse((boolean)csvFormat.isEscapeCharacterSet());
        Assertions.assertNull((Object)csvFormat.getRecordSeparator());
        Assertions.assertNull((Object)csvFormat.getQuoteMode());
        Assertions.assertNull((Object)csvFormat.getCommentMarker());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreHeaderCase());
        Assertions.assertFalse((boolean)csvFormat.getAllowMissingColumnNames());
        Assertions.assertFalse((boolean)csvFormat.getTrim());
        Assertions.assertFalse((boolean)csvFormat.isNullStringSet());
        Assertions.assertNull((Object)csvFormat.getEscapeCharacter());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreSurroundingSpaces());
        Assertions.assertFalse((boolean)csvFormat.getTrailingDelimiter());
        Assertions.assertEquals((char)'X', (char)csvFormat.getDelimiter());
        Assertions.assertNull((Object)csvFormat.getNullString());
        Assertions.assertFalse((boolean)csvFormat.isQuoteCharacterSet());
        Assertions.assertFalse((boolean)csvFormat.isCommentMarkerSet());
        Assertions.assertNull((Object)csvFormat.getQuoteCharacter());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreEmptyLines());
        Assertions.assertFalse((boolean)csvFormat.getSkipHeaderRecord());
        Assertions.assertFalse((boolean)csvFormat.isEscapeCharacterSet());
        Assertions.assertNull((Object)csvFormat.getRecordSeparator());
        Assertions.assertNull((Object)csvFormat.getQuoteMode());
        Assertions.assertNull((Object)csvFormat.getCommentMarker());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreHeaderCase());
        Assertions.assertFalse((boolean)csvFormat.getAllowMissingColumnNames());
        Assertions.assertFalse((boolean)csvFormat.getTrim());
        Assertions.assertFalse((boolean)csvFormat.isNullStringSet());
        Assertions.assertNull((Object)csvFormat.getEscapeCharacter());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreSurroundingSpaces());
        Assertions.assertFalse((boolean)csvFormat.getTrailingDelimiter());
        Assertions.assertEquals((char)'X', (char)csvFormat.getDelimiter());
        Assertions.assertNull((Object)csvFormat.getNullString());
        Assertions.assertFalse((boolean)csvFormat.isQuoteCharacterSet());
        Assertions.assertFalse((boolean)csvFormat.isCommentMarkerSet());
        Assertions.assertNull((Object)csvFormat.getQuoteCharacter());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreEmptyLines());
    }

    @Test
    public void testNullRecordSeparatorCsv106() {
        CSVFormat format = CSVFormat.newFormat((char)';').withSkipHeaderRecord().withHeader(new String[]{"H1", "H2"});
        String formatStr = format.format(new Object[]{"A", "B"});
        Assertions.assertNotNull((Object)formatStr);
        Assertions.assertFalse((boolean)formatStr.endsWith("null"));
    }

    @Test
    public void testQuoteCharSameAsCommentStartThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CSVFormat.DEFAULT.withQuote('!').withCommentMarker('!'));
    }

    @Test
    public void testQuoteCharSameAsCommentStartThrowsExceptionForWrapperType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CSVFormat.DEFAULT.withQuote(new Character('!')).withCommentMarker('!'));
    }

    @Test
    public void testQuoteCharSameAsDelimiterThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CSVFormat.DEFAULT.withQuote('!').withDelimiter('!'));
    }

    @Test
    public void testQuotePolicyNoneWithoutEscapeThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CSVFormat.newFormat((char)'!').withQuoteMode(QuoteMode.NONE));
    }

    @Test
    public void testRFC4180() {
        Assertions.assertEquals(null, (Character)CSVFormat.RFC4180.getCommentMarker());
        Assertions.assertEquals((char)',', (char)CSVFormat.RFC4180.getDelimiter());
        Assertions.assertEquals(null, (Character)CSVFormat.RFC4180.getEscapeCharacter());
        Assertions.assertFalse((boolean)CSVFormat.RFC4180.getIgnoreEmptyLines());
        Assertions.assertEquals((Character)Character.valueOf('\"'), (Character)CSVFormat.RFC4180.getQuoteCharacter());
        Assertions.assertEquals(null, (Object)CSVFormat.RFC4180.getQuoteMode());
        Assertions.assertEquals((Object)"\r\n", (Object)CSVFormat.RFC4180.getRecordSeparator());
    }

    @Test
    public void testSerialization() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(out);){
            oos.writeObject(CSVFormat.DEFAULT);
            oos.flush();
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
        CSVFormat format = (CSVFormat)in.readObject();
        Assertions.assertNotNull((Object)format);
        Assertions.assertEquals((char)CSVFormat.DEFAULT.getDelimiter(), (char)format.getDelimiter(), (String)"delimiter");
        Assertions.assertEquals((Character)CSVFormat.DEFAULT.getQuoteCharacter(), (Character)format.getQuoteCharacter(), (String)"encapsulator");
        Assertions.assertEquals((Character)CSVFormat.DEFAULT.getCommentMarker(), (Character)format.getCommentMarker(), (String)"comment start");
        Assertions.assertEquals((Object)CSVFormat.DEFAULT.getRecordSeparator(), (Object)format.getRecordSeparator(), (String)"record separator");
        Assertions.assertEquals((Character)CSVFormat.DEFAULT.getEscapeCharacter(), (Character)format.getEscapeCharacter(), (String)"escape");
        Assertions.assertEquals((Object)CSVFormat.DEFAULT.getIgnoreSurroundingSpaces(), (Object)format.getIgnoreSurroundingSpaces(), (String)"trim");
        Assertions.assertEquals((Object)CSVFormat.DEFAULT.getIgnoreEmptyLines(), (Object)format.getIgnoreEmptyLines(), (String)"empty lines");
    }

    @Test
    public void testToString() {
        String string = CSVFormat.INFORMIX_UNLOAD.toString();
        Assertions.assertEquals((Object)"Delimiter=<|> Escape=<\\> QuoteChar=<\"> RecordSeparator=<\n> EmptyLines:ignored SkipHeaderRecord:false", (Object)string);
    }

    @Test
    public void testToStringAndWithCommentMarkerTakingCharacter() {
        CSVFormat.Predefined csvFormat_Predefined = CSVFormat.Predefined.Default;
        CSVFormat csvFormat = csvFormat_Predefined.getFormat();
        Assertions.assertNull((Object)csvFormat.getEscapeCharacter());
        Assertions.assertTrue((boolean)csvFormat.isQuoteCharacterSet());
        Assertions.assertFalse((boolean)csvFormat.getTrim());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreSurroundingSpaces());
        Assertions.assertFalse((boolean)csvFormat.getTrailingDelimiter());
        Assertions.assertEquals((char)',', (char)csvFormat.getDelimiter());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreHeaderCase());
        Assertions.assertEquals((Object)"\r\n", (Object)csvFormat.getRecordSeparator());
        Assertions.assertFalse((boolean)csvFormat.isCommentMarkerSet());
        Assertions.assertNull((Object)csvFormat.getCommentMarker());
        Assertions.assertFalse((boolean)csvFormat.isNullStringSet());
        Assertions.assertFalse((boolean)csvFormat.getAllowMissingColumnNames());
        Assertions.assertFalse((boolean)csvFormat.isEscapeCharacterSet());
        Assertions.assertFalse((boolean)csvFormat.getSkipHeaderRecord());
        Assertions.assertNull((Object)csvFormat.getNullString());
        Assertions.assertNull((Object)csvFormat.getQuoteMode());
        Assertions.assertTrue((boolean)csvFormat.getIgnoreEmptyLines());
        Assertions.assertEquals((char)'\"', (char)csvFormat.getQuoteCharacter().charValue());
        Character character = Character.valueOf('n');
        CSVFormat csvFormatTwo = csvFormat.withCommentMarker(character);
        Assertions.assertNull((Object)csvFormat.getEscapeCharacter());
        Assertions.assertTrue((boolean)csvFormat.isQuoteCharacterSet());
        Assertions.assertFalse((boolean)csvFormat.getTrim());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreSurroundingSpaces());
        Assertions.assertFalse((boolean)csvFormat.getTrailingDelimiter());
        Assertions.assertEquals((char)',', (char)csvFormat.getDelimiter());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreHeaderCase());
        Assertions.assertEquals((Object)"\r\n", (Object)csvFormat.getRecordSeparator());
        Assertions.assertFalse((boolean)csvFormat.isCommentMarkerSet());
        Assertions.assertNull((Object)csvFormat.getCommentMarker());
        Assertions.assertFalse((boolean)csvFormat.isNullStringSet());
        Assertions.assertFalse((boolean)csvFormat.getAllowMissingColumnNames());
        Assertions.assertFalse((boolean)csvFormat.isEscapeCharacterSet());
        Assertions.assertFalse((boolean)csvFormat.getSkipHeaderRecord());
        Assertions.assertNull((Object)csvFormat.getNullString());
        Assertions.assertNull((Object)csvFormat.getQuoteMode());
        Assertions.assertTrue((boolean)csvFormat.getIgnoreEmptyLines());
        Assertions.assertEquals((char)'\"', (char)csvFormat.getQuoteCharacter().charValue());
        Assertions.assertFalse((boolean)csvFormatTwo.isNullStringSet());
        Assertions.assertFalse((boolean)csvFormatTwo.getAllowMissingColumnNames());
        Assertions.assertEquals((char)'\"', (char)csvFormatTwo.getQuoteCharacter().charValue());
        Assertions.assertNull((Object)csvFormatTwo.getNullString());
        Assertions.assertEquals((char)',', (char)csvFormatTwo.getDelimiter());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrailingDelimiter());
        Assertions.assertTrue((boolean)csvFormatTwo.isCommentMarkerSet());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreHeaderCase());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrim());
        Assertions.assertNull((Object)csvFormatTwo.getEscapeCharacter());
        Assertions.assertTrue((boolean)csvFormatTwo.isQuoteCharacterSet());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreSurroundingSpaces());
        Assertions.assertEquals((Object)"\r\n", (Object)csvFormatTwo.getRecordSeparator());
        Assertions.assertNull((Object)csvFormatTwo.getQuoteMode());
        Assertions.assertEquals((char)'n', (char)csvFormatTwo.getCommentMarker().charValue());
        Assertions.assertFalse((boolean)csvFormatTwo.getSkipHeaderRecord());
        Assertions.assertFalse((boolean)csvFormatTwo.isEscapeCharacterSet());
        Assertions.assertTrue((boolean)csvFormatTwo.getIgnoreEmptyLines());
        Assertions.assertNotSame((Object)csvFormat, (Object)csvFormatTwo);
        Assertions.assertNotSame((Object)csvFormatTwo, (Object)csvFormat);
        Assertions.assertFalse((boolean)csvFormatTwo.equals((Object)csvFormat));
        Assertions.assertNull((Object)csvFormat.getEscapeCharacter());
        Assertions.assertTrue((boolean)csvFormat.isQuoteCharacterSet());
        Assertions.assertFalse((boolean)csvFormat.getTrim());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreSurroundingSpaces());
        Assertions.assertFalse((boolean)csvFormat.getTrailingDelimiter());
        Assertions.assertEquals((char)',', (char)csvFormat.getDelimiter());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreHeaderCase());
        Assertions.assertEquals((Object)"\r\n", (Object)csvFormat.getRecordSeparator());
        Assertions.assertFalse((boolean)csvFormat.isCommentMarkerSet());
        Assertions.assertNull((Object)csvFormat.getCommentMarker());
        Assertions.assertFalse((boolean)csvFormat.isNullStringSet());
        Assertions.assertFalse((boolean)csvFormat.getAllowMissingColumnNames());
        Assertions.assertFalse((boolean)csvFormat.isEscapeCharacterSet());
        Assertions.assertFalse((boolean)csvFormat.getSkipHeaderRecord());
        Assertions.assertNull((Object)csvFormat.getNullString());
        Assertions.assertNull((Object)csvFormat.getQuoteMode());
        Assertions.assertTrue((boolean)csvFormat.getIgnoreEmptyLines());
        Assertions.assertEquals((char)'\"', (char)csvFormat.getQuoteCharacter().charValue());
        Assertions.assertFalse((boolean)csvFormatTwo.isNullStringSet());
        Assertions.assertFalse((boolean)csvFormatTwo.getAllowMissingColumnNames());
        Assertions.assertEquals((char)'\"', (char)csvFormatTwo.getQuoteCharacter().charValue());
        Assertions.assertNull((Object)csvFormatTwo.getNullString());
        Assertions.assertEquals((char)',', (char)csvFormatTwo.getDelimiter());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrailingDelimiter());
        Assertions.assertTrue((boolean)csvFormatTwo.isCommentMarkerSet());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreHeaderCase());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrim());
        Assertions.assertNull((Object)csvFormatTwo.getEscapeCharacter());
        Assertions.assertTrue((boolean)csvFormatTwo.isQuoteCharacterSet());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreSurroundingSpaces());
        Assertions.assertEquals((Object)"\r\n", (Object)csvFormatTwo.getRecordSeparator());
        Assertions.assertNull((Object)csvFormatTwo.getQuoteMode());
        Assertions.assertEquals((char)'n', (char)csvFormatTwo.getCommentMarker().charValue());
        Assertions.assertFalse((boolean)csvFormatTwo.getSkipHeaderRecord());
        Assertions.assertFalse((boolean)csvFormatTwo.isEscapeCharacterSet());
        Assertions.assertTrue((boolean)csvFormatTwo.getIgnoreEmptyLines());
        Assertions.assertNotSame((Object)csvFormat, (Object)csvFormatTwo);
        Assertions.assertNotSame((Object)csvFormatTwo, (Object)csvFormat);
        Assertions.assertFalse((boolean)csvFormat.equals((Object)csvFormatTwo));
        Assertions.assertFalse((boolean)csvFormatTwo.equals((Object)csvFormat));
        Assertions.assertEquals((Object)"Delimiter=<,> QuoteChar=<\"> CommentStart=<n> RecordSeparator=<\r\n> EmptyLines:ignored SkipHeaderRecord:false", (Object)csvFormatTwo.toString());
    }

    @Test
    public void testWithCommentStart() {
        CSVFormat formatWithCommentStart = CSVFormat.DEFAULT.withCommentMarker('#');
        Assertions.assertEquals((Character)Character.valueOf('#'), (Character)formatWithCommentStart.getCommentMarker());
    }

    @Test
    public void testWithCommentStartCRThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CSVFormat.DEFAULT.withCommentMarker('\r'));
    }

    @Test
    public void testWithDelimiter() {
        CSVFormat formatWithDelimiter = CSVFormat.DEFAULT.withDelimiter('!');
        Assertions.assertEquals((char)'!', (char)formatWithDelimiter.getDelimiter());
    }

    @Test
    public void testWithDelimiterLFThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CSVFormat.DEFAULT.withDelimiter('\n'));
    }

    @Test
    public void testWithEmptyEnum() {
        CSVFormat formatWithHeader = CSVFormat.DEFAULT.withHeader(EmptyEnum.class);
        Assertions.assertTrue((formatWithHeader.getHeader().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWithEscape() {
        CSVFormat formatWithEscape = CSVFormat.DEFAULT.withEscape('&');
        Assertions.assertEquals((Character)Character.valueOf('&'), (Character)formatWithEscape.getEscapeCharacter());
    }

    @Test
    public void testWithEscapeCRThrowsExceptions() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CSVFormat.DEFAULT.withEscape('\r'));
    }

    @Test
    public void testWithFirstRecordAsHeader() {
        CSVFormat formatWithFirstRecordAsHeader = CSVFormat.DEFAULT.withFirstRecordAsHeader();
        Assertions.assertTrue((boolean)formatWithFirstRecordAsHeader.getSkipHeaderRecord());
        Assertions.assertTrue((formatWithFirstRecordAsHeader.getHeader().length == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testWithHeader() {
        Object[] header = new String[]{"one", "two", "three"};
        CSVFormat formatWithHeader = CSVFormat.DEFAULT.withHeader((String[])header);
        Assertions.assertArrayEquals((Object[])header, (Object[])formatWithHeader.getHeader());
        Assertions.assertNotSame((Object)header, (Object)formatWithHeader.getHeader());
    }

    @Test
    public void testWithHeaderComments() {
        CSVFormat csvFormat = CSVFormat.DEFAULT;
        Assertions.assertEquals((char)'\"', (char)csvFormat.getQuoteCharacter().charValue());
        Assertions.assertFalse((boolean)csvFormat.isCommentMarkerSet());
        Assertions.assertFalse((boolean)csvFormat.isEscapeCharacterSet());
        Assertions.assertTrue((boolean)csvFormat.isQuoteCharacterSet());
        Assertions.assertFalse((boolean)csvFormat.getSkipHeaderRecord());
        Assertions.assertNull((Object)csvFormat.getQuoteMode());
        Assertions.assertEquals((char)',', (char)csvFormat.getDelimiter());
        Assertions.assertTrue((boolean)csvFormat.getIgnoreEmptyLines());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreHeaderCase());
        Assertions.assertNull((Object)csvFormat.getCommentMarker());
        Assertions.assertEquals((Object)"\r\n", (Object)csvFormat.getRecordSeparator());
        Assertions.assertFalse((boolean)csvFormat.getTrailingDelimiter());
        Assertions.assertFalse((boolean)csvFormat.getAllowMissingColumnNames());
        Assertions.assertFalse((boolean)csvFormat.getTrim());
        Assertions.assertFalse((boolean)csvFormat.isNullStringSet());
        Assertions.assertNull((Object)csvFormat.getNullString());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreSurroundingSpaces());
        Assertions.assertNull((Object)csvFormat.getEscapeCharacter());
        Object[] objectArray = new Object[8];
        CSVFormat csvFormatTwo = csvFormat.withHeaderComments(objectArray);
        Assertions.assertEquals((char)'\"', (char)csvFormat.getQuoteCharacter().charValue());
        Assertions.assertFalse((boolean)csvFormat.isCommentMarkerSet());
        Assertions.assertFalse((boolean)csvFormat.isEscapeCharacterSet());
        Assertions.assertTrue((boolean)csvFormat.isQuoteCharacterSet());
        Assertions.assertFalse((boolean)csvFormat.getSkipHeaderRecord());
        Assertions.assertNull((Object)csvFormat.getQuoteMode());
        Assertions.assertEquals((char)',', (char)csvFormat.getDelimiter());
        Assertions.assertTrue((boolean)csvFormat.getIgnoreEmptyLines());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreHeaderCase());
        Assertions.assertNull((Object)csvFormat.getCommentMarker());
        Assertions.assertEquals((Object)"\r\n", (Object)csvFormat.getRecordSeparator());
        Assertions.assertFalse((boolean)csvFormat.getTrailingDelimiter());
        Assertions.assertFalse((boolean)csvFormat.getAllowMissingColumnNames());
        Assertions.assertFalse((boolean)csvFormat.getTrim());
        Assertions.assertFalse((boolean)csvFormat.isNullStringSet());
        Assertions.assertNull((Object)csvFormat.getNullString());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreSurroundingSpaces());
        Assertions.assertNull((Object)csvFormat.getEscapeCharacter());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreHeaderCase());
        Assertions.assertNull((Object)csvFormatTwo.getQuoteMode());
        Assertions.assertTrue((boolean)csvFormatTwo.getIgnoreEmptyLines());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreSurroundingSpaces());
        Assertions.assertNull((Object)csvFormatTwo.getEscapeCharacter());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrim());
        Assertions.assertFalse((boolean)csvFormatTwo.isEscapeCharacterSet());
        Assertions.assertTrue((boolean)csvFormatTwo.isQuoteCharacterSet());
        Assertions.assertFalse((boolean)csvFormatTwo.getSkipHeaderRecord());
        Assertions.assertEquals((char)'\"', (char)csvFormatTwo.getQuoteCharacter().charValue());
        Assertions.assertFalse((boolean)csvFormatTwo.getAllowMissingColumnNames());
        Assertions.assertNull((Object)csvFormatTwo.getNullString());
        Assertions.assertFalse((boolean)csvFormatTwo.isNullStringSet());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrailingDelimiter());
        Assertions.assertEquals((Object)"\r\n", (Object)csvFormatTwo.getRecordSeparator());
        Assertions.assertEquals((char)',', (char)csvFormatTwo.getDelimiter());
        Assertions.assertNull((Object)csvFormatTwo.getCommentMarker());
        Assertions.assertFalse((boolean)csvFormatTwo.isCommentMarkerSet());
        Assertions.assertNotSame((Object)csvFormat, (Object)csvFormatTwo);
        Assertions.assertNotSame((Object)csvFormatTwo, (Object)csvFormat);
        Assertions.assertFalse((boolean)csvFormatTwo.equals((Object)csvFormat));
        String string = csvFormatTwo.format(objectArray);
        Assertions.assertEquals((char)'\"', (char)csvFormat.getQuoteCharacter().charValue());
        Assertions.assertFalse((boolean)csvFormat.isCommentMarkerSet());
        Assertions.assertFalse((boolean)csvFormat.isEscapeCharacterSet());
        Assertions.assertTrue((boolean)csvFormat.isQuoteCharacterSet());
        Assertions.assertFalse((boolean)csvFormat.getSkipHeaderRecord());
        Assertions.assertNull((Object)csvFormat.getQuoteMode());
        Assertions.assertEquals((char)',', (char)csvFormat.getDelimiter());
        Assertions.assertTrue((boolean)csvFormat.getIgnoreEmptyLines());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreHeaderCase());
        Assertions.assertNull((Object)csvFormat.getCommentMarker());
        Assertions.assertEquals((Object)"\r\n", (Object)csvFormat.getRecordSeparator());
        Assertions.assertFalse((boolean)csvFormat.getTrailingDelimiter());
        Assertions.assertFalse((boolean)csvFormat.getAllowMissingColumnNames());
        Assertions.assertFalse((boolean)csvFormat.getTrim());
        Assertions.assertFalse((boolean)csvFormat.isNullStringSet());
        Assertions.assertNull((Object)csvFormat.getNullString());
        Assertions.assertFalse((boolean)csvFormat.getIgnoreSurroundingSpaces());
        Assertions.assertNull((Object)csvFormat.getEscapeCharacter());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreHeaderCase());
        Assertions.assertNull((Object)csvFormatTwo.getQuoteMode());
        Assertions.assertTrue((boolean)csvFormatTwo.getIgnoreEmptyLines());
        Assertions.assertFalse((boolean)csvFormatTwo.getIgnoreSurroundingSpaces());
        Assertions.assertNull((Object)csvFormatTwo.getEscapeCharacter());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrim());
        Assertions.assertFalse((boolean)csvFormatTwo.isEscapeCharacterSet());
        Assertions.assertTrue((boolean)csvFormatTwo.isQuoteCharacterSet());
        Assertions.assertFalse((boolean)csvFormatTwo.getSkipHeaderRecord());
        Assertions.assertEquals((char)'\"', (char)csvFormatTwo.getQuoteCharacter().charValue());
        Assertions.assertFalse((boolean)csvFormatTwo.getAllowMissingColumnNames());
        Assertions.assertNull((Object)csvFormatTwo.getNullString());
        Assertions.assertFalse((boolean)csvFormatTwo.isNullStringSet());
        Assertions.assertFalse((boolean)csvFormatTwo.getTrailingDelimiter());
        Assertions.assertEquals((Object)"\r\n", (Object)csvFormatTwo.getRecordSeparator());
        Assertions.assertEquals((char)',', (char)csvFormatTwo.getDelimiter());
        Assertions.assertNull((Object)csvFormatTwo.getCommentMarker());
        Assertions.assertFalse((boolean)csvFormatTwo.isCommentMarkerSet());
        Assertions.assertNotSame((Object)csvFormat, (Object)csvFormatTwo);
        Assertions.assertNotSame((Object)csvFormatTwo, (Object)csvFormat);
        Assertions.assertNotNull((Object)string);
        Assertions.assertFalse((boolean)csvFormat.equals((Object)csvFormatTwo));
        Assertions.assertFalse((boolean)csvFormatTwo.equals((Object)csvFormat));
        Assertions.assertEquals((Object)",,,,,,,", (Object)string);
    }

    @Test
    public void testWithHeaderEnum() {
        CSVFormat formatWithHeader = CSVFormat.DEFAULT.withHeader(Header.class);
        Assertions.assertArrayEquals((Object[])new String[]{"Name", "Email", "Phone"}, (Object[])formatWithHeader.getHeader());
    }

    @Test
    public void testWithIgnoreEmptyLines() {
        Assertions.assertFalse((boolean)CSVFormat.DEFAULT.withIgnoreEmptyLines(false).getIgnoreEmptyLines());
        Assertions.assertTrue((boolean)CSVFormat.DEFAULT.withIgnoreEmptyLines().getIgnoreEmptyLines());
    }

    @Test
    public void testWithIgnoreSurround() {
        Assertions.assertFalse((boolean)CSVFormat.DEFAULT.withIgnoreSurroundingSpaces(false).getIgnoreSurroundingSpaces());
        Assertions.assertTrue((boolean)CSVFormat.DEFAULT.withIgnoreSurroundingSpaces().getIgnoreSurroundingSpaces());
    }

    @Test
    public void testWithNullString() {
        CSVFormat formatWithNullString = CSVFormat.DEFAULT.withNullString("null");
        Assertions.assertEquals((Object)"null", (Object)formatWithNullString.getNullString());
    }

    @Test
    public void testWithQuoteChar() {
        CSVFormat formatWithQuoteChar = CSVFormat.DEFAULT.withQuote('\"');
        Assertions.assertEquals((Character)Character.valueOf('\"'), (Character)formatWithQuoteChar.getQuoteCharacter());
    }

    @Test
    public void testWithQuoteLFThrowsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> CSVFormat.DEFAULT.withQuote('\n'));
    }

    @Test
    public void testWithQuotePolicy() {
        CSVFormat formatWithQuotePolicy = CSVFormat.DEFAULT.withQuoteMode(QuoteMode.ALL);
        Assertions.assertEquals((Object)QuoteMode.ALL, (Object)formatWithQuotePolicy.getQuoteMode());
    }

    @Test
    public void testWithRecordSeparatorCR() {
        CSVFormat formatWithRecordSeparator = CSVFormat.DEFAULT.withRecordSeparator('\r');
        Assertions.assertEquals((Object)String.valueOf('\r'), (Object)formatWithRecordSeparator.getRecordSeparator());
    }

    @Test
    public void testWithRecordSeparatorCRLF() {
        CSVFormat formatWithRecordSeparator = CSVFormat.DEFAULT.withRecordSeparator("\r\n");
        Assertions.assertEquals((Object)"\r\n", (Object)formatWithRecordSeparator.getRecordSeparator());
    }

    @Test
    public void testWithRecordSeparatorLF() {
        CSVFormat formatWithRecordSeparator = CSVFormat.DEFAULT.withRecordSeparator('\n');
        Assertions.assertEquals((Object)String.valueOf('\n'), (Object)formatWithRecordSeparator.getRecordSeparator());
    }

    @Test
    public void testWithSystemRecordSeparator() {
        CSVFormat formatWithRecordSeparator = CSVFormat.DEFAULT.withSystemRecordSeparator();
        Assertions.assertEquals((Object)System.getProperty("line.separator"), (Object)formatWithRecordSeparator.getRecordSeparator());
    }

    public static enum Header {
        Name,
        Email,
        Phone;

    }

    public static enum EmptyEnum {

    }
}

