/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import org.apache.commons.csv.Token;
import org.apache.commons.csv.TokenMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TokenMatchersTest {
    private Token token;

    @Before
    public void setUp() {
        this.token = new Token();
        this.token.type = Token.Type.TOKEN;
        this.token.isReady = true;
        this.token.content.append("content");
    }

    @Test
    public void testHasType() {
        Assert.assertFalse((boolean)TokenMatchers.hasType(Token.Type.COMMENT).matches((Object)this.token));
        Assert.assertFalse((boolean)TokenMatchers.hasType(Token.Type.EOF).matches((Object)this.token));
        Assert.assertFalse((boolean)TokenMatchers.hasType(Token.Type.EORECORD).matches((Object)this.token));
        Assert.assertTrue((boolean)TokenMatchers.hasType(Token.Type.TOKEN).matches((Object)this.token));
    }

    @Test
    public void testHasContent() {
        Assert.assertFalse((boolean)TokenMatchers.hasContent("This is not the token's content").matches((Object)this.token));
        Assert.assertTrue((boolean)TokenMatchers.hasContent("content").matches((Object)this.token));
    }

    @Test
    public void testIsReady() {
        Assert.assertTrue((boolean)TokenMatchers.isReady().matches((Object)this.token));
        this.token.isReady = false;
        Assert.assertFalse((boolean)TokenMatchers.isReady().matches((Object)this.token));
    }

    @Test
    public void testMatches() {
        Assert.assertTrue((boolean)TokenMatchers.matches(Token.Type.TOKEN, "content").matches((Object)this.token));
        Assert.assertFalse((boolean)TokenMatchers.matches(Token.Type.EOF, "content").matches((Object)this.token));
        Assert.assertFalse((boolean)TokenMatchers.matches(Token.Type.TOKEN, "not the content").matches((Object)this.token));
        Assert.assertFalse((boolean)TokenMatchers.matches(Token.Type.EORECORD, "not the content").matches((Object)this.token));
    }
}

