/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.csv;

import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.csv.ExtendedBufferedReader;
import org.junit.Assert;
import org.junit.Test;

public class ExtendedBufferedReaderTest {
    @Test
    public void testEmptyInput() throws Exception {
        try (ExtendedBufferedReader br = this.createBufferedReader("");){
            Assert.assertEquals((long)-1L, (long)br.read());
            Assert.assertEquals((long)-1L, (long)br.lookAhead());
            Assert.assertEquals((long)-1L, (long)br.getLastChar());
            Assert.assertNull((Object)br.readLine());
            Assert.assertEquals((long)0L, (long)br.read(new char[10], 0, 0));
        }
    }

    @Test
    public void testReadLookahead1() throws Exception {
        try (ExtendedBufferedReader br = this.createBufferedReader("1\n2\r3\n");){
            Assert.assertEquals((long)0L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)49L, (long)br.lookAhead());
            Assert.assertEquals((long)-2L, (long)br.getLastChar());
            Assert.assertEquals((long)0L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)49L, (long)br.read());
            Assert.assertEquals((long)49L, (long)br.getLastChar());
            Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)10L, (long)br.lookAhead());
            Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)49L, (long)br.getLastChar());
            Assert.assertEquals((long)10L, (long)br.read());
            Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)10L, (long)br.getLastChar());
            Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)50L, (long)br.lookAhead());
            Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)10L, (long)br.getLastChar());
            Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)50L, (long)br.read());
            Assert.assertEquals((long)2L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)50L, (long)br.getLastChar());
            Assert.assertEquals((long)13L, (long)br.lookAhead());
            Assert.assertEquals((long)2L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)50L, (long)br.getLastChar());
            Assert.assertEquals((long)13L, (long)br.read());
            Assert.assertEquals((long)13L, (long)br.getLastChar());
            Assert.assertEquals((long)2L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)51L, (long)br.lookAhead());
            Assert.assertEquals((long)13L, (long)br.getLastChar());
            Assert.assertEquals((long)51L, (long)br.read());
            Assert.assertEquals((long)51L, (long)br.getLastChar());
            Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)10L, (long)br.lookAhead());
            Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)51L, (long)br.getLastChar());
            Assert.assertEquals((long)10L, (long)br.read());
            Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)10L, (long)br.getLastChar());
            Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)-1L, (long)br.lookAhead());
            Assert.assertEquals((long)10L, (long)br.getLastChar());
            Assert.assertEquals((long)-1L, (long)br.read());
            Assert.assertEquals((long)-1L, (long)br.getLastChar());
            Assert.assertEquals((long)-1L, (long)br.read());
            Assert.assertEquals((long)-1L, (long)br.lookAhead());
            Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        }
    }

    @Test
    public void testReadLookahead2() throws Exception {
        char[] ref = new char[5];
        char[] res = new char[5];
        try (ExtendedBufferedReader br = this.createBufferedReader("abcdefg");){
            ref[0] = 97;
            ref[1] = 98;
            ref[2] = 99;
            Assert.assertEquals((long)3L, (long)br.read(res, 0, 3));
            Assert.assertArrayEquals((char[])ref, (char[])res);
            Assert.assertEquals((long)99L, (long)br.getLastChar());
            Assert.assertEquals((long)100L, (long)br.lookAhead());
            ref[4] = 100;
            Assert.assertEquals((long)1L, (long)br.read(res, 4, 1));
            Assert.assertArrayEquals((char[])ref, (char[])res);
            Assert.assertEquals((long)100L, (long)br.getLastChar());
        }
    }

    @Test
    public void testReadLine() throws Exception {
        try (ExtendedBufferedReader br = this.createBufferedReader("");){
            Assert.assertNull((Object)br.readLine());
        }
        br = this.createBufferedReader("\n");
        var2_2 = null;
        try {
            Assert.assertEquals((Object)"", (Object)br.readLine());
            Assert.assertNull((Object)br.readLine());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var2_2 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        br = this.createBufferedReader("foo\n\nhello");
        var2_2 = null;
        try {
            Assert.assertEquals((long)0L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((Object)"foo", (Object)br.readLine());
            Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((Object)"", (Object)br.readLine());
            Assert.assertEquals((long)2L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((Object)"hello", (Object)br.readLine());
            Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
            Assert.assertNull((Object)br.readLine());
            Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var2_2 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        br = this.createBufferedReader("foo\n\nhello");
        var2_2 = null;
        try {
            Assert.assertEquals((long)102L, (long)br.read());
            Assert.assertEquals((long)111L, (long)br.lookAhead());
            Assert.assertEquals((Object)"oo", (Object)br.readLine());
            Assert.assertEquals((long)1L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)10L, (long)br.lookAhead());
            Assert.assertEquals((Object)"", (Object)br.readLine());
            Assert.assertEquals((long)2L, (long)br.getCurrentLineNumber());
            Assert.assertEquals((long)104L, (long)br.lookAhead());
            Assert.assertEquals((Object)"hello", (Object)br.readLine());
            Assert.assertNull((Object)br.readLine());
            Assert.assertEquals((long)3L, (long)br.getCurrentLineNumber());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var2_2 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        br = this.createBufferedReader("foo\rbaar\r\nfoo");
        var2_2 = null;
        try {
            Assert.assertEquals((Object)"foo", (Object)br.readLine());
            Assert.assertEquals((long)98L, (long)br.lookAhead());
            Assert.assertEquals((Object)"baar", (Object)br.readLine());
            Assert.assertEquals((long)102L, (long)br.lookAhead());
            Assert.assertEquals((Object)"foo", (Object)br.readLine());
            Assert.assertNull((Object)br.readLine());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var2_2 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
    }

    @Test
    public void testReadChar() throws Exception {
        String LF = "\n";
        String CR = "\r";
        String CRLF = "\r\n";
        String LFCR = "\n\r";
        String test = "a\nb\rc\n\nd\r\re\n\rf \r\n";
        int EOLeolct = 9;
        try (ExtendedBufferedReader br = this.createBufferedReader("a\nb\rc\n\nd\r\re\n\rf \r\n");){
            Assert.assertEquals((long)0L, (long)br.getCurrentLineNumber());
            while (br.readLine() != null) {
            }
            Assert.assertEquals((long)9L, (long)br.getCurrentLineNumber());
        }
        br = this.createBufferedReader("a\nb\rc\n\nd\r\re\n\rf \r\n");
        var8_8 = null;
        try {
            Assert.assertEquals((long)0L, (long)br.getCurrentLineNumber());
            while (br.read() != -1) {
            }
            Assert.assertEquals((long)9L, (long)br.getCurrentLineNumber());
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var8_8 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
        br = this.createBufferedReader("a\nb\rc\n\nd\r\re\n\rf \r\n");
        var8_8 = null;
        try {
            Assert.assertEquals((long)0L, (long)br.getCurrentLineNumber());
            char[] buff = new char[10];
            while (br.read(buff, 0, 3) != -1) {
            }
            Assert.assertEquals((long)9L, (long)br.getCurrentLineNumber());
        }
        catch (Throwable throwable) {
            var8_8 = throwable;
            throw throwable;
        }
        finally {
            if (br != null) {
                if (var8_8 != null) {
                    try {
                        br.close();
                    }
                    catch (Throwable throwable) {
                        var8_8.addSuppressed(throwable);
                    }
                } else {
                    br.close();
                }
            }
        }
    }

    private ExtendedBufferedReader createBufferedReader(String s) {
        return new ExtendedBufferedReader((Reader)new StringReader(s));
    }
}

