/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import proguard.util.StringMatcher;

public class MapUtil {
    private MapUtil() {
    }

    public static <K, V> Map<K, V> of(Object ... keysValues) {
        if (keysValues.length % 2 != 0) {
            throw new IllegalArgumentException("You need to supply an even number of input arguments.");
        }
        HashMap<Object, Object> intermediate = new HashMap<Object, Object>();
        for (int i = 0; i < keysValues.length; i += 2) {
            Object key = keysValues[i];
            Object value = keysValues[i + 1];
            intermediate.put(key, value);
        }
        return Collections.unmodifiableMap(intermediate);
    }

    public static <T> void filterTreeMap(TreeMap<String, T> map, StringMatcher keyFilter, Consumer<T> consumer) {
        String prefix = keyFilter.prefix();
        if ("".equals(prefix)) {
            for (Map.Entry<String, T> entry : map.entrySet()) {
                if (!keyFilter.matches(entry.getKey())) continue;
                consumer.accept(entry.getValue());
            }
        } else {
            Map.Entry<String, T> entry = map.ceilingEntry(prefix);
            while (entry != null && entry.getKey().startsWith(prefix)) {
                if (keyFilter.matches(entry.getKey())) {
                    consumer.accept(entry.getValue());
                }
                entry = map.higherEntry(entry.getKey());
            }
        }
    }
}

