/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value.object.model.reflective;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.evaluation.MethodResult;
import proguard.evaluation.ValueCalculator;
import proguard.evaluation.executor.MethodExecutionInfo;
import proguard.evaluation.value.object.model.Model;
import proguard.evaluation.value.object.model.reflective.ModelHelper;

public interface ReflectiveModel<T extends ReflectiveModel<T>>
extends Model {
    public static final Logger log = LogManager.getLogger(ReflectiveModel.class);

    @Override
    default public MethodResult init(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        if (this != ModelHelper.getDummyObject(this.getClass())) {
            throw new IllegalStateException("Should not call init on an initialized model");
        }
        ModelHelper.MethodExecutionContext context = new ModelHelper.MethodExecutionContext(methodExecutionInfo, valueCalculator);
        return ModelHelper.executeViaHandler(context, ModelHelper.getConstructorHandlers(this.getClass()), this);
    }

    @Override
    default public MethodResult invoke(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        if (this == ModelHelper.getDummyObject(this.getClass()) && methodExecutionInfo.getInstanceNonStatic().isParticular()) {
            throw new IllegalStateException("Should not invoke methods on dummy model");
        }
        ModelHelper.MethodExecutionContext context = new ModelHelper.MethodExecutionContext(methodExecutionInfo, valueCalculator);
        return ModelHelper.executeViaHandler(context, ModelHelper.getInstanceMethodHandlers(this.getClass()), this);
    }

    @Override
    default public MethodResult invokeStatic(MethodExecutionInfo methodExecutionInfo, ValueCalculator valueCalculator) {
        if (this != ModelHelper.getDummyObject(this.getClass())) {
            throw new IllegalStateException("Should not call a static method on an initialized model");
        }
        ModelHelper.MethodExecutionContext context = new ModelHelper.MethodExecutionContext(methodExecutionInfo, valueCalculator);
        return ModelHelper.executeViaHandler(context, ModelHelper.getStaticMethodHandlers(this.getClass()), this);
    }
}

