/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util.inject.argument;

import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.util.inject.argument.InjectedArgument;

public class LocalVariable
implements InjectedArgument {
    private final String internalType;
    private final int targetVariableIndex;

    public LocalVariable(int targetVariableIndex, String internalType) {
        this.targetVariableIndex = targetVariableIndex;
        this.internalType = internalType;
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public String getInternalType() {
        return this.internalType;
    }

    public int getTargetVariableIndex() {
        return this.targetVariableIndex;
    }

    @Override
    public void pushToStack(InstructionSequenceBuilder code) {
        String type = this.getInternalType();
        if (type.startsWith("L") || type.startsWith("[")) {
            code.aload(this.targetVariableIndex);
        } else {
            switch (type) {
                case "I": 
                case "S": 
                case "C": 
                case "B": 
                case "Z": {
                    code.iload(this.targetVariableIndex);
                    break;
                }
                case "F": {
                    code.fload(this.targetVariableIndex);
                    break;
                }
                case "J": {
                    code.lload(this.targetVariableIndex);
                    break;
                }
                case "D": {
                    code.dload(this.targetVariableIndex);
                }
            }
        }
    }
}

