/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LineOrigin;
import proguard.classfile.attribute.StructuredLineNumberInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LineNumberInfoVisitor;
import proguard.classfile.editor.LineNumberTableAttributeEditor;

public class LineNumberInfoAdder
implements AttributeVisitor,
LineNumberInfoVisitor {
    private final LineNumberTableAttributeEditor lineNumberTableAttributeEditor;
    private StructuredLineNumberInfo.Block sourceBlock;

    public LineNumberInfoAdder(LineNumberTableAttribute targetLineNumberTableAttribute) {
        this.lineNumberTableAttributeEditor = new LineNumberTableAttributeEditor(targetLineNumberTableAttribute);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.sourceBlock = new StructuredLineNumberInfo.Block(LineOrigin.SimpleOrigin.COPIED, clazz.getName() + "." + method.getName(clazz) + method.getDescriptor(clazz), lineNumberTableAttribute.getLowestLineNumber(), lineNumberTableAttribute.getHighestLineNumber());
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLineNumberInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberInfo lineNumberInfo) {
        LineNumberInfo newLineNumberInfo = lineNumberInfo.getSource() == null ? this.sourceBlock.line(lineNumberInfo.u2startPC, lineNumberInfo.u2lineNumber) : ((StructuredLineNumberInfo)lineNumberInfo).getBlock().line(lineNumberInfo.u2startPC, lineNumberInfo.u2lineNumber);
        this.lineNumberTableAttributeEditor.addLineNumberInfo(newLineNumberInfo);
    }
}

