/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value.object;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import proguard.evaluation.value.object.AnalyzedObject;

class TypedNullObject
implements AnalyzedObject {
    private final String type;

    TypedNullObject(String type) {
        this.type = type;
    }

    @Override
    @Nullable
    public Object getPreciseValue() {
        return null;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    public boolean isModeled() {
        return false;
    }

    @Override
    public boolean isPrecise() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypedNullObject)) {
            return false;
        }
        TypedNullObject that = (TypedNullObject)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public String toString() {
        return String.format("TypedNullObject(%s)", this.type);
    }
}

