/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.signature.ast.signature;

import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import proguard.classfile.attribute.signature.ast.ASTStructureException;
import proguard.classfile.attribute.signature.ast.signature.ClassBoundNode;
import proguard.classfile.attribute.signature.ast.signature.InterfaceBoundNode;
import proguard.classfile.attribute.signature.ast.visitor.ASTNodeVisitor;

public class TypeParameterNode {
    @NotNull
    private String identifier;
    @NotNull
    private ClassBoundNode classBound;
    @NotNull
    private List<InterfaceBoundNode> interfaceBounds;

    public TypeParameterNode(@NotNull String identifier, @NotNull ClassBoundNode classBound, @NotNull List<InterfaceBoundNode> interfaceBounds) {
        if (identifier == null || classBound == null || interfaceBounds == null) {
            throw new ASTStructureException("Arguments must not be null");
        }
        this.identifier = identifier;
        this.classBound = classBound;
        this.interfaceBounds = interfaceBounds;
    }

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.identifier = identifier;
    }

    @NotNull
    public ClassBoundNode getClassBound() {
        return this.classBound;
    }

    public void setClassBound(@NotNull ClassBoundNode classBound) {
        if (classBound == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.classBound = classBound;
    }

    @NotNull
    public List<InterfaceBoundNode> getInterfaceBounds() {
        return this.interfaceBounds;
    }

    public void setInterfaceBounds(@NotNull List<InterfaceBoundNode> interfaceBounds) {
        if (interfaceBounds == null) {
            throw new ASTStructureException("Argument must not be null.");
        }
        this.interfaceBounds = interfaceBounds;
    }

    public <R, P> R accept(ASTNodeVisitor<R, P> visitor, P arg) {
        return visitor.visit(this, arg);
    }

    @NotNull
    public String toString() {
        return this.identifier + this.classBound.toString() + this.interfaceBounds.stream().map(Object::toString).collect(Collectors.joining());
    }
}

