/*
 * Decompiled with CFR 0.152.
 */
package proguard.analysis.cpa.jvm.domain.value;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.analysis.cpa.defaults.MapAbstractState;
import proguard.analysis.cpa.jvm.cfa.nodes.JvmCfaNode;
import proguard.analysis.cpa.jvm.domain.value.ValueAbstractState;
import proguard.analysis.cpa.jvm.state.JvmAbstractState;
import proguard.analysis.cpa.jvm.state.JvmFrameAbstractState;
import proguard.analysis.cpa.jvm.state.heap.JvmHeapAbstractState;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.evaluation.ExecutingInvocationUnit;
import proguard.evaluation.value.IdentifiedReferenceValue;
import proguard.evaluation.value.ParticularReferenceValue;
import proguard.evaluation.value.TypedReferenceValue;
import proguard.evaluation.value.Value;
import proguard.evaluation.value.ValueFactory;

public class JvmValueAbstractState
extends JvmAbstractState<ValueAbstractState> {
    private static final Logger logger = LogManager.getLogger(JvmValueAbstractState.class);
    private final ValueFactory valueFactory;
    private final ExecutingInvocationUnit executingInvocationUnit;

    public JvmValueAbstractState(ValueFactory valueFactory, ExecutingInvocationUnit executingInvocationUnit, JvmCfaNode programLocation, JvmFrameAbstractState<ValueAbstractState> frame, JvmHeapAbstractState<ValueAbstractState> heap, MapAbstractState<String, ValueAbstractState> staticFields) {
        super(programLocation, frame, heap, staticFields);
        this.valueFactory = valueFactory;
        this.executingInvocationUnit = executingInvocationUnit;
    }

    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    @Override
    public ValueAbstractState getVariableOrDefault(int index, ValueAbstractState defaultState) {
        ValueAbstractState value = super.getVariableOrDefault(index, defaultState);
        if (!(value.getValue() instanceof IdentifiedReferenceValue) || JvmValueAbstractState.isString(value.getValue())) {
            return value;
        }
        return this.getFieldOrDefault(((IdentifiedReferenceValue)value.getValue()).id, defaultState);
    }

    @Override
    public ValueAbstractState setVariable(int index, ValueAbstractState state, ValueAbstractState defaultState) {
        if (state.getValue() instanceof IdentifiedReferenceValue) {
            this.setField(((IdentifiedReferenceValue)state.getValue()).id, state);
        }
        return super.setVariable(index, state, defaultState);
    }

    @Override
    public ValueAbstractState newObject(String className) {
        if (!this.executingInvocationUnit.isSupportedMethodCall(className, "<init>")) {
            return new ValueAbstractState(this.valueFactory.createReferenceValue());
        }
        IdentifiedReferenceValue value = (IdentifiedReferenceValue)this.valueFactory.createReferenceValue(ClassUtil.internalTypeFromClassName(className), null, true, true, this.programLocation.getClazz(), this.programLocation.getSignature().getReferencedMethod(), this.programLocation.getOffset(), ParticularReferenceValue.UNINITIALIZED);
        logger.trace("newObject(className = {}): {}", (Object)className, (Object)value);
        ValueAbstractState jvmValueAbstractState = new ValueAbstractState(value);
        this.setField(value.id, jvmValueAbstractState);
        return jvmValueAbstractState;
    }

    @Override
    public ValueAbstractState newObject(Clazz clazz) {
        if (!this.executingInvocationUnit.isSupportedMethodCall(clazz.getName(), "<init>")) {
            return new ValueAbstractState(this.valueFactory.createReferenceValue());
        }
        IdentifiedReferenceValue value = (IdentifiedReferenceValue)this.valueFactory.createReferenceValue(ClassUtil.internalTypeFromClassName(clazz.getName()), clazz, ClassUtil.isNullOrFinal(clazz), true, this.programLocation.getClazz(), this.programLocation.getSignature().getReferencedMethod(), this.programLocation.getOffset(), ParticularReferenceValue.UNINITIALIZED);
        logger.trace("newObject(clazz = {}): {}", (Object)clazz.getName(), (Object)value);
        ValueAbstractState jvmValueAbstractState = new ValueAbstractState(value);
        this.setField(value.id, jvmValueAbstractState);
        return jvmValueAbstractState;
    }

    @Override
    public <T> void setField(T object, ValueAbstractState value) {
        if (JvmValueAbstractState.isString(value.getValue())) {
            return;
        }
        super.setField(object, value);
    }

    @Override
    public JvmValueAbstractState join(JvmAbstractState<ValueAbstractState> abstractState) {
        JvmValueAbstractState answer = new JvmValueAbstractState(this.valueFactory, this.executingInvocationUnit, this.programLocation.equals(abstractState.getProgramLocation()) ? this.programLocation : topLocation, this.frame.join(abstractState.getFrame()), this.heap.join(abstractState.getHeap()), this.staticFields.join(abstractState.getStaticFields()));
        return this.equals(answer) ? this : answer;
    }

    @Override
    public JvmValueAbstractState copy() {
        return new JvmValueAbstractState(this.valueFactory, this.executingInvocationUnit, this.programLocation, (JvmFrameAbstractState<ValueAbstractState>)this.frame.copy(), (JvmHeapAbstractState<ValueAbstractState>)this.heap.copy(), (MapAbstractState<String, ValueAbstractState>)this.staticFields.copy());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JvmAbstractState)) {
            return false;
        }
        JvmValueAbstractState other = (JvmValueAbstractState)obj;
        return this.valueFactory.equals(other.valueFactory) && this.programLocation.equals(other.programLocation) && this.frame.equals(other.frame) && this.heap.equals(other.heap) && this.staticFields.equals(other.staticFields);
    }

    public String toString() {
        return "JvmValueAbstractState(" + this.getProgramLocation() + ")";
    }

    private static boolean isString(Value value) {
        return value instanceof TypedReferenceValue && value.internalType().equals("Ljava/lang/String;");
    }
}

