/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import proguard.ClassSpecification;
import proguard.MemberSpecification;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.MemberVisitor;

public class ClassMemberChecker
implements MemberVisitor {
    private static final Logger logger = LogManager.getLogger(ClassMemberChecker.class);
    private final ClassPool programClassPool;
    private final WarningPrinter notePrinter;

    public ClassMemberChecker(ClassPool programClassPool, WarningPrinter notePrinter) {
        this.programClassPool = programClassPool;
        this.notePrinter = notePrinter;
    }

    public void checkClassSpecifications(List classSpecifications) {
        if (classSpecifications != null) {
            for (int index = 0; index < classSpecifications.size(); ++index) {
                Clazz clazz;
                ClassSpecification classSpecification = (ClassSpecification)classSpecifications.get(index);
                String className = classSpecification.className;
                if (className == null || ClassMemberChecker.containsWildCards(className) || !this.notePrinter.accepts(className) || (clazz = this.programClassPool.getClass(className)) == null) continue;
                this.checkMemberSpecifications(clazz, classSpecification.fieldSpecifications, true);
                this.checkMemberSpecifications(clazz, classSpecification.methodSpecifications, false);
            }
        }
    }

    private void checkMemberSpecifications(Clazz clazz, List memberSpecifications, boolean isField) {
        if (memberSpecifications != null) {
            String className = clazz.getName();
            for (int index = 0; index < memberSpecifications.size(); ++index) {
                MemberSpecification memberSpecification = (MemberSpecification)memberSpecifications.get(index);
                String memberName = memberSpecification.name;
                String descriptor = memberSpecification.descriptor;
                if (memberName == null || ClassMemberChecker.containsWildCards(memberName) || descriptor == null || ClassMemberChecker.containsWildCards(descriptor)) continue;
                if (isField) {
                    if (clazz.findField(memberName, descriptor) != null) continue;
                    this.notePrinter.print(className, "Note: the configuration refers to the unknown field '" + ClassUtil.externalFullFieldDescription((int)0, (String)memberName, (String)descriptor) + "' in class '" + ClassUtil.externalClassName((String)className) + "'");
                    continue;
                }
                if (clazz.findMethod(memberName, descriptor) != null) continue;
                this.notePrinter.print(className, "Note: the configuration refers to the unknown method '" + ClassUtil.externalFullMethodDescription((String)className, (int)0, (String)memberName, (String)descriptor) + "' in class '" + ClassUtil.externalClassName((String)className) + "'");
            }
        }
    }

    private static boolean containsWildCards(String string) {
        return string != null && (string.indexOf(33) >= 0 || string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(44) >= 0 || string.indexOf("///") >= 0);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        logger.info("      Maybe you meant the field '{}'?", (Object)ClassUtil.externalFullFieldDescription((int)0, (String)programField.getName((Clazz)programClass), (String)programField.getDescriptor((Clazz)programClass)));
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        logger.info("      Maybe you meant the method '{}'?", (Object)ClassUtil.externalFullMethodDescription((String)programClass.getName(), (int)0, (String)programMethod.getName((Clazz)programClass), (String)programMethod.getDescriptor((Clazz)programClass)));
    }
}

